"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FreeSwitchChannelRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
const readSecondaryPreferred_1 = require("../readSecondaryPreferred");
class FreeSwitchChannelRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'freeswitch_channels', trash);
    }
    modelIndexes() {
        return [
            { key: { uniqueId: 1 }, unique: true },
            { key: { kind: 1, startedAt: -1 } },
            { key: { kind: 1, callDirection: 1, startedAt: -1 } },
            { key: { kind: 1, anyBridge: 1, startedAt: -1 } },
        ];
    }
    async registerChannel(channel) {
        return this.insertOne(channel);
    }
    findAllByUniqueIds(uniqueIds, options) {
        return this.find({
            uniqueId: { $in: uniqueIds },
        }, options);
    }
    countChannelsByKind(kind, minDate, options) {
        return this.countDocuments({
            kind,
            ...(minDate && { startedAt: { $gte: minDate } }),
        }, { readPreference: (0, readSecondaryPreferred_1.readSecondaryPreferred)(), ...options });
    }
    countChannelsByKindAndDirection(kind, callDirection, minDate, options) {
        return this.countDocuments({
            kind,
            callDirection,
            ...(minDate && { startedAt: { $gte: minDate } }),
        }, { readPreference: (0, readSecondaryPreferred_1.readSecondaryPreferred)(), ...options });
    }
    async sumChannelsDurationByKind(kind, minDate, options) {
        return this.col
            .aggregate([
            {
                $match: {
                    kind,
                    ...(minDate && { startedAt: { $gte: minDate } }),
                },
            },
            {
                $group: {
                    _id: '1',
                    calls: { $sum: '$totalDuration' },
                },
            },
        ], { readPreference: (0, readSecondaryPreferred_1.readSecondaryPreferred)(), ...options })
            .toArray()
            .then(([{ calls }]) => calls);
    }
    countChannelsByKindAndSuccessState(kind, success, minDate, options) {
        return this.countDocuments({
            kind,
            anyBridge: success,
            ...(minDate && { startedAt: { $gte: minDate } }),
        }, { readPreference: (0, readSecondaryPreferred_1.readSecondaryPreferred)(), ...options });
    }
}
exports.FreeSwitchChannelRaw = FreeSwitchChannelRaw;
//# sourceMappingURL=FreeSwitchChannel.js.map