"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FederationServersRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
const index_1 = require("../index");
class FederationServersRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'federation_servers', trash);
    }
    modelIndexes() {
        return [{ key: { domain: 1 } }];
    }
    saveDomain(domain) {
        return this.updateOne({ domain }, {
            $setOnInsert: {
                domain,
            },
        }, { upsert: true });
    }
    async refreshServers() {
        // TODO remove model dependency - this logs should be inside a function/service and not in a model
        const domains = await index_1.Users.getDistinctFederationDomains();
        for await (const domain of domains) {
            await this.saveDomain(domain);
        }
        await this.deleteMany({ domain: { $nin: domains } });
    }
}
exports.FederationServersRaw = FederationServersRaw;
//# sourceMappingURL=FederationServers.js.map