"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FederationRoomEventsRaw = void 0;
const core_typings_1 = require("@rocket.chat/core-typings");
const FederationEvents_1 = require("./FederationEvents");
class FederationRoomEventsRaw extends FederationEvents_1.FederationEventsModel {
    constructor(db) {
        super(db, 'federation_room_events');
    }
    modelIndexes() {
        return [{ key: { 'context.roomId': 1 } }];
    }
    // @ts-expect-error - TODO: Bad extends
    async createGenesisEvent(origin, room) {
        return super.createGenesisEvent(origin, { roomId: room._id }, { contextType: 'room', room });
    }
    async createDeleteRoomEvent(origin, roomId) {
        return super.createEvent(origin, { roomId }, core_typings_1.eventTypes.ROOM_DELETE, { roomId });
    }
    async createAddUserEvent(origin, roomId, user, subscription, domainsAfterAdd) {
        return super.createEvent(origin, { roomId }, core_typings_1.eventTypes.ROOM_ADD_USER, {
            roomId,
            user,
            subscription,
            domainsAfterAdd,
        });
    }
    async createRemoveUserEvent(origin, roomId, user, domainsAfterRemoval) {
        return super.createEvent(origin, { roomId }, core_typings_1.eventTypes.ROOM_REMOVE_USER, {
            roomId,
            user,
            domainsAfterRemoval,
        });
    }
    async createUserLeftEvent(origin, roomId, user, domainsAfterLeave) {
        return super.createEvent(origin, { roomId }, core_typings_1.eventTypes.ROOM_USER_LEFT, {
            roomId,
            user,
            domainsAfterLeave,
        });
    }
    async createMessageEvent(origin, roomId, message) {
        return super.createEvent(origin, { roomId }, core_typings_1.eventTypes.ROOM_MESSAGE, { message });
    }
    async createEditMessageEvent(origin, roomId, originalMessage) {
        const message = {
            _id: originalMessage._id,
            msg: originalMessage.msg,
            federation: originalMessage.federation,
        };
        return super.createEvent(origin, { roomId }, core_typings_1.eventTypes.ROOM_EDIT_MESSAGE, {
            message,
        });
    }
    async createDeleteMessageEvent(origin, roomId, messageId) {
        return super.createEvent(origin, { roomId }, core_typings_1.eventTypes.ROOM_DELETE_MESSAGE, {
            roomId,
            messageId,
        });
    }
    async createSetMessageReactionEvent(origin, roomId, messageId, username, reaction) {
        return super.createEvent(origin, { roomId }, core_typings_1.eventTypes.ROOM_SET_MESSAGE_REACTION, {
            roomId,
            messageId,
            username,
            reaction,
        });
    }
    async createUnsetMessageReactionEvent(origin, roomId, messageId, username, reaction) {
        return super.createEvent(origin, { roomId }, core_typings_1.eventTypes.ROOM_UNSET_MESSAGE_REACTION, {
            roomId,
            messageId,
            username,
            reaction,
        });
    }
    async createMuteUserEvent(origin, roomId, user) {
        return super.createEvent(origin, { roomId }, core_typings_1.eventTypes.ROOM_MUTE_USER, {
            roomId,
            user,
        });
    }
    async createUnmuteUserEvent(origin, roomId, user) {
        return super.createEvent(origin, { roomId }, core_typings_1.eventTypes.ROOM_UNMUTE_USER, {
            roomId,
            user,
        });
    }
    async removeRoomEvents(roomId) {
        return super.removeContextEvents({ roomId });
    }
}
exports.FederationRoomEventsRaw = FederationRoomEventsRaw;
//# sourceMappingURL=FederationRoomEvents.js.map