"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailMessageHistoryRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class EmailMessageHistoryRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'email_message_history', trash);
    }
    modelIndexes() {
        return [{ key: { createdAt: 1 }, expireAfterSeconds: 60 * 60 * 24 }];
    }
    async create({ _id, email }) {
        return this.insertOne({
            _id,
            email,
            createdAt: new Date(),
        });
    }
}
exports.EmailMessageHistoryRaw = EmailMessageHistoryRaw;
//# sourceMappingURL=EmailMessageHistory.js.map