"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaCallChannels = exports.MediaCalls = exports.Messages = exports.LoginServiceConfiguration = exports.LivechatUnitMonitors = exports.LivechatUnit = exports.LivechatVisitors = exports.LivechatTrigger = exports.LivechatTag = exports.LivechatRooms = exports.LivechatPriority = exports.LivechatInquiry = exports.LivechatDepartment = exports.LivechatDepartmentAgents = exports.LivechatCustomField = exports.LivechatContacts = exports.LivechatBusinessHours = exports.LivechatAgentActivity = exports.Invites = exports.Integrations = exports.IntegrationHistory = exports.InstanceStatus = exports.Imports = exports.ImportData = exports.FreeSwitchChannelEventDelta = exports.FreeSwitchChannelEvent = exports.FreeSwitchChannel = exports.FederationRoomEvents = exports.FederationKeys = exports.FederationServers = exports.ExportOperations = exports.EmojiCustom = exports.EmailMessageHistory = exports.EmailInbox = exports.CustomUserStatus = exports.CustomSounds = exports.CredentialTokens = exports.CannedResponse = exports.CallHistory = exports.Banners = exports.BannersDismiss = exports.Avatars = exports.Analytics = exports.AppLogs = exports.AppsPersistence = exports.AppsTokens = exports.Apps = exports.UpdaterImpl = exports.registerModel = exports.dbWatchersDisabled = void 0;
exports.WorkspaceCredentials = exports.ModerationReports = exports.Migrations = exports.CronHistory = exports.AuditLog = exports.OmnichannelServiceLevelAgreements = exports.CalendarEvent = exports.WebdavAccounts = exports.VoipRoom = exports.VideoConference = exports.UsersSessions = exports.UserDataFiles = exports.Uploads = exports.Users = exports.Team = exports.TeamMember = exports.Subscriptions = exports.Statistics = exports.SmarshHistory = exports.Settings = exports.Sessions = exports.ServerEvents = exports.Rooms = exports.Roles = exports.Reports = exports.MessageReads = exports.ReadReceipts = exports.Permissions = exports.PushToken = exports.PbxEvents = exports.OEmbedCache = exports.OAuthRefreshTokens = exports.OAuthAccessTokens = exports.OAuthAuthCodes = exports.OAuthApps = exports.NpsVote = exports.Nps = exports.NotificationQueue = exports.MediaCallNegotiations = void 0;
exports.getCollectionName = getCollectionName;
exports.registerServiceModels = registerServiceModels;
const modelClasses_1 = require("./modelClasses");
const proxify_1 = require("./proxify");
const prefix = 'rocketchat_';
function getCollectionName(name) {
    return `${prefix}${name}`;
}
const disabledEnvVar = String(process.env.DISABLE_DB_WATCHERS).toLowerCase();
exports.dbWatchersDisabled = !['no', 'false'].includes(disabledEnvVar);
__exportStar(require("./modelClasses"), exports);
__exportStar(require("./DatabaseWatcher"), exports);
__exportStar(require("./dummy/ReadReceipts"), exports);
var proxify_2 = require("./proxify");
Object.defineProperty(exports, "registerModel", { enumerable: true, get: function () { return proxify_2.registerModel; } });
var updater_1 = require("./updater");
Object.defineProperty(exports, "UpdaterImpl", { enumerable: true, get: function () { return updater_1.UpdaterImpl; } });
exports.Apps = (0, proxify_1.proxify)('IAppsModel');
exports.AppsTokens = (0, proxify_1.proxify)('IAppsTokensModel');
exports.AppsPersistence = (0, proxify_1.proxify)('IAppsPersistenceModel');
exports.AppLogs = (0, proxify_1.proxify)('IAppLogsModel');
exports.Analytics = (0, proxify_1.proxify)('IAnalyticsModel');
exports.Avatars = (0, proxify_1.proxify)('IAvatarsModel');
exports.BannersDismiss = (0, proxify_1.proxify)('IBannersDismissModel');
exports.Banners = (0, proxify_1.proxify)('IBannersModel');
exports.CallHistory = (0, proxify_1.proxify)('ICallHistoryModel');
exports.CannedResponse = (0, proxify_1.proxify)('ICannedResponseModel');
exports.CredentialTokens = (0, proxify_1.proxify)('ICredentialTokensModel');
exports.CustomSounds = (0, proxify_1.proxify)('ICustomSoundsModel');
exports.CustomUserStatus = (0, proxify_1.proxify)('ICustomUserStatusModel');
exports.EmailInbox = (0, proxify_1.proxify)('IEmailInboxModel');
exports.EmailMessageHistory = (0, proxify_1.proxify)('IEmailMessageHistoryModel');
exports.EmojiCustom = (0, proxify_1.proxify)('IEmojiCustomModel');
exports.ExportOperations = (0, proxify_1.proxify)('IExportOperationsModel');
exports.FederationServers = (0, proxify_1.proxify)('IFederationServersModel');
exports.FederationKeys = (0, proxify_1.proxify)('IFederationKeysModel');
exports.FederationRoomEvents = (0, proxify_1.proxify)('IFederationRoomEventsModel');
exports.FreeSwitchChannel = (0, proxify_1.proxify)('IFreeSwitchChannelModel');
exports.FreeSwitchChannelEvent = (0, proxify_1.proxify)('IFreeSwitchChannelEventModel');
exports.FreeSwitchChannelEventDelta = (0, proxify_1.proxify)('IFreeSwitchChannelEventDeltaModel');
exports.ImportData = (0, proxify_1.proxify)('IImportDataModel');
exports.Imports = (0, proxify_1.proxify)('IImportsModel');
exports.InstanceStatus = (0, proxify_1.proxify)('IInstanceStatusModel');
exports.IntegrationHistory = (0, proxify_1.proxify)('IIntegrationHistoryModel');
exports.Integrations = (0, proxify_1.proxify)('IIntegrationsModel');
exports.Invites = (0, proxify_1.proxify)('IInvitesModel');
exports.LivechatAgentActivity = (0, proxify_1.proxify)('ILivechatAgentActivityModel');
exports.LivechatBusinessHours = (0, proxify_1.proxify)('ILivechatBusinessHoursModel');
exports.LivechatContacts = (0, proxify_1.proxify)('ILivechatContactsModel');
exports.LivechatCustomField = (0, proxify_1.proxify)('ILivechatCustomFieldModel');
exports.LivechatDepartmentAgents = (0, proxify_1.proxify)('ILivechatDepartmentAgentsModel');
exports.LivechatDepartment = (0, proxify_1.proxify)('ILivechatDepartmentModel');
exports.LivechatInquiry = (0, proxify_1.proxify)('ILivechatInquiryModel');
exports.LivechatPriority = (0, proxify_1.proxify)('ILivechatPriorityModel');
exports.LivechatRooms = (0, proxify_1.proxify)('ILivechatRoomsModel');
exports.LivechatTag = (0, proxify_1.proxify)('ILivechatTagModel');
exports.LivechatTrigger = (0, proxify_1.proxify)('ILivechatTriggerModel');
exports.LivechatVisitors = (0, proxify_1.proxify)('ILivechatVisitorsModel');
exports.LivechatUnit = (0, proxify_1.proxify)('ILivechatUnitModel');
exports.LivechatUnitMonitors = (0, proxify_1.proxify)('ILivechatUnitMonitorsModel');
exports.LoginServiceConfiguration = (0, proxify_1.proxify)('ILoginServiceConfigurationModel');
exports.Messages = (0, proxify_1.proxify)('IMessagesModel');
exports.MediaCalls = (0, proxify_1.proxify)('IMediaCallsModel');
exports.MediaCallChannels = (0, proxify_1.proxify)('IMediaCallChannelsModel');
exports.MediaCallNegotiations = (0, proxify_1.proxify)('IMediaCallNegotiationsModel');
exports.NotificationQueue = (0, proxify_1.proxify)('INotificationQueueModel');
exports.Nps = (0, proxify_1.proxify)('INpsModel');
exports.NpsVote = (0, proxify_1.proxify)('INpsVoteModel');
exports.OAuthApps = (0, proxify_1.proxify)('IOAuthAppsModel');
exports.OAuthAuthCodes = (0, proxify_1.proxify)('IOAuthAuthCodesModel');
exports.OAuthAccessTokens = (0, proxify_1.proxify)('IOAuthAccessTokensModel');
exports.OAuthRefreshTokens = (0, proxify_1.proxify)('IOAuthRefreshTokensModel');
exports.OEmbedCache = (0, proxify_1.proxify)('IOEmbedCacheModel');
exports.PbxEvents = (0, proxify_1.proxify)('IPbxEventsModel');
exports.PushToken = (0, proxify_1.proxify)('IPushTokenModel');
exports.Permissions = (0, proxify_1.proxify)('IPermissionsModel');
exports.ReadReceipts = (0, proxify_1.proxify)('IReadReceiptsModel');
exports.MessageReads = (0, proxify_1.proxify)('IMessageReadsModel');
exports.Reports = (0, proxify_1.proxify)('IReportsModel');
exports.Roles = (0, proxify_1.proxify)('IRolesModel');
exports.Rooms = (0, proxify_1.proxify)('IRoomsModel');
exports.ServerEvents = (0, proxify_1.proxify)('IServerEventsModel');
exports.Sessions = (0, proxify_1.proxify)('ISessionsModel');
exports.Settings = (0, proxify_1.proxify)('ISettingsModel');
exports.SmarshHistory = (0, proxify_1.proxify)('ISmarshHistoryModel');
exports.Statistics = (0, proxify_1.proxify)('IStatisticsModel');
exports.Subscriptions = (0, proxify_1.proxify)('ISubscriptionsModel');
exports.TeamMember = (0, proxify_1.proxify)('ITeamMemberModel');
exports.Team = (0, proxify_1.proxify)('ITeamModel');
exports.Users = (0, proxify_1.proxify)('IUsersModel');
exports.Uploads = (0, proxify_1.proxify)('IUploadsModel');
exports.UserDataFiles = (0, proxify_1.proxify)('IUserDataFilesModel');
exports.UsersSessions = (0, proxify_1.proxify)('IUsersSessionsModel');
exports.VideoConference = (0, proxify_1.proxify)('IVideoConferenceModel');
exports.VoipRoom = (0, proxify_1.proxify)('IVoipRoomModel');
exports.WebdavAccounts = (0, proxify_1.proxify)('IWebdavAccountsModel');
exports.CalendarEvent = (0, proxify_1.proxify)('ICalendarEventModel');
exports.OmnichannelServiceLevelAgreements = (0, proxify_1.proxify)('IOmnichannelServiceLevelAgreementsModel');
exports.AuditLog = (0, proxify_1.proxify)('IAuditLogModel');
exports.CronHistory = (0, proxify_1.proxify)('ICronHistoryModel');
exports.Migrations = (0, proxify_1.proxify)('IMigrationsModel');
exports.ModerationReports = (0, proxify_1.proxify)('IModerationReportsModel');
exports.WorkspaceCredentials = (0, proxify_1.proxify)('IWorkspaceCredentialsModel');
function registerServiceModels(db, trash) {
    (0, proxify_1.registerModel)('ISettingsModel', () => new modelClasses_1.SettingsRaw(db, trash));
    (0, proxify_1.registerModel)('IUsersSessionsModel', () => new modelClasses_1.UsersSessionsRaw(db));
    (0, proxify_1.registerModel)('IUsersModel', () => new modelClasses_1.UsersRaw(db));
    (0, proxify_1.registerModel)('IRolesModel', () => new modelClasses_1.RolesRaw(db));
    (0, proxify_1.registerModel)('IRoomsModel', () => new modelClasses_1.RoomsRaw(db));
    (0, proxify_1.registerModel)('ISubscriptionsModel', () => new modelClasses_1.SubscriptionsRaw(db, trash));
    (0, proxify_1.registerModel)('ITeamModel', () => new modelClasses_1.TeamRaw(db));
    (0, proxify_1.registerModel)('ITeamMemberModel', () => new modelClasses_1.TeamMemberRaw(db));
    (0, proxify_1.registerModel)('IMessagesModel', () => new modelClasses_1.MessagesRaw(db));
    (0, proxify_1.registerModel)('ILivechatInquiryModel', () => new modelClasses_1.LivechatInquiryRaw(db, trash));
    (0, proxify_1.registerModel)('ILivechatDepartmentAgentsModel', () => new modelClasses_1.LivechatDepartmentAgentsRaw(db, trash));
    (0, proxify_1.registerModel)('IPermissionsModel', () => new modelClasses_1.PermissionsRaw(db));
    (0, proxify_1.registerModel)('ILoginServiceConfigurationModel', () => new modelClasses_1.LoginServiceConfigurationRaw(db));
    (0, proxify_1.registerModel)('IInstanceStatusModel', () => new modelClasses_1.InstanceStatusRaw(db));
    (0, proxify_1.registerModel)('IIntegrationHistoryModel', () => new modelClasses_1.IntegrationHistoryRaw(db));
    (0, proxify_1.registerModel)('IIntegrationsModel', () => new modelClasses_1.IntegrationsRaw(db));
    (0, proxify_1.registerModel)('IEmailInboxModel', () => new modelClasses_1.EmailInboxRaw(db));
    (0, proxify_1.registerModel)('IPbxEventsModel', () => new modelClasses_1.PbxEventsRaw(db));
    (0, proxify_1.registerModel)('ILivechatPriorityModel', new modelClasses_1.LivechatPriorityRaw(db));
    (0, proxify_1.registerModel)('ILivechatRoomsModel', () => new modelClasses_1.LivechatRoomsRaw(db));
    (0, proxify_1.registerModel)('IUploadsModel', () => new modelClasses_1.UploadsRaw(db));
    (0, proxify_1.registerModel)('ILivechatVisitorsModel', () => new modelClasses_1.LivechatVisitorsRaw(db));
}
if (!exports.dbWatchersDisabled) {
    console.warn(`Database watchers is enabled and this is not the default option.\nRocket.Chat deprecated the usage of \`oplog/change streams\` and are going to remove it the next major version (8.0.0).`);
}
//# sourceMappingURL=index.js.map