"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseDummy = void 0;
const index_1 = require("../index");
class BaseDummy {
    constructor(name) {
        this.name = name;
        this.collectionName = (0, index_1.getCollectionName)(name);
        this.col = undefined;
    }
    async createIndexes() {
        // nothing to do
    }
    getUpdater() {
        return new index_1.UpdaterImpl();
    }
    updateFromUpdater(query, updater) {
        return this.updateOne(query, updater);
    }
    getCollectionName() {
        return this.collectionName;
    }
    async findOneAndDelete() {
        return null;
    }
    async findOneAndUpdate() {
        return null;
    }
    async findOneById(_id, _options) {
        return null;
    }
    async findOne(_query, _options) {
        return null;
    }
    find(_query, _options) {
        return undefined;
    }
    findPaginated(_query, _options) {
        return {
            cursor: undefined,
            totalCount: Promise.resolve(0),
        };
    }
    async update(filter, update, options) {
        return this.updateOne(filter, update, options);
    }
    async updateOne(_filter, _update, _options) {
        return {
            acknowledged: true,
            matchedCount: 0,
            modifiedCount: 0,
            upsertedCount: 0,
            upsertedId: '',
        };
    }
    async updateMany(filter, update, options) {
        return this.updateOne(filter, update, options);
    }
    async insertMany(_docs, _options) {
        return {
            acknowledged: true,
            insertedCount: 0,
            insertedIds: {},
        };
    }
    async insertOne(_doc, _options) {
        return {
            acknowledged: true,
            insertedId: '',
        };
    }
    async removeById(_id) {
        return {
            acknowledged: true,
            deletedCount: 0,
        };
    }
    async removeByIds(_ids) {
        return {
            acknowledged: true,
            deletedCount: 0,
        };
    }
    async deleteOne(filter, options) {
        return this.deleteMany(filter, options);
    }
    async deleteMany(_filter, _options) {
        return {
            acknowledged: true,
            deletedCount: 0,
        };
    }
    // Trash
    trashFind(_query, _options) {
        return undefined;
    }
    async trashFindOneById(_id, _options) {
        return null;
    }
    trashFindDeletedAfter(_deletedAt, _query, _options) {
        return undefined;
    }
    trashFindPaginatedDeletedAfter(_deletedAt, _query, _options) {
        return {
            cursor: undefined,
            totalCount: Promise.resolve(0),
        };
    }
    watch(_pipeline) {
        return undefined;
    }
    async countDocuments() {
        return 0;
    }
    async estimatedDocumentCount() {
        return 0;
    }
}
exports.BaseDummy = BaseDummy;
//# sourceMappingURL=BaseDummy.js.map