export const SipErrorCodes = {
	BAD_REQUEST: 400,
	UNAUTHORIZED: 401,
	FORBIDDEN: 403,
	NOT_FOUND: 404,
	METHOD_NOT_ALLOWED: 405,
	NOT_ACCEPTABLE: 406,
	TIMEOUT: 408,
	TEMPORARILY_UNAVAILABLE: 480,
	INVALID_CALL: 481,
	ADDRESS_INCOMPLETE: 484,
	AMBIGUOUS: 485,
	BUSY_HERE: 486,
	REQUEST_TERMINATED: 487,
	NOT_ACCEPTABLE_HERE: 488,
	BAD_EVENT: 489,

	INTERNAL_SERVER_ERROR: 500,
	NOT_IMPLEMENTED: 501,
	SERVICE_NOT_AVAILABLE: 503,

	DECLINED: 603,
} as const;

export class SipError extends Error {
	constructor(
		public readonly sipErrorCode: number,
		message?: string,
	) {
		super(message || 'sip-error');
	}
}
