"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseSipCall = void 0;
const models_1 = require("@rocket.chat/models");
const BaseCallProvider_1 = require("../../base/BaseCallProvider");
class BaseSipCall extends BaseCallProvider_1.BaseCallProvider {
    constructor(session, call, agent, channel) {
        super(call);
        this.session = session;
        this.agent = agent;
        this.channel = channel;
        this.lastCallState = 'none';
    }
    async reactToCallChanges(params) {
        // If we already knew this call was over, there's nothing more to reflect
        if (this.lastCallState === 'hangup') {
            return;
        }
        const freshCall = await models_1.MediaCalls.findOneById(this.call._id);
        if (!freshCall) {
            return;
        }
        // Don't do anything unless our agent has one of the call's signed actors
        const callActor = this.agent.getMyCallActor(freshCall);
        if (!this.agent.isRepresentingActor(callActor) || callActor.contractId !== this.session.sessionId) {
            return;
        }
        return this.reflectCall(freshCall, params);
    }
    async sendDTMF(dialog, dtmf, duration) {
        await dialog.request({
            method: 'INFO',
            headers: {
                'Content-Type': 'application/dtmf-relay',
            },
            body: `Signal=${dtmf}\r\nDuration=${duration}`,
        });
    }
}
exports.BaseSipCall = BaseSipCall;
//# sourceMappingURL=BaseSipCall.js.map