"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setCastDirector = setCastDirector;
exports.getCastDirector = getCastDirector;
exports.setMediaCallServer = setMediaCallServer;
exports.getMediaCallServer = getMediaCallServer;
const logger_1 = require("../logger");
let castDirectorInstance = null;
let mediaCallServerInstance = null;
function setCastDirector(director) {
    castDirectorInstance = director;
}
function getCastDirector() {
    if (!castDirectorInstance) {
        logger_1.logger.error({ msg: 'cast director instance was not set.', stack: new Error().stack });
        throw new Error('cast director instance was not set.');
    }
    return castDirectorInstance;
}
function setMediaCallServer(server) {
    mediaCallServerInstance = server;
}
function getMediaCallServer() {
    if (!mediaCallServerInstance) {
        logger_1.logger.error({ msg: 'media call server instance was not set.', stack: new Error().stack });
        throw new Error('media call server instance was not set.');
    }
    return mediaCallServerInstance;
}
//# sourceMappingURL=injection.js.map