"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNewCallTransferredBy = getNewCallTransferredBy;
function getNewCallTransferredBy(call) {
    const { createdBy, parentCallId, caller, callee } = call;
    if (!createdBy || !parentCallId) {
        return null;
    }
    if (createdBy.type === caller.type && createdBy.id === caller.id) {
        return null;
    }
    if (createdBy.type === callee.type && createdBy.id === callee.id) {
        return null;
    }
    return createdBy;
}
//# sourceMappingURL=getNewCallTransferredBy.js.map