"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalCallProvider = void 0;
const models_1 = require("@rocket.chat/models");
const BaseCallProvider_1 = require("../base/BaseCallProvider");
const common_1 = require("../definition/common");
const logger_1 = require("../logger");
const CallDirector_1 = require("../server/CallDirector");
class InternalCallProvider extends BaseCallProvider_1.BaseCallProvider {
    static async createCall(params) {
        logger_1.logger.debug({ msg: 'InternalCallProvider.createCall', params });
        if (params.caller.type !== 'user' || params.callee.type !== 'user') {
            throw new common_1.CallRejectedError('unsupported');
        }
        if (await models_1.MediaCalls.hasUnfinishedCallsByUid(params.caller.id, params.parentCallId)) {
            throw new common_1.CallRejectedError('busy');
        }
        if (await models_1.MediaCalls.hasUnfinishedCallsByUid(params.callee.id)) {
            throw new common_1.CallRejectedError('unavailable');
        }
        const callerAgent = await CallDirector_1.mediaCallDirector.cast.getAgentForActorAndRole(params.caller, 'caller');
        const calleeAgent = await CallDirector_1.mediaCallDirector.cast.getAgentForActorAndRole(params.callee, 'callee');
        if (!callerAgent) {
            throw new Error('invalid-caller');
        }
        if (!calleeAgent) {
            throw new Error('invalid-callee');
        }
        callerAgent.oppositeAgent = calleeAgent;
        calleeAgent.oppositeAgent = callerAgent;
        const call = await CallDirector_1.mediaCallDirector.createCall({
            ...params,
            callerAgent,
            calleeAgent,
        });
        // If the caller agent fails, this will automatically hangup the call and throw an error
        await CallDirector_1.mediaCallDirector.runOnCallCreatedForAgent(call, callerAgent);
        // If the callee agent fails, this will automatically hangup the call, notify the caller agent and then throw an error
        await CallDirector_1.mediaCallDirector.runOnCallCreatedForAgent(call, calleeAgent, callerAgent);
        if (params.parentCallId) {
            CallDirector_1.mediaCallDirector.hangupTransferredCallById(params.parentCallId).catch(() => null);
        }
        return call;
    }
}
exports.InternalCallProvider = InternalCallProvider;
//# sourceMappingURL=InternalCallProvider.js.map