"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseMediaCallAgent = void 0;
const models_1 = require("@rocket.chat/models");
class BaseMediaCallAgent {
    get actor() {
        return {
            type: this.actorType,
            id: this.actorId,
        };
    }
    get oppositeRole() {
        return { callee: 'caller', caller: 'callee' }[this.role];
    }
    constructor(contact, role) {
        this.contact = contact;
        this.role = role;
        this.actorType = contact.type;
        this.actorId = contact.id;
        this.localDescription = null;
        this.oppositeAgent = null;
    }
    isRepresentingActor(actor) {
        return actor.type === this.actorType && actor.id === this.actorId;
    }
    getMyCallActor(call) {
        return call[this.role];
    }
    getOtherCallActor(call) {
        return call[this.oppositeRole];
    }
    getSignedActor(contractId) {
        return {
            ...this.actor,
            contractId,
        };
    }
    async getOrCreateChannel(call, contractId) {
        return this.createOrUpdateChannel(call, contractId);
    }
    async createOrUpdateChannel(call, contractId) {
        if (!contractId) {
            throw new Error('error-invalid-contract');
        }
        const newChannel = {
            callId: call._id,
            state: 'none',
            role: this.role,
            contractId,
            actorType: this.actorType,
            actorId: this.actorId,
        };
        // Create this channel if it doesn't yet exist
        const insertedChannel = await models_1.MediaCallChannels.createOrUpdateChannel(newChannel);
        if (!insertedChannel) {
            throw new Error('failed-to-insert-channel');
        }
        // This shouldn't be possible unless something tried to switch the roles of the call's actors
        if (insertedChannel.role !== this.role) {
            throw new Error('invalid-channel-data');
        }
        return insertedChannel;
    }
}
exports.BaseMediaCallAgent = BaseMediaCallAgent;
//# sourceMappingURL=BaseAgent.js.map