"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateLicensePeriods = exports.isPeriodInvalid = void 0;
const isItemAllowed_1 = require("../isItemAllowed");
const logger_1 = require("../logger");
const getResultingBehavior_1 = require("./getResultingBehavior");
const isPeriodInvalid = (from, until) => {
    const now = new Date();
    if (from && now < new Date(from)) {
        return true;
    }
    if (until && now > new Date(until)) {
        return true;
    }
    return false;
};
exports.isPeriodInvalid = isPeriodInvalid;
const validateLicensePeriods = (license, options) => {
    const { validation: { validPeriods }, } = license;
    return validPeriods
        .filter(({ validFrom, validUntil, invalidBehavior }) => (0, isItemAllowed_1.isBehaviorAllowed)(invalidBehavior, options) && (0, exports.isPeriodInvalid)(validFrom, validUntil))
        .map((period) => {
        if (!options.suppressLog) {
            logger_1.logger.error({
                msg: 'Period validation failed',
                period,
            });
        }
        return (0, getResultingBehavior_1.getResultingBehavior)(period, { reason: 'period' });
    });
};
exports.validateLicensePeriods = validateLicensePeriods;
//# sourceMappingURL=validateLicensePeriods.js.map