"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateFormat = void 0;
const InvalidLicenseError_1 = require("../errors/InvalidLicenseError");
const token_1 = require("../token");
const validateFormat = async (encryptedLicense) => {
    if (!encryptedLicense || String(encryptedLicense).trim() === '') {
        throw new InvalidLicenseError_1.InvalidLicenseError('Empty license');
    }
    try {
        await (0, token_1.decrypt)(encryptedLicense);
    }
    catch (e) {
        throw new InvalidLicenseError_1.InvalidLicenseError();
    }
    return true;
};
exports.validateFormat = validateFormat;
//# sourceMappingURL=validateFormat.js.map