"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runValidation = runValidation;
const validateLicenseLimits_1 = require("./validateLicenseLimits");
const validateLicensePeriods_1 = require("./validateLicensePeriods");
const validateLicenseUrl_1 = require("./validateLicenseUrl");
async function runValidation(license, options) {
    return [
        ...validateLicenseUrl_1.validateLicenseUrl.call(this, license, options),
        ...(0, validateLicensePeriods_1.validateLicensePeriods)(license, options),
        ...(await validateLicenseLimits_1.validateLicenseLimits.call(this, license, options)),
    ];
}
//# sourceMappingURL=runValidation.js.map