"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getModulesToDisable = void 0;
const filterValidationResult = (result, expectedBehavior) => result.filter(({ behavior }) => behavior === expectedBehavior);
const getModulesToDisable = (validationResult) => {
    return [
        ...new Set([
            ...filterValidationResult(validationResult, 'disable_modules')
                .map(({ modules }) => modules || [])
                .flat(),
        ]),
    ];
};
exports.getModulesToDisable = getModulesToDisable;
//# sourceMappingURL=getModulesToDisable.js.map