"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBundleFromModule = void 0;
exports.isBundle = isBundle;
exports.getBundleModules = getBundleModules;
const core_typings_1 = require("@rocket.chat/core-typings");
const bundles = {
    enterprise: core_typings_1.CoreModules,
    pro: [],
};
const getBundleFromModule = (moduleName) => {
    const match = moduleName.match(/(.*):\*$/);
    if (!match) {
        return;
    }
    return match[1];
};
exports.getBundleFromModule = getBundleFromModule;
function isBundle(moduleName) {
    if (moduleName === '*') {
        return true;
    }
    const bundle = (0, exports.getBundleFromModule)(moduleName);
    if (!bundle) {
        return false;
    }
    return true;
}
function getBundleModules(moduleName) {
    if (moduleName === '*') {
        return Object.keys(bundles).reduce((modules, bundle) => modules.concat(bundles[bundle]), []);
    }
    const bundle = (0, exports.getBundleFromModule)(moduleName);
    if (!bundle || !bundles[bundle]) {
        return [];
    }
    return bundles[bundle];
}
//# sourceMappingURL=bundles.js.map