"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.License = exports.LicenseImp = void 0;
const deprecated_1 = require("./deprecated");
const deprecated_2 = require("./events/deprecated");
const listeners_1 = require("./events/listeners");
const overwriteClassOnLicense_1 = require("./events/overwriteClassOnLicense");
const license_1 = require("./license");
const logger_1 = require("./logger");
const modules_1 = require("./modules");
const showLicense_1 = require("./showLicense");
const tags_1 = require("./tags");
const getCurrentValueForLicenseLimit_1 = require("./validation/getCurrentValueForLicenseLimit");
const validateFormat_1 = require("./validation/validateFormat");
// eslint-disable-next-line @typescript-eslint/naming-convention
class LicenseImp extends license_1.LicenseManager {
    constructor() {
        super();
        this.validateFormat = validateFormat_1.validateFormat;
        this.hasModule = modules_1.hasModule;
        this.getModules = modules_1.getModules;
        this.getModuleDefinition = modules_1.getModuleDefinition;
        this.getExternalModules = modules_1.getExternalModules;
        this.getTags = tags_1.getTags;
        this.overwriteClassOnLicense = overwriteClassOnLicense_1.overwriteClassOnLicense;
        this.setLicenseLimitCounter = getCurrentValueForLicenseLimit_1.setLicenseLimitCounter;
        this.getCurrentValueForLicenseLimit = getCurrentValueForLicenseLimit_1.getCurrentValueForLicenseLimit;
        this.onChange = listeners_1.onChange;
        this.onInstall = listeners_1.onInstall;
        this.onRemoveLicense = listeners_1.onRemoveLicense;
        this.onInvalidate = listeners_1.onInvalidate;
        this.onValidFeature = listeners_1.onValidFeature;
        this.onInvalidFeature = listeners_1.onInvalidFeature;
        this.onToggledFeature = listeners_1.onToggledFeature;
        this.onModule = listeners_1.onModule;
        this.onValidateLicense = listeners_1.onValidateLicense;
        this.onInvalidateLicense = listeners_1.onInvalidateLicense;
        this.onLimitReached = listeners_1.onLimitReached;
        this.onBehaviorTriggered = listeners_1.onBehaviorTriggered;
        this.onBehaviorToggled = listeners_1.onBehaviorToggled;
        // Deprecated:
        this.onLicense = deprecated_2.onLicense;
        // Deprecated:
        this.getMaxActiveUsers = deprecated_1.getMaxActiveUsers;
        // Deprecated:
        this.getAppsConfig = deprecated_1.getAppsConfig;
        // Deprecated:
        this.getUnmodifiedLicenseAndModules = deprecated_1.getUnmodifiedLicenseAndModules;
        this.onValidateLicense(() => showLicense_1.showLicense.call(this, this.getLicense(), this.hasValidLicense()));
        this.onValidateLicense(() => {
            logger_1.logger.startup({
                msg: 'License installed',
                version: this.getLicense()?.version,
                hash: this._lockedLicense?.slice(-8),
            });
        });
        this.onRemoveLicense(() => {
            logger_1.logger.startup({
                msg: 'License removed',
            });
        });
        this.onInvalidateLicense(() => {
            logger_1.logger.startup({
                msg: 'License invalidated',
            });
        });
    }
    async isLimitReached(action, context) {
        return this.shouldPreventAction(action, 0, context);
    }
}
exports.LicenseImp = LicenseImp;
const license = new LicenseImp();
exports.License = license;
//# sourceMappingURL=licenseImp.js.map