"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isBehaviorAllowed = exports.isLimitAllowed = void 0;
const isItemAllowed = (item, allowList) => {
    return !allowList || allowList.includes(item);
};
const isLimitAllowed = (item, options) => isItemAllowed(item, options.limits);
exports.isLimitAllowed = isLimitAllowed;
const isBehaviorAllowed = (item, options) => isItemAllowed(item, options.behaviors) && (options.isNewLicense || item !== 'prevent_installation');
exports.isBehaviorAllowed = isBehaviorAllowed;
//# sourceMappingURL=isItemAllowed.js.map