"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.onChange = onChange;
exports.onInstall = onInstall;
exports.onRemoveLicense = onRemoveLicense;
exports.onInvalidate = onInvalidate;
exports.onValidFeature = onValidFeature;
exports.onInvalidFeature = onInvalidFeature;
exports.onToggledFeature = onToggledFeature;
exports.onModule = onModule;
exports.onValidateLicense = onValidateLicense;
exports.onInvalidateLicense = onInvalidateLicense;
exports.onBehaviorTriggered = onBehaviorTriggered;
exports.onBehaviorToggled = onBehaviorToggled;
exports.onLimitReached = onLimitReached;
const modules_1 = require("../modules");
/**
 * Invoked when the license changes some internal state. it's called to sync the license with other instances.
 */
function onChange(cb) {
    this.on('sync', cb);
}
function onInstall(cb) {
    if (this.hasValidLicense()) {
        cb();
    }
    this.on('installed', cb);
}
function onRemoveLicense(cb) {
    this.on('removed', cb);
}
function onInvalidate(cb) {
    if (!this.hasValidLicense()) {
        cb();
    }
    this.on('invalidate', cb);
}
function onValidFeature(feature, cb) {
    this.on(`valid:${feature}`, cb);
    if (modules_1.hasModule.call(this, feature)) {
        cb();
    }
    return () => {
        this.off(`valid:${feature}`, cb);
    };
}
function onInvalidFeature(feature, cb) {
    this.on(`invalid:${feature}`, cb);
    if (!modules_1.hasModule.call(this, feature)) {
        cb();
    }
    return () => {
        this.off(`invalid:${feature}`, cb);
    };
}
function onToggledFeature(feature, { up, down }) {
    let enabled = modules_1.hasModule.call(this, feature);
    const offValidFeature = onValidFeature.bind(this)(feature, () => {
        if (!enabled) {
            void up?.();
            enabled = true;
        }
    });
    const offInvalidFeature = onInvalidFeature.bind(this)(feature, () => {
        if (enabled) {
            void down?.();
            enabled = false;
        }
    });
    if (enabled) {
        void up?.();
    }
    return () => {
        offValidFeature();
        offInvalidFeature();
    };
}
function onModule(cb) {
    this.on('module', cb);
}
function onValidateLicense(cb) {
    this.on('validate', cb);
}
function onInvalidateLicense(cb) {
    this.on('invalidate', cb);
}
function onBehaviorTriggered(behavior, cb) {
    this.on(`behavior:${behavior}`, cb);
}
function onBehaviorToggled(behavior, cb) {
    this.on(`behaviorToggled:${behavior}`, cb);
}
function onLimitReached(limitKind, cb) {
    this.on(`limitReached:${limitKind}`, cb);
}
//# sourceMappingURL=listeners.js.map