"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLicenseLimit = void 0;
exports.getMaxActiveUsers = getMaxActiveUsers;
exports.getAppsConfig = getAppsConfig;
exports.getUnmodifiedLicenseAndModules = getUnmodifiedLicenseAndModules;
const modules_1 = require("./modules");
const validateDefaultLimits_1 = require("./validation/validateDefaultLimits");
const getLicenseLimit = (license, kind) => {
    const limitList = license ? license.limits[kind] : validateDefaultLimits_1.defaultLimits[kind];
    if (!limitList?.length) {
        return -1;
    }
    return Math.min(...limitList.map(({ max }) => max));
};
exports.getLicenseLimit = getLicenseLimit;
// #TODO: Remove references to those functions
function getMaxActiveUsers() {
    return (0, exports.getLicenseLimit)(this.getLicense(), 'activeUsers') ?? 0;
}
function getAppsConfig() {
    return {
        maxPrivateApps: (0, exports.getLicenseLimit)(this.getLicense(), 'privateApps'),
        maxMarketplaceApps: (0, exports.getLicenseLimit)(this.getLicense(), 'marketplaceApps'),
    };
}
function getUnmodifiedLicenseAndModules() {
    if (this.valid && this.unmodifiedLicense) {
        return {
            license: this.unmodifiedLicense,
            modules: modules_1.getModules.call(this),
        };
    }
}
//# sourceMappingURL=deprecated.js.map