"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _AirGappedRestrictionClass_restricted;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AirGappedRestriction = void 0;
const events_1 = __importDefault(require("events"));
const _1 = require(".");
const token_1 = require("./token");
const DAY_IN_MS = 24 * 60 * 60 * 1000;
const NO_ACTION_PERIOD_IN_DAYS = 3;
const WARNING_PERIOD_IN_DAYS = 7;
class AirGappedRestrictionClass extends events_1.default {
    constructor() {
        super(...arguments);
        _AirGappedRestrictionClass_restricted.set(this, true);
    }
    get restricted() {
        return __classPrivateFieldGet(this, _AirGappedRestrictionClass_restricted, "f");
    }
    async computeRestriction(encryptedToken) {
        if (_1.License.hasValidLicense()) {
            this.removeRestrictionsUnderLicense();
            return;
        }
        if (typeof encryptedToken !== 'string') {
            this.applyRestrictions();
            return;
        }
        return this.checkRemainingDaysSinceLastStatsReport(encryptedToken);
    }
    async checkRemainingDaysSinceLastStatsReport(encryptedToken) {
        try {
            const { timestamp: lastStatsReportTimestamp } = JSON.parse(await (0, token_1.decryptStatsToken)(encryptedToken));
            const now = new Date();
            const lastStatsReport = new Date(lastStatsReportTimestamp);
            const nowUTC = Date.UTC(now.getFullYear(), now.getMonth(), now.getDate());
            const lastStatsReportUTC = Date.UTC(lastStatsReport.getFullYear(), lastStatsReport.getMonth(), lastStatsReport.getDate());
            const daysSinceLastStatsReport = Math.floor((nowUTC - lastStatsReportUTC) / DAY_IN_MS);
            this.notifyRemainingDaysUntilRestriction(daysSinceLastStatsReport);
        }
        catch {
            this.applyRestrictions();
        }
    }
    applyRestrictions() {
        this.notifyRemainingDaysUntilRestriction(NO_ACTION_PERIOD_IN_DAYS + WARNING_PERIOD_IN_DAYS);
    }
    removeRestrictionsUnderLicense() {
        __classPrivateFieldSet(this, _AirGappedRestrictionClass_restricted, false, "f");
        this.emit('remainingDays', { days: -1 });
    }
    isWarningPeriod(days) {
        if (days < 0) {
            return false;
        }
        return days <= WARNING_PERIOD_IN_DAYS;
    }
    notifyRemainingDaysUntilRestriction(daysSinceLastStatsReport) {
        const remainingDaysUntilRestriction = Math.max(NO_ACTION_PERIOD_IN_DAYS + WARNING_PERIOD_IN_DAYS - daysSinceLastStatsReport, 0);
        __classPrivateFieldSet(this, _AirGappedRestrictionClass_restricted, remainingDaysUntilRestriction === 0, "f");
        this.emit('remainingDays', { days: remainingDaysUntilRestriction });
    }
}
_AirGappedRestrictionClass_restricted = new WeakMap();
const airGappedRestriction = new AirGappedRestrictionClass();
exports.AirGappedRestriction = airGappedRestriction;
//# sourceMappingURL=AirGappedRestriction.js.map