import { jsx as _jsx } from "react/jsx-runtime";
import colors from '@rocket.chat/fuselage-tokens/colors.json';
import { useMemo } from 'react';
import { renderToStaticMarkup } from 'react-dom/server';
import { useDarkMode } from '../../DarkModeProvider';
import { useLayoutContext } from '../../contexts/LayoutContext';
import BackgroundImage from './BackgroundImage';
import { Wrapper } from './BackgroundLayer.styles';
var BackgroundLayer = function (_a) {
    var children = _a.children;
    var _b = useLayoutContext(), background = _b.background, _c = _b.backgroundDark, backgroundDark = _c === void 0 ? background : _c;
    var darkMode = useDarkMode();
    var backgroundColor = darkMode ? colors.n800 : colors.n200;
    var color = darkMode ? colors.white : colors.n800;
    var backgroundImage = useMemo(function () {
        return (darkMode ? backgroundDark : background) ||
            "data:image/svg+xml,".concat(encodeURIComponent(renderToStaticMarkup(_jsx(BackgroundImage, { backgroundColor: backgroundColor }))));
    }, [backgroundColor]);
    return (_jsx(Wrapper, { color: color, backgroundImage: backgroundImage, backgroundColor: backgroundColor, children: children }));
};
export default BackgroundLayer;
//# sourceMappingURL=BackgroundLayer.js.map