"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.honoAdapterForExpress = void 0;
const stream_1 = require("stream");
const honoAdapterForExpress = (hono) => async (expressReq, res) => {
    expressReq.duplex = 'half';
    if (stream_1.Readable.isDisturbed(expressReq)) {
        return;
    }
    const { body, ...req } = expressReq;
    const honoRes = await hono.request(expressReq.originalUrl, {
        ...req,
        ...(['POST', 'PUT', 'DELETE'].includes(expressReq.method) && { body: expressReq }),
        headers: new Headers(Object.fromEntries(Object.entries(expressReq.headers))),
    }, {
        incoming: expressReq,
    });
    res.status(honoRes.status);
    honoRes.headers.forEach((value, key) => res.setHeader(key, value));
    if (!honoRes.body) {
        res.end();
        return;
    }
    if (honoRes.body instanceof ReadableStream) {
        stream_1.Readable.fromWeb(honoRes.body).pipe(res);
        return;
    }
    // Converting it to a Buffer because res.send appends always a charset to the Content-Type
    // https://github.com/expressjs/express/issues/2238
    res.send(Buffer.from(await honoRes.text()));
};
exports.honoAdapterForExpress = honoAdapterForExpress;
//# sourceMappingURL=honoAdapterForExpress.js.map