import { Fragment as _Fragment, jsxs as _jsxs, jsx as _jsx } from "react/jsx-runtime";
import { Message } from '@rocket.chat/fuselage';
import { useButtonPattern } from '@rocket.chat/fuselage-hooks';
import { memo, useContext, useMemo } from 'react';
import { useTranslation } from 'react-i18next';
import { MarkupInteractionContext } from '../MarkupInteractionContext';
const handleChannelMention = (mention, withSymbol) => (withSymbol ? `#${mention}` : mention);
const ChannelMentionElement = ({ mention }) => {
    var _a;
    const { t } = useTranslation();
    const { resolveChannelMention, onChannelMentionClick, showMentionSymbol } = useContext(MarkupInteractionContext);
    const resolved = useMemo(() => resolveChannelMention === null || resolveChannelMention === void 0 ? void 0 : resolveChannelMention(mention), [mention, resolveChannelMention]);
    const handleClick = useMemo(() => (resolved ? onChannelMentionClick === null || onChannelMentionClick === void 0 ? void 0 : onChannelMentionClick(resolved) : undefined), [resolved, onChannelMentionClick]);
    const buttonProps = useButtonPattern((e) => handleClick === null || handleClick === void 0 ? void 0 : handleClick(e));
    if (!resolved) {
        return _jsxs(_Fragment, { children: ["#", mention] });
    }
    return (_jsx(Message.Highlight, Object.assign({ title: t('Mentions_channel'), variant: 'link', clickable: true }, buttonProps, { children: handleChannelMention((_a = resolved.fname) !== null && _a !== void 0 ? _a : mention, showMentionSymbol) })));
};
export default memo(ChannelMentionElement);
//# sourceMappingURL=ChannelMentionElement.js.map