import { jsx as _jsx } from "react/jsx-runtime";
import katex from 'katex';
import { useMemo } from 'react';
import 'katex/dist/katex.css';
const KatexElement = ({ code }) => {
    const html = useMemo(() => katex.renderToString(code, {
        displayMode: false,
        macros: {
            '\\href': '\\@secondoftwo',
        },
        maxSize: 100,
    }), [code]);
    return _jsx("span", { dangerouslySetInnerHTML: { __html: html } });
};
export default KatexElement;
//# sourceMappingURL=KatexElement.js.map