import { Fragment as _Fragment, jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Fragment, memo, useContext, useMemo } from 'react';
import { useTranslation } from 'react-i18next';
import { MarkupInteractionContext } from '../MarkupInteractionContext';
const PlainSpan = ({ text }) => {
    const { t } = useTranslation();
    const { highlightRegex, markRegex } = useContext(MarkupInteractionContext);
    const content = useMemo(() => {
        var _a, _b;
        if (highlightRegex) {
            const chunks = text.split(highlightRegex());
            const head = (_a = chunks.shift()) !== null && _a !== void 0 ? _a : '';
            return (_jsxs(_Fragment, { children: [_jsx(_Fragment, { children: head }), chunks.map((chunk, i) => {
                        if (i % 2 === 0) {
                            return (_jsx("mark", { title: t('Highlighted_chosen_word'), className: 'highlight-text', children: chunk }, i));
                        }
                        return _jsx(Fragment, { children: chunk }, i);
                    })] }));
        }
        if (markRegex) {
            const chunks = text.split(markRegex());
            const head = (_b = chunks.shift()) !== null && _b !== void 0 ? _b : '';
            return (_jsxs(_Fragment, { children: [_jsx(_Fragment, { children: head }), chunks.map((chunk, i) => {
                        if (i % 2 === 0) {
                            return _jsx("mark", { children: chunk }, i);
                        }
                        return _jsx(Fragment, { children: chunk }, i);
                    })] }));
        }
        return text;
    }, [highlightRegex, markRegex, text, t]);
    return _jsx(_Fragment, { children: content });
};
export default memo(PlainSpan);
//# sourceMappingURL=PlainSpan.js.map