import { jsx as _jsx } from "react/jsx-runtime";
import { getBaseURI, isExternal } from '@rocket.chat/ui-client';
import { useMemo } from 'react';
import { useTranslation } from 'react-i18next';
import BoldSpan from './BoldSpan';
import ItalicSpan from './ItalicSpan';
import PlainSpan from './PlainSpan';
import StrikeSpan from './StrikeSpan';
import { sanitizeUrl } from './sanitizeUrl';
const LinkSpan = ({ href, label }) => {
    // Should sanitize 'href' if any of the insecure prefixes are present - see DSK-34 on Jira
    const sanitizedHref = sanitizeUrl(href);
    const { t } = useTranslation();
    const children = useMemo(() => {
        const labelArray = Array.isArray(label) ? label : [label];
        const labelElements = labelArray.map((child, index) => {
            switch (child.type) {
                case 'PLAIN_TEXT':
                    return _jsx(PlainSpan, { text: child.value }, index);
                case 'STRIKE':
                    return _jsx(StrikeSpan, { children: child.value }, index);
                case 'ITALIC':
                    return _jsx(ItalicSpan, { children: child.value }, index);
                case 'BOLD':
                    return _jsx(BoldSpan, { children: child.value }, index);
                default:
                    return null;
            }
        });
        return labelElements;
    }, [label]);
    if (isExternal(sanitizedHref)) {
        return (_jsx("a", { href: sanitizedHref, title: sanitizedHref, rel: 'noopener noreferrer', target: '_blank', children: children }));
    }
    return (_jsx("a", { href: sanitizedHref, title: t('Go_to_href', { href: sanitizedHref.replace(getBaseURI(), '') }), children: children }));
};
export default LinkSpan;
//# sourceMappingURL=LinkSpan.js.map