import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { lazy } from 'react';
import BoldSpan from './BoldSpan';
import ImageElement from './ImageElement';
import ItalicSpan from './ItalicSpan';
import LinkSpan from './LinkSpan';
import PlainSpan from './PlainSpan';
import StrikeSpan from './StrikeSpan';
import Timestamp from './Timestamp';
import CodeElement from '../code/CodeElement';
import ColorElement from '../colors/ColorElement';
import EmojiElement from '../emoji/EmojiElement';
import KatexErrorBoundary from '../katex/KatexErrorBoundary';
import ChannelMentionElement from '../mentions/ChannelMentionElement';
import UserMentionElement from '../mentions/UserMentionElement';
const KatexElement = lazy(() => import('../katex/KatexElement'));
const InlineElements = ({ children }) => (_jsx(_Fragment, { children: children.map((child, index) => {
        switch (child.type) {
            case 'BOLD':
                return _jsx(BoldSpan, { children: child.value }, index);
            case 'STRIKE':
                return _jsx(StrikeSpan, { children: child.value }, index);
            case 'ITALIC':
                return _jsx(ItalicSpan, { children: child.value }, index);
            case 'LINK':
                return (_jsx(LinkSpan, { href: child.value.src.value, label: Array.isArray(child.value.label) ? child.value.label : [child.value.label] }, index));
            case 'PLAIN_TEXT':
                return _jsx(PlainSpan, { text: child.value }, index);
            case 'IMAGE':
                return _jsx(ImageElement, { src: child.value.src.value, alt: child.value.label }, index);
            case 'MENTION_USER':
                return _jsx(UserMentionElement, { mention: child.value.value }, index);
            case 'MENTION_CHANNEL':
                return _jsx(ChannelMentionElement, { mention: child.value.value }, index);
            case 'INLINE_CODE':
                return _jsx(CodeElement, { code: child.value.value }, index);
            case 'EMOJI':
                return _jsx(EmojiElement, Object.assign({}, child), index);
            case 'COLOR':
                return _jsx(ColorElement, Object.assign({}, child.value), index);
            case 'INLINE_KATEX':
                return (_jsx(KatexErrorBoundary, { code: child.value, children: _jsx(KatexElement, { code: child.value }) }, index));
            case 'TIMESTAMP': {
                return _jsx(Timestamp, { children: child }, index);
            }
            default: {
                if ('fallback' in child) {
                    return _jsx(InlineElements, { children: [child.fallback] }, index);
                }
                return null;
            }
        }
    }) }));
export default InlineElements;
//# sourceMappingURL=InlineElements.js.map