'use strict';

if (process.env.NODE_ENV !== "production") {
(function() {
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("@rocket.chat/css-in-js"), require("@rocket.chat/css-supports"), require("@rocket.chat/fuselage-hooks"), require("@rocket.chat/fuselage-tokens/colors.json"), require("@rocket.chat/fuselage-tokens/dist/badge.json"), require("@rocket.chat/fuselage-tokens/dist/button.json"), require("@rocket.chat/fuselage-tokens/dist/font.json"), require("@rocket.chat/fuselage-tokens/dist/shadow.json"), require("@rocket.chat/fuselage-tokens/dist/status.json"), require("@rocket.chat/fuselage-tokens/dist/statusBullet.json"), require("@rocket.chat/fuselage-tokens/dist/stroke.json"), require("@rocket.chat/fuselage-tokens/dist/surface.json"), require("@rocket.chat/fuselage-tokens/typography.json"), require("@rocket.chat/icons"), require("@rocket.chat/memo"), require("invariant"), require("react"), require("react-aria"), require("react-dom"), require("react-keyed-flatten-children"), require("react-stately"), require("react-virtuoso"), require("react/jsx-runtime"));
	else if(typeof define === 'function' && define.amd)
		define("RocketChatFuselage", ["@rocket.chat/css-in-js", "@rocket.chat/css-supports", "@rocket.chat/fuselage-hooks", "@rocket.chat/fuselage-tokens/colors.json", "@rocket.chat/fuselage-tokens/dist/badge.json", "@rocket.chat/fuselage-tokens/dist/button.json", "@rocket.chat/fuselage-tokens/dist/font.json", "@rocket.chat/fuselage-tokens/dist/shadow.json", "@rocket.chat/fuselage-tokens/dist/status.json", "@rocket.chat/fuselage-tokens/dist/statusBullet.json", "@rocket.chat/fuselage-tokens/dist/stroke.json", "@rocket.chat/fuselage-tokens/dist/surface.json", "@rocket.chat/fuselage-tokens/typography.json", "@rocket.chat/icons", "@rocket.chat/memo", "invariant", "react", "react-aria", "react-dom", "react-keyed-flatten-children", "react-stately", "react-virtuoso", "react/jsx-runtime"], factory);
	else if(typeof exports === 'object')
		exports["RocketChatFuselage"] = factory(require("@rocket.chat/css-in-js"), require("@rocket.chat/css-supports"), require("@rocket.chat/fuselage-hooks"), require("@rocket.chat/fuselage-tokens/colors.json"), require("@rocket.chat/fuselage-tokens/dist/badge.json"), require("@rocket.chat/fuselage-tokens/dist/button.json"), require("@rocket.chat/fuselage-tokens/dist/font.json"), require("@rocket.chat/fuselage-tokens/dist/shadow.json"), require("@rocket.chat/fuselage-tokens/dist/status.json"), require("@rocket.chat/fuselage-tokens/dist/statusBullet.json"), require("@rocket.chat/fuselage-tokens/dist/stroke.json"), require("@rocket.chat/fuselage-tokens/dist/surface.json"), require("@rocket.chat/fuselage-tokens/typography.json"), require("@rocket.chat/icons"), require("@rocket.chat/memo"), require("invariant"), require("react"), require("react-aria"), require("react-dom"), require("react-keyed-flatten-children"), require("react-stately"), require("react-virtuoso"), require("react/jsx-runtime"));
	else
		root["RocketChatFuselage"] = factory(root["@rocket.chat/css-in-js"], root["@rocket.chat/css-supports"], root["@rocket.chat/fuselage-hooks"], root["@rocket.chat/fuselage-tokens/colors.json"], root["@rocket.chat/fuselage-tokens/dist/badge.json"], root["@rocket.chat/fuselage-tokens/dist/button.json"], root["@rocket.chat/fuselage-tokens/dist/font.json"], root["@rocket.chat/fuselage-tokens/dist/shadow.json"], root["@rocket.chat/fuselage-tokens/dist/status.json"], root["@rocket.chat/fuselage-tokens/dist/statusBullet.json"], root["@rocket.chat/fuselage-tokens/dist/stroke.json"], root["@rocket.chat/fuselage-tokens/dist/surface.json"], root["@rocket.chat/fuselage-tokens/typography.json"], root["@rocket.chat/icons"], root["@rocket.chat/memo"], root["invariant"], root["react"], root["react-aria"], root["react-dom"], root["react-keyed-flatten-children"], root["react-stately"], root["react-virtuoso"], root["react/jsx-runtime"]);
})(self, function(__WEBPACK_EXTERNAL_MODULE__rocket_chat_css_in_js__, __WEBPACK_EXTERNAL_MODULE__rocket_chat_css_supports__, __WEBPACK_EXTERNAL_MODULE__rocket_chat_fuselage_hooks__, __WEBPACK_EXTERNAL_MODULE__rocket_chat_fuselage_tokens_colors_json__, __WEBPACK_EXTERNAL_MODULE__rocket_chat_fuselage_tokens_dist_badge_json__, __WEBPACK_EXTERNAL_MODULE__rocket_chat_fuselage_tokens_dist_button_json__, __WEBPACK_EXTERNAL_MODULE__rocket_chat_fuselage_tokens_dist_font_json__, __WEBPACK_EXTERNAL_MODULE__rocket_chat_fuselage_tokens_dist_shadow_json__, __WEBPACK_EXTERNAL_MODULE__rocket_chat_fuselage_tokens_dist_status_json__, __WEBPACK_EXTERNAL_MODULE__rocket_chat_fuselage_tokens_dist_statusBullet_json__, __WEBPACK_EXTERNAL_MODULE__rocket_chat_fuselage_tokens_dist_stroke_json__, __WEBPACK_EXTERNAL_MODULE__rocket_chat_fuselage_tokens_dist_surface_json__, __WEBPACK_EXTERNAL_MODULE__rocket_chat_fuselage_tokens_typography_json__, __WEBPACK_EXTERNAL_MODULE__rocket_chat_icons__, __WEBPACK_EXTERNAL_MODULE__rocket_chat_memo__, __WEBPACK_EXTERNAL_MODULE_invariant__, __WEBPACK_EXTERNAL_MODULE_react__, __WEBPACK_EXTERNAL_MODULE_react_aria__, __WEBPACK_EXTERNAL_MODULE_react_dom__, __WEBPACK_EXTERNAL_MODULE_react_keyed_flatten_children__, __WEBPACK_EXTERNAL_MODULE_react_stately__, __WEBPACK_EXTERNAL_MODULE_react_virtuoso__, __WEBPACK_EXTERNAL_MODULE_react_jsx_runtime__) {
return /******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/Theme.ts":
/*!**********************!*\
  !*** ./src/Theme.ts ***!
  \**********************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Palette: function() { return /* binding */ Palette; },
/* harmony export */   Var: function() { return /* binding */ Var; },
/* harmony export */   __setThrowErrorOnInvalidToken__: function() { return /* binding */ __setThrowErrorOnInvalidToken__; },
/* harmony export */   badgeBackgroundColors: function() { return /* binding */ badgeBackgroundColors; },
/* harmony export */   isBadgeColor: function() { return /* binding */ isBadgeColor; },
/* harmony export */   isShadowColor: function() { return /* binding */ isShadowColor; },
/* harmony export */   isStatusBackgroundColor: function() { return /* binding */ isStatusBackgroundColor; },
/* harmony export */   isStatusColor: function() { return /* binding */ isStatusColor; },
/* harmony export */   isStrokeColor: function() { return /* binding */ isStrokeColor; },
/* harmony export */   isSurfaceColor: function() { return /* binding */ isSurfaceColor; },
/* harmony export */   isTextIconColor: function() { return /* binding */ isTextIconColor; },
/* harmony export */   neutral: function() { return /* binding */ neutral; },
/* harmony export */   shadowColors: function() { return /* binding */ shadowColors; },
/* harmony export */   statusBackgroundColors: function() { return /* binding */ statusBackgroundColors; },
/* harmony export */   statusColors: function() { return /* binding */ statusColors; },
/* harmony export */   strokeColors: function() { return /* binding */ strokeColors; },
/* harmony export */   surfaceColors: function() { return /* binding */ surfaceColors; },
/* harmony export */   textIconColors: function() { return /* binding */ textIconColors; },
/* harmony export */   throwErrorOnInvalidToken: function() { return /* binding */ throwErrorOnInvalidToken; }
/* harmony export */ });
/* harmony import */ var _rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rocket.chat/fuselage-tokens/colors.json */ "@rocket.chat/fuselage-tokens/colors.json");
/* harmony import */ var _rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _getPaletteColor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getPaletteColor */ "./src/getPaletteColor.ts");
/* harmony import */ var _helpers_toCSSValue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./helpers/toCSSValue */ "./src/helpers/toCSSValue.ts");



class Var {
    name;
    value;
    constructor(name, value) {
        this.name = name;
        this.value = value;
    }
    toString() {
        return (0,_helpers_toCSSValue__WEBPACK_IMPORTED_MODULE_2__.toCSSColorValue)(this.name, this.value);
    }
    theme(name) {
        return new Var(name, this.toString());
    }
}
const white = new Var('white', '#ffffff');
let throwErrorOnInvalidToken = false;
const __setThrowErrorOnInvalidToken__ = (value) => {
    throwErrorOnInvalidToken = value;
};
const neutral = {
    100: new Var('neutral-100', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().n100)),
    200: new Var('neutral-200', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().n200)),
    250: new Var('neutral-250', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().n250)),
    300: new Var('neutral-300', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().n300)),
    400: new Var('neutral-400', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().n400)),
    450: new Var('neutral-450', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().n450)),
    500: new Var('neutral-500', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().n500)),
    600: new Var('neutral-600', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().n600)),
    700: new Var('neutral-700', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().n700)),
    800: new Var('neutral-800', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().n800)),
    900: new Var('neutral-900', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().n900)),
};
const blue = {
    100: new Var('primary-100', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().b100)),
    200: new Var('primary-200', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().b200)),
    300: new Var('primary-300', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().b300)),
    400: new Var('primary-400', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().b400)),
    500: new Var('primary-500', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().b500)),
    600: new Var('primary-600', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().b600)),
    700: new Var('primary-700', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().b700)),
    800: new Var('primary-800', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().b800)),
    900: new Var('primary-900', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().b900)),
};
const green = {
    100: new Var('success-100', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().g100)),
    200: new Var('success-200', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().g200)),
    300: new Var('success-300', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().g300)),
    400: new Var('success-400', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().g400)),
    500: new Var('success-500', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().g500)),
    600: new Var('success-600', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().g600)),
    700: new Var('success-700', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().g700)),
    800: new Var('success-800', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().g800)),
    900: new Var('success-900', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().g900)),
};
const yellow = {
    100: new Var('warning-100', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().y100)),
    200: new Var('warning-200', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().y200)),
    300: new Var('warning-300', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().y300)),
    400: new Var('warning-400', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().y400)),
    500: new Var('warning-500', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().y500)),
    600: new Var('warning-600', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().y600)),
    700: new Var('warning-700', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().y700)),
    800: new Var('warning-800', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().y800)),
    900: new Var('warning-900', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().y900)),
};
const red = {
    100: new Var('danger-100', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().r100)),
    200: new Var('danger-200', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().r200)),
    300: new Var('danger-300', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().r300)),
    400: new Var('danger-400', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().r400)),
    500: new Var('danger-500', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().r500)),
    600: new Var('danger-600', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().r600)),
    700: new Var('danger-700', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().r700)),
    800: new Var('danger-800', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().r800)),
    900: new Var('danger-900', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().r900)),
};
const orange = {
    100: new Var('service-1-100', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().o100)),
    200: new Var('service-1-200', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().o200)),
    300: new Var('service-1-300', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().o300)),
    400: new Var('service-1-400', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().o400)),
    500: new Var('service-1-500', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().o500)),
    600: new Var('service-1-600', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().o600)),
    700: new Var('service-1-700', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().o700)),
    800: new Var('service-1-800', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().o800)),
    900: new Var('service-1-900', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().o900)),
};
const purple = {
    100: new Var('service-2-100', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().p100)),
    200: new Var('service-2-200', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().p200)),
    300: new Var('service-2-300', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().p300)),
    400: new Var('service-2-400', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().p400)),
    500: new Var('service-2-500', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().p500)),
    600: new Var('service-2-600', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().p600)),
    700: new Var('service-2-700', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().p700)),
    800: new Var('service-2-800', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().p800)),
    900: new Var('service-2-900', (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default().p900)),
};
const surfaceColors = {
    'surface-light': white.theme('surface-light'),
    'surface-tint': neutral[100].theme('surface-tint'),
    'surface-room': white.theme('surface-room'),
    'surface-neutral': neutral[400].theme('surface-neutral'),
    'surface-disabled': neutral[100].theme('surface-disabled'),
    'surface-hover': neutral[200].theme('surface-hover'),
    'surface-selected': neutral[450].theme('surface-selected'),
    'surface-dark': neutral[800].theme('surface-dark'),
    'surface-featured': purple['700'].theme('surface-featured'),
    'surface-featured-hover': purple['800'].theme('surface-featured-hover'),
    'surface-overlay': neutral[800].theme('surface-overlay'),
    'surface-transparent': 'transparent',
    'surface-sidebar': neutral[400].theme('surface-sidebar'),
};
const strokeColors = {
    'stroke-extra-light': neutral[250].theme('stroke-extra-light'),
    'stroke-light': neutral[500].theme('stroke-light'),
    'stroke-medium': neutral[600].theme('stroke-medium'),
    'stroke-dark': neutral[700].theme('stroke-dark'),
    'stroke-extra-dark': neutral[800].theme('stroke-extra-dark'),
    'stroke-extra-light-highlight': blue[200].theme('stroke-extra-light-highlight'),
    'stroke-highlight': blue[500].theme('stroke-highlight'),
    'stroke-extra-light-error': red[200].theme('stroke-extra-light-error'),
    'stroke-error': red[500].theme('stroke-error'),
};
const textIconColors = {
    'font-white': white.theme('font-white'),
    'font-disabled': neutral[500].theme('font-disabled'),
    'font-annotation': neutral[600].theme('font-annotation'),
    'font-hint': neutral[700].theme('font-hint'),
    'font-secondary-info': neutral[700].theme('font-secondary-info'),
    'font-default': neutral[800].theme('font-default'),
    'font-titles-labels': neutral[900].theme('font-titles-labels'),
    'font-info': blue[600].theme('font-info'),
    'font-danger': red[600].theme('font-danger'),
    'font-pure-black': neutral[800].theme('font-pure-black'),
    'font-pure-white': white.theme('font-pure-white'),
};
const statusBackgroundColors = {
    'status-background-info': blue[200].theme('status-background-info'),
    'status-background-success': green[200].theme('status-background-success'),
    'status-background-danger': red[200].theme('status-background-danger'),
    'status-background-warning': yellow[200].theme('status-background-warning'),
    'status-background-warning-2': yellow[100].theme('status-background-warning-2'),
    'status-background-service-1': orange[200].theme('status-background-service-1'),
    'status-background-service-2': purple[200].theme('status-background-service-2'),
};
const statusColors = {
    'status-font-on-info': blue[600].theme('status-font-on-info'),
    'status-font-on-success': green[800].theme('status-font-on-success'),
    'status-font-on-warning': yellow[800].theme('status-font-on-warning'),
    'status-font-on-warning-2': neutral[800].theme('status-font-on-warning-2'),
    'status-font-on-danger': red[800].theme('status-font-on-danger'),
    'status-font-on-service-1': orange[800].theme('status-font-on-service-1'),
    'status-font-on-service-2': purple[600].theme('status-font-on-service-2'),
};
const badgeBackgroundColors = {
    'badge-background-level-0': neutral[400].theme('badge-background-level-0'),
    'badge-background-level-1': neutral[600].theme('badge-background-level-1'),
    'badge-background-level-2': blue[500].theme('badge-background-level-2'),
    'badge-background-level-3': orange[500].theme('badge-background-level-3'),
    'badge-background-level-4': red[500].theme('badge-background-level-4'),
};
const shadowColors = {
    'shadow-elevation-border': strokeColors['stroke-extra-light'].theme('shadow-elevation-border'),
    'shadow-elevation-1': new Var('shadow-elevation-1', (0,_getPaletteColor__WEBPACK_IMPORTED_MODULE_1__.getPaletteColor)('neutral', 800, 0.1)[1]),
    'shadow-elevation-2x': new Var('shadow-elevation-2x', (0,_getPaletteColor__WEBPACK_IMPORTED_MODULE_1__.getPaletteColor)('neutral', 800, 0.08)[1]),
    'shadow-elevation-2y': new Var('shadow-elevation-2y', (0,_getPaletteColor__WEBPACK_IMPORTED_MODULE_1__.getPaletteColor)('neutral', 800, 0.12)[1]),
    'shadow-highlight': blue[200].theme('shadow-highlight'),
    'shadow-danger': red[100].theme('shadow-danger'),
};
const isSurfaceColor = (color) => typeof color === 'string' && color in surfaceColors;
const isStrokeColor = (color) => typeof color === 'string' && color in strokeColors;
const isTextIconColor = (color) => typeof color === 'string' && color in textIconColors;
const isBadgeColor = (color) => typeof color === 'string' && color in badgeBackgroundColors;
const isStatusBackgroundColor = (color) => typeof color === 'string' && color in statusBackgroundColors;
const isStatusColor = (color) => typeof color === 'string' && color in statusColors;
const isShadowColor = (color) => typeof color === 'string' && color in shadowColors;
const Palette = {
    surface: surfaceColors,
    status: statusBackgroundColors,
    statusColor: statusColors,
    badge: badgeBackgroundColors,
    text: textIconColors,
    stroke: strokeColors,
    shadow: shadowColors,
};


/***/ }),

/***/ "./src/components/Accordion/Accordion.tsx":
/*!************************************************!*\
  !*** ./src/components/Accordion/Accordion.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/composeClassNames */ "./src/helpers/composeClassNames.ts");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



/**
 * An `Accordion` allows users to toggle the display of sections of content.
 */
const Accordion = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__.StylingBox, { ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: (0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_1__.cx)((0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_1__.cxx)('rcx-box')('full', 'animated'), 'rcx-accordion'), children: children }) }));
/* harmony default export */ __webpack_exports__["default"] = (Accordion);


/***/ }),

/***/ "./src/components/Accordion/AccordionItem.tsx":
/*!****************************************************!*\
  !*** ./src/components/Accordion/AccordionItem.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers/composeClassNames */ "./src/helpers/composeClassNames.ts");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Chevron__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Chevron */ "./src/components/Chevron/index.tsx");






const AccordionItem = ({ children, defaultExpanded, disabled = false, expanded: propExpanded, tabIndex = 0, title, noncollapsible = !title, ...props }) => {
    const [stateExpanded, toggleStateExpanded] = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useToggle)(defaultExpanded);
    const expanded = propExpanded || stateExpanded;
    const panelExpanded = noncollapsible || expanded;
    const titleId = (0,react__WEBPACK_IMPORTED_MODULE_2__.useId)();
    const panelId = (0,react__WEBPACK_IMPORTED_MODULE_2__.useId)();
    const handleClick = (e) => {
        if (disabled) {
            return;
        }
        e.currentTarget?.blur();
        toggleStateExpanded();
    };
    const handleKeyDown = (event) => {
        if (disabled || event.currentTarget !== event.target) {
            return;
        }
        if (![' ', 'Enter'].includes(event.key)) {
            return;
        }
        event.preventDefault();
        if (event.repeat) {
            return;
        }
        toggleStateExpanded();
    };
    const collapsibleProps = {
        'aria-controls': panelId,
        'aria-expanded': expanded ? 'true' : 'false',
        'tabIndex': !disabled ? tabIndex : undefined,
        'onClick': handleClick,
        'onKeyDown': handleKeyDown,
    };
    const nonCollapsibleProps = {
        'aria-disabled': 'true',
        'aria-expanded': 'true',
        'aria-labelledby': titleId,
    };
    const barProps = noncollapsible ? nonCollapsibleProps : collapsibleProps;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_4__.StylingBox, { ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("section", { className: (0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.cx)((0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.cxx)('rcx-box')('full'), 'rcx-accordion-item'), children: [title && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { role: 'button', className: (0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.cx)((0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.cxx)('rcx-box')('full', 'animated'), (0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.cxx)('rcx-accordion-item__bar')({ disabled })), ...barProps, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", { className: (0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.cx)((0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.cxx)('rcx-box')('full'), 'rcx-accordion-item__title'), id: titleId, children: title }), !noncollapsible && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Chevron__WEBPACK_IMPORTED_MODULE_5__.Chevron, { size: 'x24', up: expanded })] })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: (0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.cx)((0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.cxx)('rcx-box')('full', 'animated'), (0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.cxx)('rcx-accordion-item__panel')({ expanded: panelExpanded })), id: panelId, children: children })] }) }));
};
/* harmony default export */ __webpack_exports__["default"] = (AccordionItem);


/***/ }),

/***/ "./src/components/Accordion/index.ts":
/*!*******************************************!*\
  !*** ./src/components/Accordion/index.ts ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Accordion: function() { return /* reexport safe */ _Accordion__WEBPACK_IMPORTED_MODULE_0__["default"]; },
/* harmony export */   AccordionItem: function() { return /* reexport safe */ _AccordionItem__WEBPACK_IMPORTED_MODULE_1__["default"]; }
/* harmony export */ });
/* harmony import */ var _Accordion__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Accordion */ "./src/components/Accordion/Accordion.tsx");
/* harmony import */ var _AccordionItem__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AccordionItem */ "./src/components/Accordion/AccordionItem.tsx");




/***/ }),

/***/ "./src/components/AnimatedVisibility/AnimatedVisibility.tsx":
/*!******************************************************************!*\
  !*** ./src/components/AnimatedVisibility/AnimatedVisibility.tsx ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/css-in-js */ "@rocket.chat/css-in-js");
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _helpers_appendClassName__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers/appendClassName */ "./src/helpers/appendClassName.ts");
/* harmony import */ var _hooks_useStyle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../hooks/useStyle */ "./src/hooks/useStyle.ts");
/* harmony import */ var _Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box/BoxTransforms */ "./src/components/Box/BoxTransforms.ts");






const Visibility = {
    HIDDEN: 'hidden',
    VISIBLE: 'visible',
    HIDING: 'hiding',
    UNHIDING: 'unhiding',
};
const AnimatedVisibility = (props) => {
    const propVisibility = props.visibility || Visibility.HIDDEN;
    const [visibility, setVisibility] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(propVisibility);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        setVisibility((visibility) => {
            if (propVisibility === Visibility.VISIBLE &&
                visibility !== propVisibility) {
                return Visibility.UNHIDING;
            }
            if (propVisibility === Visibility.HIDDEN &&
                visibility !== propVisibility) {
                return Visibility.HIDING;
            }
            return visibility;
        });
    }, [propVisibility]);
    const className = (0,_hooks_useStyle__WEBPACK_IMPORTED_MODULE_4__.useStyle)((0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
      animation-duration: 230ms;

      ${visibility === Visibility.HIDING &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
        animation-name: ${(0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.keyframes) `
        from {
          transform: translate3d(0, 0, 0);
          opacity: 1;
        }

        to {
          transform: translate3d(0, 1rem, 0);
          opacity: 0;
        }
      `};
      `}

      ${visibility === Visibility.UNHIDING &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
        animation-name: ${(0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.keyframes) `
        from {
          transform: translate3d(0, 1rem, 0);
          opacity: 0;
        }

        to {
          transform: translate3d(0, 0, 0);
          opacity: 1;
        }
      `};
      `}
    `, null);
    const handleAnimationEnd = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)(() => setVisibility((visibility) => {
        if (visibility === Visibility.HIDING) {
            return Visibility.HIDDEN;
        }
        if (visibility === Visibility.UNHIDING) {
            return Visibility.VISIBLE;
        }
        return visibility;
    }), []);
    const transformFn = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((props) => {
        if (props.onAnimationEnd === undefined) {
            props.onAnimationEnd = handleAnimationEnd;
        }
        props.className =
            className && (0,_helpers_appendClassName__WEBPACK_IMPORTED_MODULE_3__.appendClassName)(props.className, className);
        return props;
    }, [className, handleAnimationEnd]);
    const composedFn = (0,_Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_5__.useComposedBoxTransform)(transformFn);
    if (visibility === Visibility.HIDDEN) {
        return null;
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_5__.BoxTransforms.Provider, { children: props.children, value: composedFn }));
};
/* harmony default export */ __webpack_exports__["default"] = (AnimatedVisibility);


/***/ }),

/***/ "./src/components/AnimatedVisibility/index.ts":
/*!****************************************************!*\
  !*** ./src/components/AnimatedVisibility/index.ts ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AnimatedVisibility */ "./src/components/AnimatedVisibility/AnimatedVisibility.tsx");

/* harmony default export */ __webpack_exports__["default"] = (Object.assign(_AnimatedVisibility__WEBPACK_IMPORTED_MODULE_0__["default"], {
    HIDDEN: 'hidden',
    VISIBLE: 'visible',
    HIDING: 'hiding',
    UNHIDING: 'unhiding',
}));


/***/ }),

/***/ "./src/components/AudioPlayer/AudioPlayer.tsx":
/*!****************************************************!*\
  !*** ./src/components/AudioPlayer/AudioPlayer.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AudioPlayer: function() { return /* binding */ AudioPlayer; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../.. */ "./src/index.ts");
/* harmony import */ var _Slider__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Slider */ "./src/components/Slider/index.tsx");





const getMaskTime = (durationTime) => new Date(durationTime * 1000)
    .toISOString()
    .slice(durationTime > 60 * 60 ? 11 : 14, 19);
function forceDownload(url, fileName) {
    const xhr = new XMLHttpRequest();
    xhr.open('GET', url, true);
    xhr.responseType = 'blob';
    xhr.onload = function () {
        const urlCreator = window.URL || window.webkitURL;
        const imageUrl = urlCreator.createObjectURL(this.response);
        const tag = document.createElement('a');
        tag.href = imageUrl;
        if (fileName) {
            tag.download = fileName;
        }
        document.body.appendChild(tag);
        tag.click();
        document.body.removeChild(tag);
    };
    xhr.send();
}
const getDurationForInfinityDurationAudioFile = (src, callback) => {
    const audioElement = new Audio();
    audioElement.src = src;
    audioElement.addEventListener('loadedmetadata', () => {
        const { duration } = audioElement;
        if (duration === Infinity) {
            audioElement.currentTime = 1e101;
            return;
        }
        return callback(duration);
    });
    audioElement.addEventListener('durationchange', () => {
        if (audioElement.duration === Infinity) {
            return;
        }
        callback(audioElement.duration);
        audioElement.remove();
    });
};
const AudioPlayer = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({ src, type = 'audio/mpeg', maxPlaybackSpeed = 2, minPlaybackSpeed = 0.5, playbackSpeedStep = 0.25, download = false, playLabel = 'Play', pauseLabel = 'Pause', audioPlaybackRangeLabel = 'Audio Playback Range', changePlaybackSpeedLabel = 'Change Playback Speed', downloadAudioFileLabel = 'Download Audio File', trackProps, }, ref) => {
    const audioRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const refs = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useMergedRefs)(ref, audioRef);
    const [isPlaying, setIsPlaying] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    const [currentTime, setCurrentTime] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
    const [durationTime, setDurationTime] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(0);
    const [playbackSpeed, setPlaybackSpeed] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(1);
    const { ref: containerRef } = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useResizeObserver)();
    const handlePlay = () => {
        const isPlaying = audioRef.current?.paused;
        if (isPlaying) {
            audioRef.current?.play();
        }
        else {
            audioRef.current?.pause();
        }
    };
    const handlePlaybackSpeed = (mod) => {
        if (audioRef.current) {
            audioRef.current.playbackRate += playbackSpeedStep * mod;
        }
    };
    const handlePlaybackSpeedSingleControl = () => {
        const reachedMaxPlaybackSpeed = maxPlaybackSpeed === audioRef?.current?.playbackRate;
        if (reachedMaxPlaybackSpeed) {
            audioRef.current.playbackRate = minPlaybackSpeed;
            return;
        }
        handlePlaybackSpeed(1);
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(___WEBPACK_IMPORTED_MODULE_3__.Box, { borderWidth: 'default', bg: 'tint', borderColor: 'extra-light', pb: 12, pie: 8, pis: 16, borderRadius: 'x4', w: '100%', maxWidth: 'x300', ref: containerRef, display: 'flex', alignItems: 'center', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_3__.IconButton, { primary: true, medium: true, onClick: handlePlay, "aria-label": isPlaying ? pauseLabel : playLabel, icon: isPlaying ? 'pause-shape-filled' : 'play-shape-filled' }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(___WEBPACK_IMPORTED_MODULE_3__.Margins, { inline: 8, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_3__.Box, { fontScale: 'p2', color: 'secondary-info', children: isPlaying || currentTime > 0
                            ? getMaskTime(currentTime)
                            : getMaskTime(durationTime) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_3__.Box, { mi: 16, w: 'full', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Slider__WEBPACK_IMPORTED_MODULE_4__.Slider, { "aria-label": audioPlaybackRangeLabel, showOutput: false, value: currentTime, maxValue: durationTime, onChange: (value) => {
                                if (audioRef.current) {
                                    audioRef.current.currentTime = value;
                                }
                            } }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(___WEBPACK_IMPORTED_MODULE_3__.Button, { secondary: true, small: true, onClick: handlePlaybackSpeedSingleControl, "aria-label": changePlaybackSpeedLabel, children: [playbackSpeed, "x"] })] }), download && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_3__.IconButton, { primary: true, "aria-label": downloadAudioFileLabel, is: 'a', href: src, download: true, icon: 'download', medium: true, onClick: (e) => {
                    const { host } = new URL(src);
                    if (host !== window.location.host) {
                        e.preventDefault();
                        forceDownload(src);
                    }
                } })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("audio", { style: { display: 'none' }, onTimeUpdate: (e) => {
                    setCurrentTime(e.target.currentTime);
                }, onLoadedMetadata: (e) => {
                    const { duration } = e.target;
                    if (duration !== Infinity) {
                        return setDurationTime(duration);
                    }
                    getDurationForInfinityDurationAudioFile(src, setDurationTime);
                }, onEnded: () => setIsPlaying(false), ref: refs, preload: 'metadata', onRateChange: (e) => {
                    setPlaybackSpeed(e.target.playbackRate);
                }, onPlay: () => {
                    setIsPlaying(true);
                }, onPause: () => {
                    setIsPlaying(false);
                }, controls: true, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("source", { src: src, type: type }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("track", { kind: 'captions', ...trackProps })] })] }));
});


/***/ }),

/***/ "./src/components/AudioPlayer/index.ts":
/*!*********************************************!*\
  !*** ./src/components/AudioPlayer/index.ts ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AudioPlayer: function() { return /* reexport safe */ _AudioPlayer__WEBPACK_IMPORTED_MODULE_0__.AudioPlayer; }
/* harmony export */ });
/* harmony import */ var _AudioPlayer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AudioPlayer */ "./src/components/AudioPlayer/AudioPlayer.tsx");



/***/ }),

/***/ "./src/components/AutoComplete/AutoComplete.tsx":
/*!******************************************************!*\
  !*** ./src/components/AutoComplete/AutoComplete.tsx ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AutoComplete: function() { return /* binding */ AutoComplete; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../AnimatedVisibility */ "./src/components/AnimatedVisibility/index.ts");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Chip__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Chip */ "./src/components/Chip/index.ts");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../InputBox */ "./src/components/InputBox/index.ts");
/* harmony import */ var _Margins__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Margins */ "./src/components/Margins/index.ts");
/* harmony import */ var _Options__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Options */ "./src/components/Options/index.ts");
/* harmony import */ var _PositionAnimated__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../PositionAnimated */ "./src/components/PositionAnimated/index.ts");











const Addon = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_4__["default"], { "rcx-autocomplete__addon": true, ...props }));
const getSelected = (value, options) => {
    if (!value) {
        return [];
    }
    return typeof value === 'string'
        ? options.filter((option) => option.value === value)
        : options?.filter((option) => value.includes(option.value));
};
const isSelectedValid = (value) => (selected) => {
    if (!value) {
        return false;
    }
    return typeof value === 'string'
        ? selected.value === value
        : value.includes(selected.value);
};
/**
 * An input for selection of options.
 */
function AutoComplete({ value, filter, setFilter, options = [], renderItem, renderSelected: RenderSelected, onChange, renderEmpty, placeholder, error, disabled, multiple, onBlur: onBlurAction = () => { }, ...props }) {
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const { ref: containerRef, borderBoxSize } = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useResizeObserver)();
    const [selected, setSelected] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(() => getSelected(value, options) || []);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        // Validates if selected items are still valid after value changes
        setSelected((selected) => {
            return !selected.every(isSelectedValid(value))
                ? selected.filter(isSelectedValid(value))
                : selected;
        });
    }, [value]);
    const handleSelect = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useEffectEvent)(([newValue]) => {
        if (selected.some((item) => item.value === newValue)) {
            hide();
            return;
        }
        if (multiple) {
            setSelected([...selected, ...getSelected(newValue, options)]);
            onChange([...(value || []), newValue]);
        }
        else {
            setSelected(getSelected(newValue, options));
            onChange(newValue);
        }
        setFilter?.('');
        hide();
    });
    const handleRemove = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useEffectEvent)((event) => {
        event.stopPropagation();
        event.preventDefault();
        const filtered = selected.filter((item) => item.value !== event.currentTarget.value);
        const filteredValue = multiple && Array.isArray(value)
            ? value?.filter((item) => item !== event.currentTarget.value) || []
            : '';
        setSelected(filtered);
        onChange(filteredValue);
        hide();
    });
    const memoizedOptions = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => options.map(({ value, label }) => [value, label]), [options]);
    const firstSelectedIndex = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => options.findIndex((option) => selected[0]?.value === option.value), [options, selected]);
    const [cursor, handleKeyDown, , reset, [optionsAreVisible, hide, show]] = (0,_Options__WEBPACK_IMPORTED_MODULE_9__.useCursor)(firstSelectedIndex, memoizedOptions, handleSelect);
    const handleOnBlur = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useEffectEvent)((event) => {
        hide();
        onBlurAction(event);
    });
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(reset, [filter, reset]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_4__["default"], { "rcx-autocomplete": true, ref: containerRef, onClick: (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useEffectEvent)(() => ref.current?.focus()), flexGrow: 1, className: (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => [error && 'invalid', disabled && 'disabled'], [error, disabled]), children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_4__["default"], { display: 'flex', flexGrow: 1, alignItems: 'center', flexWrap: 'wrap', margin: 'neg-x4', role: 'group', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Margins__WEBPACK_IMPORTED_MODULE_8__["default"], { all: 'x4', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBox__WEBPACK_IMPORTED_MODULE_7__.Input, { ref: ref, onChange: (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useEffectEvent)((e) => setFilter?.(e.currentTarget.value)), onBlur: handleOnBlur, onFocus: show, onKeyDown: handleKeyDown, placeholder: optionsAreVisible === _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_3__["default"].HIDDEN || !value
                                ? placeholder
                                : undefined, order: 1, "rcx-input-box--undecorated": true, value: filter, disabled: disabled, ...props }), selected.map((itemSelected) => RenderSelected ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(RenderSelected, { selected: itemSelected, onRemove: handleRemove }, itemSelected.value)) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Chip__WEBPACK_IMPORTED_MODULE_5__["default"], { value: itemSelected.value, children: itemSelected.label, onClick: handleRemove }, itemSelected.value)))] }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Addon, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_6__.Icon, { name: optionsAreVisible === _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_3__["default"].VISIBLE
                        ? 'cross'
                        : 'magnifier', size: 'x20', color: 'default' }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_PositionAnimated__WEBPACK_IMPORTED_MODULE_10__["default"], { visible: optionsAreVisible, anchor: containerRef, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Options__WEBPACK_IMPORTED_MODULE_9__.Options, { width: borderBoxSize.inlineSize, onSelect: handleSelect, renderItem: renderItem, renderEmpty: renderEmpty, cursor: cursor, value: value, options: memoizedOptions }) })] }));
}


/***/ }),

/***/ "./src/components/AutoComplete/index.ts":
/*!**********************************************!*\
  !*** ./src/components/AutoComplete/index.ts ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AutoComplete: function() { return /* reexport safe */ _AutoComplete__WEBPACK_IMPORTED_MODULE_0__.AutoComplete; }
/* harmony export */ });
/* harmony import */ var _AutoComplete__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AutoComplete */ "./src/components/AutoComplete/AutoComplete.tsx");



/***/ }),

/***/ "./src/components/Avatar/Avatar.tsx":
/*!******************************************!*\
  !*** ./src/components/Avatar/Avatar.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _AvatarContainer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AvatarContainer */ "./src/components/Avatar/AvatarContainer.tsx");


const Avatar = ({ size = 'x36', rounded = false, objectFit = false, url, className, alt, ...props }) => {
    const innerClass = [
        'rcx-avatar__element',
        objectFit && 'rcx-avatar__element--object-fit',
        size && `rcx-avatar__element--${size}`,
        rounded && 'rcx-avatar__element--rounded',
    ]
        .filter(Boolean)
        .join(' ');
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_AvatarContainer__WEBPACK_IMPORTED_MODULE_1__["default"], { size: size, className: className, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", { src: url, className: innerClass, alt: alt || '', ...props }) }));
};
/* harmony default export */ __webpack_exports__["default"] = (Avatar);


/***/ }),

/***/ "./src/components/Avatar/AvatarContainer.tsx":
/*!***************************************************!*\
  !*** ./src/components/Avatar/AvatarContainer.tsx ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/prependClassName */ "./src/helpers/prependClassName.ts");


const AvatarContainer = ({ size = 'x36', children, ...props }) => {
    props.className = (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__.prependClassName)(props.className, ['rcx-box rcx-box--full rcx-avatar', size && `rcx-avatar--${size}`]
        .filter(Boolean)
        .join(' '));
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("figure", { ...props, children: children });
};
/* harmony default export */ __webpack_exports__["default"] = (AvatarContainer);


/***/ }),

/***/ "./src/components/Avatar/AvatarStack.tsx":
/*!***********************************************!*\
  !*** ./src/components/Avatar/AvatarStack.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_keyed_flatten_children__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-keyed-flatten-children */ "react-keyed-flatten-children");
/* harmony import */ var react_keyed_flatten_children__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_keyed_flatten_children__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _helpers_prependClassName__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/prependClassName */ "./src/helpers/prependClassName.ts");



const AvatarStack = ({ children, ...props }) => {
    props.className = (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_2__.prependClassName)(props.className, 'rcx-avatar-stack');
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ...props, children: react_keyed_flatten_children__WEBPACK_IMPORTED_MODULE_1___default()(children).reverse() });
};
/* harmony default export */ __webpack_exports__["default"] = (AvatarStack);


/***/ }),

/***/ "./src/components/Avatar/index.ts":
/*!****************************************!*\
  !*** ./src/components/Avatar/index.ts ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Avatar: function() { return /* reexport safe */ _Avatar__WEBPACK_IMPORTED_MODULE_0__["default"]; },
/* harmony export */   AvatarContainer: function() { return /* reexport safe */ _AvatarContainer__WEBPACK_IMPORTED_MODULE_1__["default"]; },
/* harmony export */   AvatarStack: function() { return /* reexport safe */ _AvatarStack__WEBPACK_IMPORTED_MODULE_2__["default"]; }
/* harmony export */ });
/* harmony import */ var _Avatar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Avatar */ "./src/components/Avatar/Avatar.tsx");
/* harmony import */ var _AvatarContainer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AvatarContainer */ "./src/components/Avatar/AvatarContainer.tsx");
/* harmony import */ var _AvatarStack__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AvatarStack */ "./src/components/Avatar/AvatarStack.tsx");





/***/ }),

/***/ "./src/components/Badge/Badge.tsx":
/*!****************************************!*\
  !*** ./src/components/Badge/Badge.tsx ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Badge: function() { return /* binding */ Badge; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/prependClassName */ "./src/helpers/prependClassName.ts");


/**
 * Communicates notification’s amount and types.
 */
function Badge({ is: Tag = 'span', variant = 'secondary', small, className, disabled, ...props }) {
    const modifiers = [variant, small && 'small', disabled && 'disabled']
        .filter(Boolean)
        .map((modifier) => `rcx-badge--${modifier}`)
        .join(' ');
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Tag, { className: (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__.prependClassName)(className, `rcx-box rcx-box--full rcx-badge ${modifiers}`), ...props }));
}


/***/ }),

/***/ "./src/components/Badge/index.tsx":
/*!****************************************!*\
  !*** ./src/components/Badge/index.tsx ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Badge: function() { return /* reexport safe */ _Badge__WEBPACK_IMPORTED_MODULE_0__.Badge; }
/* harmony export */ });
/* harmony import */ var _Badge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Badge */ "./src/components/Badge/Badge.tsx");



/***/ }),

/***/ "./src/components/Banner/Banner.tsx":
/*!******************************************!*\
  !*** ./src/components/Banner/Banner.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers/composeClassNames */ "./src/helpers/composeClassNames.ts");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Button */ "./src/components/Button/index.ts");





const variants = [
    'neutral',
    'info',
    'success',
    'warning',
    'danger',
];
const Banner = ({ actionable, children, className, closeable, icon, inline = false, link, linkText = 'More info', linkTarget = '_blank', onAction, onClose, title, variant = 'neutral', ...props }) => {
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const { inlineSize } = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useBorderBoxSize)(ref, {
        debounceDelay: 70,
    });
    const isIconVisible = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => inlineSize > 375, [inlineSize]);
    variant = variants.includes(variant) ? variant : variants[0];
    const handleBannerClick = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)(() => {
        if (onAction) {
            onAction();
        }
    }, [onAction]);
    const handleCloseButtonClick = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((event) => {
        event.stopPropagation();
        if (onClose) {
            onClose();
        }
    }, [onClose]);
    const buttonProps = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useButtonPattern)(handleBannerClick);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: (0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.composeClassNames)('rcx-banner')({ [variant]: true, inline, actionable }, className), ref: ref, ...(onAction ? { ...buttonProps } : { role: 'banner', tabIndex: -1 }), ...props, children: [icon && isIconVisible && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: (0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.composeClassNames)(`rcx-banner__icon rcx-banner__icon--${variant}`)({
                    inline,
                }), children: icon })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: (0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.composeClassNames)('rcx-banner__content')({ inline }), children: [title && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h6", { className: (0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.composeClassNames)('rcx-banner__title')({ inline }), children: title })), children, link && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: link, target: linkTarget, className: (0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.composeClassNames)('rcx-banner__link')({ [variant]: true }), children: linkText }))] }), closeable && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: (0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_3__.composeClassNames)('rcx-banner__close-button')({ inline }), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_4__.IconButton, { small: true, onClick: handleCloseButtonClick, icon: 'cross' }) }))] }));
};
/* harmony default export */ __webpack_exports__["default"] = (Banner);


/***/ }),

/***/ "./src/components/Banner/index.ts":
/*!****************************************!*\
  !*** ./src/components/Banner/index.ts ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* reexport safe */ _Banner__WEBPACK_IMPORTED_MODULE_0__["default"]; }
/* harmony export */ });
/* harmony import */ var _Banner__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Banner */ "./src/components/Banner/Banner.tsx");



/***/ }),

/***/ "./src/components/Box/Box.tsx":
/*!************************************!*\
  !*** ./src/components/Box/Box.tsx ***!
  \************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Box: function() { return /* binding */ Box; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _hooks_useArrayLikeClassNameProp__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../hooks/useArrayLikeClassNameProp */ "./src/hooks/useArrayLikeClassNameProp.ts");
/* harmony import */ var _hooks_useBoxOnlyProps__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../hooks/useBoxOnlyProps */ "./src/hooks/useBoxOnlyProps.ts");
/* harmony import */ var _BoxTransforms__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./BoxTransforms */ "./src/components/Box/BoxTransforms.ts");
/* harmony import */ var _useStylingProps__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./useStylingProps */ "./src/components/Box/useStylingProps.ts");






const Box = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Box({ is = 'div', children, ...props }, ref) {
    const propsWithRef = props;
    if (ref) {
        propsWithRef.ref = ref;
    }
    let propsWithStringClassName = (0,_hooks_useArrayLikeClassNameProp__WEBPACK_IMPORTED_MODULE_2__.useArrayLikeClassNameProp)(propsWithRef);
    const transformFn = (0,_BoxTransforms__WEBPACK_IMPORTED_MODULE_4__.useBoxTransform)();
    if (transformFn) {
        propsWithStringClassName = transformFn(propsWithStringClassName);
    }
    const propsWithoutStylingProps = (0,_useStylingProps__WEBPACK_IMPORTED_MODULE_5__.useStylingProps)(propsWithStringClassName);
    const propsWithoutBoxOnlyProps = (0,_hooks_useBoxOnlyProps__WEBPACK_IMPORTED_MODULE_3__.useBoxOnlyProps)(propsWithoutStylingProps);
    const element = (0,react__WEBPACK_IMPORTED_MODULE_1__.createElement)(is, propsWithoutBoxOnlyProps, children);
    if (transformFn) {
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_BoxTransforms__WEBPACK_IMPORTED_MODULE_4__.BoxTransforms.Provider, { children: element, value: null });
    }
    return element;
});
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(Box));


/***/ }),

/***/ "./src/components/Box/BoxTransforms.ts":
/*!*********************************************!*\
  !*** ./src/components/Box/BoxTransforms.ts ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BoxTransforms: function() { return /* binding */ BoxTransforms; },
/* harmony export */   useBoxTransform: function() { return /* binding */ useBoxTransform; },
/* harmony export */   useComposedBoxTransform: function() { return /* binding */ useComposedBoxTransform; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const BoxTransforms = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
const useBoxTransform = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(BoxTransforms);
const useComposedBoxTransform = (fn) => {
    const parentFn = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(BoxTransforms);
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
        if (!parentFn) {
            return fn;
        }
        if (!fn) {
            return parentFn;
        }
        return (props) => fn(parentFn(props));
    }, [fn, parentFn]);
};


/***/ }),

/***/ "./src/components/Box/StylingBox.tsx":
/*!*******************************************!*\
  !*** ./src/components/Box/StylingBox.tsx ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StylingBox: function() { return /* binding */ StylingBox; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _hooks_useArrayLikeClassNameProp__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../hooks/useArrayLikeClassNameProp */ "./src/hooks/useArrayLikeClassNameProp.ts");
/* harmony import */ var _useStylingProps__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./useStylingProps */ "./src/components/Box/useStylingProps.ts");



/**
 * Merges its `StylingProps` props into a `className` prop passed to a child element.
 *
 * This is intended to be used as a wrapper for components that accept styling props but don't need the weight of the
 * `Box` component prop handling internally.
 */
const StylingBox = ({ children, ...props }) => {
    const propsWithStringClassName = (0,_hooks_useArrayLikeClassNameProp__WEBPACK_IMPORTED_MODULE_1__.useArrayLikeClassNameProp)(props);
    propsWithStringClassName.className = [
        children.props.className,
        propsWithStringClassName.className,
    ]
        .filter(Boolean)
        .join(' ');
    const propsWithoutStylingProps = (0,_useStylingProps__WEBPACK_IMPORTED_MODULE_2__.useStylingProps)(propsWithStringClassName);
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(children, propsWithoutStylingProps);
};
/* harmony default export */ __webpack_exports__["default"] = (StylingBox);


/***/ }),

/***/ "./src/components/Box/index.ts":
/*!*************************************!*\
  !*** ./src/components/Box/index.ts ***!
  \*************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Box: function() { return /* reexport safe */ _Box__WEBPACK_IMPORTED_MODULE_0__["default"]; },
/* harmony export */   StylingBox: function() { return /* reexport safe */ _StylingBox__WEBPACK_IMPORTED_MODULE_1__["default"]; },
/* harmony export */   "default": function() { return /* reexport safe */ _Box__WEBPACK_IMPORTED_MODULE_0__["default"]; }
/* harmony export */ });
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Box */ "./src/components/Box/Box.tsx");
/* harmony import */ var _StylingBox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./StylingBox */ "./src/components/Box/StylingBox.tsx");




/***/ }),

/***/ "./src/components/Box/stylingProps.ts":
/*!********************************************!*\
  !*** ./src/components/Box/stylingProps.ts ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   extractStylingProps: function() { return /* binding */ extractStylingProps; },
/* harmony export */   propDefs: function() { return /* binding */ propDefs; }
/* harmony export */ });
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rocket.chat/css-in-js */ "@rocket.chat/css-in-js");
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Theme__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Theme */ "./src/Theme.ts");
/* harmony import */ var _helpers_fromCamelToKebab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/fromCamelToKebab */ "./src/helpers/fromCamelToKebab.ts");
/* harmony import */ var _styleTokens__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../styleTokens */ "./src/styleTokens.ts");




const stringProp = {
    toCSSValue: (value) => (typeof value === 'string' ? value : undefined),
};
const numberOrStringProp = {
    toCSSValue: (value) => {
        if (typeof value === 'number' || typeof value === 'string') {
            return String(value);
        }
        return undefined;
    },
};
const borderWidthProp = {
    toCSSValue: _styleTokens__WEBPACK_IMPORTED_MODULE_3__.borderWidth,
};
const borderRadiusProp = {
    toCSSValue: _styleTokens__WEBPACK_IMPORTED_MODULE_3__.borderRadius,
};
const backgroundColorProp = {
    toCSSValue: _styleTokens__WEBPACK_IMPORTED_MODULE_3__.backgroundColor,
};
const fontColorProp = {
    toCSSValue: _styleTokens__WEBPACK_IMPORTED_MODULE_3__.fontColor,
};
const strokeColorProp = {
    toCSSValue: _styleTokens__WEBPACK_IMPORTED_MODULE_3__.strokeColor,
};
const sizeProp = {
    toCSSValue: _styleTokens__WEBPACK_IMPORTED_MODULE_3__.size,
};
const insetProp = {
    toCSSValue: _styleTokens__WEBPACK_IMPORTED_MODULE_3__.inset,
};
const marginProp = {
    toCSSValue: _styleTokens__WEBPACK_IMPORTED_MODULE_3__.margin,
};
const paddingProp = {
    toCSSValue: _styleTokens__WEBPACK_IMPORTED_MODULE_3__.padding,
};
const fontFamilyProp = {
    toCSSValue: _styleTokens__WEBPACK_IMPORTED_MODULE_3__.fontFamily,
};
const fontSizeProp = {
    toCSSValue: (value) => (0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.fontScale)(value)?.fontSize || (0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.size)(value),
};
const fontWeightProp = {
    toCSSValue: (value) => value ? String((0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.fontScale)(value)?.fontWeight || value) : undefined,
};
const lineHeightProp = {
    toCSSValue: (value) => (0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.fontScale)(value)?.lineHeight || (0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.size)(value),
};
const letterSpacingProp = {
    toCSSValue: (value) => value ? String((0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.fontScale)(value)?.letterSpacing || value) : undefined,
};
const aliasOf = (propName) => ({
    aliasOf: propName,
});
const propDefs = {
    border: stringProp,
    borderBlock: stringProp,
    borderBlockStart: stringProp,
    borderBlockEnd: stringProp,
    borderInline: stringProp,
    borderInlineStart: stringProp,
    borderInlineEnd: stringProp,
    borderWidth: borderWidthProp,
    borderBlockWidth: borderWidthProp,
    borderBlockStartWidth: borderWidthProp,
    borderBlockEndWidth: borderWidthProp,
    borderInlineWidth: borderWidthProp,
    borderInlineStartWidth: borderWidthProp,
    borderInlineEndWidth: borderWidthProp,
    borderStyle: stringProp,
    borderBlockStyle: stringProp,
    borderBlockStartStyle: stringProp,
    borderBlockEndStyle: stringProp,
    borderInlineStyle: stringProp,
    borderInlineStartStyle: stringProp,
    borderInlineEndStyle: stringProp,
    borderColor: strokeColorProp,
    borderBlockColor: strokeColorProp,
    borderBlockStartColor: strokeColorProp,
    borderBlockEndColor: strokeColorProp,
    borderInlineColor: strokeColorProp,
    borderInlineStartColor: strokeColorProp,
    borderInlineEndColor: strokeColorProp,
    borderRadius: borderRadiusProp,
    borderStartStartRadius: borderRadiusProp,
    borderStartEndRadius: borderRadiusProp,
    borderEndStartRadius: borderRadiusProp,
    borderEndEndRadius: borderRadiusProp,
    color: fontColorProp,
    backgroundColor: backgroundColorProp,
    bg: aliasOf('backgroundColor'),
    opacity: numberOrStringProp,
    alignItems: stringProp,
    alignContent: stringProp,
    justifyItems: stringProp,
    justifyContent: stringProp,
    flexWrap: stringProp,
    flexDirection: stringProp,
    flexGrow: numberOrStringProp,
    flexShrink: numberOrStringProp,
    flexBasis: stringProp,
    justifySelf: stringProp,
    alignSelf: stringProp,
    order: numberOrStringProp,
    w: aliasOf('width'),
    width: sizeProp,
    minWidth: sizeProp,
    maxWidth: sizeProp,
    h: aliasOf('height'),
    height: sizeProp,
    minHeight: sizeProp,
    maxHeight: sizeProp,
    display: stringProp,
    verticalAlign: stringProp,
    overflow: stringProp,
    overflowX: stringProp,
    overflowY: stringProp,
    position: stringProp,
    zIndex: numberOrStringProp,
    inset: insetProp,
    insetBlock: insetProp,
    insetBlockStart: insetProp,
    insetBlockEnd: insetProp,
    insetInline: insetProp,
    insetInlineStart: insetProp,
    insetInlineEnd: insetProp,
    m: aliasOf('margin'),
    margin: marginProp,
    mb: aliasOf('marginBlock'),
    marginBlock: marginProp,
    mbs: aliasOf('marginBlockStart'),
    marginBlockStart: marginProp,
    mbe: aliasOf('marginBlockEnd'),
    marginBlockEnd: marginProp,
    mi: aliasOf('marginInline'),
    marginInline: marginProp,
    mis: aliasOf('marginInlineStart'),
    marginInlineStart: marginProp,
    mie: aliasOf('marginInlineEnd'),
    marginInlineEnd: marginProp,
    p: aliasOf('padding'),
    padding: paddingProp,
    pb: aliasOf('paddingBlock'),
    paddingBlock: paddingProp,
    pbs: aliasOf('paddingBlockStart'),
    paddingBlockStart: paddingProp,
    pbe: aliasOf('paddingBlockEnd'),
    paddingBlockEnd: paddingProp,
    pi: aliasOf('paddingInline'),
    paddingInline: paddingProp,
    pis: aliasOf('paddingInlineStart'),
    paddingInlineStart: paddingProp,
    pie: aliasOf('paddingInlineEnd'),
    paddingInlineEnd: paddingProp,
    fontFamily: fontFamilyProp,
    fontSize: fontSizeProp,
    fontStyle: stringProp,
    fontWeight: fontWeightProp,
    letterSpacing: letterSpacingProp,
    lineHeight: lineHeightProp,
    textAlign: stringProp,
    textTransform: stringProp,
    textDecorationLine: stringProp,
    wordBreak: stringProp,
    elevation: {
        toStyle: (value) => {
            if (value === '0') {
                return (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.css) `
          box-shadow: none;
        `;
            }
            if (value === '1') {
                return (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.css) `
          box-shadow: 0px 0px 12px 0px ${_Theme__WEBPACK_IMPORTED_MODULE_1__.Palette.shadow['shadow-elevation-1']};
          border: 1px solid ${_Theme__WEBPACK_IMPORTED_MODULE_1__.Palette.shadow['shadow-elevation-border']};
        `;
            }
            if (value === '1nb') {
                return (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.css) `
          box-shadow: 0px 0px 12px 0px ${_Theme__WEBPACK_IMPORTED_MODULE_1__.Palette.shadow['shadow-elevation-1']};
        `;
            }
            if (value === '2') {
                return (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.css) `
          box-shadow:
            0px 0px 2px 0px ${_Theme__WEBPACK_IMPORTED_MODULE_1__.Palette.shadow['shadow-elevation-2x']},
            0px 0px 12px 0px ${_Theme__WEBPACK_IMPORTED_MODULE_1__.Palette.shadow['shadow-elevation-2y']};
          border: 1px solid ${_Theme__WEBPACK_IMPORTED_MODULE_1__.Palette.shadow['shadow-elevation-border']};
        `;
            }
            if (value === '2nb') {
                return (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.css) `
          box-shadow:
            0px 0px 2px 0px ${_Theme__WEBPACK_IMPORTED_MODULE_1__.Palette.shadow['shadow-elevation-2x']},
            0px 0px 12px 0px ${_Theme__WEBPACK_IMPORTED_MODULE_1__.Palette.shadow['shadow-elevation-2y']};
        `;
            }
            return undefined;
        },
    },
    invisible: {
        toStyle: (value) => value
            ? (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.css) `
            visibility: hidden;
            opacity: 0;
          `
            : undefined,
    },
    withTruncatedText: {
        toStyle: (value) => value
            ? (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.css) `
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
          `
            : undefined,
    },
    size: {
        toStyle: (value) => (0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.size)(value)
            ? (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.css) `
            width: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.size)(value)} !important;
            height: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.size)(value)} !important;
          `
            : undefined,
    },
    minSize: {
        toStyle: (value) => (0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.size)(value)
            ? (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.css) `
            min-width: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.size)(value)} !important;
            min-height: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.size)(value)} !important;
          `
            : undefined,
    },
    maxSize: {
        toStyle: (value) => (0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.size)(value)
            ? (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.css) `
            max-width: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.size)(value)} !important;
            max-height: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.size)(value)} !important;
          `
            : undefined,
    },
    fontScale: {
        toStyle: (value) => (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.css) `
      font-size: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.fontScale)(value)?.fontSize} !important;
      font-weight: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.fontScale)(value)?.fontWeight} !important;
      letter-spacing: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.fontScale)(value)?.letterSpacing} !important;
      line-height: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_3__.fontScale)(value)?.lineHeight} !important;
    `,
    },
};
const compiledPropDefs = new Map(Object.entries(propDefs).map(([propName, propDef]) => {
    if ('aliasOf' in propDef) {
        const { aliasOf: effectivePropName } = propDef;
        return [
            propName,
            (value, stylingProps) => {
                if (stylingProps.has(effectivePropName)) {
                    return;
                }
                const inject = compiledPropDefs.get(effectivePropName);
                inject?.(value, stylingProps);
            },
        ];
    }
    if ('toCSSValue' in propDef) {
        const cssProperty = (0,_helpers_fromCamelToKebab__WEBPACK_IMPORTED_MODULE_2__.fromCamelToKebab)(propName);
        const { toCSSValue } = propDef;
        return [
            propName,
            (value, stylingProps) => {
                const cssValue = toCSSValue(value);
                if (cssValue === undefined) {
                    return;
                }
                stylingProps.set(propName, (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.css) `
                ${cssProperty}: ${cssValue} !important;
              `);
            },
        ];
    }
    const { toStyle } = propDef;
    return [
        propName,
        (value, stylingProps) => {
            const style = toStyle(value);
            if (style === undefined) {
                return;
            }
            stylingProps.set(propName, style);
        },
    ];
}));
const extractStylingProps = (props) => {
    const stylingProps = new Map();
    const newProps = {};
    for (const [propName, value] of Object.entries(props)) {
        const inject = compiledPropDefs.get(propName);
        if (!inject) {
            newProps[propName] = value;
            continue;
        }
        if (value === undefined) {
            continue;
        }
        inject(value, stylingProps);
    }
    const styles = stylingProps.size
        ? (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.css) `
        ${Array.from(stylingProps.values())}
      `
        : undefined;
    return [newProps, styles];
};


/***/ }),

/***/ "./src/components/Box/useStylingProps.ts":
/*!***********************************************!*\
  !*** ./src/components/Box/useStylingProps.ts ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useStylingProps: function() { return /* binding */ useStylingProps; }
/* harmony export */ });
/* harmony import */ var _helpers_appendClassName__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../helpers/appendClassName */ "./src/helpers/appendClassName.ts");
/* harmony import */ var _hooks_useStyle__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../hooks/useStyle */ "./src/hooks/useStyle.ts");
/* harmony import */ var _stylingProps__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./stylingProps */ "./src/components/Box/stylingProps.ts");



const useStylingProps = (originalProps) => {
    const [props, styles] = (0,_stylingProps__WEBPACK_IMPORTED_MODULE_2__.extractStylingProps)(originalProps);
    const newClassName = (0,_hooks_useStyle__WEBPACK_IMPORTED_MODULE_1__.useStyle)(styles, undefined);
    if (newClassName) {
        props.className = props.className
            ? (0,_helpers_appendClassName__WEBPACK_IMPORTED_MODULE_0__.appendClassName)(props.className, newClassName)
            : newClassName;
    }
    return props;
};


/***/ }),

/***/ "./src/components/Box/withBoxStyling.tsx":
/*!***********************************************!*\
  !*** ./src/components/Box/withBoxStyling.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   withBoxStyling: function() { return /* binding */ withBoxStyling; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _useStylingProps__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useStylingProps */ "./src/components/Box/useStylingProps.ts");


const withBoxStyling = (Component) => {
    const WithBoxStyling = (props) => {
        const propsWithoutStylingProps = (0,_useStylingProps__WEBPACK_IMPORTED_MODULE_1__.useStylingProps)(props);
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Component, { ...propsWithoutStylingProps });
    };
    WithBoxStyling.displayName = `WithBoxStyling(${Component.displayName || Component.name || 'Component'})`;
    return WithBoxStyling;
};


/***/ }),

/***/ "./src/components/Bubble/Bubble.tsx":
/*!******************************************!*\
  !*** ./src/components/Bubble/Bubble.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Bubble: function() { return /* binding */ Bubble; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _BubbleButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BubbleButton */ "./src/components/Bubble/BubbleButton.tsx");
/* harmony import */ var _BubbleItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./BubbleItem */ "./src/components/Bubble/BubbleItem.tsx");



const Bubble = ({ secondary, children, onClick, icon, onDismiss, small, contentProps, dismissProps, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: [
        'rcx-bubble',
        'rcx-box',
        'rcx-box--full',
        onDismiss && 'rcx-bubble__group',
        small && 'rcx-bubble--small',
    ].join(' '), ...props, children: [onClick ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_BubbleButton__WEBPACK_IMPORTED_MODULE_1__.BubbleButton, { onClick: onClick, secondary: secondary, icon: icon, label: children, ...contentProps })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_BubbleItem__WEBPACK_IMPORTED_MODULE_2__.BubbleItem, { secondary: secondary, icon: icon, label: children, ...contentProps })), onDismiss && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_BubbleButton__WEBPACK_IMPORTED_MODULE_1__.BubbleButton, { onClick: onDismiss, secondary: secondary, icon: 'cross-small', 'aria-label': `Dismiss ${children}`, ...dismissProps }))] }));


/***/ }),

/***/ "./src/components/Bubble/BubbleButton.tsx":
/*!************************************************!*\
  !*** ./src/components/Bubble/BubbleButton.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BubbleButton: function() { return /* binding */ BubbleButton; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");


const BubbleButton = ({ secondary, label, onClick, icon, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("button", { className: `rcx-box rcx-box--full rcx-bubble__button ${secondary
        ? 'rcx-bubble__button--secondary'
        : 'rcx-bubble__button--primary'}`, onClick: onClick, ...props, children: [icon && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__.Icon, { name: icon, size: 'x16' }), label && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { children: label })] }));


/***/ }),

/***/ "./src/components/Bubble/BubbleItem.tsx":
/*!**********************************************!*\
  !*** ./src/components/Bubble/BubbleItem.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BubbleItem: function() { return /* binding */ BubbleItem; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");


const BubbleItem = ({ secondary, label, icon, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { className: `rcx-bubble__item ${secondary ? 'rcx-bubble__item--secondary' : 'rcx-bubble__item--primary'}`, ...props, children: [icon && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__.Icon, { name: icon, size: 'x16', mie: 8 }), label && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { children: label })] }));


/***/ }),

/***/ "./src/components/Bubble/index.ts":
/*!****************************************!*\
  !*** ./src/components/Bubble/index.ts ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Bubble: function() { return /* reexport safe */ _Bubble__WEBPACK_IMPORTED_MODULE_0__.Bubble; }
/* harmony export */ });
/* harmony import */ var _Bubble__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Bubble */ "./src/components/Bubble/Bubble.tsx");



/***/ }),

/***/ "./src/components/Button/ActionButton.tsx":
/*!************************************************!*\
  !*** ./src/components/Button/ActionButton.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ActionButton: function() { return /* binding */ ActionButton; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! . */ "./src/components/Button/index.ts");




const getSize = ({ tiny, mini, small }) => {
    if (mini) {
        return 'x16';
    }
    if (tiny || small) {
        return 'x20';
    }
    return 'x20';
};
const ActionButton = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(({ icon, children, ...props }, ref) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(___WEBPACK_IMPORTED_MODULE_3__.Button, { ref: ref, square: true, flexShrink: 0, ...props, children: [children, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_2__.Icon, { name: icon, size: getSize(props) })] })));


/***/ }),

/***/ "./src/components/Button/Button.tsx":
/*!******************************************!*\
  !*** ./src/components/Button/Button.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Button: function() { return /* binding */ Button; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");




/**
 * Indicates an actionable user action.
 */
const Button = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Button({ primary, secondary, danger, warning, success, external, icon, is = 'button', rel: _rel, tiny, mini, small, medium, large, square, loading, disabled, children, ...props }, ref) {
    const extraProps = (is === 'a' && {
        rel: external ? 'noopener noreferrer' : undefined,
        target: external ? '_blank' : undefined,
    }) ||
        (is === 'button' && {
            type: 'button',
        }) ||
        {};
    const kindAndVariantProps = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
        const variant = (primary && 'primary') ||
            (secondary && success && 'secondary-success') ||
            (secondary && warning && 'secondary-warning') ||
            (secondary && danger && 'secondary-danger') ||
            (success && 'success') ||
            (warning && 'warning') ||
            (danger && 'danger') ||
            (secondary && 'secondary');
        if (variant) {
            return {
                [`rcx-button--${[variant].filter(Boolean).join('-')}`]: true,
            };
        }
        return {};
    }, [primary, secondary, danger, warning, success]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: is, type: 'button', "rcx-button": true, ...kindAndVariantProps, "rcx-button--small": small, "rcx-button--medium": medium, "rcx-button--large": large, "rcx-button--square": square, "rcx-button--tiny-square": tiny && square, "rcx-button--mini-square": mini && square, "rcx-button--small-square": small && square, "rcx-button--medium-square": medium && square, "rcx-button--large-square": large && square, "rcx-button--loading": loading, disabled: disabled || loading, ref: ref, ...extraProps, ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { className: 'rcx-button--content', children: [icon && !loading && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_3__.Icon, { size: 'x16', name: icon, mie: 4 }), loading && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_3__.Icon, { size: 'x16', name: 'loading', mie: 4 }), children] }) }));
});
/* harmony default export */ __webpack_exports__["default"] = (Button);


/***/ }),

/***/ "./src/components/Button/IconButton.tsx":
/*!**********************************************!*\
  !*** ./src/components/Button/IconButton.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconButton: function() { return /* binding */ IconButton; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");




const getVariantClass = (variant) => {
    if (variant) {
        const variantClass = [
            `rcx-button--icon-${[variant].filter(Boolean).join('-')}`,
        ];
        return variantClass;
    }
    return [''];
};
const getPressedClass = (variant) => {
    const variantClass = [
        `rcx-button--icon-${[variant].filter(Boolean).join('-')}-pressed`,
    ];
    return variantClass;
};
const IconButton = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(({ icon, primary, info, secondary, danger, warning, success, mini, large, tiny, small, medium, pressed, children, ...props }, ref) => {
    const variant = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => (secondary && danger && 'secondary-danger') ||
        (secondary && warning && 'secondary-warning') ||
        (secondary && success && 'secondary-success') ||
        (secondary && info && 'secondary-info') ||
        (info && 'info') ||
        (success && 'success') ||
        (warning && 'warning') ||
        (danger && 'danger') ||
        (primary && 'secondary-info') ||
        (secondary && 'secondary') ||
        '', [danger, info, primary, secondary, success, warning]);
    const kindAndVariantProps = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
        const variantProp = {};
        if (variant) {
            variantProp[`${getVariantClass(variant)}`] = true;
        }
        if (pressed) {
            variantProp[`${getPressedClass(variant)}`] = true;
        }
        return variantProp;
    }, [variant, pressed]);
    const size = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => (mini && 'mini') ||
        (tiny && 'tiny') ||
        (small && 'small') ||
        (medium && 'medium') ||
        (large && 'large') ||
        'large', [medium, mini, small, tiny, large]);
    const getSizeClass = () => ({ [`rcx-button--${size}-square`]: true });
    const getIconSize = () => (large && 'x28') ||
        (medium && 'x24') ||
        (small && 'x20') ||
        (tiny && 'x16') ||
        (mini && 'x12') ||
        'x28';
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'button', type: 'button', "rcx-button": true, "rcx-button--icon": true, "rcx-button--square": true, ...kindAndVariantProps, ...getSizeClass(), "rcx-button--icon-pressed": pressed, ref: ref, ...props, children: [(0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(icon) ? (icon) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_3__.Icon, { name: icon, size: getIconSize() })), children] }));
});


/***/ }),

/***/ "./src/components/Button/index.ts":
/*!****************************************!*\
  !*** ./src/components/Button/index.ts ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ActionButton: function() { return /* reexport safe */ _ActionButton__WEBPACK_IMPORTED_MODULE_1__.ActionButton; },
/* harmony export */   Button: function() { return /* reexport safe */ _Button__WEBPACK_IMPORTED_MODULE_0__.Button; },
/* harmony export */   IconButton: function() { return /* reexport safe */ _IconButton__WEBPACK_IMPORTED_MODULE_2__.IconButton; },
/* harmony export */   "default": function() { return /* reexport safe */ _Button__WEBPACK_IMPORTED_MODULE_0__["default"]; }
/* harmony export */ });
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Button */ "./src/components/Button/Button.tsx");
/* harmony import */ var _ActionButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ActionButton */ "./src/components/Button/ActionButton.tsx");
/* harmony import */ var _IconButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./IconButton */ "./src/components/Button/IconButton.tsx");





/***/ }),

/***/ "./src/components/ButtonGroup/ButtonGroup.tsx":
/*!****************************************************!*\
  !*** ./src/components/ButtonGroup/ButtonGroup.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ButtonGroup: function() { return /* binding */ ButtonGroup; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _helpers_appendClassName__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/appendClassName */ "./src/helpers/appendClassName.ts");
/* harmony import */ var _helpers_patchChildren__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers/patchChildren */ "./src/helpers/patchChildren.ts");




/**
 * A container for grouping buttons that semantically share a common action context.
 */
const ButtonGroup = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function ButtonGroup({ align = 'start', children, stretch, vertical, wrap, small, large, className, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ref: ref, className: [
            'rcx-button-group',
            stretch && 'rcx-button-group--stretch',
            vertical && 'rcx-button-group--vertical',
            align && `rcx-button-group--align-${align}`,
            small && 'rcx-button-group--small',
            large && 'rcx-button-group--large',
            wrap && 'rcx-button-group--wrap',
            className,
        ]
            .filter(Boolean)
            .join(' '), role: 'group', ...props, children: (0,_helpers_patchChildren__WEBPACK_IMPORTED_MODULE_3__.patchChildren)(children, (childProps) => ({
            className: (0,_helpers_appendClassName__WEBPACK_IMPORTED_MODULE_2__.appendClassName)(childProps.className, 'rcx-button-group__item'),
        })) }));
});


/***/ }),

/***/ "./src/components/ButtonGroup/index.ts":
/*!*********************************************!*\
  !*** ./src/components/ButtonGroup/index.ts ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ButtonGroup: function() { return /* reexport safe */ _ButtonGroup__WEBPACK_IMPORTED_MODULE_0__.ButtonGroup; }
/* harmony export */ });
/* harmony import */ var _ButtonGroup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ButtonGroup */ "./src/components/ButtonGroup/ButtonGroup.tsx");



/***/ }),

/***/ "./src/components/Callout/Callout.tsx":
/*!********************************************!*\
  !*** ./src/components/Callout/Callout.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Callout: function() { return /* binding */ Callout; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");




const WRAPPER_LIMIT_SIZE = 420;
/**
 * The `Callout` is used to get the user's attention explaining something important in the content of the current page.
 */
const Callout = ({ type, title, children, icon, className, actions, ...props }) => {
    const { ref, borderBoxSize } = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useResizeObserver)();
    const isLarge = borderBoxSize.inlineSize && borderBoxSize.inlineSize >= WRAPPER_LIMIT_SIZE;
    const defaultIcon = (type === 'info' && 'info-circled') ||
        (type === 'success' && 'checkmark-circled') ||
        (type === 'warning' && 'warning') ||
        (type === 'danger' && 'ban') ||
        'info-circled';
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { ref: ref, is: 'section', className: ['rcx-callout', type && `rcx-callout--${type}`, className]
            .filter(Boolean)
            .join(' '), ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_3__.Icon, { className: 'rcx-callout__icon', name: icon || defaultIcon, size: 'x20' }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { "rcx-callout__wrapper": true, "rcx-callout__wrapper--large": isLarge, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { "rcx-callout__wrapper-content": true, children: [title && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { "rcx-callout__title": true, children: title }), children && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { "rcx-callout__content": true, children: children })] }), actions && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { "rcx-callout__actions": true, children: actions })] })] }));
};


/***/ }),

/***/ "./src/components/Callout/index.tsx":
/*!******************************************!*\
  !*** ./src/components/Callout/index.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Callout: function() { return /* reexport safe */ _Callout__WEBPACK_IMPORTED_MODULE_0__.Callout; }
/* harmony export */ });
/* harmony import */ var _Callout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Callout */ "./src/components/Callout/Callout.tsx");



/***/ }),

/***/ "./src/components/Card/Card.tsx":
/*!**************************************!*\
  !*** ./src/components/Card/Card.tsx ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box_Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box/Box */ "./src/components/Box/Box.tsx");



const Card = ({ horizontal, hero, clickable, ...props }) => {
    const breakpoints = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useBreakpoints)();
    const isMobile = !breakpoints.includes('sm');
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { "rcx-card": true, "rcx-card__horizontal": horizontal, "rcx-card__vertical": !horizontal, "rcx-card__hero": hero, "rcx-card__horizontal--wrap": horizontal && isMobile, "rcx-card__clickable": clickable, ...props }));
};
/* harmony default export */ __webpack_exports__["default"] = (Card);


/***/ }),

/***/ "./src/components/Card/CardBody.tsx":
/*!******************************************!*\
  !*** ./src/components/Card/CardBody.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box/Box */ "./src/components/Box/Box.tsx");


const CardBody = ({ children, flexDirection = 'row', height, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { fontScale: 'p2m', display: 'flex', flexDirection: flexDirection, flexGrow: 1, height: height, "rcx-card__body": true, ...props, children: children }));
/* harmony default export */ __webpack_exports__["default"] = (CardBody);


/***/ }),

/***/ "./src/components/Card/CardCol.tsx":
/*!*****************************************!*\
  !*** ./src/components/Card/CardCol.tsx ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const CardCol = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-card__col', ...props, children: children }));
/* harmony default export */ __webpack_exports__["default"] = (CardCol);


/***/ }),

/***/ "./src/components/Card/CardControls.tsx":
/*!**********************************************!*\
  !*** ./src/components/Card/CardControls.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const CardControls = ({ ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-card__controls', ...props }));
/* harmony default export */ __webpack_exports__["default"] = (CardControls);


/***/ }),

/***/ "./src/components/Card/CardHeader.tsx":
/*!********************************************!*\
  !*** ./src/components/Card/CardHeader.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const CardHeader = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-card__header', ...props, children: children }));
/* harmony default export */ __webpack_exports__["default"] = (CardHeader);


/***/ }),

/***/ "./src/components/Card/CardRow.tsx":
/*!*****************************************!*\
  !*** ./src/components/Card/CardRow.tsx ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const CardRow = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-card__row', ...props, children: children }));
/* harmony default export */ __webpack_exports__["default"] = (CardRow);


/***/ }),

/***/ "./src/components/Card/CardTitle.tsx":
/*!*******************************************!*\
  !*** ./src/components/Card/CardTitle.tsx ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box/Box */ "./src/components/Box/Box.tsx");
/* harmony import */ var _Label_LabelInfo__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Label/LabelInfo */ "./src/components/Label/LabelInfo.tsx");



const CardTitle = ({ children, info, variant = 'h4', ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { fontScale: variant, is: variant, "rcx-card__title": true, ...props, children: [children, info && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Label_LabelInfo__WEBPACK_IMPORTED_MODULE_2__.LabelInfo, { title: info })] }));
/* harmony default export */ __webpack_exports__["default"] = (CardTitle);


/***/ }),

/***/ "./src/components/Card/index.ts":
/*!**************************************!*\
  !*** ./src/components/Card/index.ts ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Card: function() { return /* reexport safe */ _Card__WEBPACK_IMPORTED_MODULE_0__["default"]; },
/* harmony export */   CardBody: function() { return /* reexport safe */ _CardBody__WEBPACK_IMPORTED_MODULE_1__["default"]; },
/* harmony export */   CardCol: function() { return /* reexport safe */ _CardCol__WEBPACK_IMPORTED_MODULE_2__["default"]; },
/* harmony export */   CardContent: function() { return /* reexport safe */ _CardRow__WEBPACK_IMPORTED_MODULE_3__["default"]; },
/* harmony export */   CardControls: function() { return /* reexport safe */ _CardControls__WEBPACK_IMPORTED_MODULE_5__["default"]; },
/* harmony export */   CardHeader: function() { return /* reexport safe */ _CardHeader__WEBPACK_IMPORTED_MODULE_6__["default"]; },
/* harmony export */   CardRow: function() { return /* reexport safe */ _CardRow__WEBPACK_IMPORTED_MODULE_3__["default"]; },
/* harmony export */   CardTitle: function() { return /* reexport safe */ _CardTitle__WEBPACK_IMPORTED_MODULE_4__["default"]; }
/* harmony export */ });
/* harmony import */ var _Card__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Card */ "./src/components/Card/Card.tsx");
/* harmony import */ var _CardBody__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CardBody */ "./src/components/Card/CardBody.tsx");
/* harmony import */ var _CardCol__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CardCol */ "./src/components/Card/CardCol.tsx");
/* harmony import */ var _CardRow__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CardRow */ "./src/components/Card/CardRow.tsx");
/* harmony import */ var _CardTitle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CardTitle */ "./src/components/Card/CardTitle.tsx");
/* harmony import */ var _CardControls__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./CardControls */ "./src/components/Card/CardControls.tsx");
/* harmony import */ var _CardHeader__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./CardHeader */ "./src/components/Card/CardHeader.tsx");










/***/ }),

/***/ "./src/components/CardGrid/CardGrid.tsx":
/*!**********************************************!*\
  !*** ./src/components/CardGrid/CardGrid.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CardGrid: function() { return /* binding */ CardGrid; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Grid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Grid */ "./src/components/Grid/index.ts");



const CardGrid = ({ children, breakpoints, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Grid__WEBPACK_IMPORTED_MODULE_2__["default"], { "rcx-card-grid": true, m: -8, ...props, children: react__WEBPACK_IMPORTED_MODULE_1__.Children.map(children, (child) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Grid__WEBPACK_IMPORTED_MODULE_2__.GridItem, { "rcx-card-grid__item": true, p: 8, ...breakpoints, children: child }))) }));


/***/ }),

/***/ "./src/components/CardGrid/index.ts":
/*!******************************************!*\
  !*** ./src/components/CardGrid/index.ts ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CardGrid: function() { return /* reexport safe */ _CardGrid__WEBPACK_IMPORTED_MODULE_0__.CardGrid; }
/* harmony export */ });
/* harmony import */ var _CardGrid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CardGrid */ "./src/components/CardGrid/CardGrid.tsx");



/***/ }),

/***/ "./src/components/CardGroup/CardGroup.tsx":
/*!************************************************!*\
  !*** ./src/components/CardGroup/CardGroup.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CardGroup: function() { return /* binding */ CardGroup; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_appendClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/appendClassName */ "./src/helpers/appendClassName.ts");
/* harmony import */ var _helpers_patchChildren__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/patchChildren */ "./src/helpers/patchChildren.ts");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");




const CardGroup = ({ align = 'start', children, stretch, vertical, wrap, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_3__["default"], { "rcx-card-group": true, "rcx-card-group--align": align, "rcx-card-group--stretch": stretch, "rcx-card-group--vertical": vertical, "rcx-card-group--wrap": wrap, role: 'group', ...props, children: (0,_helpers_patchChildren__WEBPACK_IMPORTED_MODULE_2__.patchChildren)(children, (childProps) => ({
        className: (0,_helpers_appendClassName__WEBPACK_IMPORTED_MODULE_1__.appendClassName)(childProps.className, 'rcx-card-group__item'),
    })) }));


/***/ }),

/***/ "./src/components/CardGroup/index.ts":
/*!*******************************************!*\
  !*** ./src/components/CardGroup/index.ts ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CardGroup: function() { return /* reexport safe */ _CardGroup__WEBPACK_IMPORTED_MODULE_0__.CardGroup; }
/* harmony export */ });
/* harmony import */ var _CardGroup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CardGroup */ "./src/components/CardGroup/CardGroup.tsx");



/***/ }),

/***/ "./src/components/CheckBox/CheckBox.tsx":
/*!**********************************************!*\
  !*** ./src/components/CheckBox/CheckBox.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CheckBox: function() { return /* binding */ CheckBox; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");




const CheckBox = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(function CheckBox({ indeterminate, onChange, className, labelChildren, ...props }, ref) {
    const innerRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const mergedRef = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useMergedRefs)(ref, innerRef);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useLayoutEffect)(() => {
        if (innerRef && innerRef.current && indeterminate !== undefined) {
            innerRef.current.indeterminate = indeterminate;
        }
    }, [innerRef, indeterminate]);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((event) => {
        if (innerRef && innerRef.current && indeterminate !== undefined) {
            innerRef.current.indeterminate = indeterminate;
        }
        onChange?.call(innerRef.current, event);
    }, [innerRef, indeterminate, onChange]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_3__["default"], { is: 'label', className: className, "rcx-check-box": true, children: [labelChildren, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_3__["default"], { is: 'input', type: 'checkbox', "rcx-check-box__input": true, ref: mergedRef, onChange: handleChange, ...props }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_3__["default"], { is: 'i', "rcx-check-box__fake": true, "aria-hidden": 'true' })] }));
});


/***/ }),

/***/ "./src/components/CheckBox/index.ts":
/*!******************************************!*\
  !*** ./src/components/CheckBox/index.ts ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CheckBox: function() { return /* reexport safe */ _CheckBox__WEBPACK_IMPORTED_MODULE_0__.CheckBox; }
/* harmony export */ });
/* harmony import */ var _CheckBox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CheckBox */ "./src/components/CheckBox/CheckBox.tsx");



/***/ }),

/***/ "./src/components/Chevron/Chevron.tsx":
/*!********************************************!*\
  !*** ./src/components/Chevron/Chevron.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Chevron: function() { return /* binding */ Chevron; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");




function Chevron({ up, right, down, left, size, ...props }) {
    const children = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_3__.Icon, { name: 'chevron-down', size: size }), [size]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'span', children: children, "rcx-chevron": true, "rcx-chevron--up": up, "rcx-chevron--right": right, "rcx-chevron--down": down, "rcx-chevron--left": left, ...props }));
}


/***/ }),

/***/ "./src/components/Chevron/index.tsx":
/*!******************************************!*\
  !*** ./src/components/Chevron/index.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Chevron: function() { return /* reexport safe */ _Chevron__WEBPACK_IMPORTED_MODULE_0__.Chevron; }
/* harmony export */ });
/* harmony import */ var _Chevron__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Chevron */ "./src/components/Chevron/Chevron.tsx");



/***/ }),

/***/ "./src/components/Chip/Chip.tsx":
/*!**************************************!*\
  !*** ./src/components/Chip/Chip.tsx ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Chip: function() { return /* binding */ Chip; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/components/index.ts");
/* harmony import */ var _helpers_prependClassName__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/prependClassName */ "./src/helpers/prependClassName.ts");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");
/* harmony import */ var _Margins__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Margins */ "./src/components/Margins/index.ts");





const defaultRenderThumb = ({ url }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_1__.Box, { "rcx-avatar": true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_1__.Avatar, { size: 'x20', url: url }) }));
const defaultRenderDismissSymbol = () => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_3__.Icon, { name: 'cross', size: 'x16' });
const Chip = ({ children, className, thumbUrl, onClick, onMouseDown, renderThumb = defaultRenderThumb, renderDismissSymbol = defaultRenderDismissSymbol, ...rest }) => {
    const onDismiss = onClick || onMouseDown;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("button", { type: 'button', className: (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_2__.prependClassName)(className, 'rcx-box rcx-chip'), disabled: !onDismiss, onClick: onDismiss, ...rest, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Margins__WEBPACK_IMPORTED_MODULE_4__["default"], { all: 'x4', children: [thumbUrl && renderThumb && renderThumb({ url: thumbUrl }), children && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'rcx-box rcx-chip__text', children: children }), onDismiss && renderDismissSymbol && renderDismissSymbol()] }) }));
};
Chip.displayName = 'Chip';


/***/ }),

/***/ "./src/components/Chip/index.ts":
/*!**************************************!*\
  !*** ./src/components/Chip/index.ts ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Box_withBoxStyling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Box/withBoxStyling */ "./src/components/Box/withBoxStyling.tsx");
/* harmony import */ var _Chip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Chip */ "./src/components/Chip/Chip.tsx");


/* harmony default export */ __webpack_exports__["default"] = ((0,_Box_withBoxStyling__WEBPACK_IMPORTED_MODULE_0__.withBoxStyling)(_Chip__WEBPACK_IMPORTED_MODULE_1__.Chip));


/***/ }),

/***/ "./src/components/CodeSnippet/CodeSnippet.tsx":
/*!****************************************************!*\
  !*** ./src/components/CodeSnippet/CodeSnippet.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Button */ "./src/components/Button/index.ts");
/* harmony import */ var _Skeleton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Skeleton */ "./src/components/Skeleton/index.tsx");




/**
 * The `CodeSnippet` is used to show code or commands and make easier to copy them.
 *
 * The default button text is `Copy` but you can use the `buttonText` prop to handle translations in your project.
 *
 * Please check the `useClipBoard` hook in `fuselage-hooks` package, to handle the copy behaviour.
 */
const CodeSnippet = ({ children, onClick, buttonText = 'Copy', buttonDisabled = false, ...props }) => {
    if (!children) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { is: 'pre', "rcx-code-snippet": true, ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Skeleton__WEBPACK_IMPORTED_MODULE_3__.Skeleton, { w: '100%', "aria-hidden": true, "aria-busy": true }) }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { is: 'pre', "rcx-code-snippet": true, ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { role: 'code', "rcx-code-snippet__codebox": true, children: children }), onClick && children && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_2__.Button, { small: true, primary: true, onClick: onClick, disabled: buttonDisabled, children: buttonText }) }))] }));
};
/* harmony default export */ __webpack_exports__["default"] = (CodeSnippet);


/***/ }),

/***/ "./src/components/CodeSnippet/index.tsx":
/*!**********************************************!*\
  !*** ./src/components/CodeSnippet/index.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* reexport safe */ _CodeSnippet__WEBPACK_IMPORTED_MODULE_0__["default"]; }
/* harmony export */ });
/* harmony import */ var _CodeSnippet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CodeSnippet */ "./src/components/CodeSnippet/CodeSnippet.tsx");



/***/ }),

/***/ "./src/components/Contextualbar/Contextualbar.tsx":
/*!********************************************************!*\
  !*** ./src/components/Contextualbar/Contextualbar.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



/**
 * The `Contextualbar` has the purpose to persist and input information about the scope of the related page.
 */
const Contextualbar = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Contextualbar({ children, width, position, bg = 'room', ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Box, { ref: ref, "rcx-vertical-bar": true, bg: bg, color: 'default', display: 'flex', flexDirection: 'column', flexShrink: 0, width: width, borderInlineStartWidth: 'default', borderInlineStartColor: 'extra-light', borderInlineStartStyle: 'solid', height: 'full', position: position, insetInlineEnd: 'none', insetBlockStart: 'none', zIndex: 10, ...props, children: children }));
});
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(Contextualbar));


/***/ }),

/***/ "./src/components/Contextualbar/ContextualbarAction.tsx":
/*!**************************************************************!*\
  !*** ./src/components/Contextualbar/ContextualbarAction.tsx ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarAction = ({ name, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.IconButton, { ...props, small: true, flexShrink: 0, icon: name }));
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarAction));


/***/ }),

/***/ "./src/components/Contextualbar/ContextualbarActions.tsx":
/*!***************************************************************!*\
  !*** ./src/components/Contextualbar/ContextualbarActions.tsx ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarActions = (props) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.ButtonGroup, { ...props });
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarActions));


/***/ }),

/***/ "./src/components/Contextualbar/ContextualbarButton.tsx":
/*!**************************************************************!*\
  !*** ./src/components/Contextualbar/ContextualbarButton.tsx ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarButton = (props) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Button, { ...props });
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarButton));


/***/ }),

/***/ "./src/components/Contextualbar/ContextualbarContent.tsx":
/*!***************************************************************!*\
  !*** ./src/components/Contextualbar/ContextualbarContent.tsx ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarContent = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function ContextualbarContent(props, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Box, { ref: ref, "rcx-vertical-bar__content": true, paddingInline: 24, display: 'flex', flexDirection: 'column', overflowY: 'hidden', height: 'full', ...props }));
});
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarContent));


/***/ }),

/***/ "./src/components/Contextualbar/ContextualbarEmptyContent.tsx":
/*!********************************************************************!*\
  !*** ./src/components/Contextualbar/ContextualbarEmptyContent.tsx ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");
/* harmony import */ var _ContextualbarContent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ContextualbarContent */ "./src/components/Contextualbar/ContextualbarContent.tsx");




const ContextualbarEmptyContent = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function ContextualbarEmptyContent({ icon = 'magnifier', title = 'Nothing Found', subtitle, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ContextualbarContent__WEBPACK_IMPORTED_MODULE_3__["default"], { justifyContent: 'center', ...props, ref: ref, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(___WEBPACK_IMPORTED_MODULE_2__.States, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.StatesIcon, { name: icon }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.StatesTitle, { children: title }), subtitle && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.StatesSubtitle, { children: subtitle })] }) }));
});
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarEmptyContent));


/***/ }),

/***/ "./src/components/Contextualbar/ContextualbarFooter.tsx":
/*!**************************************************************!*\
  !*** ./src/components/Contextualbar/ContextualbarFooter.tsx ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarFooter = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function ContextualbarFooter({ children, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Box, { ref: ref, p: 24, ...props, children: children }));
});
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarFooter));


/***/ }),

/***/ "./src/components/Contextualbar/ContextualbarHeader.tsx":
/*!**************************************************************!*\
  !*** ./src/components/Contextualbar/ContextualbarHeader.tsx ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Margins__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Margins */ "./src/components/Margins/index.ts");




const ContextualbarHeader = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { display: 'flex', alignItems: 'center', height: 'x56', pi: 24, borderBlockEndWidth: 'default', borderBlockColor: 'extra-light', flexShrink: 0, ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { marginInline: 'neg-x4', display: 'flex', alignItems: 'center', justifyContent: 'space-between', flexGrow: 1, height: '100%', overflow: 'hidden', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Margins__WEBPACK_IMPORTED_MODULE_3__["default"], { inline: 'x4', children: children }) }) }));
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarHeader));


/***/ }),

/***/ "./src/components/Contextualbar/ContextualbarIcon.tsx":
/*!************************************************************!*\
  !*** ./src/components/Contextualbar/ContextualbarIcon.tsx ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarIcon = (props) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Icon, { ...props, pi: 2, size: 'x24' });
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarIcon));


/***/ }),

/***/ "./src/components/Contextualbar/ContextualbarSection.tsx":
/*!***************************************************************!*\
  !*** ./src/components/Contextualbar/ContextualbarSection.tsx ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarSection = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function ContextualbarSection(props, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Box, { ref: ref, "rcx-vertical-bar__section": true, pi: 24, pb: 16, display: 'flex', alignItems: 'center', flexGrow: 1, borderBlockEndWidth: 'default', borderBlockColor: 'extra-light', ...props }));
});
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarSection));


/***/ }),

/***/ "./src/components/Contextualbar/ContextualbarSkeleton.tsx":
/*!****************************************************************!*\
  !*** ./src/components/Contextualbar/ContextualbarSkeleton.tsx ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Skeleton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Skeleton */ "./src/components/Skeleton/index.tsx");
/* harmony import */ var _Contextualbar__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Contextualbar */ "./src/components/Contextualbar/Contextualbar.tsx");
/* harmony import */ var _ContextualbarHeader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ContextualbarHeader */ "./src/components/Contextualbar/ContextualbarHeader.tsx");






const ContextualbarSkeleton = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Contextualbar__WEBPACK_IMPORTED_MODULE_4__["default"], { ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ContextualbarHeader__WEBPACK_IMPORTED_MODULE_5__["default"], { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Skeleton__WEBPACK_IMPORTED_MODULE_3__.Skeleton, { width: '100%' }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { p: 24, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Skeleton__WEBPACK_IMPORTED_MODULE_3__.Skeleton, { mbe: 4, width: '32px', height: '32px', variant: 'rect' }), Array(5)
                    .fill(5)
                    .map((_, index) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Skeleton__WEBPACK_IMPORTED_MODULE_3__.Skeleton, {}, index)))] })] }));
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarSkeleton));


/***/ }),

/***/ "./src/components/Contextualbar/ContextualbarTitle.tsx":
/*!*************************************************************!*\
  !*** ./src/components/Contextualbar/ContextualbarTitle.tsx ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarTitle = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Box, { flexShrink: 1, flexGrow: 1, fontScale: 'h4', withTruncatedText: true, ...props }));
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarTitle));


/***/ }),

/***/ "./src/components/Contextualbar/index.ts":
/*!***********************************************!*\
  !*** ./src/components/Contextualbar/index.ts ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Contextualbar: function() { return /* reexport safe */ _Contextualbar__WEBPACK_IMPORTED_MODULE_0__["default"]; },
/* harmony export */   ContextualbarAction: function() { return /* reexport safe */ _ContextualbarAction__WEBPACK_IMPORTED_MODULE_1__["default"]; },
/* harmony export */   ContextualbarActions: function() { return /* reexport safe */ _ContextualbarActions__WEBPACK_IMPORTED_MODULE_2__["default"]; },
/* harmony export */   ContextualbarButton: function() { return /* reexport safe */ _ContextualbarButton__WEBPACK_IMPORTED_MODULE_3__["default"]; },
/* harmony export */   ContextualbarContent: function() { return /* reexport safe */ _ContextualbarContent__WEBPACK_IMPORTED_MODULE_4__["default"]; },
/* harmony export */   ContextualbarEmptyContent: function() { return /* reexport safe */ _ContextualbarEmptyContent__WEBPACK_IMPORTED_MODULE_5__["default"]; },
/* harmony export */   ContextualbarFooter: function() { return /* reexport safe */ _ContextualbarFooter__WEBPACK_IMPORTED_MODULE_6__["default"]; },
/* harmony export */   ContextualbarHeader: function() { return /* reexport safe */ _ContextualbarHeader__WEBPACK_IMPORTED_MODULE_7__["default"]; },
/* harmony export */   ContextualbarIcon: function() { return /* reexport safe */ _ContextualbarIcon__WEBPACK_IMPORTED_MODULE_8__["default"]; },
/* harmony export */   ContextualbarSection: function() { return /* reexport safe */ _ContextualbarSection__WEBPACK_IMPORTED_MODULE_9__["default"]; },
/* harmony export */   ContextualbarSkeleton: function() { return /* reexport safe */ _ContextualbarSkeleton__WEBPACK_IMPORTED_MODULE_10__["default"]; },
/* harmony export */   ContextualbarTitle: function() { return /* reexport safe */ _ContextualbarTitle__WEBPACK_IMPORTED_MODULE_11__["default"]; }
/* harmony export */ });
/* harmony import */ var _Contextualbar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Contextualbar */ "./src/components/Contextualbar/Contextualbar.tsx");
/* harmony import */ var _ContextualbarAction__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ContextualbarAction */ "./src/components/Contextualbar/ContextualbarAction.tsx");
/* harmony import */ var _ContextualbarActions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ContextualbarActions */ "./src/components/Contextualbar/ContextualbarActions.tsx");
/* harmony import */ var _ContextualbarButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ContextualbarButton */ "./src/components/Contextualbar/ContextualbarButton.tsx");
/* harmony import */ var _ContextualbarContent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ContextualbarContent */ "./src/components/Contextualbar/ContextualbarContent.tsx");
/* harmony import */ var _ContextualbarEmptyContent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ContextualbarEmptyContent */ "./src/components/Contextualbar/ContextualbarEmptyContent.tsx");
/* harmony import */ var _ContextualbarFooter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ContextualbarFooter */ "./src/components/Contextualbar/ContextualbarFooter.tsx");
/* harmony import */ var _ContextualbarHeader__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ContextualbarHeader */ "./src/components/Contextualbar/ContextualbarHeader.tsx");
/* harmony import */ var _ContextualbarIcon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ContextualbarIcon */ "./src/components/Contextualbar/ContextualbarIcon.tsx");
/* harmony import */ var _ContextualbarSection__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ContextualbarSection */ "./src/components/Contextualbar/ContextualbarSection.tsx");
/* harmony import */ var _ContextualbarSkeleton__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ContextualbarSkeleton */ "./src/components/Contextualbar/ContextualbarSkeleton.tsx");
/* harmony import */ var _ContextualbarTitle__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./ContextualbarTitle */ "./src/components/Contextualbar/ContextualbarTitle.tsx");















/***/ }),

/***/ "./src/components/ContextualbarV2/Contextualbar.tsx":
/*!**********************************************************!*\
  !*** ./src/components/ContextualbarV2/Contextualbar.tsx ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



/**
 * The `Contextualbar` has the purpose to persist and input information about the scope of the related page.
 */
const Contextualbar = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Contextualbar({ children, width, position, bg = 'room', ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Box, { ref: ref, "rcx-vertical-bar": true, bg: bg, color: 'default', display: 'flex', flexDirection: 'column', flexShrink: 0, width: width, borderInlineStartWidth: 'default', borderInlineStartColor: 'extra-light', borderInlineStartStyle: 'solid', height: 'full', position: position, insetInlineEnd: 'none', insetBlockStart: 'none', zIndex: 10, ...props, children: children }));
});
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(Contextualbar));


/***/ }),

/***/ "./src/components/ContextualbarV2/ContextualbarAction.tsx":
/*!****************************************************************!*\
  !*** ./src/components/ContextualbarV2/ContextualbarAction.tsx ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarAction = ({ name, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.IconButton, { ...props, small: true, flexShrink: 0, icon: name }));
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarAction));


/***/ }),

/***/ "./src/components/ContextualbarV2/ContextualbarActions.tsx":
/*!*****************************************************************!*\
  !*** ./src/components/ContextualbarV2/ContextualbarActions.tsx ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarActions = (props) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.ButtonGroup, { ...props });
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarActions));


/***/ }),

/***/ "./src/components/ContextualbarV2/ContextualbarButton.tsx":
/*!****************************************************************!*\
  !*** ./src/components/ContextualbarV2/ContextualbarButton.tsx ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarButton = (props) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Button, { ...props });
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarButton));


/***/ }),

/***/ "./src/components/ContextualbarV2/ContextualbarContent.tsx":
/*!*****************************************************************!*\
  !*** ./src/components/ContextualbarV2/ContextualbarContent.tsx ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarContent = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function ContextualbarContent(props, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Box, { ref: ref, "rcx-vertical-bar__content": true, paddingInline: 24, display: 'flex', flexDirection: 'column', overflowY: 'hidden', height: 'full', ...props }));
});
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarContent));


/***/ }),

/***/ "./src/components/ContextualbarV2/ContextualbarEmptyContent.tsx":
/*!**********************************************************************!*\
  !*** ./src/components/ContextualbarV2/ContextualbarEmptyContent.tsx ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");
/* harmony import */ var _ContextualbarContent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ContextualbarContent */ "./src/components/ContextualbarV2/ContextualbarContent.tsx");




const ContextualbarEmptyContent = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function ContextualbarEmptyContent({ icon = 'magnifier', title = 'Nothing Found', subtitle, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ContextualbarContent__WEBPACK_IMPORTED_MODULE_3__["default"], { justifyContent: 'center', ...props, ref: ref, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(___WEBPACK_IMPORTED_MODULE_2__.States, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.StatesIcon, { name: icon }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.StatesTitle, { children: title }), subtitle && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.StatesSubtitle, { children: subtitle })] }) }));
});
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarEmptyContent));


/***/ }),

/***/ "./src/components/ContextualbarV2/ContextualbarFooter.tsx":
/*!****************************************************************!*\
  !*** ./src/components/ContextualbarV2/ContextualbarFooter.tsx ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarFooter = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function ContextualbarFooter({ children, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Box, { ref: ref, pi: 16, pb: 20, ...props, children: children }));
});
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarFooter));


/***/ }),

/***/ "./src/components/ContextualbarV2/ContextualbarHeader.tsx":
/*!****************************************************************!*\
  !*** ./src/components/ContextualbarV2/ContextualbarHeader.tsx ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/css-in-js */ "@rocket.chat/css-in-js");
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");




const ContextualbarHeader = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_3__["default"], { display: 'flex', alignItems: 'center', height: 'x44', pi: 16, borderBlockEndWidth: 'default', borderBlockColor: 'extra-light', flexShrink: 0, ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_3__["default"], { display: 'flex', alignItems: 'center', justifyContent: 'space-between', flexGrow: 1, height: '100%', overflow: 'hidden', className: (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
        gap: 8px;
      `, children: children }) }));
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_2__.memo)(ContextualbarHeader));


/***/ }),

/***/ "./src/components/ContextualbarV2/ContextualbarIcon.tsx":
/*!**************************************************************!*\
  !*** ./src/components/ContextualbarV2/ContextualbarIcon.tsx ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarIcon = (props) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Icon, { ...props, pi: 2, size: 'x20' });
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarIcon));


/***/ }),

/***/ "./src/components/ContextualbarV2/ContextualbarSection.tsx":
/*!*****************************************************************!*\
  !*** ./src/components/ContextualbarV2/ContextualbarSection.tsx ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarSection = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function ContextualbarSection(props, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Box, { ref: ref, "rcx-vertical-bar__section": true, p: 16, display: 'flex', alignItems: 'center', flexGrow: 1, borderBlockEndWidth: 'default', borderBlockColor: 'extra-light', ...props }));
});
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarSection));


/***/ }),

/***/ "./src/components/ContextualbarV2/ContextualbarSkeleton.tsx":
/*!******************************************************************!*\
  !*** ./src/components/ContextualbarV2/ContextualbarSkeleton.tsx ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! . */ "./src/components/ContextualbarV2/index.ts");




const ContextualbarSkeleton = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(___WEBPACK_IMPORTED_MODULE_3__.ContextualbarV2, { ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_3__.ContextualbarV2Header, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Skeleton, { width: '100%' }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(___WEBPACK_IMPORTED_MODULE_2__.Box, { p: 24, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Skeleton, { mbe: 4, width: '32px', height: '32px', variant: 'rect' }), Array(5)
                    .fill(5)
                    .map((_, index) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Skeleton, {}, index)))] })] }));
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarSkeleton));


/***/ }),

/***/ "./src/components/ContextualbarV2/ContextualbarTitle.tsx":
/*!***************************************************************!*\
  !*** ./src/components/ContextualbarV2/ContextualbarTitle.tsx ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const ContextualbarTitle = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Box, { flexShrink: 1, flexGrow: 1, fontScale: 'h5', withTruncatedText: true, ...props }));
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(ContextualbarTitle));


/***/ }),

/***/ "./src/components/ContextualbarV2/index.ts":
/*!*************************************************!*\
  !*** ./src/components/ContextualbarV2/index.ts ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ContextualbarV2: function() { return /* reexport safe */ _Contextualbar__WEBPACK_IMPORTED_MODULE_0__["default"]; },
/* harmony export */   ContextualbarV2Action: function() { return /* reexport safe */ _ContextualbarAction__WEBPACK_IMPORTED_MODULE_1__["default"]; },
/* harmony export */   ContextualbarV2Actions: function() { return /* reexport safe */ _ContextualbarActions__WEBPACK_IMPORTED_MODULE_2__["default"]; },
/* harmony export */   ContextualbarV2Button: function() { return /* reexport safe */ _ContextualbarButton__WEBPACK_IMPORTED_MODULE_3__["default"]; },
/* harmony export */   ContextualbarV2Content: function() { return /* reexport safe */ _ContextualbarContent__WEBPACK_IMPORTED_MODULE_4__["default"]; },
/* harmony export */   ContextualbarV2EmptyContent: function() { return /* reexport safe */ _ContextualbarEmptyContent__WEBPACK_IMPORTED_MODULE_5__["default"]; },
/* harmony export */   ContextualbarV2Footer: function() { return /* reexport safe */ _ContextualbarFooter__WEBPACK_IMPORTED_MODULE_6__["default"]; },
/* harmony export */   ContextualbarV2Header: function() { return /* reexport safe */ _ContextualbarHeader__WEBPACK_IMPORTED_MODULE_7__["default"]; },
/* harmony export */   ContextualbarV2Icon: function() { return /* reexport safe */ _ContextualbarIcon__WEBPACK_IMPORTED_MODULE_8__["default"]; },
/* harmony export */   ContextualbarV2Section: function() { return /* reexport safe */ _ContextualbarSection__WEBPACK_IMPORTED_MODULE_9__["default"]; },
/* harmony export */   ContextualbarV2Skeleton: function() { return /* reexport safe */ _ContextualbarSkeleton__WEBPACK_IMPORTED_MODULE_10__["default"]; },
/* harmony export */   ContextualbarV2Title: function() { return /* reexport safe */ _ContextualbarTitle__WEBPACK_IMPORTED_MODULE_11__["default"]; }
/* harmony export */ });
/* harmony import */ var _Contextualbar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Contextualbar */ "./src/components/ContextualbarV2/Contextualbar.tsx");
/* harmony import */ var _ContextualbarAction__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ContextualbarAction */ "./src/components/ContextualbarV2/ContextualbarAction.tsx");
/* harmony import */ var _ContextualbarActions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ContextualbarActions */ "./src/components/ContextualbarV2/ContextualbarActions.tsx");
/* harmony import */ var _ContextualbarButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ContextualbarButton */ "./src/components/ContextualbarV2/ContextualbarButton.tsx");
/* harmony import */ var _ContextualbarContent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ContextualbarContent */ "./src/components/ContextualbarV2/ContextualbarContent.tsx");
/* harmony import */ var _ContextualbarEmptyContent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ContextualbarEmptyContent */ "./src/components/ContextualbarV2/ContextualbarEmptyContent.tsx");
/* harmony import */ var _ContextualbarFooter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ContextualbarFooter */ "./src/components/ContextualbarV2/ContextualbarFooter.tsx");
/* harmony import */ var _ContextualbarHeader__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ContextualbarHeader */ "./src/components/ContextualbarV2/ContextualbarHeader.tsx");
/* harmony import */ var _ContextualbarIcon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ContextualbarIcon */ "./src/components/ContextualbarV2/ContextualbarIcon.tsx");
/* harmony import */ var _ContextualbarSection__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ContextualbarSection */ "./src/components/ContextualbarV2/ContextualbarSection.tsx");
/* harmony import */ var _ContextualbarSkeleton__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ContextualbarSkeleton */ "./src/components/ContextualbarV2/ContextualbarSkeleton.tsx");
/* harmony import */ var _ContextualbarTitle__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./ContextualbarTitle */ "./src/components/ContextualbarV2/ContextualbarTitle.tsx");















/***/ }),

/***/ "./src/components/Divider/Divider.tsx":
/*!********************************************!*\
  !*** ./src/components/Divider/Divider.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Divider: function() { return /* binding */ Divider; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");


const Divider = ({ variation, children, vertical, ...props }) => {
    if (!children) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { is: 'hr', "rcx-divider": true, "rcx-divider--vertical": vertical, "rcx-divider--danger": variation === 'danger', ...props }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-message-divider": true, role: 'separator', ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-divider__bar' }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-divider__wrapper', children: children }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-divider__bar' })] }));
};



/***/ }),

/***/ "./src/components/Divider/index.tsx":
/*!******************************************!*\
  !*** ./src/components/Divider/index.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Divider: function() { return /* reexport safe */ _Divider__WEBPACK_IMPORTED_MODULE_0__.Divider; }
/* harmony export */ });
/* harmony import */ var _Divider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Divider */ "./src/components/Divider/Divider.tsx");



/***/ }),

/***/ "./src/components/Dropdown/Dropdown.tsx":
/*!**********************************************!*\
  !*** ./src/components/Dropdown/Dropdown.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Dropdown: function() { return /* binding */ Dropdown; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _DropdownDesktopWrapper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DropdownDesktopWrapper */ "./src/components/Dropdown/DropdownDesktopWrapper.tsx");
/* harmony import */ var _DropdownMobile__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./DropdownMobile */ "./src/components/Dropdown/DropdownMobile.tsx");





const Dropdown = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(function Dropdown({ children, reference, placement = 'bottom-start', }, ref) {
    const notSmall = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useMediaQuery)('(min-width: 500px)');
    return notSmall ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_DropdownDesktopWrapper__WEBPACK_IMPORTED_MODULE_3__.DropdownDesktopWrapper, { reference: reference, children: children, placement: placement, ref: ref })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_DropdownMobile__WEBPACK_IMPORTED_MODULE_4__.DropdownMobile, { children: children, ref: ref }));
});


/***/ }),

/***/ "./src/components/Dropdown/DropdownDesktop.tsx":
/*!*****************************************************!*\
  !*** ./src/components/Dropdown/DropdownDesktop.tsx ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DropdownDesktop: function() { return /* binding */ DropdownDesktop; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const DropdownDesktop = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function DropdownDesktop({ children, style, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Tile, { style: style, ref: ref, elevation: '2', pi: '0', pb: '0', display: 'flex', flexDirection: 'column', overflow: 'auto', "data-testid": 'dropdown', ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Box, { flexShrink: 1, pb: 12, children: style?.visibility === 'hidden' ? null : children }) }));
});


/***/ }),

/***/ "./src/components/Dropdown/DropdownDesktopWrapper.tsx":
/*!************************************************************!*\
  !*** ./src/components/Dropdown/DropdownDesktopWrapper.tsx ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DropdownDesktopWrapper: function() { return /* binding */ DropdownDesktopWrapper; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _DropdownDesktop__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DropdownDesktop */ "./src/components/Dropdown/DropdownDesktop.tsx");




const DropdownDesktopWrapper = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(function DropdownDesktopWrapper({ children, reference, placement = 'bottom-start', ...props }, ref) {
    const { style } = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.usePosition)(reference, ref, {
        placement,
    });
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_DropdownDesktop__WEBPACK_IMPORTED_MODULE_3__.DropdownDesktop, { style: style, children: children, ref: ref, ...props }));
});


/***/ }),

/***/ "./src/components/Dropdown/DropdownMobile.tsx":
/*!****************************************************!*\
  !*** ./src/components/Dropdown/DropdownMobile.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DropdownMobile: function() { return /* binding */ DropdownMobile; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.ts");



const DropdownMobile = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function DropdownMobile({ children, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Tile, { ref: ref, elevation: '2', pi: '0', pb: '0', w: '100vw', maxHeight: '80%', position: 'fixed', display: 'flex', flexDirection: 'column', overflow: 'auto', style: { bottom: 0, left: 0 }, zIndex: 2, "data-testid": 'dropdown', ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.Box, { flexShrink: 1, pb: 16, children: children }) }));
});


/***/ }),

/***/ "./src/components/Dropdown/index.tsx":
/*!*******************************************!*\
  !*** ./src/components/Dropdown/index.tsx ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Dropdown: function() { return /* reexport safe */ _Dropdown__WEBPACK_IMPORTED_MODULE_0__.Dropdown; }
/* harmony export */ });
/* harmony import */ var _Dropdown__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Dropdown */ "./src/components/Dropdown/Dropdown.tsx");



/***/ }),

/***/ "./src/components/EmailInput/EmailInput.tsx":
/*!**************************************************!*\
  !*** ./src/components/EmailInput/EmailInput.tsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmailInput: function() { return /* binding */ EmailInput; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../InputBox */ "./src/components/InputBox/index.ts");



const type = 'email';
/**
 * An input for email addresses.
 */
const EmailInput = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function EmailInput(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBox__WEBPACK_IMPORTED_MODULE_2__.InputBox, { type: type, ref: ref, ...props });
});


/***/ }),

/***/ "./src/components/EmailInput/index.tsx":
/*!*********************************************!*\
  !*** ./src/components/EmailInput/index.tsx ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmailInput: function() { return /* reexport safe */ _EmailInput__WEBPACK_IMPORTED_MODULE_0__.EmailInput; }
/* harmony export */ });
/* harmony import */ var _EmailInput__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EmailInput */ "./src/components/EmailInput/EmailInput.tsx");



/***/ }),

/***/ "./src/components/Field/Field.tsx":
/*!****************************************!*\
  !*** ./src/components/Field/Field.tsx ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FieldContext: function() { return /* binding */ FieldContext; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const FieldContext = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)(false);
/**
 * A `Field` is a wrapper representing an entry in a form.
 */
function Field(props) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FieldContext.Provider, { value: true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { "rcx-field": true, ...props }) }));
}
/* harmony default export */ __webpack_exports__["default"] = (Field);


/***/ }),

/***/ "./src/components/Field/FieldDescription.tsx":
/*!***************************************************!*\
  !*** ./src/components/Field/FieldDescription.tsx ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_WithErrorWrapper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/WithErrorWrapper */ "./src/helpers/WithErrorWrapper.tsx");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Field__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Field */ "./src/components/Field/Field.tsx");




const FieldDescription = (props) => {
    const component = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'span', "rcx-field__description": true, ...props });
    if (true) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_helpers_WithErrorWrapper__WEBPACK_IMPORTED_MODULE_1__["default"], { context: _Field__WEBPACK_IMPORTED_MODULE_3__.FieldContext, parentComponent: 'Field', componentName: FieldDescription.name, children: component }));
    }
    // removed by dead control flow

};
/* harmony default export */ __webpack_exports__["default"] = (FieldDescription);


/***/ }),

/***/ "./src/components/Field/FieldError.tsx":
/*!*********************************************!*\
  !*** ./src/components/Field/FieldError.tsx ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_WithErrorWrapper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/WithErrorWrapper */ "./src/helpers/WithErrorWrapper.tsx");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Field__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Field */ "./src/components/Field/Field.tsx");




const FieldError = (props) => {
    const component = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'span', "rcx-field__error": true, ...props });
    if (true) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_helpers_WithErrorWrapper__WEBPACK_IMPORTED_MODULE_1__["default"], { context: _Field__WEBPACK_IMPORTED_MODULE_3__.FieldContext, parentComponent: 'Field', componentName: FieldError.name, children: component }));
    }
    // removed by dead control flow

};
/* harmony default export */ __webpack_exports__["default"] = (FieldError);


/***/ }),

/***/ "./src/components/Field/FieldHint.tsx":
/*!********************************************!*\
  !*** ./src/components/Field/FieldHint.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_WithErrorWrapper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/WithErrorWrapper */ "./src/helpers/WithErrorWrapper.tsx");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Field__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Field */ "./src/components/Field/Field.tsx");




const FieldHint = (props) => {
    const component = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'span', "rcx-field__hint": true, ...props });
    if (true) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_helpers_WithErrorWrapper__WEBPACK_IMPORTED_MODULE_1__["default"], { context: _Field__WEBPACK_IMPORTED_MODULE_3__.FieldContext, parentComponent: 'Field', componentName: FieldHint.name, children: component }));
    }
    // removed by dead control flow

};
/* harmony default export */ __webpack_exports__["default"] = (FieldHint);


/***/ }),

/***/ "./src/components/Field/FieldLabel.tsx":
/*!*********************************************!*\
  !*** ./src/components/Field/FieldLabel.tsx ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _helpers_WithErrorWrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/WithErrorWrapper */ "./src/helpers/WithErrorWrapper.tsx");
/* harmony import */ var _Label__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Label */ "./src/components/Label/index.tsx");
/* harmony import */ var _Field__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Field */ "./src/components/Field/Field.tsx");





const FieldLabel = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function FieldLabel(props, ref) {
    const component = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Label__WEBPACK_IMPORTED_MODULE_3__.Label, { "rcx-field__label": true, ...props, ref: ref });
    if (true) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_helpers_WithErrorWrapper__WEBPACK_IMPORTED_MODULE_2__["default"], { context: _Field__WEBPACK_IMPORTED_MODULE_4__.FieldContext, parentComponent: 'Field', componentName: FieldLabel.name, children: component }));
    }
    // removed by dead control flow

});
/* harmony default export */ __webpack_exports__["default"] = (FieldLabel);


/***/ }),

/***/ "./src/components/Field/FieldLabelInfo.tsx":
/*!*************************************************!*\
  !*** ./src/components/Field/FieldLabelInfo.tsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_WithErrorWrapper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/WithErrorWrapper */ "./src/helpers/WithErrorWrapper.tsx");
/* harmony import */ var _Label_LabelInfo__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Label/LabelInfo */ "./src/components/Label/LabelInfo.tsx");
/* harmony import */ var _Field__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Field */ "./src/components/Field/Field.tsx");




const FieldLabelInfo = (props) => {
    const component = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Label_LabelInfo__WEBPACK_IMPORTED_MODULE_2__.LabelInfo, { ...props });
    if (true) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_helpers_WithErrorWrapper__WEBPACK_IMPORTED_MODULE_1__["default"], { context: _Field__WEBPACK_IMPORTED_MODULE_3__.FieldContext, parentComponent: 'Field', componentName: FieldLabelInfo.name, children: component }));
    }
    // removed by dead control flow

};
/* harmony default export */ __webpack_exports__["default"] = (FieldLabelInfo);


/***/ }),

/***/ "./src/components/Field/FieldLink.tsx":
/*!********************************************!*\
  !*** ./src/components/Field/FieldLink.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_WithErrorWrapper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/WithErrorWrapper */ "./src/helpers/WithErrorWrapper.tsx");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Field__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Field */ "./src/components/Field/Field.tsx");




const FieldLink = (props) => {
    const component = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'a', target: '_blank', "rcx-field__link": true, ...props });
    if (true) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_helpers_WithErrorWrapper__WEBPACK_IMPORTED_MODULE_1__["default"], { context: _Field__WEBPACK_IMPORTED_MODULE_3__.FieldContext, parentComponent: 'Field', componentName: FieldLink.name, children: component }));
    }
    // removed by dead control flow

};
/* harmony default export */ __webpack_exports__["default"] = (FieldLink);


/***/ }),

/***/ "./src/components/Field/FieldRow.tsx":
/*!*******************************************!*\
  !*** ./src/components/Field/FieldRow.tsx ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_WithErrorWrapper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/WithErrorWrapper */ "./src/helpers/WithErrorWrapper.tsx");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Field__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Field */ "./src/components/Field/Field.tsx");




const FieldRow = (props) => {
    const component = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'span', "rcx-field__row": true, ...props });
    if (true) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_helpers_WithErrorWrapper__WEBPACK_IMPORTED_MODULE_1__["default"], { context: _Field__WEBPACK_IMPORTED_MODULE_3__.FieldContext, parentComponent: 'Field', componentName: FieldRow.name, children: component }));
    }
    // removed by dead control flow

};
/* harmony default export */ __webpack_exports__["default"] = (FieldRow);


/***/ }),

/***/ "./src/components/Field/index.ts":
/*!***************************************!*\
  !*** ./src/components/Field/index.ts ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Field: function() { return /* reexport safe */ _Field__WEBPACK_IMPORTED_MODULE_0__["default"]; },
/* harmony export */   FieldDescription: function() { return /* reexport safe */ _FieldDescription__WEBPACK_IMPORTED_MODULE_1__["default"]; },
/* harmony export */   FieldError: function() { return /* reexport safe */ _FieldError__WEBPACK_IMPORTED_MODULE_2__["default"]; },
/* harmony export */   FieldHint: function() { return /* reexport safe */ _FieldHint__WEBPACK_IMPORTED_MODULE_3__["default"]; },
/* harmony export */   FieldLabel: function() { return /* reexport safe */ _FieldLabel__WEBPACK_IMPORTED_MODULE_4__["default"]; },
/* harmony export */   FieldLabelInfo: function() { return /* reexport safe */ _FieldLabelInfo__WEBPACK_IMPORTED_MODULE_5__["default"]; },
/* harmony export */   FieldLink: function() { return /* reexport safe */ _FieldLink__WEBPACK_IMPORTED_MODULE_6__["default"]; },
/* harmony export */   FieldRow: function() { return /* reexport safe */ _FieldRow__WEBPACK_IMPORTED_MODULE_7__["default"]; }
/* harmony export */ });
/* harmony import */ var _Field__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Field */ "./src/components/Field/Field.tsx");
/* harmony import */ var _FieldDescription__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FieldDescription */ "./src/components/Field/FieldDescription.tsx");
/* harmony import */ var _FieldError__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FieldError */ "./src/components/Field/FieldError.tsx");
/* harmony import */ var _FieldHint__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./FieldHint */ "./src/components/Field/FieldHint.tsx");
/* harmony import */ var _FieldLabel__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./FieldLabel */ "./src/components/Field/FieldLabel.tsx");
/* harmony import */ var _FieldLabelInfo__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./FieldLabelInfo */ "./src/components/Field/FieldLabelInfo.tsx");
/* harmony import */ var _FieldLink__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./FieldLink */ "./src/components/Field/FieldLink.tsx");
/* harmony import */ var _FieldRow__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./FieldRow */ "./src/components/Field/FieldRow.tsx");










/***/ }),

/***/ "./src/components/FieldGroup/FieldGroup.tsx":
/*!**************************************************!*\
  !*** ./src/components/FieldGroup/FieldGroup.tsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FieldGroup: function() { return /* binding */ FieldGroup; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_appendClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/appendClassName */ "./src/helpers/appendClassName.ts");
/* harmony import */ var _helpers_patchChildren__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/patchChildren */ "./src/helpers/patchChildren.ts");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");




/**
 * A container for grouping fields that semantically share a common data context.
 */
const FieldGroup = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_3__["default"], { is: 'fieldset', "rcx-field-group": true, role: 'group', ...props, children: (0,_helpers_patchChildren__WEBPACK_IMPORTED_MODULE_2__.patchChildren)(children, (childProps) => ({
        className: (0,_helpers_appendClassName__WEBPACK_IMPORTED_MODULE_1__.appendClassName)(childProps.className, 'rcx-field-group__item'),
    })) }));


/***/ }),

/***/ "./src/components/FieldGroup/index.ts":
/*!********************************************!*\
  !*** ./src/components/FieldGroup/index.ts ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FieldGroup: function() { return /* reexport safe */ _FieldGroup__WEBPACK_IMPORTED_MODULE_0__.FieldGroup; }
/* harmony export */ });
/* harmony import */ var _FieldGroup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FieldGroup */ "./src/components/FieldGroup/FieldGroup.tsx");



/***/ }),

/***/ "./src/components/Flex/FlexContainer.tsx":
/*!***********************************************!*\
  !*** ./src/components/Flex/FlexContainer.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box/BoxTransforms */ "./src/components/Box/BoxTransforms.ts");



function FlexContainer({ inline = false, children, direction, wrap, alignItems, alignContent, justifyContent, }) {
    const transformFn = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((props) => {
        if (inline !== undefined && props.display === undefined) {
            props.display = inline ? 'inline-flex' : 'flex';
        }
        if (direction !== undefined && props.flexDirection === undefined) {
            props.flexDirection = direction;
        }
        if (wrap !== undefined && props.flexWrap === undefined) {
            props.flexWrap = wrap === 'no-wrap' ? 'nowrap' : wrap;
        }
        if (alignItems !== undefined && props.alignItems === undefined) {
            props.alignItems =
                (alignItems === 'start' && 'flex-start') ||
                    (alignItems === 'end' && 'flex-end') ||
                    alignItems;
        }
        if (alignContent !== undefined && props.alignContent === undefined) {
            props.alignContent =
                (alignContent === 'start' && 'flex-start') ||
                    (alignContent === 'end' && 'flex-end') ||
                    alignContent;
        }
        if (justifyContent !== undefined && props.justifyContent === undefined) {
            props.justifyContent =
                (justifyContent === 'start' && 'flex-start') ||
                    (justifyContent === 'end' && 'flex-end') ||
                    justifyContent;
        }
        return props;
    }, [alignContent, alignItems, direction, inline, justifyContent, wrap]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_2__.BoxTransforms.Provider, { children: children, value: (0,_Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_2__.useComposedBoxTransform)(transformFn) }));
}
/* harmony default export */ __webpack_exports__["default"] = (FlexContainer);


/***/ }),

/***/ "./src/components/Flex/FlexItem.tsx":
/*!******************************************!*\
  !*** ./src/components/Flex/FlexItem.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box/BoxTransforms */ "./src/components/Box/BoxTransforms.ts");



function FlexItem({ children, order, grow, shrink, basis, align, }) {
    const transformFn = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((props) => {
        if (order !== undefined && props.order === undefined) {
            props.order = order;
        }
        if (grow !== undefined && props.flexGrow === undefined) {
            props.flexGrow = grow;
        }
        if (shrink !== undefined && props.flexShrink === undefined) {
            props.flexShrink = shrink;
        }
        if (basis !== undefined && props.flexBasis === undefined) {
            props.flexBasis = basis;
        }
        if (align !== undefined && props.alignSelf === undefined) {
            props.alignSelf =
                (align === 'start' && 'flex-start') ||
                    (align === 'end' && 'flex-end') ||
                    align;
        }
        return props;
    }, [align, basis, grow, order, shrink]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_2__.BoxTransforms.Provider, { children: children, value: (0,_Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_2__.useComposedBoxTransform)(transformFn) }));
}
/* harmony default export */ __webpack_exports__["default"] = (FlexItem);


/***/ }),

/***/ "./src/components/Flex/index.ts":
/*!**************************************!*\
  !*** ./src/components/Flex/index.ts ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _FlexContainer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FlexContainer */ "./src/components/Flex/FlexContainer.tsx");
/* harmony import */ var _FlexItem__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FlexItem */ "./src/components/Flex/FlexItem.tsx");


/* harmony default export */ __webpack_exports__["default"] = ({
    Container: _FlexContainer__WEBPACK_IMPORTED_MODULE_0__["default"],
    Item: _FlexItem__WEBPACK_IMPORTED_MODULE_1__["default"],
});


/***/ }),

/***/ "./src/components/FramedIcon/FramedIcon.tsx":
/*!**************************************************!*\
  !*** ./src/components/FramedIcon/FramedIcon.tsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FramedIcon: function() { return /* binding */ FramedIcon; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");


const FramedIcon = ({ info, success, warning, danger, neutral, icon, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__.Icon, { ...props, "rcx-framed-icon": true, "rcx-framed-icon--info": info, "rcx-framed-icon--success": success, "rcx-framed-icon--warning": warning, "rcx-framed-icon--danger": danger, "rcx-framed-icon--neutral": neutral || (!info && !success && !warning && !danger), name: icon, size: 20 }));


/***/ }),

/***/ "./src/components/FramedIcon/index.ts":
/*!********************************************!*\
  !*** ./src/components/FramedIcon/index.ts ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FramedIcon: function() { return /* reexport safe */ _FramedIcon__WEBPACK_IMPORTED_MODULE_0__.FramedIcon; }
/* harmony export */ });
/* harmony import */ var _FramedIcon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FramedIcon */ "./src/components/FramedIcon/FramedIcon.tsx");



/***/ }),

/***/ "./src/components/Grid/Grid.tsx":
/*!**************************************!*\
  !*** ./src/components/Grid/Grid.tsx ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Grid: function() { return /* binding */ Grid; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _GridItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./GridItem */ "./src/components/Grid/GridItem.tsx");



const Grid = ({ xs, sm, md, lg, xl, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-grid__wrapper": true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-grid": true, "rcx-grid--xs": xs, "rcx-grid--sm": sm, "rcx-grid--md": md, "rcx-grid--lg": lg, "rcx-grid--xl": xl, ...props }) }));
Grid.Item = _GridItem__WEBPACK_IMPORTED_MODULE_2__.GridItem;


/***/ }),

/***/ "./src/components/Grid/GridItem.tsx":
/*!******************************************!*\
  !*** ./src/components/Grid/GridItem.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GridItem: function() { return /* binding */ GridItem; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");


const GridItem = ({ xs, sm, md, lg, xl, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-grid__item": true, "rcx-grid__item--xs": xs, "rcx-grid__item--sm": sm, "rcx-grid__item--md": md, "rcx-grid__item--lg": lg, "rcx-grid__item--xl": xl, ...props }));


/***/ }),

/***/ "./src/components/Grid/index.ts":
/*!**************************************!*\
  !*** ./src/components/Grid/index.ts ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Grid: function() { return /* reexport safe */ _Grid__WEBPACK_IMPORTED_MODULE_0__.Grid; },
/* harmony export */   GridItem: function() { return /* reexport safe */ _GridItem__WEBPACK_IMPORTED_MODULE_1__.GridItem; }
/* harmony export */ });
/* harmony import */ var _Grid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Grid */ "./src/components/Grid/Grid.tsx");
/* harmony import */ var _GridItem__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./GridItem */ "./src/components/Grid/GridItem.tsx");



/* harmony default export */ __webpack_exports__["default"] = (_Grid__WEBPACK_IMPORTED_MODULE_0__.Grid);


/***/ }),

/***/ "./src/components/Icon/Icon.tsx":
/*!**************************************!*\
  !*** ./src/components/Icon/Icon.tsx ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Icon: function() { return /* binding */ Icon; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/icons */ "@rocket.chat/icons");
/* harmony import */ var _rocket_chat_icons__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_icons__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");




const Icon = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(function Icon({ name, size, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_3__["default"], { is: 'i', "rcx-icon": true, "rcx-icon--name": name, children: (_rocket_chat_icons__WEBPACK_IMPORTED_MODULE_1___default())[name], "aria-hidden": 'true', fontSize: size, ref: ref, ...props }));
});


/***/ }),

/***/ "./src/components/Icon/index.ts":
/*!**************************************!*\
  !*** ./src/components/Icon/index.ts ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Icon: function() { return /* reexport safe */ _Icon__WEBPACK_IMPORTED_MODULE_0__.Icon; }
/* harmony export */ });
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Icon */ "./src/components/Icon/Icon.tsx");



/***/ }),

/***/ "./src/components/InputBox/Input.tsx":
/*!*******************************************!*\
  !*** ./src/components/InputBox/Input.tsx ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const Input = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Input(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'input', animated: true, "rcx-input-box": true, ref: ref, ...props });
});
/* harmony default export */ __webpack_exports__["default"] = (Input);


/***/ }),

/***/ "./src/components/InputBox/InputBox.tsx":
/*!**********************************************!*\
  !*** ./src/components/InputBox/InputBox.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");
/* harmony import */ var _Input__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Input */ "./src/components/InputBox/Input.tsx");
/* harmony import */ var _InputBoxAddon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./InputBoxAddon */ "./src/components/InputBox/InputBoxAddon.tsx");
/* harmony import */ var _InputBoxWrapper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./InputBoxWrapper */ "./src/components/InputBox/InputBoxWrapper.tsx");







/**
 * A decorated input control with support for addons.
 *
 * Usually you'll perfer to use `-Input` (e.g. <LinkTo kind='Forms/TextInput' story='Default'>`TextInput`</LinkTo>)
 * components over this one because it works as a construction block for them.
 */
// eslint-disable-next-line complexity
const InputBox = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(function InputBox({ className, addon, error, hidden, invisible, multiple, placeholderVisible, type = 'text', small, onChange, ...props }, ref) {
    const innerRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const mergedRef = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useMergedRefs)(ref, innerRef);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useLayoutEffect)(() => {
        if (innerRef.current && innerRef.current.setCustomValidity) {
            innerRef.current.setCustomValidity(error || '');
        }
    }, [error]);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useLayoutEffect)(() => {
        if (addon && innerRef.current && innerRef.current.parentElement) {
            innerRef.current.parentElement.classList.toggle('invalid', !innerRef.current.checkValidity());
        }
    }, []);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((event) => {
        if (addon && innerRef.current && innerRef.current.parentElement) {
            innerRef.current.parentElement.classList.toggle('invalid', !innerRef.current.checkValidity());
        }
        onChange?.call(event.currentTarget, event);
    }, [addon, onChange]);
    const handleAddonClick = () => innerRef.current.showPicker();
    if (type === 'date') {
        addon = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_3__.Icon, { name: 'calendar', size: 'x20', onClick: handleAddonClick });
    }
    if (type === 'time') {
        addon = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_3__.Icon, { name: 'clock', size: 'x20', onClick: handleAddonClick });
    }
    if (!addon) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Input__WEBPACK_IMPORTED_MODULE_4__["default"], { is: (type === 'textarea' && 'textarea') ||
                (type === 'select' && 'select') ||
                'input', className: className, cols: (type === 'textarea' && 1) || (type === 'select' && 0) || 0, hidden: hidden, invisible: invisible, multiple: multiple, ref: mergedRef, htmlSize: (type === 'textarea' && undefined) || (type === 'select' && 1) || 1, type: type === 'textarea' || type === 'select' ? undefined : type, onChange: handleChange, "rcx-input-box--multiple": multiple, "rcx-input-box--placeholder-visible": placeholderVisible, "rcx-input-box--type": type, "rcx-input-box--small": small, ...props }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_InputBoxWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], { className: [
            props.disabled && 'disabled',
            ...(Array.isArray(className) ? className : [className]),
        ], hidden: hidden, invisible: invisible, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Input__WEBPACK_IMPORTED_MODULE_4__["default"], { is: (type === 'textarea' && 'textarea') ||
                    (type === 'select' && 'select') ||
                    'input', className: className, cols: (type === 'textarea' && 1) || (type === 'select' && 0) || 0, multiple: multiple, ref: mergedRef, htmlSize: (type === 'textarea' && undefined) || (type === 'select' && 1) || 1, type: type === 'textarea' || type === 'select' ? undefined : type, onChange: handleChange, "rcx-input-box--multiple": multiple, "rcx-input-box--placeholder-visible": placeholderVisible, "rcx-input-box--type": type, "rcx-input-box--undecorated": true, "rcx-input-box--small": small, ...props }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBoxAddon__WEBPACK_IMPORTED_MODULE_5__["default"], { children: addon })] }));
});
/* harmony default export */ __webpack_exports__["default"] = (InputBox);


/***/ }),

/***/ "./src/components/InputBox/InputBoxAddon.tsx":
/*!***************************************************!*\
  !*** ./src/components/InputBox/InputBoxAddon.tsx ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const InputBoxAddon = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function InputBoxAddon(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'span', "rcx-input-box__addon": true, ref: ref, ...props });
});
/* harmony default export */ __webpack_exports__["default"] = (InputBoxAddon);


/***/ }),

/***/ "./src/components/InputBox/InputBoxSkeleton.tsx":
/*!******************************************************!*\
  !*** ./src/components/InputBox/InputBoxSkeleton.tsx ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Skeleton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Skeleton */ "./src/components/Skeleton/index.tsx");



const InputBoxSkeleton = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-skeleton__input": true, ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Skeleton__WEBPACK_IMPORTED_MODULE_2__.Skeleton, { width: '100%' }) }));
/* harmony default export */ __webpack_exports__["default"] = (InputBoxSkeleton);


/***/ }),

/***/ "./src/components/InputBox/InputBoxWrapper.tsx":
/*!*****************************************************!*\
  !*** ./src/components/InputBox/InputBoxWrapper.tsx ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Label__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Label */ "./src/components/Label/index.tsx");



const InputBoxWrapper = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { animated: true, is: _Label__WEBPACK_IMPORTED_MODULE_2__.Label, "rcx-input-box__wrapper": true, ...props }));
/* harmony default export */ __webpack_exports__["default"] = (InputBoxWrapper);


/***/ }),

/***/ "./src/components/InputBox/index.ts":
/*!******************************************!*\
  !*** ./src/components/InputBox/index.ts ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Input: function() { return /* reexport safe */ _Input__WEBPACK_IMPORTED_MODULE_0__["default"]; },
/* harmony export */   InputBox: function() { return /* reexport safe */ _InputBox__WEBPACK_IMPORTED_MODULE_1__["default"]; },
/* harmony export */   InputBoxSkeleton: function() { return /* reexport safe */ _InputBoxSkeleton__WEBPACK_IMPORTED_MODULE_2__["default"]; }
/* harmony export */ });
/* harmony import */ var _Input__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Input */ "./src/components/InputBox/Input.tsx");
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./InputBox */ "./src/components/InputBox/InputBox.tsx");
/* harmony import */ var _InputBoxSkeleton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InputBoxSkeleton */ "./src/components/InputBox/InputBoxSkeleton.tsx");





/***/ }),

/***/ "./src/components/Label/Label.tsx":
/*!****************************************!*\
  !*** ./src/components/Label/Label.tsx ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Label: function() { return /* binding */ Label; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const LabelContext = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)(false);
/**
 * A caption for an input component.
 */
const Label = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Label({ disabled, is, required, children, ...props }, ref) {
    const isInsideLabel = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(LabelContext);
    const component = is || (isInsideLabel && 'span') || 'label';
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(LabelContext.Provider, { value: true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: component, "rcx-label": true, "rcx-label--disabled": disabled, ...props, ref: ref, children: [children, required && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'span', "rcx-label__required": true, mis: 'x4', "aria-hidden": 'true', children: "*" }))] }) }));
});


/***/ }),

/***/ "./src/components/Label/LabelInfo.tsx":
/*!********************************************!*\
  !*** ./src/components/Label/LabelInfo.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LabelInfo: function() { return /* binding */ LabelInfo; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box/Box */ "./src/components/Box/Box.tsx");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");



const LabelInfo = ({ title, id, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { is: 'span', mi: 2, "rcx-label__info": true, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { hidden: true, id: id, children: title }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_2__.Icon, { ...props, name: 'info-circled', title: title })] }));


/***/ }),

/***/ "./src/components/Label/index.tsx":
/*!****************************************!*\
  !*** ./src/components/Label/index.tsx ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Label: function() { return /* reexport safe */ _Label__WEBPACK_IMPORTED_MODULE_0__.Label; }
/* harmony export */ });
/* harmony import */ var _Label__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Label */ "./src/components/Label/Label.tsx");



/***/ }),

/***/ "./src/components/Margins/Margins.tsx":
/*!********************************************!*\
  !*** ./src/components/Margins/Margins.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Margins: function() { return /* binding */ Margins; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/css-in-js */ "@rocket.chat/css-in-js");
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _helpers_appendClassName__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers/appendClassName */ "./src/helpers/appendClassName.ts");
/* harmony import */ var _helpers_patchChildren__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../helpers/patchChildren */ "./src/helpers/patchChildren.ts");
/* harmony import */ var _hooks_useStyle__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../hooks/useStyle */ "./src/hooks/useStyle.ts");
/* harmony import */ var _styleTokens__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../styleTokens */ "./src/styleTokens.ts");
/* harmony import */ var _Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Box/BoxTransforms */ "./src/components/Box/BoxTransforms.ts");








/**
 * Add margins to the wrapped component.
 */
const Margins = (props) => {
    const { children, className, all, block, blockStart, blockEnd, inline, inlineStart, inlineEnd, } = props;
    const transformFn = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)((props) => {
        if (all !== undefined && props.margin === undefined) {
            props.margin = all;
        }
        if (block !== undefined && props.marginBlock === undefined) {
            props.marginBlock = block;
        }
        if (blockStart !== undefined && props.marginBlockStart === undefined) {
            props.marginBlockStart = blockStart;
        }
        if (blockEnd !== undefined && props.marginBlockEnd === undefined) {
            props.marginBlockEnd = blockEnd;
        }
        if (inline !== undefined && props.marginInline === undefined) {
            props.marginInline = inline;
        }
        if (inlineStart !== undefined && props.marginInlineStart === undefined) {
            props.marginInlineStart = inlineStart;
        }
        if (inlineEnd !== undefined && props.marginInlineEnd === undefined) {
            props.marginInlineEnd = inlineEnd;
        }
        return props;
    }, [all, block, blockEnd, blockStart, inline, inlineEnd, inlineStart]);
    const marginsClassName = (0,_hooks_useStyle__WEBPACK_IMPORTED_MODULE_5__.useStyle)((0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
      &:not(.rcx-box--full) {
        ${props.all &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
          margin: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_6__.margin)(props.all)};
        `}
        ${props.inline &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
          margin-inline: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_6__.margin)(props.inline)};
        `}
      ${props.inlineStart &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
          margin-inline-start: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_6__.margin)(props.inlineStart)};
        `}
      ${props.inlineEnd &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
          margin-inline-end: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_6__.margin)(props.inlineEnd)};
        `}
      ${props.block &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
          margin-block: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_6__.margin)(props.block)};
        `}
      ${props.blockStart &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
          margin-block-start: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_6__.margin)(props.blockStart)};
        `}
      ${props.blockEnd &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
          margin-block-end: ${(0,_styleTokens__WEBPACK_IMPORTED_MODULE_6__.margin)(props.blockEnd)};
        `}
      }
    `, props);
    const patchedChildren = (0,_helpers_patchChildren__WEBPACK_IMPORTED_MODULE_4__.patchChildren)(children, (childProps) => ({
        className: (0,_helpers_appendClassName__WEBPACK_IMPORTED_MODULE_3__.appendClassName)(childProps.className, (0,_helpers_appendClassName__WEBPACK_IMPORTED_MODULE_3__.appendClassName)(className, marginsClassName)),
    }));
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_7__.BoxTransforms.Provider, { children: patchedChildren, value: (0,_Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_7__.useComposedBoxTransform)(transformFn) }));
};


/***/ }),

/***/ "./src/components/Margins/index.ts":
/*!*****************************************!*\
  !*** ./src/components/Margins/index.ts ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Margins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Margins */ "./src/components/Margins/Margins.tsx");

/* harmony default export */ __webpack_exports__["default"] = (_Margins__WEBPACK_IMPORTED_MODULE_0__.Margins);


/***/ }),

/***/ "./src/components/Menu/Menu.tsx":
/*!**************************************!*\
  !*** ./src/components/Menu/Menu.tsx ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Menu: function() { return /* binding */ Menu; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Button */ "./src/components/Button/index.ts");
/* harmony import */ var _Options__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Options */ "./src/components/Options/index.ts");
/* harmony import */ var _PositionAnimated__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../PositionAnimated */ "./src/components/PositionAnimated/index.ts");





const menuAction = ([selected], options) => {
    options[selected].action?.();
};
const mapOptions = (options) => Object.entries(options).map(([value, { type = 'option', label, disabled }]) => [
    value,
    label,
    undefined,
    disabled,
    type,
]);
/**
 * Kebab Menu
 */
const Menu = ({ tiny, mini, small = !(tiny || mini), options, optionWidth, placement = 'bottom-start', renderItem, maxHeight, icon = 'kebab', ...props }) => {
    const mappedOptions = mapOptions(options);
    const [cursor, handleKeyDown, handleKeyUp, reset, [visible, hide, show]] = (0,_Options__WEBPACK_IMPORTED_MODULE_3__.useCursor)(-1, mappedOptions, (args, [, hide]) => {
        menuAction(args, options);
        reset();
        hide();
    });
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    const onClick = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
        if (ref.current?.classList.contains('focus-visible')) {
            ref.current.classList.remove('focus-visible');
            hide();
            return;
        }
        if (ref.current) {
            ref.current.focus();
            show();
            ref.current.classList.add('focus-visible');
        }
    }, [hide, show]);
    const handleSelection = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((args) => {
        menuAction(args, options);
        reset();
        hide();
    }, [hide, reset, options]);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        if (visible === 'hidden') {
            ref.current?.classList.remove('focus-visible');
        }
    }, [visible]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_2__.IconButton, { "data-testid": 'menu', ref: ref, small: small, tiny: tiny, mini: mini, onClick: onClick, onBlur: hide, onKeyUp: handleKeyUp, onKeyDown: handleKeyDown, icon: icon, ...props }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_PositionAnimated__WEBPACK_IMPORTED_MODULE_4__["default"], { width: 'auto', visible: visible, anchor: ref, placement: placement, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Options__WEBPACK_IMPORTED_MODULE_3__.Options, { maxHeight: maxHeight, renderItem: renderItem, width: optionWidth, onSelect: handleSelection, options: mappedOptions, cursor: cursor, ref: ref }) })] }));
};


/***/ }),

/***/ "./src/components/Menu/V2/Menu.tsx":
/*!*****************************************!*\
  !*** ./src/components/Menu/V2/Menu.tsx ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-aria */ "react-aria");
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_aria__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-dom */ "react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_stately__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-stately */ "react-stately");
/* harmony import */ var react_stately__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_stately__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Button */ "./src/components/Button/index.ts");
/* harmony import */ var _MenuDropdown__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./MenuDropdown */ "./src/components/Menu/V2/MenuDropdown.tsx");
/* harmony import */ var _MenuPopover__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./MenuPopover */ "./src/components/Menu/V2/MenuPopover.tsx");
/* harmony import */ var _helpers_helpers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./helpers/helpers */ "./src/components/Menu/V2/helpers/helpers.ts");









/**
 * Kebab Menu. Use `<MenuItem>` to render the menu items.
 */
const Menu = ({ icon = 'kebab', placement = 'bottom-start', title, is: MenuButton = _Button__WEBPACK_IMPORTED_MODULE_5__.IconButton, className, pressed, maxWidth = 'x250', button, detached, ...props }) => {
    const state = (0,react_stately__WEBPACK_IMPORTED_MODULE_4__.useMenuTriggerState)(props);
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    const { menuTriggerProps, menuProps } = (0,react_aria__WEBPACK_IMPORTED_MODULE_2__.useMenuTrigger)({}, state, ref);
    const { buttonProps } = (0,react_aria__WEBPACK_IMPORTED_MODULE_2__.useButton)({
        ...menuTriggerProps,
        'aria-label': props['aria-label'] || title,
        ...{ preventFocusOnPress: true },
    }, ref);
    const { large, medium, tiny, mini } = props;
    const sizes = { large, medium, tiny, mini };
    const defaultSmall = !large && !medium && !tiny && !mini;
    const popover = state.isOpen && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MenuPopover__WEBPACK_IMPORTED_MODULE_7__["default"], { state: state, triggerRef: ref, placement: (0,_helpers_helpers__WEBPACK_IMPORTED_MODULE_8__.getPlacement)(placement), maxWidth: maxWidth, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MenuDropdown__WEBPACK_IMPORTED_MODULE_6__["default"], { ...props, ...menuProps }) }));
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [button ? ((0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(button, {
                ...buttonProps,
                ref,
                icon,
                className,
                title,
                pressed: pressed || state.isOpen,
            })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MenuButton, { ...buttonProps, ref: ref, icon: icon, className: className, title: title, pressed: pressed || state.isOpen, small: defaultSmall, ...sizes })), detached ? (0,react_dom__WEBPACK_IMPORTED_MODULE_3__.createPortal)(popover, document.body) : popover] }));
};
Menu.displayName = 'MenuV2';
/* harmony default export */ __webpack_exports__["default"] = (Menu);


/***/ }),

/***/ "./src/components/Menu/V2/MenuDropdown.tsx":
/*!*************************************************!*\
  !*** ./src/components/Menu/V2/MenuDropdown.tsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-aria */ "react-aria");
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_aria__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_stately__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-stately */ "react-stately");
/* harmony import */ var react_stately__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_stately__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _MenuItem__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./MenuItem */ "./src/components/Menu/V2/MenuItem.tsx");
/* harmony import */ var _MenuSection__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./MenuSection */ "./src/components/Menu/V2/MenuSection.tsx");






function MenuDropDown(props) {
    const state = (0,react_stately__WEBPACK_IMPORTED_MODULE_3__.useTreeState)(props);
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    const { menuProps } = (0,react_aria__WEBPACK_IMPORTED_MODULE_2__.useMenu)(props, state, ref);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ...menuProps, ref: ref, children: [...state.collection].map((item) => item.type === 'section' ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MenuSection__WEBPACK_IMPORTED_MODULE_5__["default"], { section: item, state: state }, item.key)) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MenuItem__WEBPACK_IMPORTED_MODULE_4__["default"], { item: item, state: state }, item.key))) }));
}
/* harmony default export */ __webpack_exports__["default"] = (MenuDropDown);


/***/ }),

/***/ "./src/components/Menu/V2/MenuItem.tsx":
/*!*********************************************!*\
  !*** ./src/components/Menu/V2/MenuItem.tsx ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-aria */ "react-aria");
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_aria__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! . */ "./src/components/Menu/V2/index.ts");
/* harmony import */ var _MenuOption__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./MenuOption */ "./src/components/Menu/V2/MenuOption.tsx");





function MenuItem({ item, state }) {
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    const { menuItemProps: { onPointerUp, ...menuItemProps }, isFocused, isDisabled, } = (0,react_aria__WEBPACK_IMPORTED_MODULE_2__.useMenuItem)({ key: item.key }, state, ref);
    // There's an issue caused by conflicting event handlers. The popover opens on onPointerDown and the selection event for both, the menu (listbox), happens on onPointerUp.
    // As a workaround, we are overwriting `onPointerDown` event with `onPointerUp`
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_MenuOption__WEBPACK_IMPORTED_MODULE_4__["default"], { ...(0,react_aria__WEBPACK_IMPORTED_MODULE_2__.mergeProps)(menuItemProps, { onPointerDown: onPointerUp }), ref: ref, focus: isFocused, disabled: isDisabled, is: 'label', variant: item.value?.variant, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-option__wrapper', children: item.rendered }), item.value && item.value.description && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_3__.MenuItemDescription, { children: item.value.description }))] }));
}
/* harmony default export */ __webpack_exports__["default"] = (MenuItem);


/***/ }),

/***/ "./src/components/Menu/V2/MenuOption.tsx":
/*!***********************************************!*\
  !*** ./src/components/Menu/V2/MenuOption.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_prevent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../helpers/prevent */ "./src/helpers/prevent.ts");



const MenuOption = (0,react__WEBPACK_IMPORTED_MODULE_0__.memo)((0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({ is: Tag = 'li', id, children, focus, selected, className, title, disabled, variant, onClick, ...props }, ref) => ((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(Tag, { ...props, key: id, id: id, ref: ref, "aria-selected": !!selected, "aria-disabled": !!disabled, title: title, onClick: (e) => {
        if (disabled) {
            (0,_helpers_prevent__WEBPACK_IMPORTED_MODULE_1__.prevent)(e);
            return;
        }
        onClick?.(e);
    }, className: [
        'rcx-option',
        className,
        focus && 'rcx-option--focus',
        selected && 'rcx-option--selected',
        disabled && 'rcx-option--disabled',
        variant && `rcx-option--${variant}`,
    ]
        .filter(Boolean)
        .join(' ') }, children))));
/* harmony default export */ __webpack_exports__["default"] = (MenuOption);


/***/ }),

/***/ "./src/components/Menu/V2/MenuPopover.tsx":
/*!************************************************!*\
  !*** ./src/components/Menu/V2/MenuPopover.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Dropdown_DropdownDesktop__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Dropdown/DropdownDesktop */ "./src/components/Dropdown/DropdownDesktop.tsx");
/* harmony import */ var _Dropdown_DropdownMobile__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Dropdown/DropdownMobile */ "./src/components/Dropdown/DropdownMobile.tsx");
/* harmony import */ var _Popover__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Popover */ "./src/components/Popover/index.ts");





function MenuPopover({ children, state, offset = 4, maxWidth, ...props }) {
    const isMobile = !(0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useBreakpoints)().includes('sm');
    if (isMobile) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Popover__WEBPACK_IMPORTED_MODULE_4__.Popover, { state: state, offset: offset, ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Dropdown_DropdownMobile__WEBPACK_IMPORTED_MODULE_3__.DropdownMobile, { children: children }) }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Popover__WEBPACK_IMPORTED_MODULE_4__.Popover, { state: state, offset: offset, ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Dropdown_DropdownDesktop__WEBPACK_IMPORTED_MODULE_2__.DropdownDesktop, { maxWidth: maxWidth, children: children }) }));
}
/* harmony default export */ __webpack_exports__["default"] = (MenuPopover);


/***/ }),

/***/ "./src/components/Menu/V2/MenuSection.tsx":
/*!************************************************!*\
  !*** ./src/components/Menu/V2/MenuSection.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-aria */ "react-aria");
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_aria__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box_Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Box/Box */ "./src/components/Box/Box.tsx");
/* harmony import */ var _Divider__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Divider */ "./src/components/Divider/index.tsx");
/* harmony import */ var _Option__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Option */ "./src/components/Option/index.ts");
/* harmony import */ var _MenuItem__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./MenuItem */ "./src/components/Menu/V2/MenuItem.tsx");






function MenuSection({ section, state, }) {
    const { itemProps, headingProps, groupProps } = (0,react_aria__WEBPACK_IMPORTED_MODULE_1__.useMenuSection)({
        'heading': section.rendered,
        'aria-label': section['aria-label'],
    });
    const { separatorProps } = (0,react_aria__WEBPACK_IMPORTED_MODULE_1__.useSeparator)({
        elementType: 'span',
    });
    // If the section is not the first, add a separator element.
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [section.key !== state.collection.getFirstKey() && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Divider__WEBPACK_IMPORTED_MODULE_3__.Divider, { ...separatorProps })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { ...itemProps, children: [section.rendered && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Option__WEBPACK_IMPORTED_MODULE_4__.OptionTitle, { ...headingProps, children: section.rendered })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { ...groupProps, p: '0', children: [...section.childNodes].map((node) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MenuItem__WEBPACK_IMPORTED_MODULE_5__["default"], { item: node, state: state }, node.key))) })] })] }));
}
/* harmony default export */ __webpack_exports__["default"] = (MenuSection);


/***/ }),

/***/ "./src/components/Menu/V2/helpers/helpers.ts":
/*!***************************************************!*\
  !*** ./src/components/Menu/V2/helpers/helpers.ts ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getPlacement: function() { return /* binding */ getPlacement; }
/* harmony export */ });
const getPlacement = (placement) => {
    // switch case for placement from usePosition placement to react-aria
    switch (placement) {
        case 'bottom':
            return 'bottom';
        case 'bottom-start':
            return 'bottom start';
        case 'bottom-end':
            return 'bottom end';
        case 'top':
            return 'top';
        case 'top-start':
            return 'top start';
        case 'top-end':
            return 'top end';
        case 'left':
            return 'left';
        case 'left-start':
            return 'left top';
        case 'left-end':
            return 'left bottom';
        case 'right':
            return 'right';
        case 'right-start':
            return 'right top';
        case 'right-end':
            return 'right bottom';
        default:
            return 'bottom start';
    }
};


/***/ }),

/***/ "./src/components/Menu/V2/index.ts":
/*!*****************************************!*\
  !*** ./src/components/Menu/V2/index.ts ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MenuItem: function() { return /* reexport safe */ _stately_MenuItem__WEBPACK_IMPORTED_MODULE_2__["default"]; },
/* harmony export */   MenuItemAvatar: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_0__.OptionAvatar; },
/* harmony export */   MenuItemColumn: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_0__.OptionColumn; },
/* harmony export */   MenuItemContent: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_0__.OptionContent; },
/* harmony export */   MenuItemDescription: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_0__.OptionDescriptionBlock; },
/* harmony export */   MenuItemIcon: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_0__.OptionIcon; },
/* harmony export */   MenuItemInput: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_0__.OptionInput; },
/* harmony export */   MenuItemSkeleton: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_0__.OptionSkeleton; },
/* harmony export */   MenuItemTitle: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_0__.OptionTitle; },
/* harmony export */   MenuSection: function() { return /* reexport safe */ _stately_MenuSection__WEBPACK_IMPORTED_MODULE_3__["default"]; },
/* harmony export */   MenuV2: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_1__["default"]; }
/* harmony export */ });
/* harmony import */ var _Option__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Option */ "./src/components/Option/index.ts");
/* harmony import */ var _Menu__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Menu */ "./src/components/Menu/V2/Menu.tsx");
/* harmony import */ var _stately_MenuItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./stately/MenuItem */ "./src/components/Menu/V2/stately/MenuItem.tsx");
/* harmony import */ var _stately_MenuSection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./stately/MenuSection */ "./src/components/Menu/V2/stately/MenuSection.tsx");







/***/ }),

/***/ "./src/components/Menu/V2/stately/MenuItem.tsx":
/*!*****************************************************!*\
  !*** ./src/components/Menu/V2/stately/MenuItem.tsx ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function MenuItem(_props) {
    return null;
}
MenuItem.getCollectionNode = function* getCollectionNode(props, context) {
    const { childItems, title, children } = props;
    const rendered = props.title || props.children;
    const textValue = props.textValue ||
        (typeof rendered === 'string' ? rendered : '') ||
        props['aria-label'] ||
        '';
    if (!textValue && !context?.suppressTextValueWarning) {
        console.warn('<Item> with non-plain text contents is unsupported by type to select for accessibility. Please add a `textValue` prop.');
    }
    yield {
        'type': 'item',
        props,
        rendered,
        textValue,
        'aria-label': props['aria-label'],
        'hasChildNodes': hasChildItems(props),
        *'childNodes'() {
            if (childItems) {
                for (const child of childItems) {
                    yield {
                        type: 'item',
                        value: child,
                    };
                }
            }
            else if (title) {
                const items = [];
                react__WEBPACK_IMPORTED_MODULE_0__.Children.forEach(children, (child) => {
                    items.push({
                        type: 'item',
                        element: child,
                    });
                });
                yield* items;
            }
        },
    };
};
function hasChildItems(props) {
    if (props.hasChildItems != null) {
        return props.hasChildItems;
    }
    if (props.childItems) {
        return true;
    }
    if (props.title && react__WEBPACK_IMPORTED_MODULE_0__.Children.count(props.children) > 0) {
        return true;
    }
    return false;
}
/* harmony default export */ __webpack_exports__["default"] = (MenuItem);


/***/ }),

/***/ "./src/components/Menu/V2/stately/MenuSection.tsx":
/*!********************************************************!*\
  !*** ./src/components/Menu/V2/stately/MenuSection.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function MenuSection(_props) {
    return null;
}
MenuSection.getCollectionNode = function* getCollectionNode(props) {
    const { children, title, items } = props;
    yield {
        'type': 'section',
        props,
        'hasChildNodes': true,
        'rendered': title,
        'aria-label': props['aria-label'],
        *'childNodes'() {
            if (typeof children === 'function') {
                if (!items) {
                    throw new Error('props.children was a function but props.items is missing');
                }
                for (const item of items) {
                    yield {
                        type: 'item',
                        value: item,
                        element: children(item),
                    };
                }
            }
            else {
                const items = [];
                react__WEBPACK_IMPORTED_MODULE_0__.Children.forEach(children, (child) => {
                    items.push({
                        type: 'item',
                        element: child ?? undefined,
                    });
                });
                yield* items;
            }
        },
    };
};
/* harmony default export */ __webpack_exports__["default"] = (MenuSection);


/***/ }),

/***/ "./src/components/Menu/index.ts":
/*!**************************************!*\
  !*** ./src/components/Menu/index.ts ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Menu: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_0__.Menu; },
/* harmony export */   MenuItem: function() { return /* reexport safe */ _V2__WEBPACK_IMPORTED_MODULE_1__.MenuItem; },
/* harmony export */   MenuItemAvatar: function() { return /* reexport safe */ _V2__WEBPACK_IMPORTED_MODULE_1__.MenuItemAvatar; },
/* harmony export */   MenuItemColumn: function() { return /* reexport safe */ _V2__WEBPACK_IMPORTED_MODULE_1__.MenuItemColumn; },
/* harmony export */   MenuItemContent: function() { return /* reexport safe */ _V2__WEBPACK_IMPORTED_MODULE_1__.MenuItemContent; },
/* harmony export */   MenuItemDescription: function() { return /* reexport safe */ _V2__WEBPACK_IMPORTED_MODULE_1__.MenuItemDescription; },
/* harmony export */   MenuItemIcon: function() { return /* reexport safe */ _V2__WEBPACK_IMPORTED_MODULE_1__.MenuItemIcon; },
/* harmony export */   MenuItemInput: function() { return /* reexport safe */ _V2__WEBPACK_IMPORTED_MODULE_1__.MenuItemInput; },
/* harmony export */   MenuItemSkeleton: function() { return /* reexport safe */ _V2__WEBPACK_IMPORTED_MODULE_1__.MenuItemSkeleton; },
/* harmony export */   MenuItemTitle: function() { return /* reexport safe */ _V2__WEBPACK_IMPORTED_MODULE_1__.MenuItemTitle; },
/* harmony export */   MenuSection: function() { return /* reexport safe */ _V2__WEBPACK_IMPORTED_MODULE_1__.MenuSection; },
/* harmony export */   MenuV2: function() { return /* reexport safe */ _V2__WEBPACK_IMPORTED_MODULE_1__.MenuV2; }
/* harmony export */ });
/* harmony import */ var _Menu__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Menu */ "./src/components/Menu/Menu.tsx");
/* harmony import */ var _V2__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./V2 */ "./src/components/Menu/V2/index.ts");




/***/ }),

/***/ "./src/components/Message/Message.tsx":
/*!********************************************!*\
  !*** ./src/components/Message/Message.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Message: function() { return /* binding */ Message; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _helpers_prependClassName__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/prependClassName */ "./src/helpers/prependClassName.ts");



const Message = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Message({ className, clickable, sequential, isSelected, isEditing, isPending, highlight, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ref: ref, className: (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_2__.prependClassName)(className, [
            'rcx-message',
            (clickable || props.onClick) && 'rcx-message--clickable',
            sequential && 'rcx-message--sequential',
            isSelected && 'rcx-message--selected',
            isEditing && 'rcx-message--editing',
            isPending && 'rcx-message--pending',
            highlight && 'rcx-message--highlight',
        ]
            .filter(Boolean)
            .join(' ')), ...props }));
});


/***/ }),

/***/ "./src/components/Message/MessageBlock.tsx":
/*!*************************************************!*\
  !*** ./src/components/Message/MessageBlock.tsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageBlock: function() { return /* binding */ MessageBlock; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const MessageBlock = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(({ className: _className, fixedWidth, ...props }, ref) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { "rcx-message-block": true, "rcx-message-block--width-fixed": fixedWidth, ref: ref, ...props })));


/***/ }),

/***/ "./src/components/Message/MessageBody.tsx":
/*!************************************************!*\
  !*** ./src/components/Message/MessageBody.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageBody: function() { return /* binding */ MessageBody; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/prependClassName */ "./src/helpers/prependClassName.ts");


const MessageBody = ({ clamp, className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__.prependClassName)(className, [
        'rcx-message-body',
        clamp && `rcx-message-body--clamp rcx-message-body--clamp-${clamp}`,
    ]
        .filter(Boolean)
        .join(' ')), ...props }));


/***/ }),

/***/ "./src/components/Message/MessageContainer.tsx":
/*!*****************************************************!*\
  !*** ./src/components/Message/MessageContainer.tsx ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageContainer: function() { return /* binding */ MessageContainer; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageContainer = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-message-container', ...props }));


/***/ }),

/***/ "./src/components/Message/MessageContainerFixed.tsx":
/*!**********************************************************!*\
  !*** ./src/components/Message/MessageContainerFixed.tsx ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageContainerFixed: function() { return /* binding */ MessageContainerFixed; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageContainerFixed = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-message-container rcx-message-container--fixed', ...props }));


/***/ }),

/***/ "./src/components/Message/MessageDivider/MessageDivider.tsx":
/*!******************************************************************!*\
  !*** ./src/components/Message/MessageDivider/MessageDivider.tsx ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageDivider: function() { return /* binding */ MessageDivider; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageDivider = ({ children, unreadLabel, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { role: 'separator', className: !unreadLabel
        ? 'rcx-message-divider'
        : 'rcx-message-divider rcx-message-divider--unread', ...props, children: [children && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-divider__bar' }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-divider__wrapper', children: children }), ' '] })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-divider__bar', children: unreadLabel && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-divider__wrapper--unread', children: unreadLabel })) })] }));


/***/ }),

/***/ "./src/components/Message/MessageDivider/index.tsx":
/*!*********************************************************!*\
  !*** ./src/components/Message/MessageDivider/index.tsx ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageDivider: function() { return /* reexport safe */ _MessageDivider__WEBPACK_IMPORTED_MODULE_0__.MessageDivider; }
/* harmony export */ });
/* harmony import */ var _MessageDivider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MessageDivider */ "./src/components/Message/MessageDivider/MessageDivider.tsx");



/***/ }),

/***/ "./src/components/Message/MessageEmoji.tsx":
/*!*************************************************!*\
  !*** ./src/components/Message/MessageEmoji.tsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageEmoji: function() { return /* binding */ MessageEmoji; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _MessageEmojiBase__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MessageEmojiBase */ "./src/components/Message/MessageEmojiBase.tsx");


const MessageEmoji = ({ name, className, image, big, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MessageEmojiBase__WEBPACK_IMPORTED_MODULE_1__.MessageEmojiBase, { className: [
        'rcx-message__emoji',
        className,
        big && 'rcx-message__emoji--big',
    ]
        .filter(Boolean)
        .join(' '), name: name, image: image, ...props }));


/***/ }),

/***/ "./src/components/Message/MessageEmojiBase.tsx":
/*!*****************************************************!*\
  !*** ./src/components/Message/MessageEmojiBase.tsx ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageEmojiBase: function() { return /* binding */ MessageEmojiBase; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageEmojiBase = ({ name, image, className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: `${className || ''} ${name}`, style: image && image.length ? { backgroundImage: image } : undefined, ...props }));


/***/ }),

/***/ "./src/components/Message/MessageGenericPreview/MessageGenericPreview.styles.scss":
/*!****************************************************************************************!*\
  !*** ./src/components/Message/MessageGenericPreview/MessageGenericPreview.styles.scss ***!
  \****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/components/Message/MessageGenericPreview/MessageGenericPreview.tsx":
/*!********************************************************************************!*\
  !*** ./src/components/Message/MessageGenericPreview/MessageGenericPreview.tsx ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageGenericPreview: function() { return /* binding */ MessageGenericPreview; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _MessageGenericPreview_styles_scss__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MessageGenericPreview.styles.scss */ "./src/components/Message/MessageGenericPreview/MessageGenericPreview.styles.scss");


const MessageGenericPreview = (props) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-generic-preview', ...props });


/***/ }),

/***/ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewContent.tsx":
/*!***************************************************************************************!*\
  !*** ./src/components/Message/MessageGenericPreview/MessageGenericPreviewContent.tsx ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageGenericPreviewContent: function() { return /* binding */ MessageGenericPreviewContent; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageGenericPreviewContent = ({ thumb, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'rcx-message-generic-preview__content', children: [thumb, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-generic-preview__content-wrapper', ...props })] }));


/***/ }),

/***/ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewCoverImage.tsx":
/*!******************************************************************************************!*\
  !*** ./src/components/Message/MessageGenericPreview/MessageGenericPreviewCoverImage.tsx ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageGenericPreviewCoverImage: function() { return /* binding */ MessageGenericPreviewCoverImage; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../helpers/prependClassName */ "./src/helpers/prependClassName.ts");


const MessageGenericPreviewCoverImage = ({ url, width, height, className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__.prependClassName)(className, 'rcx-message-generic-preview__preview'), style: { backgroundImage: `url(${url})`, maxWidth: '100%' }, "data-testid": 'preview-image', ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { style: { paddingTop: `${(height / width) * 100}%` } }) }));


/***/ }),

/***/ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewDescription.tsx":
/*!*******************************************************************************************!*\
  !*** ./src/components/Message/MessageGenericPreview/MessageGenericPreviewDescription.tsx ***!
  \*******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageGenericPreviewDescription: function() { return /* binding */ MessageGenericPreviewDescription; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageGenericPreviewDescription = ({ children, clamp = false, }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: [
        'rcx-message-generic-preview__description',
        clamp && 'rcx-message-generic-preview__description--clamp',
    ]
        .filter(Boolean)
        .join(' '), children: children }));


/***/ }),

/***/ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewFooter.tsx":
/*!**************************************************************************************!*\
  !*** ./src/components/Message/MessageGenericPreview/MessageGenericPreviewFooter.tsx ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageGenericPreviewFooter: function() { return /* binding */ MessageGenericPreviewFooter; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageGenericPreviewFooter = ({ children, }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-generic-preview__footer', children: children }));


/***/ }),

/***/ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewIcon.tsx":
/*!************************************************************************************!*\
  !*** ./src/components/Message/MessageGenericPreview/MessageGenericPreviewIcon.tsx ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageGenericPreviewIcon: function() { return /* binding */ MessageGenericPreviewIcon; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Icon */ "./src/components/Icon/index.ts");


const MessageGenericPreviewIcon = ({ name = 'attachment-file', size = 32, color = 'default', type = 'file', }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'rcx-message-generic-preview__icon', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__.Icon, { name: name, color: color, size: size }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-generic-preview__icon-title', children: type })] }));


/***/ }),

/***/ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewImage.tsx":
/*!*************************************************************************************!*\
  !*** ./src/components/Message/MessageGenericPreview/MessageGenericPreviewImage.tsx ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageGenericPreviewImage: function() { return /* binding */ MessageGenericPreviewImage; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../helpers/prependClassName */ "./src/helpers/prependClassName.ts");


const MessageGenericPreviewImage = ({ url, className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", { src: url, className: (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__.prependClassName)(className, 'rcx-message-generic-preview__image'), alt: '', ...props }));


/***/ }),

/***/ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewThumb.tsx":
/*!*************************************************************************************!*\
  !*** ./src/components/Message/MessageGenericPreview/MessageGenericPreviewThumb.tsx ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageGenericPreviewThumb: function() { return /* binding */ MessageGenericPreviewThumb; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageGenericPreviewThumb = (props) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-generic-preview__thumb', ...props });


/***/ }),

/***/ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewTitle.tsx":
/*!*************************************************************************************!*\
  !*** ./src/components/Message/MessageGenericPreview/MessageGenericPreviewTitle.tsx ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageGenericPreviewTitle: function() { return /* binding */ MessageGenericPreviewTitle; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageGenericPreviewTitle = ({ externalUrl, children, ...props }) => {
    if (externalUrl) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { className: 'rcx-message-generic-preview__title rcx-message-generic-preview__title-link', href: externalUrl, target: '_blank', ...props, children: children }));
    }
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'rcx-message-generic-preview__title', ...props });
};


/***/ }),

/***/ "./src/components/Message/MessageGenericPreview/index.tsx":
/*!****************************************************************!*\
  !*** ./src/components/Message/MessageGenericPreview/index.tsx ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageGenericPreview: function() { return /* reexport safe */ _MessageGenericPreview__WEBPACK_IMPORTED_MODULE_0__.MessageGenericPreview; },
/* harmony export */   MessageGenericPreviewContent: function() { return /* reexport safe */ _MessageGenericPreviewContent__WEBPACK_IMPORTED_MODULE_1__.MessageGenericPreviewContent; },
/* harmony export */   MessageGenericPreviewCoverImage: function() { return /* reexport safe */ _MessageGenericPreviewCoverImage__WEBPACK_IMPORTED_MODULE_4__.MessageGenericPreviewCoverImage; },
/* harmony export */   MessageGenericPreviewDescription: function() { return /* reexport safe */ _MessageGenericPreviewDescription__WEBPACK_IMPORTED_MODULE_2__.MessageGenericPreviewDescription; },
/* harmony export */   MessageGenericPreviewFooter: function() { return /* reexport safe */ _MessageGenericPreviewFooter__WEBPACK_IMPORTED_MODULE_3__.MessageGenericPreviewFooter; },
/* harmony export */   MessageGenericPreviewIcon: function() { return /* reexport safe */ _MessageGenericPreviewIcon__WEBPACK_IMPORTED_MODULE_8__.MessageGenericPreviewIcon; },
/* harmony export */   MessageGenericPreviewImage: function() { return /* reexport safe */ _MessageGenericPreviewImage__WEBPACK_IMPORTED_MODULE_5__.MessageGenericPreviewImage; },
/* harmony export */   MessageGenericPreviewThumb: function() { return /* reexport safe */ _MessageGenericPreviewThumb__WEBPACK_IMPORTED_MODULE_6__.MessageGenericPreviewThumb; },
/* harmony export */   MessageGenericPreviewTitle: function() { return /* reexport safe */ _MessageGenericPreviewTitle__WEBPACK_IMPORTED_MODULE_7__.MessageGenericPreviewTitle; }
/* harmony export */ });
/* harmony import */ var _MessageGenericPreview__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MessageGenericPreview */ "./src/components/Message/MessageGenericPreview/MessageGenericPreview.tsx");
/* harmony import */ var _MessageGenericPreviewContent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MessageGenericPreviewContent */ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewContent.tsx");
/* harmony import */ var _MessageGenericPreviewDescription__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MessageGenericPreviewDescription */ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewDescription.tsx");
/* harmony import */ var _MessageGenericPreviewFooter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MessageGenericPreviewFooter */ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewFooter.tsx");
/* harmony import */ var _MessageGenericPreviewCoverImage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./MessageGenericPreviewCoverImage */ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewCoverImage.tsx");
/* harmony import */ var _MessageGenericPreviewImage__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./MessageGenericPreviewImage */ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewImage.tsx");
/* harmony import */ var _MessageGenericPreviewThumb__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./MessageGenericPreviewThumb */ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewThumb.tsx");
/* harmony import */ var _MessageGenericPreviewTitle__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./MessageGenericPreviewTitle */ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewTitle.tsx");
/* harmony import */ var _MessageGenericPreviewIcon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./MessageGenericPreviewIcon */ "./src/components/Message/MessageGenericPreview/MessageGenericPreviewIcon.tsx");











/***/ }),

/***/ "./src/components/Message/MessageHeader.tsx":
/*!**************************************************!*\
  !*** ./src/components/Message/MessageHeader.tsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageHeader: function() { return /* binding */ MessageHeader; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageHeader = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-message-header', ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-message-header__wrapper', children: children }) }));


/***/ }),

/***/ "./src/components/Message/MessageHighlight.tsx":
/*!*****************************************************!*\
  !*** ./src/components/Message/MessageHighlight.tsx ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageHighlight: function() { return /* binding */ MessageHighlight; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/prependClassName */ "./src/helpers/prependClassName.ts");


function MessageHighlight({ is: Tag = 'span', variant = 'other', className, clickable, ...props }) {
    const modifiers = [variant, clickable && 'clickable']
        .filter(Boolean)
        .map((modifier) => `rcx-message__highlight--${modifier}`)
        .join(' ');
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Tag, { className: (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__.prependClassName)(className, `rcx-box rcx-box--full rcx-message__highlight ${modifiers}`), ...props }));
}


/***/ }),

/***/ "./src/components/Message/MessageLeftContainer.tsx":
/*!*********************************************************!*\
  !*** ./src/components/Message/MessageLeftContainer.tsx ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageLeftContainer: function() { return /* binding */ MessageLeftContainer; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageLeftContainer = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-message-container rcx-message-container--left', ...props }));


/***/ }),

/***/ "./src/components/Message/MessageMetrics/MessageMetrics.tsx":
/*!******************************************************************!*\
  !*** ./src/components/Message/MessageMetrics/MessageMetrics.tsx ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageMetrics: function() { return /* binding */ MessageMetrics; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _MessageMetricsContentItem__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MessageMetricsContentItem */ "./src/components/Message/MessageMetrics/MessageMetricsContentItem.tsx");


const MessageMetrics = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MessageMetricsContentItem__WEBPACK_IMPORTED_MODULE_1__.MessageMetricsContentItem, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-metrics__content-wrapper', ...props }) }));


/***/ }),

/***/ "./src/components/Message/MessageMetrics/MessageMetricsContentItem.tsx":
/*!*****************************************************************************!*\
  !*** ./src/components/Message/MessageMetrics/MessageMetricsContentItem.tsx ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageMetricsContentItem: function() { return /* binding */ MessageMetricsContentItem; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageMetricsContentItem = (props) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-metrics__content-item', ...props });


/***/ }),

/***/ "./src/components/Message/MessageMetrics/MessageMetricsFollowing.tsx":
/*!***************************************************************************!*\
  !*** ./src/components/Message/MessageMetrics/MessageMetricsFollowing.tsx ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageMetricsFollowing: function() { return /* binding */ MessageMetricsFollowing; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Button */ "./src/components/Button/index.ts");


const MessageMetricsFollowing = ({ name, badge, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__.IconButton, { position: 'relative', overflow: 'visible', ...props, small: true, icon: name, children: badge && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-metrics__item__follow-badge', children: badge })) }));


/***/ }),

/***/ "./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItem.tsx":
/*!*****************************************************************************************!*\
  !*** ./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItem.tsx ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageMetricsItem: function() { return /* binding */ MessageMetricsItem; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../helpers/prependClassName */ "./src/helpers/prependClassName.ts");


const MessageMetricsItem = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__.prependClassName)(className, 'rcx-message-metrics__item'), ...props }));


/***/ }),

/***/ "./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItemAvatarRow.tsx":
/*!**************************************************************************************************!*\
  !*** ./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItemAvatarRow.tsx ***!
  \**************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageMetricsItemAvatarRow: function() { return /* binding */ MessageMetricsItemAvatarRow; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../helpers/prependClassName */ "./src/helpers/prependClassName.ts");


const MessageMetricsItemAvatarRow = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__.prependClassName)(className, 'rcx-message-metrics__avatar-row'), ...props }));


/***/ }),

/***/ "./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItemAvatarRowContent.tsx":
/*!*********************************************************************************************************!*\
  !*** ./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItemAvatarRowContent.tsx ***!
  \*********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageMetricsItemAvatarRowContent: function() { return /* binding */ MessageMetricsItemAvatarRowContent; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../helpers/prependClassName */ "./src/helpers/prependClassName.ts");


const MessageMetricsItemAvatarRowContent = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__.prependClassName)(className, 'rcx-message-metrics__avatar-row__content'), ...props }));


/***/ }),

/***/ "./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItemIcon.tsx":
/*!*********************************************************************************************!*\
  !*** ./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItemIcon.tsx ***!
  \*********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageMetricsItemIcon: function() { return /* binding */ MessageMetricsItemIcon; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../.. */ "./src/index.ts");


const MessageMetricsItemIcon = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_1__.Icon, { size: 'x20', ...props }));


/***/ }),

/***/ "./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItemLabel.tsx":
/*!**********************************************************************************************!*\
  !*** ./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItemLabel.tsx ***!
  \**********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageMetricsItemLabel: function() { return /* binding */ MessageMetricsItemLabel; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageMetricsItemLabel = (props) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-metrics__item-label', ...props });


/***/ }),

/***/ "./src/components/Message/MessageMetrics/MessageMetricsItem/index.ts":
/*!***************************************************************************!*\
  !*** ./src/components/Message/MessageMetrics/MessageMetricsItem/index.ts ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageMetricsItem: function() { return /* reexport safe */ _MessageMetricsItem__WEBPACK_IMPORTED_MODULE_0__.MessageMetricsItem; },
/* harmony export */   MessageMetricsItemAvatarRow: function() { return /* reexport safe */ _MessageMetricsItemAvatarRow__WEBPACK_IMPORTED_MODULE_1__.MessageMetricsItemAvatarRow; },
/* harmony export */   MessageMetricsItemAvatarRowContent: function() { return /* reexport safe */ _MessageMetricsItemAvatarRowContent__WEBPACK_IMPORTED_MODULE_2__.MessageMetricsItemAvatarRowContent; },
/* harmony export */   MessageMetricsItemIcon: function() { return /* reexport safe */ _MessageMetricsItemIcon__WEBPACK_IMPORTED_MODULE_3__.MessageMetricsItemIcon; },
/* harmony export */   MessageMetricsItemLabel: function() { return /* reexport safe */ _MessageMetricsItemLabel__WEBPACK_IMPORTED_MODULE_4__.MessageMetricsItemLabel; }
/* harmony export */ });
/* harmony import */ var _MessageMetricsItem__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MessageMetricsItem */ "./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItem.tsx");
/* harmony import */ var _MessageMetricsItemAvatarRow__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MessageMetricsItemAvatarRow */ "./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItemAvatarRow.tsx");
/* harmony import */ var _MessageMetricsItemAvatarRowContent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MessageMetricsItemAvatarRowContent */ "./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItemAvatarRowContent.tsx");
/* harmony import */ var _MessageMetricsItemIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MessageMetricsItemIcon */ "./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItemIcon.tsx");
/* harmony import */ var _MessageMetricsItemLabel__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./MessageMetricsItemLabel */ "./src/components/Message/MessageMetrics/MessageMetricsItem/MessageMetricsItemLabel.tsx");





/* harmony default export */ __webpack_exports__["default"] = (Object.assign(_MessageMetricsItem__WEBPACK_IMPORTED_MODULE_0__.MessageMetricsItem, {
    /**
     * @deprecated prefer using named imports
     * */
    Icon: _MessageMetricsItemIcon__WEBPACK_IMPORTED_MODULE_3__.MessageMetricsItemIcon,
    /**
     * @deprecated prefer using named imports
     * */
    Label: _MessageMetricsItemLabel__WEBPACK_IMPORTED_MODULE_4__.MessageMetricsItemLabel,
}));



/***/ }),

/***/ "./src/components/Message/MessageMetrics/MessageMetricsReply.tsx":
/*!***********************************************************************!*\
  !*** ./src/components/Message/MessageMetrics/MessageMetricsReply.tsx ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageMetricsReply: function() { return /* binding */ MessageMetricsReply; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../.. */ "./src/components/index.ts");
/* harmony import */ var _MessageMetricsItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MessageMetricsItem */ "./src/components/Message/MessageMetrics/MessageMetricsItem/index.ts");



const MessageMetricsReply = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MessageMetricsItem__WEBPACK_IMPORTED_MODULE_2__["default"], { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_1__.Button, { primary: true, ...props, small: true }) }));


/***/ }),

/***/ "./src/components/Message/MessageMetrics/index.tsx":
/*!*********************************************************!*\
  !*** ./src/components/Message/MessageMetrics/index.tsx ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageMetrics: function() { return /* reexport safe */ _MessageMetrics__WEBPACK_IMPORTED_MODULE_0__.MessageMetrics; },
/* harmony export */   MessageMetricsFollowing: function() { return /* reexport safe */ _MessageMetricsFollowing__WEBPACK_IMPORTED_MODULE_1__.MessageMetricsFollowing; },
/* harmony export */   MessageMetricsItem: function() { return /* reexport safe */ _MessageMetricsItem__WEBPACK_IMPORTED_MODULE_2__["default"]; },
/* harmony export */   MessageMetricsItemAvatarRow: function() { return /* reexport safe */ _MessageMetricsItem__WEBPACK_IMPORTED_MODULE_2__.MessageMetricsItemAvatarRow; },
/* harmony export */   MessageMetricsItemAvatarRowContent: function() { return /* reexport safe */ _MessageMetricsItem__WEBPACK_IMPORTED_MODULE_2__.MessageMetricsItemAvatarRowContent; },
/* harmony export */   MessageMetricsItemIcon: function() { return /* reexport safe */ _MessageMetricsItem__WEBPACK_IMPORTED_MODULE_2__.MessageMetricsItemIcon; },
/* harmony export */   MessageMetricsItemLabel: function() { return /* reexport safe */ _MessageMetricsItem__WEBPACK_IMPORTED_MODULE_2__.MessageMetricsItemLabel; },
/* harmony export */   MessageMetricsReply: function() { return /* reexport safe */ _MessageMetricsReply__WEBPACK_IMPORTED_MODULE_3__.MessageMetricsReply; }
/* harmony export */ });
/* harmony import */ var _MessageMetrics__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MessageMetrics */ "./src/components/Message/MessageMetrics/MessageMetrics.tsx");
/* harmony import */ var _MessageMetricsFollowing__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MessageMetricsFollowing */ "./src/components/Message/MessageMetrics/MessageMetricsFollowing.tsx");
/* harmony import */ var _MessageMetricsItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MessageMetricsItem */ "./src/components/Message/MessageMetrics/MessageMetricsItem/index.ts");
/* harmony import */ var _MessageMetricsReply__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MessageMetricsReply */ "./src/components/Message/MessageMetrics/MessageMetricsReply.tsx");




/* harmony default export */ __webpack_exports__["default"] = (Object.assign(_MessageMetrics__WEBPACK_IMPORTED_MODULE_0__.MessageMetrics, {
    /**
     * @deprecated prefer using named imports
     * */
    Reply: _MessageMetricsReply__WEBPACK_IMPORTED_MODULE_3__.MessageMetricsReply,
    /**
     * @deprecated prefer using named imports
     * */
    Item: _MessageMetricsItem__WEBPACK_IMPORTED_MODULE_2__["default"],
    /**
     * @deprecated prefer using named imports
     * */
    Following: _MessageMetricsFollowing__WEBPACK_IMPORTED_MODULE_1__.MessageMetricsFollowing,
}));



/***/ }),

/***/ "./src/components/Message/MessageName.tsx":
/*!************************************************!*\
  !*** ./src/components/Message/MessageName.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageName: function() { return /* binding */ MessageName; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageName = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'rcx-box rcx-box--full rcx-message-header__name', ...props }));


/***/ }),

/***/ "./src/components/Message/MessageNameContainer.tsx":
/*!*********************************************************!*\
  !*** ./src/components/Message/MessageNameContainer.tsx ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageNameContainer: function() { return /* binding */ MessageNameContainer; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const MessageNameContainer = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function MessageNameContainer(props, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { ref: ref, className: 'rcx-box rcx-box--full rcx-message-header__name-container', ...props }));
});


/***/ }),

/***/ "./src/components/Message/MessageReactions/MessageReaction.tsx":
/*!*********************************************************************!*\
  !*** ./src/components/Message/MessageReactions/MessageReaction.tsx ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageReaction: function() { return /* binding */ MessageReaction; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _MessageReactionCounter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MessageReactionCounter */ "./src/components/Message/MessageReactions/MessageReactionCounter.tsx");
/* harmony import */ var _MessageReactionEmoji__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MessageReactionEmoji */ "./src/components/Message/MessageReactions/MessageReactionEmoji.tsx");




const MessageReaction = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Reaction({ name, counter, mine, children, className, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: [
            `rcx-message-reactions__reaction`,
            mine && 'rcx-message-reactions__reaction--mine',
            className,
        ]
            .filter(Boolean)
            .join(' '), ref: ref, role: 'button', tabIndex: 0, ...props, children: children || ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [name && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MessageReactionEmoji__WEBPACK_IMPORTED_MODULE_3__.MessageReactionEmoji, { name: name }), counter && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MessageReactionCounter__WEBPACK_IMPORTED_MODULE_2__.MessageReactionCounter, { counter: counter })] })) }));
});


/***/ }),

/***/ "./src/components/Message/MessageReactions/MessageReactionAction.tsx":
/*!***************************************************************************!*\
  !*** ./src/components/Message/MessageReactions/MessageReactionAction.tsx ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageReactionAction: function() { return /* binding */ MessageReactionAction; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Icon */ "./src/components/Icon/index.ts");


const MessageReactionAction = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { role: 'button', tabIndex: 0, className: [
        'rcx-message-reactions__reaction rcx-message-reactions__reaction--action',
        className,
    ]
        .filter(Boolean)
        .join(' '), ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__.Icon, { name: 'emoji-plus', size: 'x16' }) }));


/***/ }),

/***/ "./src/components/Message/MessageReactions/MessageReactionCounter.tsx":
/*!****************************************************************************!*\
  !*** ./src/components/Message/MessageReactions/MessageReactionCounter.tsx ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageReactionCounter: function() { return /* binding */ MessageReactionCounter; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageReactionCounter = ({ counter, className, }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: `rcx-message-reactions__counter ${className}`, children: counter }));


/***/ }),

/***/ "./src/components/Message/MessageReactions/MessageReactionEmoji.tsx":
/*!**************************************************************************!*\
  !*** ./src/components/Message/MessageReactions/MessageReactionEmoji.tsx ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageReactionEmoji: function() { return /* binding */ MessageReactionEmoji; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _MessageEmojiBase__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../MessageEmojiBase */ "./src/components/Message/MessageEmojiBase.tsx");


const MessageReactionEmoji = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MessageEmojiBase__WEBPACK_IMPORTED_MODULE_1__.MessageEmojiBase, { className: `rcx-message-reactions__emoji ${className || ''}`, ...props }));


/***/ }),

/***/ "./src/components/Message/MessageReactions/MessageReactions.tsx":
/*!**********************************************************************!*\
  !*** ./src/components/Message/MessageReactions/MessageReactions.tsx ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageReactions: function() { return /* binding */ MessageReactions; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _MessageBlock__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../MessageBlock */ "./src/components/Message/MessageBlock.tsx");



const MessageReactions = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function MessageReactions(props, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MessageBlock__WEBPACK_IMPORTED_MODULE_2__.MessageBlock, { className: 'rcx-message-reactions', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ref: ref, className: 'rcx-message-reactions__container', ...props }) }));
});


/***/ }),

/***/ "./src/components/Message/MessageReactions/index.tsx":
/*!***********************************************************!*\
  !*** ./src/components/Message/MessageReactions/index.tsx ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageReaction: function() { return /* reexport safe */ _MessageReaction__WEBPACK_IMPORTED_MODULE_0__.MessageReaction; },
/* harmony export */   MessageReactionAction: function() { return /* reexport safe */ _MessageReactionAction__WEBPACK_IMPORTED_MODULE_1__.MessageReactionAction; },
/* harmony export */   MessageReactionCounter: function() { return /* reexport safe */ _MessageReactionCounter__WEBPACK_IMPORTED_MODULE_2__.MessageReactionCounter; },
/* harmony export */   MessageReactionEmoji: function() { return /* reexport safe */ _MessageReactionEmoji__WEBPACK_IMPORTED_MODULE_3__.MessageReactionEmoji; },
/* harmony export */   MessageReactions: function() { return /* reexport safe */ _MessageReactions__WEBPACK_IMPORTED_MODULE_4__.MessageReactions; }
/* harmony export */ });
/* harmony import */ var _MessageReaction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MessageReaction */ "./src/components/Message/MessageReactions/MessageReaction.tsx");
/* harmony import */ var _MessageReactionAction__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MessageReactionAction */ "./src/components/Message/MessageReactions/MessageReactionAction.tsx");
/* harmony import */ var _MessageReactionCounter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MessageReactionCounter */ "./src/components/Message/MessageReactions/MessageReactionCounter.tsx");
/* harmony import */ var _MessageReactionEmoji__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MessageReactionEmoji */ "./src/components/Message/MessageReactions/MessageReactionEmoji.tsx");
/* harmony import */ var _MessageReactions__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./MessageReactions */ "./src/components/Message/MessageReactions/MessageReactions.tsx");





/* harmony default export */ __webpack_exports__["default"] = (Object.assign(_MessageReactions__WEBPACK_IMPORTED_MODULE_4__.MessageReactions, {
    /**
     * @deprecated prefer using named imports
     * */
    Reaction: _MessageReaction__WEBPACK_IMPORTED_MODULE_0__.MessageReaction,
    /**
     * @deprecated prefer using named imports
     * */
    Action: _MessageReactionAction__WEBPACK_IMPORTED_MODULE_1__.MessageReactionAction,
}));



/***/ }),

/***/ "./src/components/Message/MessageRole.tsx":
/*!************************************************!*\
  !*** ./src/components/Message/MessageRole.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageRole: function() { return /* binding */ MessageRole; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Tag__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Tag */ "./src/components/Tag/index.tsx");


const MessageRole = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Tag__WEBPACK_IMPORTED_MODULE_1__.Tag, { className: 'rcx-box rcx-box--full rcx-message-header__role', ...props }));


/***/ }),

/***/ "./src/components/Message/MessageRoles.tsx":
/*!*************************************************!*\
  !*** ./src/components/Message/MessageRoles.tsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageRoles: function() { return /* binding */ MessageRoles; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageRoles = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-message-header__roles', ...props }));


/***/ }),

/***/ "./src/components/Message/MessageStatusIndicator/MessageStatusIndicator.styles.scss":
/*!******************************************************************************************!*\
  !*** ./src/components/Message/MessageStatusIndicator/MessageStatusIndicator.styles.scss ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/components/Message/MessageStatusIndicator/MessageStatusIndicator.tsx":
/*!**********************************************************************************!*\
  !*** ./src/components/Message/MessageStatusIndicator/MessageStatusIndicator.tsx ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageStatusIndicator: function() { return /* binding */ MessageStatusIndicator; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _MessageStatusIndicator_styles_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MessageStatusIndicator.styles.scss */ "./src/components/Message/MessageStatusIndicator/MessageStatusIndicator.styles.scss");



const MessageStatusIndicator = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)((props, ref) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ref: ref, className: 'rcx-message-status-indicator', ...props })));


/***/ }),

/***/ "./src/components/Message/MessageStatusIndicator/MessageStatusIndicatorItem.tsx":
/*!**************************************************************************************!*\
  !*** ./src/components/Message/MessageStatusIndicator/MessageStatusIndicatorItem.tsx ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageStatusIndicatorItem: function() { return /* binding */ MessageStatusIndicatorItem; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../.. */ "./src/components/index.ts");


const MessageStatusIndicatorItem = ({ name, variant, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_1__.Icon, { name: name, size: 'x16', className: [
        'rcx-message-status-indicator__item',
        variant && `rcx-message-status-indicator__item--${variant}`,
    ]
        .filter(Boolean)
        .join(' '), ...props }));


/***/ }),

/***/ "./src/components/Message/MessageStatusIndicator/MessageStatusIndicatorText.tsx":
/*!**************************************************************************************!*\
  !*** ./src/components/Message/MessageStatusIndicator/MessageStatusIndicatorText.tsx ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageStatusIndicatorText: function() { return /* binding */ MessageStatusIndicatorText; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageStatusIndicatorText = ({ children, }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'rcx-message-status-indicator__text', "aria-hidden": true, children: children }));


/***/ }),

/***/ "./src/components/Message/MessageStatusIndicator/MessageStatusPrivateIndicator.tsx":
/*!*****************************************************************************************!*\
  !*** ./src/components/Message/MessageStatusIndicator/MessageStatusPrivateIndicator.tsx ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageStatusPrivateIndicator: function() { return /* binding */ MessageStatusPrivateIndicator; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageStatusPrivateIndicator = ({ children, variant, }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: [
        'rcx-message-status-indicator__item `rcx-message-status-indicator__item--private',
        variant && `rcx-message-status-indicator__item--${variant}`,
    ]
        .filter(Boolean)
        .join(' '), children: children }));


/***/ }),

/***/ "./src/components/Message/MessageStatusIndicator/index.ts":
/*!****************************************************************!*\
  !*** ./src/components/Message/MessageStatusIndicator/index.ts ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageStatusIndicator: function() { return /* reexport safe */ _MessageStatusIndicator__WEBPACK_IMPORTED_MODULE_0__.MessageStatusIndicator; },
/* harmony export */   MessageStatusIndicatorItem: function() { return /* reexport safe */ _MessageStatusIndicatorItem__WEBPACK_IMPORTED_MODULE_2__.MessageStatusIndicatorItem; },
/* harmony export */   MessageStatusIndicatorText: function() { return /* reexport safe */ _MessageStatusIndicatorText__WEBPACK_IMPORTED_MODULE_1__.MessageStatusIndicatorText; },
/* harmony export */   MessageStatusPrivateIndicator: function() { return /* reexport safe */ _MessageStatusPrivateIndicator__WEBPACK_IMPORTED_MODULE_3__.MessageStatusPrivateIndicator; }
/* harmony export */ });
/* harmony import */ var _MessageStatusIndicator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MessageStatusIndicator */ "./src/components/Message/MessageStatusIndicator/MessageStatusIndicator.tsx");
/* harmony import */ var _MessageStatusIndicatorText__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MessageStatusIndicatorText */ "./src/components/Message/MessageStatusIndicator/MessageStatusIndicatorText.tsx");
/* harmony import */ var _MessageStatusIndicatorItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MessageStatusIndicatorItem */ "./src/components/Message/MessageStatusIndicator/MessageStatusIndicatorItem.tsx");
/* harmony import */ var _MessageStatusPrivateIndicator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MessageStatusPrivateIndicator */ "./src/components/Message/MessageStatusIndicator/MessageStatusPrivateIndicator.tsx");






/***/ }),

/***/ "./src/components/Message/MessageSystem/MessageSystem.styles.scss":
/*!************************************************************************!*\
  !*** ./src/components/Message/MessageSystem/MessageSystem.styles.scss ***!
  \************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/components/Message/MessageSystem/MessageSystem.tsx":
/*!****************************************************************!*\
  !*** ./src/components/Message/MessageSystem/MessageSystem.tsx ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageSystem: function() { return /* binding */ MessageSystem; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _MessageSystem_styles_scss__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MessageSystem.styles.scss */ "./src/components/Message/MessageSystem/MessageSystem.styles.scss");


const MessageSystem = ({ children, title, isSelected, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: [
        'rcx-box rcx-box--full rcx-message-system',
        isSelected && 'rcx-message-system--selected',
    ]
        .filter(Boolean)
        .join(' '), title: title, ...props, children: children }));


/***/ }),

/***/ "./src/components/Message/MessageSystem/MessageSystemBlock.tsx":
/*!*********************************************************************!*\
  !*** ./src/components/Message/MessageSystem/MessageSystemBlock.tsx ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageSystemBlock: function() { return /* binding */ MessageSystemBlock; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageSystemBlock = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-system__block', ...props }));


/***/ }),

/***/ "./src/components/Message/MessageSystem/MessageSystemBody.tsx":
/*!********************************************************************!*\
  !*** ./src/components/Message/MessageSystem/MessageSystemBody.tsx ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageSystemBody: function() { return /* binding */ MessageSystemBody; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageSystemBody = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-message-system__body', ...props }));


/***/ }),

/***/ "./src/components/Message/MessageSystem/MessageSystemContainer.tsx":
/*!*************************************************************************!*\
  !*** ./src/components/Message/MessageSystem/MessageSystemContainer.tsx ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageSystemContainer: function() { return /* binding */ MessageSystemContainer; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageSystemContainer = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-message-system__container', ...props }));


/***/ }),

/***/ "./src/components/Message/MessageSystem/MessageSystemName.tsx":
/*!********************************************************************!*\
  !*** ./src/components/Message/MessageSystem/MessageSystemName.tsx ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageSystemName: function() { return /* binding */ MessageSystemName; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageSystemName = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'rcx-box rcx-box--full rcx-message-system__name', ...props }));


/***/ }),

/***/ "./src/components/Message/MessageSystem/MessageSystemTimestamp.tsx":
/*!*************************************************************************!*\
  !*** ./src/components/Message/MessageSystem/MessageSystemTimestamp.tsx ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageSystemTimestamp: function() { return /* binding */ MessageSystemTimestamp; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageSystemTimestamp = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'rcx-box rcx-box--full rcx-message-system__time', ...props }));


/***/ }),

/***/ "./src/components/Message/MessageSystem/index.tsx":
/*!********************************************************!*\
  !*** ./src/components/Message/MessageSystem/index.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageSystem: function() { return /* reexport safe */ _MessageSystem__WEBPACK_IMPORTED_MODULE_1__.MessageSystem; },
/* harmony export */   MessageSystemBlock: function() { return /* reexport safe */ _MessageSystemBlock__WEBPACK_IMPORTED_MODULE_2__.MessageSystemBlock; },
/* harmony export */   MessageSystemBody: function() { return /* reexport safe */ _MessageSystemBody__WEBPACK_IMPORTED_MODULE_3__.MessageSystemBody; },
/* harmony export */   MessageSystemContainer: function() { return /* reexport safe */ _MessageSystemContainer__WEBPACK_IMPORTED_MODULE_4__.MessageSystemContainer; },
/* harmony export */   MessageSystemLeftContainer: function() { return /* binding */ MessageSystemLeftContainer; },
/* harmony export */   MessageSystemName: function() { return /* reexport safe */ _MessageSystemName__WEBPACK_IMPORTED_MODULE_5__.MessageSystemName; },
/* harmony export */   MessageSystemTimestamp: function() { return /* reexport safe */ _MessageSystemTimestamp__WEBPACK_IMPORTED_MODULE_6__.MessageSystemTimestamp; }
/* harmony export */ });
/* harmony import */ var _MessageLeftContainer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../MessageLeftContainer */ "./src/components/Message/MessageLeftContainer.tsx");
/* harmony import */ var _MessageSystem__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MessageSystem */ "./src/components/Message/MessageSystem/MessageSystem.tsx");
/* harmony import */ var _MessageSystemBlock__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MessageSystemBlock */ "./src/components/Message/MessageSystem/MessageSystemBlock.tsx");
/* harmony import */ var _MessageSystemBody__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MessageSystemBody */ "./src/components/Message/MessageSystem/MessageSystemBody.tsx");
/* harmony import */ var _MessageSystemContainer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./MessageSystemContainer */ "./src/components/Message/MessageSystem/MessageSystemContainer.tsx");
/* harmony import */ var _MessageSystemName__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./MessageSystemName */ "./src/components/Message/MessageSystem/MessageSystemName.tsx");
/* harmony import */ var _MessageSystemTimestamp__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./MessageSystemTimestamp */ "./src/components/Message/MessageSystem/MessageSystemTimestamp.tsx");







const MessageSystemLeftContainer = _MessageLeftContainer__WEBPACK_IMPORTED_MODULE_0__.MessageLeftContainer;


/***/ }),

/***/ "./src/components/Message/MessageTimestamp.tsx":
/*!*****************************************************!*\
  !*** ./src/components/Message/MessageTimestamp.tsx ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageTimestamp: function() { return /* binding */ MessageTimestamp; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageTimestamp = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'rcx-box rcx-box--full rcx-message-header__time', ...props }));


/***/ }),

/***/ "./src/components/Message/MessageToolbar/MessageToolbar.tsx":
/*!******************************************************************!*\
  !*** ./src/components/Message/MessageToolbar/MessageToolbar.tsx ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageToolbar: function() { return /* binding */ MessageToolbar; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../.. */ "./src/components/index.ts");



const MessageToolbar = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function MessageToolbar(props, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-message-toolbar', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.ButtonGroup, { role: 'toolbar', ref: ref, small: true, ...props }) }));
});


/***/ }),

/***/ "./src/components/Message/MessageToolbar/MessageToolbarItem.tsx":
/*!**********************************************************************!*\
  !*** ./src/components/Message/MessageToolbar/MessageToolbarItem.tsx ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageToolbarItem: function() { return /* binding */ MessageToolbarItem; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Button */ "./src/components/Button/index.ts");



const MessageToolbarItem = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function MessageToolbarItem(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_2__.IconButton, { ref: ref, small: true, ...props });
});


/***/ }),

/***/ "./src/components/Message/MessageToolbar/MessageToolbarWrapper.tsx":
/*!*************************************************************************!*\
  !*** ./src/components/Message/MessageToolbar/MessageToolbarWrapper.tsx ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageToolbarWrapper: function() { return /* binding */ MessageToolbarWrapper; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const MessageToolbarWrapper = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function MessageToolbarWrapper({ className, visible, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ref: ref, className: [
            'rcx-box rcx-box--full rcx-message-toolbar__wrapper',
            visible && 'rcx-message-toolbar__wrapper--visible',
            className,
        ]
            .filter(Boolean)
            .join(' '), ...props }));
});


/***/ }),

/***/ "./src/components/Message/MessageToolbar/index.tsx":
/*!*********************************************************!*\
  !*** ./src/components/Message/MessageToolbar/index.tsx ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Menu: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_0__.Menu; },
/* harmony export */   MessageToolbar: function() { return /* reexport safe */ _MessageToolbar__WEBPACK_IMPORTED_MODULE_1__.MessageToolbar; },
/* harmony export */   MessageToolbarItem: function() { return /* reexport safe */ _MessageToolbarItem__WEBPACK_IMPORTED_MODULE_2__.MessageToolbarItem; },
/* harmony export */   MessageToolbarWrapper: function() { return /* reexport safe */ _MessageToolbarWrapper__WEBPACK_IMPORTED_MODULE_3__.MessageToolbarWrapper; }
/* harmony export */ });
/* harmony import */ var _Menu__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Menu */ "./src/components/Menu/index.ts");
/* harmony import */ var _MessageToolbar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MessageToolbar */ "./src/components/Message/MessageToolbar/MessageToolbar.tsx");
/* harmony import */ var _MessageToolbarItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MessageToolbarItem */ "./src/components/Message/MessageToolbar/MessageToolbarItem.tsx");
/* harmony import */ var _MessageToolbarWrapper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MessageToolbarWrapper */ "./src/components/Message/MessageToolbar/MessageToolbarWrapper.tsx");




/* harmony default export */ __webpack_exports__["default"] = (Object.assign(_MessageToolbar__WEBPACK_IMPORTED_MODULE_1__.MessageToolbar, {
    /**
     * @deprecated prefer using named imports
     * */
    Item: _MessageToolbarItem__WEBPACK_IMPORTED_MODULE_2__.MessageToolbarItem,
    /**
     * @deprecated prefer using named imports
     * */
    Wrapper: _MessageToolbarWrapper__WEBPACK_IMPORTED_MODULE_3__.MessageToolbarWrapper,
    /**
     * @deprecated prefer using named imports
     * */
    Menu: _Menu__WEBPACK_IMPORTED_MODULE_0__.Menu,
}));



/***/ }),

/***/ "./src/components/Message/MessageUsername.tsx":
/*!****************************************************!*\
  !*** ./src/components/Message/MessageUsername.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessageUsername: function() { return /* binding */ MessageUsername; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const MessageUsername = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'rcx-box rcx-box--full rcx-message-header__username', ...props }));


/***/ }),

/***/ "./src/components/Message/ThreadMessage/ThreadMessage.tsx":
/*!****************************************************************!*\
  !*** ./src/components/Message/ThreadMessage/ThreadMessage.tsx ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThreadMessage: function() { return /* binding */ ThreadMessage; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/components/Message/index.tsx");


const ThreadMessage = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_1__["default"], { ...{ className: 'rcx-message-thread' }, ...props }));


/***/ }),

/***/ "./src/components/Message/ThreadMessage/ThreadMessageBody.tsx":
/*!********************************************************************!*\
  !*** ./src/components/Message/ThreadMessage/ThreadMessageBody.tsx ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThreadMessageBody: function() { return /* binding */ ThreadMessageBody; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const ThreadMessageBody = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-message-thread__message', ...props }));


/***/ }),

/***/ "./src/components/Message/ThreadMessage/ThreadMessageContainer.tsx":
/*!*************************************************************************!*\
  !*** ./src/components/Message/ThreadMessage/ThreadMessageContainer.tsx ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThreadMessageContainer: function() { return /* binding */ ThreadMessageContainer; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const ThreadMessageContainer = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-message-thread__container', ...props }));


/***/ }),

/***/ "./src/components/Message/ThreadMessage/ThreadMessageEmoji.tsx":
/*!*********************************************************************!*\
  !*** ./src/components/Message/ThreadMessage/ThreadMessageEmoji.tsx ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThreadMessageEmoji: function() { return /* binding */ ThreadMessageEmoji; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _MessageEmojiBase__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../MessageEmojiBase */ "./src/components/Message/MessageEmojiBase.tsx");


const ThreadMessageEmoji = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MessageEmojiBase__WEBPACK_IMPORTED_MODULE_1__.MessageEmojiBase, { className: `rcx-message-thread__emoji ${className || ''}`, ...props }));


/***/ }),

/***/ "./src/components/Message/ThreadMessage/ThreadMessageFollow.tsx":
/*!**********************************************************************!*\
  !*** ./src/components/Message/ThreadMessage/ThreadMessageFollow.tsx ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThreadMessageFollow: function() { return /* binding */ ThreadMessageFollow; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ThreadMessageIcon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ThreadMessageIcon */ "./src/components/Message/ThreadMessage/ThreadMessageIcon.tsx");


const ThreadMessageFollow = () => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ThreadMessageIcon__WEBPACK_IMPORTED_MODULE_1__.ThreadMessageIcon, { className: 'rcx-box rcx-box--full rcx-message-thread__icon rcx-message-thread__icon--follow', ...{ name: 'bell' } }));


/***/ }),

/***/ "./src/components/Message/ThreadMessage/ThreadMessageIcon.tsx":
/*!********************************************************************!*\
  !*** ./src/components/Message/ThreadMessage/ThreadMessageIcon.tsx ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThreadMessageIcon: function() { return /* binding */ ThreadMessageIcon; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../.. */ "./src/components/index.ts");


const ThreadMessageIcon = ({ ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_1__.Icon, { className: 'rcx-box rcx-box--full rcx-message-thread__icon', size: 'x16', ...props }));


/***/ }),

/***/ "./src/components/Message/ThreadMessage/ThreadMessageIconThread.tsx":
/*!**************************************************************************!*\
  !*** ./src/components/Message/ThreadMessage/ThreadMessageIconThread.tsx ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThreadMessageIconThread: function() { return /* binding */ ThreadMessageIconThread; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ThreadMessageIcon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ThreadMessageIcon */ "./src/components/Message/ThreadMessage/ThreadMessageIcon.tsx");


const ThreadMessageIconThread = () => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ThreadMessageIcon__WEBPACK_IMPORTED_MODULE_1__.ThreadMessageIcon, { name: 'thread' }));


/***/ }),

/***/ "./src/components/Message/ThreadMessage/ThreadMessageOrigin.tsx":
/*!**********************************************************************!*\
  !*** ./src/components/Message/ThreadMessage/ThreadMessageOrigin.tsx ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThreadMessageOrigin: function() { return /* binding */ ThreadMessageOrigin; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const ThreadMessageOrigin = ({ children, system, }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: [
        'rcx-box rcx-box--full rcx-message-thread__origin',
        system && 'rcx-box rcx-box--full rcx-message-thread__origin--system',
    ]
        .filter(Boolean)
        .join(' '), children: children }));


/***/ }),

/***/ "./src/components/Message/ThreadMessage/ThreadMessageRow.tsx":
/*!*******************************************************************!*\
  !*** ./src/components/Message/ThreadMessage/ThreadMessageRow.tsx ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThreadMessageRow: function() { return /* binding */ ThreadMessageRow; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const ThreadMessageRow = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-message-thread__row', ...props }));


/***/ }),

/***/ "./src/components/Message/ThreadMessage/ThreadMessageUnfollow.tsx":
/*!************************************************************************!*\
  !*** ./src/components/Message/ThreadMessage/ThreadMessageUnfollow.tsx ***!
  \************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThreadMessageUnfollow: function() { return /* binding */ ThreadMessageUnfollow; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ThreadMessageIcon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ThreadMessageIcon */ "./src/components/Message/ThreadMessage/ThreadMessageIcon.tsx");


const ThreadMessageUnfollow = () => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ThreadMessageIcon__WEBPACK_IMPORTED_MODULE_1__.ThreadMessageIcon, { className: 'rcx-box rcx-box--full rcx-message-thread__icon rcx-message-thread__icon--unfollow', ...{ name: 'bell-off' } }));


/***/ }),

/***/ "./src/components/Message/ThreadMessage/index.tsx":
/*!********************************************************!*\
  !*** ./src/components/Message/ThreadMessage/index.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThreadMessage: function() { return /* reexport safe */ _ThreadMessage__WEBPACK_IMPORTED_MODULE_1__.ThreadMessage; },
/* harmony export */   ThreadMessageBody: function() { return /* reexport safe */ _ThreadMessageBody__WEBPACK_IMPORTED_MODULE_2__.ThreadMessageBody; },
/* harmony export */   ThreadMessageContainer: function() { return /* reexport safe */ _ThreadMessageContainer__WEBPACK_IMPORTED_MODULE_3__.ThreadMessageContainer; },
/* harmony export */   ThreadMessageEmoji: function() { return /* reexport safe */ _ThreadMessageEmoji__WEBPACK_IMPORTED_MODULE_4__.ThreadMessageEmoji; },
/* harmony export */   ThreadMessageFollow: function() { return /* reexport safe */ _ThreadMessageFollow__WEBPACK_IMPORTED_MODULE_5__.ThreadMessageFollow; },
/* harmony export */   ThreadMessageIconThread: function() { return /* reexport safe */ _ThreadMessageIconThread__WEBPACK_IMPORTED_MODULE_6__.ThreadMessageIconThread; },
/* harmony export */   ThreadMessageLeftContainer: function() { return /* binding */ ThreadMessageLeftContainer; },
/* harmony export */   ThreadMessageOrigin: function() { return /* reexport safe */ _ThreadMessageOrigin__WEBPACK_IMPORTED_MODULE_7__.ThreadMessageOrigin; },
/* harmony export */   ThreadMessageRow: function() { return /* reexport safe */ _ThreadMessageRow__WEBPACK_IMPORTED_MODULE_8__.ThreadMessageRow; },
/* harmony export */   ThreadMessageUnfollow: function() { return /* reexport safe */ _ThreadMessageUnfollow__WEBPACK_IMPORTED_MODULE_9__.ThreadMessageUnfollow; }
/* harmony export */ });
/* harmony import */ var _MessageLeftContainer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../MessageLeftContainer */ "./src/components/Message/MessageLeftContainer.tsx");
/* harmony import */ var _ThreadMessage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ThreadMessage */ "./src/components/Message/ThreadMessage/ThreadMessage.tsx");
/* harmony import */ var _ThreadMessageBody__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ThreadMessageBody */ "./src/components/Message/ThreadMessage/ThreadMessageBody.tsx");
/* harmony import */ var _ThreadMessageContainer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ThreadMessageContainer */ "./src/components/Message/ThreadMessage/ThreadMessageContainer.tsx");
/* harmony import */ var _ThreadMessageEmoji__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ThreadMessageEmoji */ "./src/components/Message/ThreadMessage/ThreadMessageEmoji.tsx");
/* harmony import */ var _ThreadMessageFollow__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ThreadMessageFollow */ "./src/components/Message/ThreadMessage/ThreadMessageFollow.tsx");
/* harmony import */ var _ThreadMessageIconThread__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ThreadMessageIconThread */ "./src/components/Message/ThreadMessage/ThreadMessageIconThread.tsx");
/* harmony import */ var _ThreadMessageOrigin__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ThreadMessageOrigin */ "./src/components/Message/ThreadMessage/ThreadMessageOrigin.tsx");
/* harmony import */ var _ThreadMessageRow__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ThreadMessageRow */ "./src/components/Message/ThreadMessage/ThreadMessageRow.tsx");
/* harmony import */ var _ThreadMessageUnfollow__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ThreadMessageUnfollow */ "./src/components/Message/ThreadMessage/ThreadMessageUnfollow.tsx");










const ThreadMessageLeftContainer = _MessageLeftContainer__WEBPACK_IMPORTED_MODULE_0__.MessageLeftContainer;
/* harmony default export */ __webpack_exports__["default"] = (Object.assign(_ThreadMessage__WEBPACK_IMPORTED_MODULE_1__.ThreadMessage, {
    Row: _ThreadMessageRow__WEBPACK_IMPORTED_MODULE_8__.ThreadMessageRow,
    Container: _ThreadMessageContainer__WEBPACK_IMPORTED_MODULE_3__.ThreadMessageContainer,
    LeftContainer: ThreadMessageLeftContainer,
    Origin: _ThreadMessageOrigin__WEBPACK_IMPORTED_MODULE_7__.ThreadMessageOrigin,
    Message: _ThreadMessageBody__WEBPACK_IMPORTED_MODULE_2__.ThreadMessageBody,
    Follow: _ThreadMessageFollow__WEBPACK_IMPORTED_MODULE_5__.ThreadMessageFollow,
    Unfollow: _ThreadMessageUnfollow__WEBPACK_IMPORTED_MODULE_9__.ThreadMessageUnfollow,
    Icon: _ThreadMessageIconThread__WEBPACK_IMPORTED_MODULE_6__.ThreadMessageIconThread,
}));



/***/ }),

/***/ "./src/components/Message/index.tsx":
/*!******************************************!*\
  !*** ./src/components/Message/index.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Menu: function() { return /* reexport safe */ _MessageToolbar__WEBPACK_IMPORTED_MODULE_15__.Menu; },
/* harmony export */   MessageBlock: function() { return /* reexport safe */ _MessageBlock__WEBPACK_IMPORTED_MODULE_1__.MessageBlock; },
/* harmony export */   MessageBody: function() { return /* reexport safe */ _MessageBody__WEBPACK_IMPORTED_MODULE_2__.MessageBody; },
/* harmony export */   MessageContainer: function() { return /* reexport safe */ _MessageContainer__WEBPACK_IMPORTED_MODULE_3__.MessageContainer; },
/* harmony export */   MessageContainerFixed: function() { return /* reexport safe */ _MessageContainerFixed__WEBPACK_IMPORTED_MODULE_4__.MessageContainerFixed; },
/* harmony export */   MessageDivider: function() { return /* reexport safe */ _MessageDivider__WEBPACK_IMPORTED_MODULE_5__.MessageDivider; },
/* harmony export */   MessageEmoji: function() { return /* reexport safe */ _MessageEmoji__WEBPACK_IMPORTED_MODULE_22__.MessageEmoji; },
/* harmony export */   MessageGenericPreview: function() { return /* reexport safe */ _MessageGenericPreview__WEBPACK_IMPORTED_MODULE_17__.MessageGenericPreview; },
/* harmony export */   MessageGenericPreviewContent: function() { return /* reexport safe */ _MessageGenericPreview__WEBPACK_IMPORTED_MODULE_17__.MessageGenericPreviewContent; },
/* harmony export */   MessageGenericPreviewCoverImage: function() { return /* reexport safe */ _MessageGenericPreview__WEBPACK_IMPORTED_MODULE_17__.MessageGenericPreviewCoverImage; },
/* harmony export */   MessageGenericPreviewDescription: function() { return /* reexport safe */ _MessageGenericPreview__WEBPACK_IMPORTED_MODULE_17__.MessageGenericPreviewDescription; },
/* harmony export */   MessageGenericPreviewFooter: function() { return /* reexport safe */ _MessageGenericPreview__WEBPACK_IMPORTED_MODULE_17__.MessageGenericPreviewFooter; },
/* harmony export */   MessageGenericPreviewIcon: function() { return /* reexport safe */ _MessageGenericPreview__WEBPACK_IMPORTED_MODULE_17__.MessageGenericPreviewIcon; },
/* harmony export */   MessageGenericPreviewImage: function() { return /* reexport safe */ _MessageGenericPreview__WEBPACK_IMPORTED_MODULE_17__.MessageGenericPreviewImage; },
/* harmony export */   MessageGenericPreviewThumb: function() { return /* reexport safe */ _MessageGenericPreview__WEBPACK_IMPORTED_MODULE_17__.MessageGenericPreviewThumb; },
/* harmony export */   MessageGenericPreviewTitle: function() { return /* reexport safe */ _MessageGenericPreview__WEBPACK_IMPORTED_MODULE_17__.MessageGenericPreviewTitle; },
/* harmony export */   MessageHeader: function() { return /* reexport safe */ _MessageHeader__WEBPACK_IMPORTED_MODULE_6__.MessageHeader; },
/* harmony export */   MessageHighlight: function() { return /* reexport safe */ _MessageHighlight__WEBPACK_IMPORTED_MODULE_7__.MessageHighlight; },
/* harmony export */   MessageLeftContainer: function() { return /* reexport safe */ _MessageLeftContainer__WEBPACK_IMPORTED_MODULE_8__.MessageLeftContainer; },
/* harmony export */   MessageMetrics: function() { return /* reexport safe */ _MessageMetrics__WEBPACK_IMPORTED_MODULE_9__.MessageMetrics; },
/* harmony export */   MessageMetricsFollowing: function() { return /* reexport safe */ _MessageMetrics__WEBPACK_IMPORTED_MODULE_9__.MessageMetricsFollowing; },
/* harmony export */   MessageMetricsItem: function() { return /* reexport safe */ _MessageMetrics__WEBPACK_IMPORTED_MODULE_9__.MessageMetricsItem; },
/* harmony export */   MessageMetricsItemAvatarRow: function() { return /* reexport safe */ _MessageMetrics__WEBPACK_IMPORTED_MODULE_9__.MessageMetricsItemAvatarRow; },
/* harmony export */   MessageMetricsItemAvatarRowContent: function() { return /* reexport safe */ _MessageMetrics__WEBPACK_IMPORTED_MODULE_9__.MessageMetricsItemAvatarRowContent; },
/* harmony export */   MessageMetricsItemIcon: function() { return /* reexport safe */ _MessageMetrics__WEBPACK_IMPORTED_MODULE_9__.MessageMetricsItemIcon; },
/* harmony export */   MessageMetricsItemLabel: function() { return /* reexport safe */ _MessageMetrics__WEBPACK_IMPORTED_MODULE_9__.MessageMetricsItemLabel; },
/* harmony export */   MessageMetricsReply: function() { return /* reexport safe */ _MessageMetrics__WEBPACK_IMPORTED_MODULE_9__.MessageMetricsReply; },
/* harmony export */   MessageName: function() { return /* reexport safe */ _MessageName__WEBPACK_IMPORTED_MODULE_10__.MessageName; },
/* harmony export */   MessageNameContainer: function() { return /* reexport safe */ _MessageNameContainer__WEBPACK_IMPORTED_MODULE_11__.MessageNameContainer; },
/* harmony export */   MessageReaction: function() { return /* reexport safe */ _MessageReactions__WEBPACK_IMPORTED_MODULE_20__.MessageReaction; },
/* harmony export */   MessageReactionAction: function() { return /* reexport safe */ _MessageReactions__WEBPACK_IMPORTED_MODULE_20__.MessageReactionAction; },
/* harmony export */   MessageReactionCounter: function() { return /* reexport safe */ _MessageReactions__WEBPACK_IMPORTED_MODULE_20__.MessageReactionCounter; },
/* harmony export */   MessageReactionEmoji: function() { return /* reexport safe */ _MessageReactions__WEBPACK_IMPORTED_MODULE_20__.MessageReactionEmoji; },
/* harmony export */   MessageReactions: function() { return /* reexport safe */ _MessageReactions__WEBPACK_IMPORTED_MODULE_20__.MessageReactions; },
/* harmony export */   MessageRole: function() { return /* reexport safe */ _MessageRole__WEBPACK_IMPORTED_MODULE_12__.MessageRole; },
/* harmony export */   MessageRoles: function() { return /* reexport safe */ _MessageRoles__WEBPACK_IMPORTED_MODULE_13__.MessageRoles; },
/* harmony export */   MessageStatusIndicator: function() { return /* reexport safe */ _MessageStatusIndicator__WEBPACK_IMPORTED_MODULE_18__.MessageStatusIndicator; },
/* harmony export */   MessageStatusIndicatorItem: function() { return /* reexport safe */ _MessageStatusIndicator__WEBPACK_IMPORTED_MODULE_18__.MessageStatusIndicatorItem; },
/* harmony export */   MessageStatusIndicatorText: function() { return /* reexport safe */ _MessageStatusIndicator__WEBPACK_IMPORTED_MODULE_18__.MessageStatusIndicatorText; },
/* harmony export */   MessageStatusPrivateIndicator: function() { return /* reexport safe */ _MessageStatusIndicator__WEBPACK_IMPORTED_MODULE_18__.MessageStatusPrivateIndicator; },
/* harmony export */   MessageSystem: function() { return /* reexport safe */ _MessageSystem__WEBPACK_IMPORTED_MODULE_19__.MessageSystem; },
/* harmony export */   MessageSystemBlock: function() { return /* reexport safe */ _MessageSystem__WEBPACK_IMPORTED_MODULE_19__.MessageSystemBlock; },
/* harmony export */   MessageSystemBody: function() { return /* reexport safe */ _MessageSystem__WEBPACK_IMPORTED_MODULE_19__.MessageSystemBody; },
/* harmony export */   MessageSystemContainer: function() { return /* reexport safe */ _MessageSystem__WEBPACK_IMPORTED_MODULE_19__.MessageSystemContainer; },
/* harmony export */   MessageSystemLeftContainer: function() { return /* reexport safe */ _MessageSystem__WEBPACK_IMPORTED_MODULE_19__.MessageSystemLeftContainer; },
/* harmony export */   MessageSystemName: function() { return /* reexport safe */ _MessageSystem__WEBPACK_IMPORTED_MODULE_19__.MessageSystemName; },
/* harmony export */   MessageSystemTimestamp: function() { return /* reexport safe */ _MessageSystem__WEBPACK_IMPORTED_MODULE_19__.MessageSystemTimestamp; },
/* harmony export */   MessageTimestamp: function() { return /* reexport safe */ _MessageTimestamp__WEBPACK_IMPORTED_MODULE_14__.MessageTimestamp; },
/* harmony export */   MessageToolbar: function() { return /* reexport safe */ _MessageToolbar__WEBPACK_IMPORTED_MODULE_15__.MessageToolbar; },
/* harmony export */   MessageToolbarItem: function() { return /* reexport safe */ _MessageToolbar__WEBPACK_IMPORTED_MODULE_15__.MessageToolbarItem; },
/* harmony export */   MessageToolbarWrapper: function() { return /* reexport safe */ _MessageToolbar__WEBPACK_IMPORTED_MODULE_15__.MessageToolbarWrapper; },
/* harmony export */   MessageUsername: function() { return /* reexport safe */ _MessageUsername__WEBPACK_IMPORTED_MODULE_16__.MessageUsername; },
/* harmony export */   ThreadMessage: function() { return /* reexport safe */ _ThreadMessage__WEBPACK_IMPORTED_MODULE_21__.ThreadMessage; },
/* harmony export */   ThreadMessageBody: function() { return /* reexport safe */ _ThreadMessage__WEBPACK_IMPORTED_MODULE_21__.ThreadMessageBody; },
/* harmony export */   ThreadMessageContainer: function() { return /* reexport safe */ _ThreadMessage__WEBPACK_IMPORTED_MODULE_21__.ThreadMessageContainer; },
/* harmony export */   ThreadMessageEmoji: function() { return /* reexport safe */ _ThreadMessage__WEBPACK_IMPORTED_MODULE_21__.ThreadMessageEmoji; },
/* harmony export */   ThreadMessageFollow: function() { return /* reexport safe */ _ThreadMessage__WEBPACK_IMPORTED_MODULE_21__.ThreadMessageFollow; },
/* harmony export */   ThreadMessageIconThread: function() { return /* reexport safe */ _ThreadMessage__WEBPACK_IMPORTED_MODULE_21__.ThreadMessageIconThread; },
/* harmony export */   ThreadMessageLeftContainer: function() { return /* reexport safe */ _ThreadMessage__WEBPACK_IMPORTED_MODULE_21__.ThreadMessageLeftContainer; },
/* harmony export */   ThreadMessageOrigin: function() { return /* reexport safe */ _ThreadMessage__WEBPACK_IMPORTED_MODULE_21__.ThreadMessageOrigin; },
/* harmony export */   ThreadMessageRow: function() { return /* reexport safe */ _ThreadMessage__WEBPACK_IMPORTED_MODULE_21__.ThreadMessageRow; },
/* harmony export */   ThreadMessageUnfollow: function() { return /* reexport safe */ _ThreadMessage__WEBPACK_IMPORTED_MODULE_21__.ThreadMessageUnfollow; }
/* harmony export */ });
/* harmony import */ var _Message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Message */ "./src/components/Message/Message.tsx");
/* harmony import */ var _MessageBlock__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MessageBlock */ "./src/components/Message/MessageBlock.tsx");
/* harmony import */ var _MessageBody__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MessageBody */ "./src/components/Message/MessageBody.tsx");
/* harmony import */ var _MessageContainer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MessageContainer */ "./src/components/Message/MessageContainer.tsx");
/* harmony import */ var _MessageContainerFixed__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./MessageContainerFixed */ "./src/components/Message/MessageContainerFixed.tsx");
/* harmony import */ var _MessageDivider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./MessageDivider */ "./src/components/Message/MessageDivider/index.tsx");
/* harmony import */ var _MessageHeader__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./MessageHeader */ "./src/components/Message/MessageHeader.tsx");
/* harmony import */ var _MessageHighlight__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./MessageHighlight */ "./src/components/Message/MessageHighlight.tsx");
/* harmony import */ var _MessageLeftContainer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./MessageLeftContainer */ "./src/components/Message/MessageLeftContainer.tsx");
/* harmony import */ var _MessageMetrics__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./MessageMetrics */ "./src/components/Message/MessageMetrics/index.tsx");
/* harmony import */ var _MessageName__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./MessageName */ "./src/components/Message/MessageName.tsx");
/* harmony import */ var _MessageNameContainer__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./MessageNameContainer */ "./src/components/Message/MessageNameContainer.tsx");
/* harmony import */ var _MessageRole__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./MessageRole */ "./src/components/Message/MessageRole.tsx");
/* harmony import */ var _MessageRoles__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./MessageRoles */ "./src/components/Message/MessageRoles.tsx");
/* harmony import */ var _MessageTimestamp__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./MessageTimestamp */ "./src/components/Message/MessageTimestamp.tsx");
/* harmony import */ var _MessageToolbar__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./MessageToolbar */ "./src/components/Message/MessageToolbar/index.tsx");
/* harmony import */ var _MessageUsername__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./MessageUsername */ "./src/components/Message/MessageUsername.tsx");
/* harmony import */ var _MessageGenericPreview__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./MessageGenericPreview */ "./src/components/Message/MessageGenericPreview/index.tsx");
/* harmony import */ var _MessageStatusIndicator__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./MessageStatusIndicator */ "./src/components/Message/MessageStatusIndicator/index.ts");
/* harmony import */ var _MessageSystem__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./MessageSystem */ "./src/components/Message/MessageSystem/index.tsx");
/* harmony import */ var _MessageReactions__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./MessageReactions */ "./src/components/Message/MessageReactions/index.tsx");
/* harmony import */ var _ThreadMessage__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./ThreadMessage */ "./src/components/Message/ThreadMessage/index.tsx");
/* harmony import */ var _MessageEmoji__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./MessageEmoji */ "./src/components/Message/MessageEmoji.tsx");







































/* harmony default export */ __webpack_exports__["default"] = (Object.assign(_Message__WEBPACK_IMPORTED_MODULE_0__.Message, {
    Metrics: _MessageMetrics__WEBPACK_IMPORTED_MODULE_9__["default"],
    Toolbar: _MessageToolbar__WEBPACK_IMPORTED_MODULE_15__["default"],
    Container: _MessageContainer__WEBPACK_IMPORTED_MODULE_3__.MessageContainer,
    ContainerFixed: _MessageContainerFixed__WEBPACK_IMPORTED_MODULE_4__.MessageContainerFixed,
    LeftContainer: _MessageLeftContainer__WEBPACK_IMPORTED_MODULE_8__.MessageLeftContainer,
    Header: _MessageHeader__WEBPACK_IMPORTED_MODULE_6__.MessageHeader,
    Body: _MessageBody__WEBPACK_IMPORTED_MODULE_2__.MessageBody,
    Block: _MessageBlock__WEBPACK_IMPORTED_MODULE_1__.MessageBlock,
    Timestamp: _MessageTimestamp__WEBPACK_IMPORTED_MODULE_14__.MessageTimestamp,
    NameContainer: _MessageNameContainer__WEBPACK_IMPORTED_MODULE_11__.MessageNameContainer,
    Name: _MessageName__WEBPACK_IMPORTED_MODULE_10__.MessageName,
    Username: _MessageUsername__WEBPACK_IMPORTED_MODULE_16__.MessageUsername,
    Roles: _MessageRoles__WEBPACK_IMPORTED_MODULE_13__.MessageRoles,
    Role: _MessageRole__WEBPACK_IMPORTED_MODULE_12__.MessageRole,
    Divider: _MessageDivider__WEBPACK_IMPORTED_MODULE_5__.MessageDivider,
    Highlight: _MessageHighlight__WEBPACK_IMPORTED_MODULE_7__.MessageHighlight,
}));


/***/ }),

/***/ "./src/components/Modal/Modal.tsx":
/*!****************************************!*\
  !*** ./src/components/Modal/Modal.tsx ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Modal: function() { return /* binding */ Modal; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const Modal = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(({ children, wrapper = _Box__WEBPACK_IMPORTED_MODULE_2__["default"], wrapperFunction, ...props }, ref) => {
    const wrapperProps = {
        children,
        className: 'rcx-modal__inner',
        elevation: '2',
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'dialog', open: true, "aria-modal": 'true', "rcx-modal": true, ref: ref, ...props, children: wrapperFunction
            ? wrapperFunction(wrapperProps)
            : (0,react__WEBPACK_IMPORTED_MODULE_1__.createElement)(wrapper, wrapperProps) }));
});


/***/ }),

/***/ "./src/components/Modal/ModalBackdrop.tsx":
/*!************************************************!*\
  !*** ./src/components/Modal/ModalBackdrop.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalBackdrop: function() { return /* binding */ ModalBackdrop; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");


const ModalBackdrop = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-modal__backdrop": true, ...props }));


/***/ }),

/***/ "./src/components/Modal/ModalClose.tsx":
/*!*********************************************!*\
  !*** ./src/components/Modal/ModalClose.tsx ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalClose: function() { return /* binding */ ModalClose; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./src/components/Button/index.ts");


const ModalClose = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__.IconButton, { "aria-label": 'Close', ...props, small: true, icon: 'cross' }));


/***/ }),

/***/ "./src/components/Modal/ModalContent.tsx":
/*!***********************************************!*\
  !*** ./src/components/Modal/ModalContent.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalContent: function() { return /* binding */ ModalContent; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Scrollable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Scrollable */ "./src/components/Scrollable/index.ts");



const ModalContent = ({ children, onScrollContent, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Scrollable__WEBPACK_IMPORTED_MODULE_2__["default"], { vertical: true, onScrollContent: onScrollContent, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-modal__content": true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-modal__content-wrapper": true, mi: 24, ...props, children: children }) }) }));


/***/ }),

/***/ "./src/components/Modal/ModalFooter.tsx":
/*!**********************************************!*\
  !*** ./src/components/Modal/ModalFooter.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalFooter: function() { return /* binding */ ModalFooter; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");


const ModalFooter = ({ children, justifyContent = 'end', }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { justifyContent: justifyContent, "rcx-modal__footer": true, children: children }));


/***/ }),

/***/ "./src/components/Modal/ModalFooterAnnotation.tsx":
/*!********************************************************!*\
  !*** ./src/components/Modal/ModalFooterAnnotation.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalFooterAnnotation: function() { return /* binding */ ModalFooterAnnotation; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");


const ModalFooterAnnotation = ({ children, }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-modal__footer-annotation": true, children: children }));


/***/ }),

/***/ "./src/components/Modal/ModalFooterControllers.tsx":
/*!*********************************************************!*\
  !*** ./src/components/Modal/ModalFooterControllers.tsx ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalFooterControllers: function() { return /* binding */ ModalFooterControllers; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/components/index.ts");


const ModalFooterControllers = ({ children, }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_1__.ButtonGroup, { align: 'end', children: children }));


/***/ }),

/***/ "./src/components/Modal/ModalHeader.tsx":
/*!**********************************************!*\
  !*** ./src/components/Modal/ModalHeader.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalHeader: function() { return /* binding */ ModalHeader; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Margins__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Margins */ "./src/components/Margins/index.ts");



const ModalHeader = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-modal__header": true, is: 'header', ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-modal__header-inner": true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Margins__WEBPACK_IMPORTED_MODULE_2__["default"], { all: 'x4', children: children }) }) }));


/***/ }),

/***/ "./src/components/Modal/ModalHeaderText.tsx":
/*!**************************************************!*\
  !*** ./src/components/Modal/ModalHeaderText.tsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalHeaderText: function() { return /* binding */ ModalHeaderText; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");


const ModalHeaderText = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-modal__header-text": true, ...props, children: children }));


/***/ }),

/***/ "./src/components/Modal/ModalHeroImage.tsx":
/*!*************************************************!*\
  !*** ./src/components/Modal/ModalHeroImage.tsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalHeroImage: function() { return /* binding */ ModalHeroImage; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");


const ModalHeroImage = ({ ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("figure", { className: 'rcx-modal__hero-image-wrapper', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-modal__hero-image": true, is: 'img', ...props }) }));


/***/ }),

/***/ "./src/components/Modal/ModalIcon.tsx":
/*!********************************************!*\
  !*** ./src/components/Modal/ModalIcon.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalIcon: function() { return /* binding */ ModalIcon; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");



const ModalIcon = ({ size = 'x20', name, alignItems = 'center', ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { ...props, display: 'flex', alignItems: alignItems, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_2__.Icon, { mb: 4, name: name, size: size }) }));


/***/ }),

/***/ "./src/components/Modal/ModalTagline.tsx":
/*!***********************************************!*\
  !*** ./src/components/Modal/ModalTagline.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalTagline: function() { return /* binding */ ModalTagline; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");


const ModalTagline = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-modal__tagline": true, ...props, children: children }));


/***/ }),

/***/ "./src/components/Modal/ModalThumb.tsx":
/*!*********************************************!*\
  !*** ./src/components/Modal/ModalThumb.tsx ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalThumb: function() { return /* binding */ ModalThumb; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Avatar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Avatar */ "./src/components/Avatar/index.ts");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const ModalThumb = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Avatar__WEBPACK_IMPORTED_MODULE_1__.Avatar, { size: 'x28', ...props }) }));


/***/ }),

/***/ "./src/components/Modal/ModalTitle.tsx":
/*!*********************************************!*\
  !*** ./src/components/Modal/ModalTitle.tsx ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalTitle: function() { return /* binding */ ModalTitle; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");


const ModalTitle = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { is: 'h2', "rcx-modal__title": true, ...props, children: children }));


/***/ }),

/***/ "./src/components/Modal/index.ts":
/*!***************************************!*\
  !*** ./src/components/Modal/index.ts ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Modal: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_0__.Modal; },
/* harmony export */   ModalBackdrop: function() { return /* reexport safe */ _ModalBackdrop__WEBPACK_IMPORTED_MODULE_1__.ModalBackdrop; },
/* harmony export */   ModalClose: function() { return /* reexport safe */ _ModalClose__WEBPACK_IMPORTED_MODULE_2__.ModalClose; },
/* harmony export */   ModalContent: function() { return /* reexport safe */ _ModalContent__WEBPACK_IMPORTED_MODULE_3__.ModalContent; },
/* harmony export */   ModalFooter: function() { return /* reexport safe */ _ModalFooter__WEBPACK_IMPORTED_MODULE_4__.ModalFooter; },
/* harmony export */   ModalFooterAnnotation: function() { return /* reexport safe */ _ModalFooterAnnotation__WEBPACK_IMPORTED_MODULE_5__.ModalFooterAnnotation; },
/* harmony export */   ModalFooterControllers: function() { return /* reexport safe */ _ModalFooterControllers__WEBPACK_IMPORTED_MODULE_6__.ModalFooterControllers; },
/* harmony export */   ModalHeader: function() { return /* reexport safe */ _ModalHeader__WEBPACK_IMPORTED_MODULE_7__.ModalHeader; },
/* harmony export */   ModalHeaderText: function() { return /* reexport safe */ _ModalHeaderText__WEBPACK_IMPORTED_MODULE_8__.ModalHeaderText; },
/* harmony export */   ModalHeroImage: function() { return /* reexport safe */ _ModalHeroImage__WEBPACK_IMPORTED_MODULE_9__.ModalHeroImage; },
/* harmony export */   ModalIcon: function() { return /* reexport safe */ _ModalIcon__WEBPACK_IMPORTED_MODULE_10__.ModalIcon; },
/* harmony export */   ModalTagline: function() { return /* reexport safe */ _ModalTagline__WEBPACK_IMPORTED_MODULE_11__.ModalTagline; },
/* harmony export */   ModalThumb: function() { return /* reexport safe */ _ModalThumb__WEBPACK_IMPORTED_MODULE_12__.ModalThumb; },
/* harmony export */   ModalTitle: function() { return /* reexport safe */ _ModalTitle__WEBPACK_IMPORTED_MODULE_13__.ModalTitle; }
/* harmony export */ });
/* harmony import */ var _Modal__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Modal */ "./src/components/Modal/Modal.tsx");
/* harmony import */ var _ModalBackdrop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ModalBackdrop */ "./src/components/Modal/ModalBackdrop.tsx");
/* harmony import */ var _ModalClose__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ModalClose */ "./src/components/Modal/ModalClose.tsx");
/* harmony import */ var _ModalContent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ModalContent */ "./src/components/Modal/ModalContent.tsx");
/* harmony import */ var _ModalFooter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ModalFooter */ "./src/components/Modal/ModalFooter.tsx");
/* harmony import */ var _ModalFooterAnnotation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ModalFooterAnnotation */ "./src/components/Modal/ModalFooterAnnotation.tsx");
/* harmony import */ var _ModalFooterControllers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ModalFooterControllers */ "./src/components/Modal/ModalFooterControllers.tsx");
/* harmony import */ var _ModalHeader__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ModalHeader */ "./src/components/Modal/ModalHeader.tsx");
/* harmony import */ var _ModalHeaderText__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ModalHeaderText */ "./src/components/Modal/ModalHeaderText.tsx");
/* harmony import */ var _ModalHeroImage__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ModalHeroImage */ "./src/components/Modal/ModalHeroImage.tsx");
/* harmony import */ var _ModalIcon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ModalIcon */ "./src/components/Modal/ModalIcon.tsx");
/* harmony import */ var _ModalTagline__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./ModalTagline */ "./src/components/Modal/ModalTagline.tsx");
/* harmony import */ var _ModalThumb__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./ModalThumb */ "./src/components/Modal/ModalThumb.tsx");
/* harmony import */ var _ModalTitle__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./ModalTitle */ "./src/components/Modal/ModalTitle.tsx");

















/***/ }),

/***/ "./src/components/MultiSelect/MultiSelect.tsx":
/*!****************************************************!*\
  !*** ./src/components/MultiSelect/MultiSelect.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MultiSelect: function() { return /* binding */ MultiSelect; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _helpers_isForwardRefType__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers/isForwardRefType */ "./src/helpers/isForwardRefType.ts");
/* harmony import */ var _helpers_prevent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../helpers/prevent */ "./src/helpers/prevent.ts");
/* harmony import */ var _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../AnimatedVisibility */ "./src/components/AnimatedVisibility/index.ts");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Flex__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Flex */ "./src/components/Flex/index.ts");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");
/* harmony import */ var _Margins__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Margins */ "./src/components/Margins/index.ts");
/* harmony import */ var _Option__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../Option */ "./src/components/Option/index.ts");
/* harmony import */ var _Options__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../Options */ "./src/components/Options/index.ts");
/* harmony import */ var _Position__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../Position */ "./src/components/Position/index.ts");
/* harmony import */ var _Select_SelectAddon__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../Select/SelectAddon */ "./src/components/Select/SelectAddon.tsx");
/* harmony import */ var _MultiSelectAnchor__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./MultiSelectAnchor */ "./src/components/MultiSelect/MultiSelectAnchor.tsx");
/* harmony import */ var _SelectedOptions__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./SelectedOptions */ "./src/components/MultiSelect/SelectedOptions.tsx");
















/**
 * An input for selection of options.
 */
const MultiSelect = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({ value, filter, setFilter, options = [], error, disabled, anchor: Anchor = _MultiSelectAnchor__WEBPACK_IMPORTED_MODULE_14__["default"], onChange = () => { }, getLabel = ([, label] = ['', '']) => label, getValue = ([value]) => value, placeholder, renderOptions: _Options = _Options__WEBPACK_IMPORTED_MODULE_11__.Options, renderItem, customEmpty, renderSelected: RenderSelected, addonIcon, ...props }, ref) => {
    const [internalValue, setInternalValue] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(value || []);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => setInternalValue(value || []), [value]);
    const [currentOptionValue, setCurrentOption] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)();
    const index = options.findIndex((option) => getValue(option) === currentOptionValue);
    const removeFocusClass = () => innerRef.current?.classList.remove('focus-visible');
    const internalChanged = ([value]) => {
        if (internalValue.includes(value)) {
            setCurrentOption(undefined);
            const newValue = internalValue.filter((item) => item !== value);
            setInternalValue(newValue);
            return onChange(newValue);
        }
        setFilter?.('');
        setCurrentOption(value);
        const newValue = [...internalValue, value];
        setInternalValue(newValue);
        return onChange(newValue);
    };
    const mapOptions = ([value, label]) => {
        if (internalValue.includes(value)) {
            return [value, label, true];
        }
        return [value, label];
    };
    const applyFilter = ([, option]) => !filter || option.toLowerCase().includes(filter.toLowerCase());
    const filteredOptions = options
        .filter(applyFilter)
        .map(mapOptions);
    const [cursor, handleKeyDown, handleKeyUp, reset, [visible, hide, show]] = (0,_Options__WEBPACK_IMPORTED_MODULE_11__.useCursor)(index, filteredOptions, internalChanged);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(reset, [filter]);
    const innerRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const anchorRef = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useMergedRefs)(ref, innerRef);
    const { ref: containerRef, borderBoxSize } = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useResizeObserver)();
    (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useOutsideClick)([containerRef], removeFocusClass);
    const renderAnchor = (params) => {
        if ((0,_helpers_isForwardRefType__WEBPACK_IMPORTED_MODULE_3__.isForwardRefType)(Anchor)) {
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Anchor, { ...params });
        }
        if (typeof Anchor === 'function') {
            return Anchor(params);
        }
        return null;
    };
    const handleClick = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useEffectEvent)(() => {
        if (visible === _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_5__["default"].VISIBLE) {
            return hide();
        }
        innerRef.current?.focus();
        return show();
    });
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_6__["default"], { is: 'div', "rcx-select": true, className: [error && 'invalid', disabled && 'disabled'], ref: containerRef, onClick: handleClick, disabled: disabled, ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Flex__WEBPACK_IMPORTED_MODULE_7__["default"].Item, { grow: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Margins__WEBPACK_IMPORTED_MODULE_9__["default"], { inline: 'x4', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Flex__WEBPACK_IMPORTED_MODULE_7__["default"].Container, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_6__["default"], { is: 'div', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_6__["default"], { is: 'div', display: 'flex', alignItems: 'center', flexWrap: 'wrap', margin: '-x8', role: 'listbox', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Margins__WEBPACK_IMPORTED_MODULE_9__["default"], { all: 'x4', children: [renderAnchor({
                                            ref: anchorRef,
                                            children: internalValue.length === 0 ? placeholder : null,
                                            disabled: disabled ?? false,
                                            onClick: show,
                                            onBlur: hide,
                                            onKeyDown: handleKeyDown,
                                            onKeyUp: handleKeyUp,
                                        }), internalValue.map((value) => {
                                            const currentOption = options.find(([val]) => val === value);
                                            return RenderSelected ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(RenderSelected, { role: 'option', value: value, label: getLabel(currentOption), onMouseDown: (e) => {
                                                    (0,_helpers_prevent__WEBPACK_IMPORTED_MODULE_4__.prevent)(e);
                                                    internalChanged(currentOption);
                                                    removeFocusClass();
                                                }, children: getLabel(currentOption) }, value)) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SelectedOptions__WEBPACK_IMPORTED_MODULE_15__.SelectedOptions, { tabIndex: -1, role: 'option', onMouseDown: (e) => {
                                                    (0,_helpers_prevent__WEBPACK_IMPORTED_MODULE_4__.prevent)(e);
                                                    internalChanged(currentOption);
                                                    removeFocusClass();
                                                }, children: getLabel(currentOption) }, String(value)));
                                        })] }) }) }) }) }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Flex__WEBPACK_IMPORTED_MODULE_7__["default"].Item, { grow: 0, shrink: 0, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Margins__WEBPACK_IMPORTED_MODULE_9__["default"], { inline: 'x4', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Select_SelectAddon__WEBPACK_IMPORTED_MODULE_13__["default"], { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_8__.Icon, { name: visible === _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_5__["default"].VISIBLE
                                ? 'chevron-up'
                                : addonIcon || 'chevron-down', size: 'x20' }) }) }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_AnimatedVisibility__WEBPACK_IMPORTED_MODULE_5__["default"], { visibility: visible, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Position__WEBPACK_IMPORTED_MODULE_12__["default"], { anchor: containerRef, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Options, { width: borderBoxSize.inlineSize, onMouseDown: _helpers_prevent__WEBPACK_IMPORTED_MODULE_4__.prevent, multiple: true, filter: filter, renderItem: renderItem || _Option__WEBPACK_IMPORTED_MODULE_10__.CheckOption, role: 'listbox', options: filteredOptions, onSelect: internalChanged, cursor: cursor, customEmpty: customEmpty }) }) })] }));
});


/***/ }),

/***/ "./src/components/MultiSelect/MultiSelectAnchor.tsx":
/*!**********************************************************!*\
  !*** ./src/components/MultiSelect/MultiSelectAnchor.tsx ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Select_SelectFocus__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Select/SelectFocus */ "./src/components/Select/SelectFocus.tsx");



const MultiSelectAnchor = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function MultiSelectAnchor(props, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Select_SelectFocus__WEBPACK_IMPORTED_MODULE_2__["default"], { "rcx-input-box--undecorated": true, ref: ref, "aria-haspopup": 'listbox', order: 1, ...props }));
});
/* harmony default export */ __webpack_exports__["default"] = (MultiSelectAnchor);


/***/ }),

/***/ "./src/components/MultiSelect/MultiSelectFiltered.tsx":
/*!************************************************************!*\
  !*** ./src/components/MultiSelect/MultiSelectFiltered.tsx ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MultiSelectFiltered: function() { return /* binding */ MultiSelectFiltered; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _MultiSelect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MultiSelect */ "./src/components/MultiSelect/MultiSelect.tsx");
/* harmony import */ var _MultiSelectFilteredAnchor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MultiSelectFilteredAnchor */ "./src/components/MultiSelect/MultiSelectFilteredAnchor.tsx");




const MultiSelectFiltered = ({ options, placeholder, filter: propFilter, setFilter: propSetFilter, ...props }) => {
    const [filter, setFilter] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)('');
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MultiSelect__WEBPACK_IMPORTED_MODULE_2__.MultiSelect, { ...props, filter: propFilter || filter, setFilter: propSetFilter || setFilter, options: options, anchor: (params) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_MultiSelectFilteredAnchor__WEBPACK_IMPORTED_MODULE_3__["default"], { placeholder: placeholder, filter: propFilter || filter, onChangeFilter: propSetFilter || setFilter, ...params })) }));
};


/***/ }),

/***/ "./src/components/MultiSelect/MultiSelectFilteredAnchor.tsx":
/*!******************************************************************!*\
  !*** ./src/components/MultiSelect/MultiSelectFilteredAnchor.tsx ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Flex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Flex */ "./src/components/Flex/index.ts");
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../InputBox */ "./src/components/InputBox/index.ts");




const MultiSelectFilteredAnchor = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function MultiSelectFilteredAnchor({ children: _children, filter, onChangeFilter, placeholder, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Flex__WEBPACK_IMPORTED_MODULE_2__["default"].Item, { grow: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBox__WEBPACK_IMPORTED_MODULE_3__.Input, { ref: ref, placeholder: placeholder, value: filter, onInput: (e) => onChangeFilter(e.currentTarget.value), ...props, "rcx-input-box--undecorated": true, "aria-haspopup": 'listbox', order: 1 }) }));
});
/* harmony default export */ __webpack_exports__["default"] = (MultiSelectFilteredAnchor);


/***/ }),

/***/ "./src/components/MultiSelect/SelectedOptions.tsx":
/*!********************************************************!*\
  !*** ./src/components/MultiSelect/SelectedOptions.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectedOptions: function() { return /* binding */ SelectedOptions; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Chip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Chip */ "./src/components/Chip/index.ts");



const SelectedOptions = (0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(function SelectedOptions(props) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Chip__WEBPACK_IMPORTED_MODULE_2__["default"], { ...props });
});


/***/ }),

/***/ "./src/components/MultiSelect/index.ts":
/*!*********************************************!*\
  !*** ./src/components/MultiSelect/index.ts ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MultiSelect: function() { return /* reexport safe */ _MultiSelect__WEBPACK_IMPORTED_MODULE_0__.MultiSelect; },
/* harmony export */   MultiSelectFiltered: function() { return /* reexport safe */ _MultiSelectFiltered__WEBPACK_IMPORTED_MODULE_1__.MultiSelectFiltered; }
/* harmony export */ });
/* harmony import */ var _MultiSelect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MultiSelect */ "./src/components/MultiSelect/MultiSelect.tsx");
/* harmony import */ var _MultiSelectFiltered__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MultiSelectFiltered */ "./src/components/MultiSelect/MultiSelectFiltered.tsx");





/***/ }),

/***/ "./src/components/NavBar/NavBar.tsx":
/*!******************************************!*\
  !*** ./src/components/NavBar/NavBar.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NavBar: function() { return /* binding */ NavBar; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const NavBar = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("nav", { className: 'rcx-navbar', ...props }));


/***/ }),

/***/ "./src/components/NavBar/NavBarDivider.tsx":
/*!*************************************************!*\
  !*** ./src/components/NavBar/NavBarDivider.tsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NavBarDivider: function() { return /* binding */ NavBarDivider; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Divider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Divider */ "./src/components/Divider/index.tsx");


const NavBarDivider = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Divider__WEBPACK_IMPORTED_MODULE_1__.Divider, { "rcx-navbar-divider": true, vertical: true, ...props }));


/***/ }),

/***/ "./src/components/NavBar/NavBarGroup.tsx":
/*!***********************************************!*\
  !*** ./src/components/NavBar/NavBarGroup.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NavBarGroup: function() { return /* binding */ NavBarGroup; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ButtonGroup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../ButtonGroup */ "./src/components/ButtonGroup/index.ts");



const NavBarGroup = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)((props, ref) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ButtonGroup__WEBPACK_IMPORTED_MODULE_2__.ButtonGroup, { className: 'rcx-navbar-group', ref: ref, ...props })));


/***/ }),

/***/ "./src/components/NavBar/NavBarItem.tsx":
/*!**********************************************!*\
  !*** ./src/components/NavBar/NavBarItem.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NavBarItem: function() { return /* binding */ NavBarItem; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _helpers_appendClassName__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/appendClassName */ "./src/helpers/appendClassName.ts");
/* harmony import */ var _helpers_patchChildren__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers/patchChildren */ "./src/helpers/patchChildren.ts");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Button */ "./src/components/Button/index.ts");





const NavBarItem = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function NavBarItem({ children, icon, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: icon ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_4__.IconButton, { ref: ref, "rcx-navbar-item": true, icon: icon, small: true, ...props })) : ((0,_helpers_patchChildren__WEBPACK_IMPORTED_MODULE_3__.patchChildren)(children, (childProps) => ({
            className: (0,_helpers_appendClassName__WEBPACK_IMPORTED_MODULE_2__.appendClassName)(childProps.className, 'rcx-navbar-item'),
            ref,
            ...props,
        }))) }));
});


/***/ }),

/***/ "./src/components/NavBar/NavBarSection.tsx":
/*!*************************************************!*\
  !*** ./src/components/NavBar/NavBarSection.tsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NavBarSection: function() { return /* binding */ NavBarSection; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _NavBarDivider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./NavBarDivider */ "./src/components/NavBar/NavBarDivider.tsx");
/* harmony import */ var _NavBarGroup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./NavBarGroup */ "./src/components/NavBar/NavBarGroup.tsx");




const isNavBarGroup = (child) => {
    if (!(0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(child))
        return false;
    const component = child.type;
    return component.displayName === _NavBarGroup__WEBPACK_IMPORTED_MODULE_3__.NavBarGroup.displayName;
};
const NavBarSection = ({ children, ...props }) => {
    const validChildren = react__WEBPACK_IMPORTED_MODULE_1__.Children.toArray(children).filter(isNavBarGroup);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'rcx-navbar-section', ...props, children: react__WEBPACK_IMPORTED_MODULE_1__.Children.toArray(children).map((child, index) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, { children: [child, index < validChildren.length - 1 && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_NavBarDivider__WEBPACK_IMPORTED_MODULE_2__.NavBarDivider, {})] }, index))) }));
};


/***/ }),

/***/ "./src/components/NavBar/index.ts":
/*!****************************************!*\
  !*** ./src/components/NavBar/index.ts ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NavBar: function() { return /* reexport safe */ _NavBar__WEBPACK_IMPORTED_MODULE_0__.NavBar; },
/* harmony export */   NavBarDivider: function() { return /* reexport safe */ _NavBarDivider__WEBPACK_IMPORTED_MODULE_3__.NavBarDivider; },
/* harmony export */   NavBarGroup: function() { return /* reexport safe */ _NavBarGroup__WEBPACK_IMPORTED_MODULE_1__.NavBarGroup; },
/* harmony export */   NavBarItem: function() { return /* reexport safe */ _NavBarItem__WEBPACK_IMPORTED_MODULE_2__.NavBarItem; },
/* harmony export */   NavBarSection: function() { return /* reexport safe */ _NavBarSection__WEBPACK_IMPORTED_MODULE_4__.NavBarSection; }
/* harmony export */ });
/* harmony import */ var _NavBar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./NavBar */ "./src/components/NavBar/NavBar.tsx");
/* harmony import */ var _NavBarGroup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./NavBarGroup */ "./src/components/NavBar/NavBarGroup.tsx");
/* harmony import */ var _NavBarItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./NavBarItem */ "./src/components/NavBar/NavBarItem.tsx");
/* harmony import */ var _NavBarDivider__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./NavBarDivider */ "./src/components/NavBar/NavBarDivider.tsx");
/* harmony import */ var _NavBarSection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./NavBarSection */ "./src/components/NavBar/NavBarSection.tsx");







/***/ }),

/***/ "./src/components/NumberInput/NumberInput.tsx":
/*!****************************************************!*\
  !*** ./src/components/NumberInput/NumberInput.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NumberInput: function() { return /* binding */ NumberInput; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../InputBox */ "./src/components/InputBox/index.ts");



/**
 * An input for numbers.
 */
const NumberInput = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function NumberInput(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBox__WEBPACK_IMPORTED_MODULE_2__.InputBox, { type: 'number', ref: ref, ...props });
});


/***/ }),

/***/ "./src/components/NumberInput/index.tsx":
/*!**********************************************!*\
  !*** ./src/components/NumberInput/index.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NumberInput: function() { return /* reexport safe */ _NumberInput__WEBPACK_IMPORTED_MODULE_0__.NumberInput; }
/* harmony export */ });
/* harmony import */ var _NumberInput__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./NumberInput */ "./src/components/NumberInput/NumberInput.tsx");



/***/ }),

/***/ "./src/components/Option/CheckOption.tsx":
/*!***********************************************!*\
  !*** ./src/components/Option/CheckOption.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _CheckBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../CheckBox */ "./src/components/CheckBox/index.ts");
/* harmony import */ var _Option__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Option */ "./src/components/Option/Option.tsx");




const CheckOption = ({ selected, children: label, ...options }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Option__WEBPACK_IMPORTED_MODULE_3__["default"], { label: label, selected: selected, ...options, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_CheckBox__WEBPACK_IMPORTED_MODULE_2__.CheckBox, { checked: selected }) }));
};
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(CheckOption));


/***/ }),

/***/ "./src/components/Option/Option.tsx":
/*!******************************************!*\
  !*** ./src/components/Option/Option.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _helpers_prevent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/prevent */ "./src/helpers/prevent.ts");
/* harmony import */ var _OptionAvatar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./OptionAvatar */ "./src/components/Option/OptionAvatar.tsx");
/* harmony import */ var _OptionColumn__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./OptionColumn */ "./src/components/Option/OptionColumn.tsx");
/* harmony import */ var _OptionContent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./OptionContent */ "./src/components/Option/OptionContent.tsx");
/* harmony import */ var _OptionIcon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./OptionIcon */ "./src/components/Option/OptionIcon.tsx");








/**
 * The generic `Option` item of options. Can be freely used or inside the `Options` as well.
 */
const Option = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Option({ is: Tag = 'li', id, children, label, focus, selected, className, icon, gap, avatar, title, disabled, variant, onClick, description, ...props }, ref) {
    return ((0,react__WEBPACK_IMPORTED_MODULE_1__.createElement)(Tag, { ...props, key: id, id: id, ref: ref, "aria-selected": !!selected, "aria-disabled": !!disabled, title: title, onClick: (e) => {
            if (disabled) {
                (0,_helpers_prevent__WEBPACK_IMPORTED_MODULE_2__.prevent)(e);
                return;
            }
            onClick?.(e);
        }, className: [
            'rcx-option',
            className,
            focus && 'rcx-option--focus',
            selected && 'rcx-option--selected',
            disabled && 'rcx-option--disabled',
            variant && `rcx-option--${variant}`,
        ]
            .filter(Boolean)
            .join(' ') },
        (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: [
                'rcx-option__wrapper',
                !!description && 'rcx-option__wrapper--align-top',
            ]
                .filter(Boolean)
                .join(' '), children: [avatar && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_OptionAvatar__WEBPACK_IMPORTED_MODULE_3__["default"], { children: avatar }), icon && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_OptionIcon__WEBPACK_IMPORTED_MODULE_6__["default"], { name: icon }), gap && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_OptionColumn__WEBPACK_IMPORTED_MODULE_4__["default"], {}), label && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_OptionContent__WEBPACK_IMPORTED_MODULE_5__["default"], { children: label }), label !== children && children] })));
});
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(Option));


/***/ }),

/***/ "./src/components/Option/OptionAvatar.tsx":
/*!************************************************!*\
  !*** ./src/components/Option/OptionAvatar.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const OptionAvatar = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-option__avatar', ...props }));
/* harmony default export */ __webpack_exports__["default"] = (OptionAvatar);


/***/ }),

/***/ "./src/components/Option/OptionColumn.tsx":
/*!************************************************!*\
  !*** ./src/components/Option/OptionColumn.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const OptionColumn = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-option__column', ...props }));
/* harmony default export */ __webpack_exports__["default"] = (OptionColumn);


/***/ }),

/***/ "./src/components/Option/OptionContent.tsx":
/*!*************************************************!*\
  !*** ./src/components/Option/OptionContent.tsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const OptionContent = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-option__content', ...props }));
/* harmony default export */ __webpack_exports__["default"] = (OptionContent);


/***/ }),

/***/ "./src/components/Option/OptionDescription.tsx":
/*!*****************************************************!*\
  !*** ./src/components/Option/OptionDescription.tsx ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const OptionDescription = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-option__description', ...props }));
/* harmony default export */ __webpack_exports__["default"] = (OptionDescription);


/***/ }),

/***/ "./src/components/Option/OptionDescriptionBlock.tsx":
/*!**********************************************************!*\
  !*** ./src/components/Option/OptionDescriptionBlock.tsx ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const OptionDescriptionBlock = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-option__description-block', ...props }));
/* harmony default export */ __webpack_exports__["default"] = (OptionDescriptionBlock);


/***/ }),

/***/ "./src/components/Option/OptionDivider.tsx":
/*!*************************************************!*\
  !*** ./src/components/Option/OptionDivider.tsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Divider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Divider */ "./src/components/Divider/index.tsx");


const OptionDivider = (props) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Divider__WEBPACK_IMPORTED_MODULE_1__.Divider, { ...props });
/* harmony default export */ __webpack_exports__["default"] = (OptionDivider);


/***/ }),

/***/ "./src/components/Option/OptionHeader.tsx":
/*!************************************************!*\
  !*** ./src/components/Option/OptionHeader.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const OptionHeader = ({ children }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-option__header', children: children }));
/* harmony default export */ __webpack_exports__["default"] = (OptionHeader);


/***/ }),

/***/ "./src/components/Option/OptionIcon.tsx":
/*!**********************************************!*\
  !*** ./src/components/Option/OptionIcon.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");
/* harmony import */ var _OptionColumn__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./OptionColumn */ "./src/components/Option/OptionColumn.tsx");



const OptionIcon = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_OptionColumn__WEBPACK_IMPORTED_MODULE_2__["default"], { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__.Icon, { size: 'x20', "rcx-option__icon": true, ...props }) }));
/* harmony default export */ __webpack_exports__["default"] = (OptionIcon);


/***/ }),

/***/ "./src/components/Option/OptionInput.tsx":
/*!***********************************************!*\
  !*** ./src/components/Option/OptionInput.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const OptionInput = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-option__input', ...props }));
/* harmony default export */ __webpack_exports__["default"] = (OptionInput);


/***/ }),

/***/ "./src/components/Option/OptionMenu.tsx":
/*!**********************************************!*\
  !*** ./src/components/Option/OptionMenu.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const OptionMenu = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box--animated rcx-option__menu-wrapper', ...props }));
/* harmony default export */ __webpack_exports__["default"] = (OptionMenu);


/***/ }),

/***/ "./src/components/Option/OptionSkeleton.tsx":
/*!**************************************************!*\
  !*** ./src/components/Option/OptionSkeleton.tsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Skeleton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Skeleton */ "./src/components/Skeleton/index.tsx");
/* harmony import */ var _Option__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Option */ "./src/components/Option/Option.tsx");



const OptionSkeleton = () => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Option__WEBPACK_IMPORTED_MODULE_2__["default"], { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Skeleton__WEBPACK_IMPORTED_MODULE_1__.Skeleton, { width: '100%' }) }));
/* harmony default export */ __webpack_exports__["default"] = (OptionSkeleton);


/***/ }),

/***/ "./src/components/Option/OptionTitle.tsx":
/*!***********************************************!*\
  !*** ./src/components/Option/OptionTitle.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const OptionTitle = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-option__title', ...props }));
/* harmony default export */ __webpack_exports__["default"] = (OptionTitle);


/***/ }),

/***/ "./src/components/Option/index.ts":
/*!****************************************!*\
  !*** ./src/components/Option/index.ts ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CheckOption: function() { return /* reexport safe */ _CheckOption__WEBPACK_IMPORTED_MODULE_0__["default"]; },
/* harmony export */   Option: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_1__["default"]; },
/* harmony export */   OptionAvatar: function() { return /* reexport safe */ _OptionAvatar__WEBPACK_IMPORTED_MODULE_2__["default"]; },
/* harmony export */   OptionColumn: function() { return /* reexport safe */ _OptionColumn__WEBPACK_IMPORTED_MODULE_3__["default"]; },
/* harmony export */   OptionContent: function() { return /* reexport safe */ _OptionContent__WEBPACK_IMPORTED_MODULE_4__["default"]; },
/* harmony export */   OptionDescription: function() { return /* reexport safe */ _OptionDescription__WEBPACK_IMPORTED_MODULE_5__["default"]; },
/* harmony export */   OptionDescriptionBlock: function() { return /* reexport safe */ _OptionDescriptionBlock__WEBPACK_IMPORTED_MODULE_6__["default"]; },
/* harmony export */   OptionDivider: function() { return /* reexport safe */ _OptionDivider__WEBPACK_IMPORTED_MODULE_7__["default"]; },
/* harmony export */   OptionHeader: function() { return /* reexport safe */ _OptionHeader__WEBPACK_IMPORTED_MODULE_13__["default"]; },
/* harmony export */   OptionIcon: function() { return /* reexport safe */ _OptionIcon__WEBPACK_IMPORTED_MODULE_8__["default"]; },
/* harmony export */   OptionInput: function() { return /* reexport safe */ _OptionInput__WEBPACK_IMPORTED_MODULE_9__["default"]; },
/* harmony export */   OptionMenu: function() { return /* reexport safe */ _OptionMenu__WEBPACK_IMPORTED_MODULE_10__["default"]; },
/* harmony export */   OptionSkeleton: function() { return /* reexport safe */ _OptionSkeleton__WEBPACK_IMPORTED_MODULE_11__["default"]; },
/* harmony export */   OptionTitle: function() { return /* reexport safe */ _OptionTitle__WEBPACK_IMPORTED_MODULE_12__["default"]; }
/* harmony export */ });
/* harmony import */ var _CheckOption__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CheckOption */ "./src/components/Option/CheckOption.tsx");
/* harmony import */ var _Option__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Option */ "./src/components/Option/Option.tsx");
/* harmony import */ var _OptionAvatar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./OptionAvatar */ "./src/components/Option/OptionAvatar.tsx");
/* harmony import */ var _OptionColumn__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./OptionColumn */ "./src/components/Option/OptionColumn.tsx");
/* harmony import */ var _OptionContent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./OptionContent */ "./src/components/Option/OptionContent.tsx");
/* harmony import */ var _OptionDescription__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./OptionDescription */ "./src/components/Option/OptionDescription.tsx");
/* harmony import */ var _OptionDescriptionBlock__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./OptionDescriptionBlock */ "./src/components/Option/OptionDescriptionBlock.tsx");
/* harmony import */ var _OptionDivider__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./OptionDivider */ "./src/components/Option/OptionDivider.tsx");
/* harmony import */ var _OptionIcon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./OptionIcon */ "./src/components/Option/OptionIcon.tsx");
/* harmony import */ var _OptionInput__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./OptionInput */ "./src/components/Option/OptionInput.tsx");
/* harmony import */ var _OptionMenu__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./OptionMenu */ "./src/components/Option/OptionMenu.tsx");
/* harmony import */ var _OptionSkeleton__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./OptionSkeleton */ "./src/components/Option/OptionSkeleton.tsx");
/* harmony import */ var _OptionTitle__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./OptionTitle */ "./src/components/Option/OptionTitle.tsx");
/* harmony import */ var _OptionHeader__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./OptionHeader */ "./src/components/Option/OptionHeader.tsx");
















/***/ }),

/***/ "./src/components/Options/OptionContainer.tsx":
/*!****************************************************!*\
  !*** ./src/components/Options/OptionContainer.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Scrollable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Scrollable */ "./src/components/Scrollable/index.ts");
/* harmony import */ var _Tile__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Tile */ "./src/components/Tile/index.ts");





const OptionContainer = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function OptionContainer({ children, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { "rcx-options": true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Tile__WEBPACK_IMPORTED_MODULE_4__["default"], { padding: 0, paddingBlock: 'x12', paddingInline: 0, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Scrollable__WEBPACK_IMPORTED_MODULE_3__["default"], { vertical: true, smooth: true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Tile__WEBPACK_IMPORTED_MODULE_4__["default"], { ref: ref, elevation: '0', padding: 'none', maxHeight: 'x240', ...props, children: children }) }) }) }));
});
/* harmony default export */ __webpack_exports__["default"] = (OptionContainer);


/***/ }),

/***/ "./src/components/Options/Options.tsx":
/*!********************************************!*\
  !*** ./src/components/Options/Options.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _helpers_prevent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/prevent */ "./src/helpers/prevent.ts");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Option__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Option */ "./src/components/Option/index.ts");
/* harmony import */ var _Scrollable__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Scrollable */ "./src/components/Scrollable/index.ts");
/* harmony import */ var _Tile__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Tile */ "./src/components/Tile/index.ts");
/* harmony import */ var _OptionsEmpty__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./OptionsEmpty */ "./src/components/Options/OptionsEmpty.tsx");








/**
 * An input for selection of options.
 */
const Options = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Options({ maxHeight = 'x144', multiple, renderEmpty: EmptyComponent = _OptionsEmpty__WEBPACK_IMPORTED_MODULE_7__["default"], options, cursor, renderItem: OptionComponent = _Option__WEBPACK_IMPORTED_MODULE_4__.Option, onSelect, customEmpty, ...props }, ref) {
    const liRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect)(() => {
        if (!liRef.current) {
            return;
        }
        const { current } = liRef;
        const li = current?.querySelector('.rcx-option--focus');
        if (!li) {
            return;
        }
        if (li.offsetTop + li.clientHeight >
            current.scrollTop + current.clientHeight ||
            li.offsetTop - li.clientHeight < current.scrollTop) {
            current.scrollTop = li.offsetTop;
        }
    }, [cursor]);
    const optionsMemoized = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => options?.map(([value, label, selected, disabled, type, url], i) => {
        switch (type) {
            case 'heading':
                return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Option__WEBPACK_IMPORTED_MODULE_4__.OptionHeader, { children: label }, value);
            case 'divider':
                return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Option__WEBPACK_IMPORTED_MODULE_4__.OptionDivider, {}, value);
            default:
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(OptionComponent, { role: 'option', label: label, onMouseDown: (e) => {
                        if (disabled) {
                            return;
                        }
                        (0,_helpers_prevent__WEBPACK_IMPORTED_MODULE_2__.prevent)(e);
                        onSelect([value, label, selected, disabled, type, url]);
                        return false;
                    }, value: value, selected: selected || (multiple !== true && null), disabled: disabled, focus: cursor === i || null }, value));
        }
    }), [options, multiple, cursor, onSelect, OptionComponent]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_3__["default"], { "rcx-options": true, ...props, ref: ref, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Tile__WEBPACK_IMPORTED_MODULE_6__["default"], { padding: 0, paddingBlock: 'x12', paddingInline: 0, elevation: '2', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Scrollable__WEBPACK_IMPORTED_MODULE_5__["default"], { vertical: true, smooth: true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Tile__WEBPACK_IMPORTED_MODULE_6__["default"], { ref: liRef, elevation: '0', padding: 'none', maxHeight: maxHeight, onMouseDown: _helpers_prevent__WEBPACK_IMPORTED_MODULE_2__.prevent, onClick: _helpers_prevent__WEBPACK_IMPORTED_MODULE_2__.prevent, is: 'ol', "aria-multiselectable": multiple || true, role: 'listbox', "aria-activedescendant": options?.[cursor]?.[0]
                        ? String(options?.[cursor]?.[0])
                        : undefined, children: [!options.length && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(EmptyComponent, { customEmpty: customEmpty }), optionsMemoized] }) }) }) }));
});
/* harmony default export */ __webpack_exports__["default"] = (Options);


/***/ }),

/***/ "./src/components/Options/OptionsEmpty.tsx":
/*!*************************************************!*\
  !*** ./src/components/Options/OptionsEmpty.tsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Option_Option__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Option/Option */ "./src/components/Option/Option.tsx");



const OptionsEmpty = ({ customEmpty }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Option_Option__WEBPACK_IMPORTED_MODULE_2__["default"], { label: customEmpty || 'Empty' }));
/* harmony default export */ __webpack_exports__["default"] = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(OptionsEmpty));


/***/ }),

/***/ "./src/components/Options/index.ts":
/*!*****************************************!*\
  !*** ./src/components/Options/index.ts ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OptionContainer: function() { return /* reexport safe */ _OptionContainer__WEBPACK_IMPORTED_MODULE_1__["default"]; },
/* harmony export */   Options: function() { return /* reexport safe */ _Options__WEBPACK_IMPORTED_MODULE_0__["default"]; },
/* harmony export */   useCursor: function() { return /* reexport safe */ _useCursor__WEBPACK_IMPORTED_MODULE_2__.useCursor; }
/* harmony export */ });
/* harmony import */ var _Options__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Options */ "./src/components/Options/Options.tsx");
/* harmony import */ var _OptionContainer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./OptionContainer */ "./src/components/Options/OptionContainer.tsx");
/* harmony import */ var _useCursor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./useCursor */ "./src/components/Options/useCursor.ts");





/***/ }),

/***/ "./src/components/Options/useCursor.ts":
/*!*********************************************!*\
  !*** ./src/components/Options/useCursor.ts ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useCursor: function() { return /* binding */ useCursor; }
/* harmony export */ });
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../AnimatedVisibility */ "./src/components/AnimatedVisibility/index.ts");
/* harmony import */ var _useVisible__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./useVisible */ "./src/components/Options/useVisible.ts");




const keyCodes = {
    ESC: 27,
    KEY_UP: 38,
    KEY_DOWN: 40,
    HOME: 36,
    END: 35,
    TAB: 9,
    ENTER: 13,
};
const findLastIndex = (options, predicate) => {
    for (let i = options.length - 1; i >= 0; i--) {
        if (predicate(options[i], i, options)) {
            return i;
        }
    }
    return -1;
};
const findPreviousIndex = (options, predicate, currentIndex) => {
    for (let i = currentIndex - 1; i >= 0; i--) {
        if (predicate(options[i], i, options)) {
            return i;
        }
    }
    return -1;
};
const findNextIndex = (options, predicate, currentIndex) => {
    for (let i = currentIndex + 1; i < options.length; i++) {
        if (predicate(options[i], i, options)) {
            return i;
        }
    }
    return -1;
};
const useCursor = (initial, options, onChange) => {
    const [cursor, setCursor] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(initial);
    const visibilityHandler = (0,_useVisible__WEBPACK_IMPORTED_MODULE_3__.useVisible)();
    const [visibility, hide, show] = visibilityHandler;
    const reset = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__.useEffectEvent)(() => setCursor(0));
    const handleKeyUp = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__.useEffectEvent)((e) => {
        const { keyCode } = e;
        if (_AnimatedVisibility__WEBPACK_IMPORTED_MODULE_2__["default"].HIDDEN === visibility && keyCode === keyCodes.TAB) {
            return show();
        }
    });
    const handleKeyDown = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__.useEffectEvent)((e) => {
        const isSelectableOption = ([, , , type]) => !type || type === 'option';
        const getLastIndex = () => findLastIndex(options, isSelectableOption);
        const { keyCode, key } = e;
        if (_AnimatedVisibility__WEBPACK_IMPORTED_MODULE_2__["default"].HIDDEN === visibility &&
            keyCode !== keyCodes.ESC &&
            keyCode !== keyCodes.TAB) {
            show();
        }
        switch (keyCode) {
            case keyCodes.HOME:
                e.preventDefault();
                return reset();
            case keyCodes.END:
                e.preventDefault();
                return setCursor(getLastIndex());
            case keyCodes.KEY_UP:
                e.preventDefault();
                if (cursor < 1) {
                    return setCursor(getLastIndex());
                }
                return setCursor((cursor) => findPreviousIndex(options, isSelectableOption, cursor));
            case keyCodes.KEY_DOWN:
                e.preventDefault();
                if (cursor === getLastIndex()) {
                    return setCursor(0);
                }
                return setCursor((cursor) => findNextIndex(options, isSelectableOption, cursor));
            case keyCodes.ENTER:
                e.preventDefault();
                if (visibility === _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_2__["default"].VISIBLE) {
                    e.persist();
                    e.nativeEvent.stopImmediatePropagation(); // TODO
                    e.stopPropagation();
                }
                hide();
                onChange(options[cursor], visibilityHandler);
                return;
            case keyCodes.ESC:
                e.preventDefault();
                reset();
                hide();
                if (visibility === _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_2__["default"].VISIBLE) {
                    e.persist();
                    e.nativeEvent.stopImmediatePropagation(); // TODO
                    e.stopPropagation();
                    return false;
                }
                break;
            default:
                if (key.match(/^[\d\w]$/i)) {
                    const index = options.findIndex((option) => {
                        if (!isSelectableOption(option)) {
                            return false;
                        }
                        const [, label] = option;
                        return typeof label === 'string' && label[0].toLowerCase() === key;
                    });
                    if (~index)
                        setCursor(index);
                }
        }
    });
    return [cursor, handleKeyDown, handleKeyUp, reset, visibilityHandler];
};


/***/ }),

/***/ "./src/components/Options/useVisible.ts":
/*!**********************************************!*\
  !*** ./src/components/Options/useVisible.ts ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useVisible: function() { return /* binding */ useVisible; }
/* harmony export */ });
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../AnimatedVisibility */ "./src/components/AnimatedVisibility/index.ts");


const useVisible = (initialVisibility = _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_1__["default"].HIDDEN) => {
    const [visible, setVisible] = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__.useDebouncedState)(initialVisibility, 10);
    const hide = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__.useEffectEvent)(() => setVisible(_AnimatedVisibility__WEBPACK_IMPORTED_MODULE_1__["default"].HIDDEN));
    const show = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__.useEffectEvent)(() => setVisible(_AnimatedVisibility__WEBPACK_IMPORTED_MODULE_1__["default"].VISIBLE));
    return [visible, hide, show];
};


/***/ }),

/***/ "./src/components/OptionsPaginated/OptionsPaginated.tsx":
/*!**************************************************************!*\
  !*** ./src/components/OptionsPaginated/OptionsPaginated.tsx ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CheckOption: function() { return /* binding */ CheckOption; },
/* harmony export */   Empty: function() { return /* binding */ Empty; },
/* harmony export */   OptionsPaginated: function() { return /* binding */ OptionsPaginated; },
/* harmony export */   useVisible: function() { return /* binding */ useVisible; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_virtuoso__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-virtuoso */ "react-virtuoso");
/* harmony import */ var react_virtuoso__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_virtuoso__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _helpers_prevent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../helpers/prevent */ "./src/helpers/prevent.ts");
/* harmony import */ var _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../AnimatedVisibility */ "./src/components/AnimatedVisibility/index.ts");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _CheckBox__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../CheckBox */ "./src/components/CheckBox/index.ts");
/* harmony import */ var _Option__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Option */ "./src/components/Option/index.ts");
/* harmony import */ var _Tile__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Tile */ "./src/components/Tile/index.ts");











const Empty = (0,react__WEBPACK_IMPORTED_MODULE_0__.memo)(() => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_Option__WEBPACK_IMPORTED_MODULE_8__.Option, { label: 'Empty' }));
const CheckOption = (0,react__WEBPACK_IMPORTED_MODULE_0__.memo)(function CheckOption({ selected, children: label, ...options }) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_Option__WEBPACK_IMPORTED_MODULE_8__.Option, { label: label, selected: selected, ...options, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_CheckBox__WEBPACK_IMPORTED_MODULE_7__.CheckBox, { checked: selected }) }));
});
/**
 * An input for selection of options.
 */
const OptionsPaginated = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({ withTitle, multiple, renderEmpty: EmptyComponent = Empty, options, cursor, renderItem: OptionComponent = _Option__WEBPACK_IMPORTED_MODULE_8__.Option, onSelect, endReached, ...props }, ref) => {
    const OptionsComponentWithData = ({ index, data, }) => {
        const { value, label, selected } = data;
        return ((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(OptionComponent, { ...(withTitle && { title: label }), index: index, role: 'option', label: label, onMouseDown: (e) => {
                (0,_helpers_prevent__WEBPACK_IMPORTED_MODULE_4__.prevent)(e);
                onSelect([value, label]);
                return false;
            }, key: value, value: value, selected: selected || (multiple !== true && null), focus: cursor === index || null }));
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_6__["default"], { "rcx-options": true, ...props, ref: ref, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_Tile__WEBPACK_IMPORTED_MODULE_9__["default"], { padding: 0, paddingBlock: 'x12', paddingInline: 0, elevation: '2', children: !options.length ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(EmptyComponent, {})) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_virtuoso__WEBPACK_IMPORTED_MODULE_3__.Virtuoso, { endReached: endReached, style: { height: '144px' }, totalCount: options.length, data: options, 
                // TODO Add a scroller element
                // components={{ Scroller: ScrollableContentWrapper }}
                itemContent: (index, data) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(OptionsComponentWithData, { index: index, data: data })) })) }) }));
});
const useVisible = (initialVisibility = _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_5__["default"].HIDDEN) => {
    const [visible, setVisible] = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_2__.useDebouncedState)(initialVisibility, 10);
    const hide = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_2__.useEffectEvent)(() => setVisible(_AnimatedVisibility__WEBPACK_IMPORTED_MODULE_5__["default"].HIDDEN));
    const show = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_2__.useEffectEvent)(() => setVisible(_AnimatedVisibility__WEBPACK_IMPORTED_MODULE_5__["default"].VISIBLE));
    return [visible, hide, show];
};


/***/ }),

/***/ "./src/components/OptionsPaginated/index.ts":
/*!**************************************************!*\
  !*** ./src/components/OptionsPaginated/index.ts ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CheckOption: function() { return /* reexport safe */ _OptionsPaginated__WEBPACK_IMPORTED_MODULE_0__.CheckOption; },
/* harmony export */   Empty: function() { return /* reexport safe */ _OptionsPaginated__WEBPACK_IMPORTED_MODULE_0__.Empty; },
/* harmony export */   OptionsPaginated: function() { return /* reexport safe */ _OptionsPaginated__WEBPACK_IMPORTED_MODULE_0__.OptionsPaginated; },
/* harmony export */   useVisible: function() { return /* reexport safe */ _OptionsPaginated__WEBPACK_IMPORTED_MODULE_0__.useVisible; }
/* harmony export */ });
/* harmony import */ var _OptionsPaginated__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./OptionsPaginated */ "./src/components/OptionsPaginated/OptionsPaginated.tsx");



/***/ }),

/***/ "./src/components/PaginatedSelect/PaginatedMultiSelect.tsx":
/*!*****************************************************************!*\
  !*** ./src/components/PaginatedSelect/PaginatedMultiSelect.tsx ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _helpers_prevent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers/prevent */ "./src/helpers/prevent.ts");
/* harmony import */ var _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../AnimatedVisibility */ "./src/components/AnimatedVisibility/index.ts");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Chip__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Chip */ "./src/components/Chip/index.ts");
/* harmony import */ var _Flex__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Flex */ "./src/components/Flex/index.ts");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");
/* harmony import */ var _Margins__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Margins */ "./src/components/Margins/index.ts");
/* harmony import */ var _Option__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../Option */ "./src/components/Option/index.ts");
/* harmony import */ var _Options_useVisible__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../Options/useVisible */ "./src/components/Options/useVisible.ts");
/* harmony import */ var _OptionsPaginated__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../OptionsPaginated */ "./src/components/OptionsPaginated/index.ts");
/* harmony import */ var _Position__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../Position */ "./src/components/Position/index.ts");
/* harmony import */ var _Select_SelectAddon__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../Select/SelectAddon */ "./src/components/Select/SelectAddon.tsx");
/* harmony import */ var _Select_SelectFocus__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../Select/SelectFocus */ "./src/components/Select/SelectFocus.tsx");
















const PaginatedMultiSelect = ({ withTitle, value, filter, options = [], error, disabled, anchor: Anchor = _Select_SelectFocus__WEBPACK_IMPORTED_MODULE_15__["default"], onChange = () => { }, placeholder, renderOptions: OptionsComponent = _OptionsPaginated__WEBPACK_IMPORTED_MODULE_12__.OptionsPaginated, renderItem = _Option__WEBPACK_IMPORTED_MODULE_10__.Option, endReached, ...props }) => {
    const [internalValue, setInternalValue] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(value || []);
    const currentValue = value !== undefined ? value : internalValue;
    const selectedOptions = options.filter((option) => currentValue.some((opt) => opt.value === option.value));
    const [visible, hide, show] = (0,_Options_useVisible__WEBPACK_IMPORTED_MODULE_11__.useVisible)();
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const { ref: containerRef, borderBoxSize } = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useResizeObserver)();
    const handleClick = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useEffectEvent)(() => {
        if (visible === _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_4__["default"].VISIBLE) {
            return hide();
        }
        if (ref && ref.current) {
            ref.current.focus();
            return show();
        }
    });
    const addOption = (value) => {
        const option = options.find((opt) => opt.value === value);
        if (!option) {
            return;
        }
        const newValue = [...currentValue, option];
        setInternalValue(newValue);
        onChange(newValue);
    };
    const removeOption = (value) => {
        const newValue = currentValue.filter((opt) => opt.value !== value);
        setInternalValue(newValue);
        onChange(newValue);
    };
    const toggleOption = (value) => {
        if (currentValue.some((opt) => opt.value === value)) {
            removeOption(value);
            return;
        }
        addOption(value);
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_5__["default"], { is: 'div', "rcx-select": true, className: [error && 'invalid', disabled && 'disabled'], ref: containerRef, onClick: handleClick, disabled: disabled, ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Flex__WEBPACK_IMPORTED_MODULE_7__["default"].Item, { grow: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Margins__WEBPACK_IMPORTED_MODULE_9__["default"], { inline: 'x4', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Flex__WEBPACK_IMPORTED_MODULE_7__["default"].Container, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_5__["default"], { is: 'div', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_5__["default"], { is: 'div', display: 'flex', alignItems: 'center', flexWrap: 'wrap', margin: '-x8', role: 'listbox', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Margins__WEBPACK_IMPORTED_MODULE_9__["default"], { all: 'x4', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Anchor, { disabled: disabled, ref: ref, "aria-haspopup": 'listbox', onClick: show, onBlur: hide, order: 1, "rcx-input-box--undecorated": true, children: placeholder ?? null }), selectedOptions.map(({ value, label }, index) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Chip__WEBPACK_IMPORTED_MODULE_6__["default"], { maxWidth: 'x150', withTruncatedText: true, title: withTitle ? label : undefined, tabIndex: -1, role: 'option', onClick: (e) => {
                                                (0,_helpers_prevent__WEBPACK_IMPORTED_MODULE_3__.prevent)(e);
                                                removeOption(value);
                                            }, children: label }, value ?? index)))] }) }) }) }) }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Flex__WEBPACK_IMPORTED_MODULE_7__["default"].Item, { grow: 0, shrink: 0, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Margins__WEBPACK_IMPORTED_MODULE_9__["default"], { inline: 'x4', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Select_SelectAddon__WEBPACK_IMPORTED_MODULE_14__["default"], { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_8__.Icon, { name: visible === _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_4__["default"].VISIBLE
                                ? 'cross'
                                : 'chevron-down', size: 'x20' }) }) }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_AnimatedVisibility__WEBPACK_IMPORTED_MODULE_4__["default"], { visibility: visible, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Position__WEBPACK_IMPORTED_MODULE_13__["default"], { anchor: containerRef, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(OptionsComponent, { width: borderBoxSize.inlineSize, onMouseDown: _helpers_prevent__WEBPACK_IMPORTED_MODULE_3__.prevent, multiple: true, filter: filter, role: 'listbox', options: options, cursor: -1, endReached: endReached, renderItem: renderItem, onSelect: ([value]) => {
                            toggleOption(value);
                        } }) }) })] }));
};
/* harmony default export */ __webpack_exports__["default"] = (PaginatedMultiSelect);


/***/ }),

/***/ "./src/components/PaginatedSelect/PaginatedMultiSelectFiltered.tsx":
/*!*************************************************************************!*\
  !*** ./src/components/PaginatedSelect/PaginatedMultiSelectFiltered.tsx ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PaginatedMultiSelectFiltered: function() { return /* binding */ PaginatedMultiSelectFiltered; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Flex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Flex */ "./src/components/Flex/index.ts");
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../InputBox */ "./src/components/InputBox/index.ts");
/* harmony import */ var _PaginatedMultiSelect__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./PaginatedMultiSelect */ "./src/components/PaginatedSelect/PaginatedMultiSelect.tsx");





const PaginatedMultiSelectFiltered = ({ filter, setFilter, options, placeholder, ...props }) => {
    // eslint-disable-next-line react-hooks/exhaustive-deps
    const anchor = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(({ children: _children, filter, ...props }, ref) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Flex__WEBPACK_IMPORTED_MODULE_2__["default"].Item, { grow: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBox__WEBPACK_IMPORTED_MODULE_3__.Input, { ref: ref, placeholder: placeholder, value: filter, onInput: (e) => setFilter?.(e.currentTarget.value), ...props, "rcx-input-box--undecorated": true }) }))), []);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_PaginatedMultiSelect__WEBPACK_IMPORTED_MODULE_4__["default"], { filter: filter, options: options, anchor: anchor, ...props }));
};


/***/ }),

/***/ "./src/components/PaginatedSelect/PaginatedSelect.tsx":
/*!************************************************************!*\
  !*** ./src/components/PaginatedSelect/PaginatedSelect.tsx ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PaginatedSelect: function() { return /* binding */ PaginatedSelect; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _helpers_prevent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers/prevent */ "./src/helpers/prevent.ts");
/* harmony import */ var _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../AnimatedVisibility */ "./src/components/AnimatedVisibility/index.ts");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");
/* harmony import */ var _Margins__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Margins */ "./src/components/Margins/index.ts");
/* harmony import */ var _Option__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Option */ "./src/components/Option/index.ts");
/* harmony import */ var _Options_useVisible__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Options/useVisible */ "./src/components/Options/useVisible.ts");
/* harmony import */ var _OptionsPaginated__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../OptionsPaginated */ "./src/components/OptionsPaginated/index.ts");
/* harmony import */ var _PositionAnimated__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../PositionAnimated */ "./src/components/PositionAnimated/index.ts");
/* harmony import */ var _Select_SelectAddon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../Select/SelectAddon */ "./src/components/Select/SelectAddon.tsx");
/* harmony import */ var _Select_SelectFocus__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../Select/SelectFocus */ "./src/components/Select/SelectFocus.tsx");
/* harmony import */ var _PaginatedSelectWrapper__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./PaginatedSelectWrapper */ "./src/components/PaginatedSelect/PaginatedSelectWrapper.tsx");















const PaginatedSelect = ({ value, withTitle, filter, setFilter: _setFilter, error, disabled, options = [], anchor: Anchor = _Select_SelectFocus__WEBPACK_IMPORTED_MODULE_13__["default"], onChange = () => { }, placeholder, renderOptions: _Options = _OptionsPaginated__WEBPACK_IMPORTED_MODULE_10__.OptionsPaginated, renderItem = _Option__WEBPACK_IMPORTED_MODULE_8__.Option, endReached, ...props }) => {
    const [internalValue, setInternalValue] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(value);
    const currentValue = value !== undefined ? value : internalValue;
    const option = options.find((option) => option?.value === currentValue);
    const [visible, hide, show] = (0,_Options_useVisible__WEBPACK_IMPORTED_MODULE_9__.useVisible)();
    const internalChangedByClick = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useEffectEvent)(([value]) => {
        setInternalValue(value);
        onChange(value); // FIXME
        hide();
    });
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const { ref: containerRef, borderBoxSize } = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useResizeObserver)();
    const valueLabel = option?.label;
    const isUnfilteredOrHidden = filter === undefined || visible === _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_4__["default"].HIDDEN;
    const visibleText = isUnfilteredOrHidden
        ? valueLabel || placeholder
        : undefined;
    const handleClick = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useEffectEvent)(() => {
        if (visible === _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_4__["default"].VISIBLE) {
            return hide();
        }
        if (ref && ref.current) {
            ref.current.focus();
            return show();
        }
    });
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_5__["default"], { "rcx-select": true, disabled: disabled, ref: containerRef, onClick: handleClick, className: (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => [error && 'invalid', disabled && 'disabled'], [error, disabled]), ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_PaginatedSelectWrapper__WEBPACK_IMPORTED_MODULE_14__["default"], { display: 'flex', mi: 'neg-x4', "rcx-select__wrapper--hidden": !!visibleText, children: [visibleText && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_5__["default"], { flexGrow: 1, is: 'span', mi: 4, "rcx-select__item": true, fontScale: 'p2m', color: valueLabel ? 'default' : 'hint', children: visibleText })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Anchor, { disabled: disabled, "rcx-input-box--undecorated": true, filter: filter, ref: ref, "aria-haspopup": 'listbox', onClick: show, onBlur: hide }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Margins__WEBPACK_IMPORTED_MODULE_7__["default"], { inline: 'x4', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Select_SelectAddon__WEBPACK_IMPORTED_MODULE_12__["default"], { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_6__.Icon, { name: visible === _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_4__["default"].VISIBLE
                                    ? 'chevron-up'
                                    : 'chevron-down', size: 'x20' }) }) })] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_PositionAnimated__WEBPACK_IMPORTED_MODULE_11__["default"], { visible: visible, anchor: containerRef, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Options, { withTitle: withTitle, width: borderBoxSize.inlineSize, role: 'listbox', filter: filter, options: options, onSelect: internalChangedByClick, endReached: endReached, onMouseDown: _helpers_prevent__WEBPACK_IMPORTED_MODULE_3__.prevent, renderItem: renderItem }) })] }));
};


/***/ }),

/***/ "./src/components/PaginatedSelect/PaginatedSelectFiltered.tsx":
/*!********************************************************************!*\
  !*** ./src/components/PaginatedSelect/PaginatedSelectFiltered.tsx ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PaginatedSelectFiltered: function() { return /* binding */ PaginatedSelectFiltered; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../InputBox */ "./src/components/InputBox/index.ts");
/* harmony import */ var _PaginatedSelect__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./PaginatedSelect */ "./src/components/PaginatedSelect/PaginatedSelect.tsx");





const PaginatedSelectFiltered = ({ filter, setFilter, options, placeholder, ...props }) => {
    const anchor = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({ filter, onChange: _onChange, ...props }, ref) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBox__WEBPACK_IMPORTED_MODULE_3__.Input, { mi: 4, flexGrow: 1, className: 'rcx-select__focus', ref: ref, placeholder: placeholder, value: filter, onChange: (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useEffectEvent)((e) => {
            setFilter(e.currentTarget.value);
        }), ...props, "rcx-input-box--undecorated": true }))), [placeholder, setFilter]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_PaginatedSelect__WEBPACK_IMPORTED_MODULE_4__.PaginatedSelect, { placeholder: undefined, filter: filter, options: options, ...props, anchor: anchor }));
};


/***/ }),

/***/ "./src/components/PaginatedSelect/PaginatedSelectWrapper.tsx":
/*!*******************************************************************!*\
  !*** ./src/components/PaginatedSelect/PaginatedSelectWrapper.tsx ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const PaginatedSelectWrapper = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function PaginatedSelectWrapper(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'div', "rcx-select__wrapper": true, ref: ref, ...props });
});
/* harmony default export */ __webpack_exports__["default"] = (PaginatedSelectWrapper);


/***/ }),

/***/ "./src/components/PaginatedSelect/index.ts":
/*!*************************************************!*\
  !*** ./src/components/PaginatedSelect/index.ts ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PaginatedMultiSelectFiltered: function() { return /* reexport safe */ _PaginatedMultiSelectFiltered__WEBPACK_IMPORTED_MODULE_1__.PaginatedMultiSelectFiltered; },
/* harmony export */   PaginatedSelectFiltered: function() { return /* reexport safe */ _PaginatedSelectFiltered__WEBPACK_IMPORTED_MODULE_0__.PaginatedSelectFiltered; }
/* harmony export */ });
/* harmony import */ var _PaginatedSelectFiltered__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PaginatedSelectFiltered */ "./src/components/PaginatedSelect/PaginatedSelectFiltered.tsx");
/* harmony import */ var _PaginatedMultiSelectFiltered__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PaginatedMultiSelectFiltered */ "./src/components/PaginatedSelect/PaginatedMultiSelectFiltered.tsx");




/***/ }),

/***/ "./src/components/Pagination/Pagination.tsx":
/*!**************************************************!*\
  !*** ./src/components/Pagination/Pagination.tsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Pagination: function() { return /* binding */ Pagination; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Chevron__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Chevron */ "./src/components/Chevron/index.tsx");




const defaultItemsPerPageLabel = () => 'Items per page:';
const defaultShowingResultsLabel = ({ count, current, itemsPerPage, }) => `Showing results ${current + 1} - ${Math.min(current + itemsPerPage, count)} of ${count}`;
const itemsPerPageOptions = [25, 50, 100];
const Pagination = ({ count, current = 0, itemsPerPage = 25, itemsPerPageLabel = defaultItemsPerPageLabel, showingResultsLabel = defaultShowingResultsLabel, onSetItemsPerPage, onSetCurrent, divider, ...props }) => {
    const hasItemsPerPageSelection = itemsPerPageOptions.length > 1;
    const currentPage = Math.floor(current / itemsPerPage);
    const pages = Math.ceil(count / itemsPerPage);
    const displayedPages = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
        if (pages <= 7) {
            // 0 1 2 3 4 5 6
            return Array.from({ length: pages }, (_, i) => i);
        }
        if (currentPage < 5) {
            // 0 1 2 3 4 ... N
            return [0, 1, 2, 3, 4, '⋯', pages - 1];
        }
        if (currentPage > pages - 5) {
            // 0 ... N-4 N-3 N-2 N-1 N
            return [0, '⋯', pages - 5, pages - 4, pages - 3, pages - 2, pages - 1];
        }
        // 0 ... x-1 x x-2 ... N
        return [
            0,
            '⋯',
            currentPage - 1,
            currentPage,
            currentPage + 1,
            '⋯',
            pages - 1,
        ];
    }, [pages, currentPage]);
    const renderingContext = { count, pages, current, currentPage, itemsPerPage };
    const handleSetItemsPerPageLinkClick = (itemsPerPageOption) => () => {
        onSetItemsPerPage?.(itemsPerPageOption);
    };
    const handleSetPageLinkClick = (page) => () => {
        onSetCurrent?.(page * itemsPerPage);
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'nav', "rcx-pagination": true, "rcx-pagination--divider": divider, ...props, children: [hasItemsPerPageSelection && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { "rcx-pagination__left": true, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'span', "rcx-pagination__label": true, children: itemsPerPageLabel(renderingContext) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'ol', "rcx-pagination__list": true, children: itemsPerPageOptions.map((itemsPerPageOption) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'li', "rcx-pagination__list-item": true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'button', "rcx-pagination__link": true, tabIndex: itemsPerPage === itemsPerPageOption ? -1 : 0, disabled: itemsPerPage === itemsPerPageOption, onClick: handleSetItemsPerPageLinkClick(itemsPerPageOption), children: itemsPerPageOption }) }, itemsPerPageOption))) })] })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { "rcx-pagination__right": true, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'span', "rcx-pagination__label": true, children: showingResultsLabel(renderingContext) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'ol', "rcx-pagination__list": true, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'li', "rcx-pagination__list-item": true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'button', "rcx-pagination__back": true, disabled: currentPage === 0, onClick: handleSetPageLinkClick(currentPage - 1), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Chevron__WEBPACK_IMPORTED_MODULE_3__.Chevron, { left: true, size: 'x16' }) }) }), displayedPages.map((page, i) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'li', "rcx-pagination__list-item": true, children: page === '⋯' ? ('⋯') : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'button', "rcx-pagination__link": true, disabled: currentPage === page, onClick: handleSetPageLinkClick(page), children: page + 1 })) }, i))), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'li', "rcx-pagination__list-item": true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'button', "rcx-pagination__forward": true, disabled: currentPage === pages - 1, onClick: handleSetPageLinkClick(currentPage + 1), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Chevron__WEBPACK_IMPORTED_MODULE_3__.Chevron, { right: true, size: 'x16' }) }) })] })] })] }));
};


/***/ }),

/***/ "./src/components/Pagination/index.ts":
/*!********************************************!*\
  !*** ./src/components/Pagination/index.ts ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Pagination: function() { return /* reexport safe */ _Pagination__WEBPACK_IMPORTED_MODULE_0__.Pagination; }
/* harmony export */ });
/* harmony import */ var _Pagination__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Pagination */ "./src/components/Pagination/Pagination.tsx");



/***/ }),

/***/ "./src/components/PaletteStyleTag/PaletteStyleTag.tsx":
/*!************************************************************!*\
  !*** ./src/components/PaletteStyleTag/PaletteStyleTag.tsx ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PaletteStyleTag: function() { return /* binding */ PaletteStyleTag; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-dom */ "react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _helpers_convertToCss__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./helpers/convertToCss */ "./src/components/PaletteStyleTag/helpers/convertToCss.ts");
/* harmony import */ var _hooks_useCreateStyleContainer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./hooks/useCreateStyleContainer */ "./src/components/PaletteStyleTag/hooks/useCreateStyleContainer.ts");
/* harmony import */ var _lib_themePalettes__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./lib/themePalettes */ "./src/components/PaletteStyleTag/lib/themePalettes.ts");






const themes = {
    light: _lib_themePalettes__WEBPACK_IMPORTED_MODULE_5__.light,
    dark: _lib_themePalettes__WEBPACK_IMPORTED_MODULE_5__.dark,
    'high-contrast': _lib_themePalettes__WEBPACK_IMPORTED_MODULE_5__.highContrast,
};
/**
 * Style tag to handle the theme of the application.
 *
 * Import `PaletteStyleTag` and use it on the application informing the desired theme.
 *
 * Toggle the theme on Storybook's Control panel to see the color changes.
 */
const PaletteStyleTag = (0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(function PaletteStyleTag({ theme = 'light', tagId = 'main-palette', prefix = '--rcx-color', selector, palette, }) {
    const themePalette = palette || (0,_helpers_convertToCss__WEBPACK_IMPORTED_MODULE_3__.convertToCss)(themes[theme], prefix, selector);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: (0,react_dom__WEBPACK_IMPORTED_MODULE_2__.createPortal)(themePalette, (0,_hooks_useCreateStyleContainer__WEBPACK_IMPORTED_MODULE_4__.useCreateStyleContainer)(tagId)) });
});
/* harmony default export */ __webpack_exports__["default"] = (PaletteStyleTag);


/***/ }),

/***/ "./src/components/PaletteStyleTag/helpers/convertToCss.ts":
/*!****************************************************************!*\
  !*** ./src/components/PaletteStyleTag/helpers/convertToCss.ts ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   convertToCss: function() { return /* binding */ convertToCss; }
/* harmony export */ });
const convertToCss = (values, prefix, selector = ':root') => `${selector} {\n${Object.entries(values)
    .map(([name, color]) => `${prefix}-${name}: ${color};`)
    .join('\n')}\n}`;


/***/ }),

/***/ "./src/components/PaletteStyleTag/helpers/getPalette.ts":
/*!**************************************************************!*\
  !*** ./src/components/PaletteStyleTag/helpers/getPalette.ts ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getThemePalette: function() { return /* binding */ getThemePalette; },
/* harmony export */   getTokens: function() { return /* binding */ getTokens; }
/* harmony export */ });
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_badge_json__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rocket.chat/fuselage-tokens/dist/badge.json */ "@rocket.chat/fuselage-tokens/dist/badge.json");
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_badge_json__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_tokens_dist_badge_json__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_button_json__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-tokens/dist/button.json */ "@rocket.chat/fuselage-tokens/dist/button.json");
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_button_json__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_tokens_dist_button_json__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_font_json__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rocket.chat/fuselage-tokens/dist/font.json */ "@rocket.chat/fuselage-tokens/dist/font.json");
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_font_json__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_tokens_dist_font_json__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_shadow_json__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @rocket.chat/fuselage-tokens/dist/shadow.json */ "@rocket.chat/fuselage-tokens/dist/shadow.json");
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_shadow_json__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_tokens_dist_shadow_json__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_status_json__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @rocket.chat/fuselage-tokens/dist/status.json */ "@rocket.chat/fuselage-tokens/dist/status.json");
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_status_json__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_tokens_dist_status_json__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_statusBullet_json__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @rocket.chat/fuselage-tokens/dist/statusBullet.json */ "@rocket.chat/fuselage-tokens/dist/statusBullet.json");
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_statusBullet_json__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_tokens_dist_statusBullet_json__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_stroke_json__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @rocket.chat/fuselage-tokens/dist/stroke.json */ "@rocket.chat/fuselage-tokens/dist/stroke.json");
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_stroke_json__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_tokens_dist_stroke_json__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_surface_json__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @rocket.chat/fuselage-tokens/dist/surface.json */ "@rocket.chat/fuselage-tokens/dist/surface.json");
/* harmony import */ var _rocket_chat_fuselage_tokens_dist_surface_json__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_tokens_dist_surface_json__WEBPACK_IMPORTED_MODULE_7__);








const getTokens = (theme) => {
    const tokens = {
        badge: (_rocket_chat_fuselage_tokens_dist_badge_json__WEBPACK_IMPORTED_MODULE_0___default().badge)[theme],
        button: (_rocket_chat_fuselage_tokens_dist_button_json__WEBPACK_IMPORTED_MODULE_1___default().button)[theme],
        font: (_rocket_chat_fuselage_tokens_dist_font_json__WEBPACK_IMPORTED_MODULE_2___default().font)[theme],
        shadow: (_rocket_chat_fuselage_tokens_dist_shadow_json__WEBPACK_IMPORTED_MODULE_3___default().shadow)[theme],
        status: (_rocket_chat_fuselage_tokens_dist_status_json__WEBPACK_IMPORTED_MODULE_4___default().status)[theme],
        statusBullet: (_rocket_chat_fuselage_tokens_dist_statusBullet_json__WEBPACK_IMPORTED_MODULE_5___default().statusBullet)[theme],
        stroke: (_rocket_chat_fuselage_tokens_dist_stroke_json__WEBPACK_IMPORTED_MODULE_6___default().stroke)[theme],
        surface: (_rocket_chat_fuselage_tokens_dist_surface_json__WEBPACK_IMPORTED_MODULE_7___default().surface)[theme],
    };
    return tokens;
};
const getThemePalette = (theme) => {
    const { badge, button, font, shadow, status, statusBullet, stroke, surface } = getTokens(theme);
    const palette = [
        {
            category: 'Stroke',
            description: "Use as component's outline, stroke, dividers",
            list: [
                { name: 'stroke-extra-light', color: stroke.extraLight },
                { name: 'stroke-light', color: stroke.light },
                { name: 'stroke-medium', color: stroke.medium },
                { name: 'stroke-dark', color: stroke.dark },
                { name: 'stroke-extra-dark', color: stroke.extraDark },
                {
                    name: 'stroke-extra-light-highlight',
                    color: stroke.extraLightHighlight,
                },
                { name: 'stroke-highlight', color: stroke.highlight },
                { name: 'stroke-extra-light-error', color: stroke.extraLightError },
                { name: 'stroke-error', color: stroke.error },
            ],
        },
        {
            category: 'Surface',
            description: 'Use as a container on top of the background',
            list: [
                { name: 'surface-light', color: surface.light },
                { name: 'surface-tint', color: surface.tint },
                { name: 'surface-room', color: surface.room },
                { name: 'surface-neutral', color: surface.neutral },
                { name: 'surface-disabled', color: surface.disabled },
                { name: 'surface-hover', color: surface.hover },
                { name: 'surface-selected', color: surface.selected },
                { name: 'surface-dark', color: surface.dark },
                { name: 'surface-featured', color: surface.featured },
                { name: 'surface-featured-hover', color: surface.featuredHover },
                { name: 'surface-overlay', color: surface.overlay },
                { name: 'surface-sidebar', color: surface.sidebar },
            ],
        },
        {
            category: 'Shadow',
            description: 'Use as a shadow color',
            list: [
                { name: 'shadow-highlight', color: shadow.highlight },
                { name: 'shadow-danger', color: shadow.danger },
                { name: 'shadow-elevation-border', color: shadow['elevation-border'] },
                { name: 'shadow-elevation-1', color: shadow['elevation-1'] },
                {
                    name: 'shadow-elevation-2x',
                    color: shadow['elevation-2x'],
                },
                {
                    name: 'shadow-elevation-2y',
                    color: shadow['elevation-2y'],
                },
            ],
        },
        {
            category: 'Font',
            description: 'These should be applied according to surfaces',
            list: [
                { name: 'font-white', color: font.white },
                { name: 'font-disabled', color: font.disabled },
                { name: 'font-annotation', color: font.annotation },
                { name: 'font-hint', color: font.hint },
                { name: 'font-secondary-info', color: font.secondaryInfo },
                { name: 'font-default', color: font.default },
                { name: 'font-titles-labels', color: font.titlesLabels },
                { name: 'font-info', color: font.info },
                { name: 'font-danger', color: font.danger },
                { name: 'font-pure-black', color: font.pureBlack },
                { name: 'font-pure-white', color: font.pureWhite },
            ],
        },
        {
            category: 'Status',
            description: 'Status Background',
            list: [
                { name: 'status-background-info', color: status.info },
                { name: 'status-background-success', color: status.success },
                { name: 'status-background-danger', color: status.danger },
                { name: 'status-background-warning', color: status.warning },
                { name: 'status-background-warning-2', color: status['warning-2'] },
                {
                    name: 'status-background-service-1',
                    color: status['service-1'],
                },
                {
                    name: 'status-background-service-2',
                    color: status['service-2'],
                },
                {
                    name: 'status-background-service-3',
                    color: status['service-3'],
                },
            ],
        },
        {
            description: 'Status Font',
            list: [
                { name: 'status-font-on-info', color: status['font-on-info'] },
                { name: 'status-font-on-success', color: status['font-on-success'] },
                { name: 'status-font-on-danger', color: status['font-on-danger'] },
                { name: 'status-font-on-warning', color: status['font-on-warning'] },
                {
                    name: 'status-font-on-warning-2',
                    color: status['font-on-warning-2'],
                },
                {
                    name: 'status-font-on-service-1',
                    color: status['font-on-service-1'],
                },
                {
                    name: 'status-font-on-service-2 ',
                    color: status['font-on-service-2'],
                },
                {
                    name: 'status-font-on-service-3 ',
                    color: status['font-on-service-3'],
                },
            ],
        },
        {
            category: 'Badge',
            description: 'Badge Background',
            list: [
                { name: 'badge-background-level-0', color: badge['level-0'] },
                { name: 'badge-background-level-1', color: badge['level-1'] },
                { name: 'badge-background-level-2', color: badge['level-2'] },
                { name: 'badge-background-level-3', color: badge['level-3'] },
                { name: 'badge-background-level-4', color: badge['level-4'] },
            ],
        },
        {
            category: 'Status Bullet',
            description: 'Used to show user status',
            list: [
                { name: 'status-bullet-online', color: statusBullet.online },
                { name: 'status-bullet-away', color: statusBullet.away },
                { name: 'status-bullet-busy', color: statusBullet.busy },
                { name: 'status-bullet-disabled', color: statusBullet.disabled },
                { name: 'status-bullet-offline', color: statusBullet.offline },
                { name: 'status-bullet-loading', color: statusBullet.loading },
            ],
        },
        {
            category: 'Button',
            description: 'Primary Background',
            list: [
                {
                    name: 'button-background-primary-default',
                    color: button.backgroundPrimaryDefault,
                },
                {
                    name: 'button-background-primary-hover',
                    color: button.backgroundPrimaryHover,
                },
                {
                    name: 'button-background-primary-press',
                    color: button.backgroundPrimaryPress,
                },
                {
                    name: 'button-background-primary-focus',
                    color: button.backgroundPrimaryFocus,
                },
                {
                    name: 'button-background-primary-keyfocus',
                    color: button.backgroundPrimaryKeyfocus,
                },
                {
                    name: 'button-background-primary-disabled',
                    color: button.backgroundPrimaryDisabled,
                },
            ],
        },
        {
            description: 'Secondary Background',
            list: [
                {
                    name: 'button-background-secondary-default',
                    color: button.backgroundSecondaryDefault,
                },
                {
                    name: 'button-background-secondary-hover',
                    color: button.backgroundSecondaryHover,
                },
                {
                    name: 'button-background-secondary-press',
                    color: button.backgroundSecondaryPress,
                },
                {
                    name: 'button-background-secondary-focus',
                    color: button.backgroundSecondaryFocus,
                },
                {
                    name: 'button-background-secondary-keyfocus',
                    color: button.backgroundSecondaryKeyfocus,
                },
                {
                    name: 'button-background-secondary-disabled',
                    color: button.backgroundSecondaryDisabled,
                },
            ],
        },
        {
            description: 'Secondary Danger Background',
            list: [
                {
                    name: 'button-background-secondary-danger-default',
                    color: button.backgroundSecondaryDangerDefault,
                },
                {
                    name: 'button-background-secondary-danger-hover',
                    color: button.backgroundSecondaryDangerHover,
                },
                {
                    name: 'button-background-secondary-danger-press',
                    color: button.backgroundSecondaryDangerPress,
                },
                {
                    name: 'button-background-secondary-danger-focus',
                    color: button.backgroundSecondaryDangerFocus,
                },
                {
                    name: 'button-background-secondary-danger-keyfocus',
                    color: button.backgroundSecondaryDangerKeyfocus,
                },
                {
                    name: 'button-background-secondary-danger-disabled',
                    color: button.backgroundDangerDisabled,
                },
            ],
        },
        {
            description: 'Danger Background',
            list: [
                {
                    name: 'button-background-danger-default',
                    color: button.backgroundDangerDefault,
                },
                {
                    name: 'button-background-danger-hover',
                    color: button.backgroundDangerHover,
                },
                {
                    name: 'button-background-danger-press',
                    color: button.backgroundDangerPress,
                },
                {
                    name: 'button-background-danger-focus',
                    color: button.backgroundDangerFocus,
                },
                {
                    name: 'button-background-danger-keyfocus',
                    color: button.backgroundDangerKeyfocus,
                },
                {
                    name: 'button-background-danger-disabled',
                    color: button.backgroundDangerDisabled,
                },
            ],
        },
        {
            description: 'Success Background',
            list: [
                {
                    name: 'button-background-success-default',
                    color: button.backgroundSuccessDefault,
                },
                {
                    name: 'button-background-success-hover',
                    color: button.backgroundSuccessHover,
                },
                {
                    name: 'button-background-success-press',
                    color: button.backgroundSuccessPress,
                },
                {
                    name: 'button-background-success-focus',
                    color: button.backgroundSuccessFocus,
                },
                {
                    name: 'button-background-success-keyfocus',
                    color: button.backgroundSuccessKeyfocus,
                },
                {
                    name: 'button-background-success-disabled',
                    color: button.backgroundSuccessDisabled,
                },
            ],
        },
        {
            description: 'Font',
            list: [
                { name: 'button-font-on-primary', color: button.fontOnPrimary },
                {
                    name: 'button-font-on-primary-disabled',
                    color: button.fontOnPrimaryDisabled,
                },
                {
                    name: 'button-font-on-secondary',
                    color: button.fontOnSecondary,
                },
                {
                    name: 'button-font-on-secondary-disabled',
                    color: button.fontOnSecondaryDisabled,
                },
                {
                    name: 'button-font-on-secondary-danger',
                    color: button.fontOnSecondaryDanger,
                },
                {
                    name: 'button-font-on-secondary-danger-disabled',
                    color: button.onSecondaryDangerDisabled,
                },
                { name: 'button-font-on-danger', color: button.fontOnDanger },
                {
                    name: 'button-font-on-danger-disabled',
                    color: button.fontOnDangerDisabled,
                },
                { name: 'button-font-on-success', color: button.fontOnSuccess },
                {
                    name: 'button-font-on-success-disabled',
                    color: button.fontOnSuccessDisabled,
                },
            ],
        },
    ];
    return {
        ...palette.reduce((rec, group) => ({
            ...rec,
            ...group.list.reduce((rec, item) => ({
                ...rec,
                [item.name]: item.color,
            }), {}),
        }), {}),
    };
};


/***/ }),

/***/ "./src/components/PaletteStyleTag/hooks/useCreateStyleContainer.ts":
/*!*************************************************************************!*\
  !*** ./src/components/PaletteStyleTag/hooks/useCreateStyleContainer.ts ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useCreateStyleContainer: function() { return /* binding */ useCreateStyleContainer; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const useCreateStyleContainer = (id) => (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    const refElement = document.getElementById('rcx-styles') || document.head.lastChild;
    const el = document.getElementById(id);
    if (el) {
        return el;
    }
    const styleElement = document.createElement('style');
    styleElement.setAttribute('id', id);
    document.head.insertBefore(styleElement, refElement);
    document.head.appendChild(document.createElement('style'));
    return styleElement;
}, [id]);


/***/ }),

/***/ "./src/components/PaletteStyleTag/index.ts":
/*!*************************************************!*\
  !*** ./src/components/PaletteStyleTag/index.ts ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PaletteStyleTag: function() { return /* reexport safe */ _PaletteStyleTag__WEBPACK_IMPORTED_MODULE_0__.PaletteStyleTag; }
/* harmony export */ });
/* harmony import */ var _PaletteStyleTag__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PaletteStyleTag */ "./src/components/PaletteStyleTag/PaletteStyleTag.tsx");



/***/ }),

/***/ "./src/components/PaletteStyleTag/lib/themePalettes.ts":
/*!*************************************************************!*\
  !*** ./src/components/PaletteStyleTag/lib/themePalettes.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   dark: function() { return /* binding */ dark; },
/* harmony export */   highContrast: function() { return /* binding */ highContrast; },
/* harmony export */   light: function() { return /* binding */ light; }
/* harmony export */ });
/* harmony import */ var _helpers_getPalette__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../helpers/getPalette */ "./src/components/PaletteStyleTag/helpers/getPalette.ts");

const light = (0,_helpers_getPalette__WEBPACK_IMPORTED_MODULE_0__.getThemePalette)('light');
const highContrast = (0,_helpers_getPalette__WEBPACK_IMPORTED_MODULE_0__.getThemePalette)('high-contrast');
const dark = (0,_helpers_getPalette__WEBPACK_IMPORTED_MODULE_0__.getThemePalette)('dark');


/***/ }),

/***/ "./src/components/PasswordInput/PasswordInput.tsx":
/*!********************************************************!*\
  !*** ./src/components/PasswordInput/PasswordInput.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../InputBox */ "./src/components/InputBox/index.ts");





const PasswordInput = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(function PasswordInput(props, ref) {
    const [hidden, toggle] = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useToggle)(true);
    const handleAddonClick = () => {
        toggle();
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBox__WEBPACK_IMPORTED_MODULE_4__.InputBox, { type: hidden ? 'password' : 'text', addon: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_3__.Icon, { name: hidden ? 'eye-off' : 'eye', size: 20, onClick: handleAddonClick }), ref: ref, ...props }));
});
/* harmony default export */ __webpack_exports__["default"] = (PasswordInput);


/***/ }),

/***/ "./src/components/PasswordInput/index.ts":
/*!***********************************************!*\
  !*** ./src/components/PasswordInput/index.ts ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* reexport safe */ _PasswordInput__WEBPACK_IMPORTED_MODULE_0__["default"]; }
/* harmony export */ });
/* harmony import */ var _PasswordInput__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PasswordInput */ "./src/components/PasswordInput/PasswordInput.tsx");



/***/ }),

/***/ "./src/components/Popover/Popover.tsx":
/*!********************************************!*\
  !*** ./src/components/Popover/Popover.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Popover: function() { return /* binding */ Popover; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-aria */ "react-aria");
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_aria__WEBPACK_IMPORTED_MODULE_2__);



function Popover(props) {
    const popoverRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    const { state, children, isNonModal } = props;
    const { popoverProps, underlayProps } = (0,react_aria__WEBPACK_IMPORTED_MODULE_2__.usePopover)({
        ...props,
        popoverRef,
    }, state);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_aria__WEBPACK_IMPORTED_MODULE_2__.Overlay, { children: [!isNonModal && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ...underlayProps }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { ...popoverProps, ref: popoverRef, children: [!isNonModal && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_aria__WEBPACK_IMPORTED_MODULE_2__.DismissButton, { onDismiss: state.close }), children, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_aria__WEBPACK_IMPORTED_MODULE_2__.DismissButton, { onDismiss: state.close })] })] }));
}


/***/ }),

/***/ "./src/components/Popover/index.ts":
/*!*****************************************!*\
  !*** ./src/components/Popover/index.ts ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Popover: function() { return /* reexport safe */ _Popover__WEBPACK_IMPORTED_MODULE_0__.Popover; }
/* harmony export */ });
/* harmony import */ var _Popover__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Popover */ "./src/components/Popover/Popover.tsx");



/***/ }),

/***/ "./src/components/Position/Position.tsx":
/*!**********************************************!*\
  !*** ./src/components/Position/Position.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-dom */ "react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_2__);



const Position = ({ anchor, children, placement, margin, className: _className, ...props }) => {
    const target = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    const { style: positionStyle, placement: positionPlacement } = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__.usePosition)(anchor, target, (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => ({ placement, margin }), [placement, margin])) || {};
    const style = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => ({ position: 'fixed', ...positionStyle }), [positionStyle]);
    const [portalContainer] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(() => {
        const prev = document.getElementById('position-container');
        if (prev) {
            return prev;
        }
        const element = document.createElement('div');
        element.id = 'position-container';
        document.body.appendChild(element);
        return element;
    });
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => () => {
        if (portalContainer.childNodes.length === 0) {
            document.body.removeChild(portalContainer);
        }
    }, [portalContainer]);
    return (0,react_dom__WEBPACK_IMPORTED_MODULE_2__.createPortal)((0,react__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(children, {
        ref: target,
        style,
        ...props,
        placement: positionPlacement,
    }), portalContainer);
};
/* harmony default export */ __webpack_exports__["default"] = (Position);


/***/ }),

/***/ "./src/components/Position/index.ts":
/*!******************************************!*\
  !*** ./src/components/Position/index.ts ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* reexport safe */ _Position__WEBPACK_IMPORTED_MODULE_0__["default"]; }
/* harmony export */ });
/* harmony import */ var _Position__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Position */ "./src/components/Position/Position.tsx");



/***/ }),

/***/ "./src/components/PositionAnimated/PositionAnimated.tsx":
/*!**************************************************************!*\
  !*** ./src/components/PositionAnimated/PositionAnimated.tsx ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../AnimatedVisibility */ "./src/components/AnimatedVisibility/index.ts");
/* harmony import */ var _Position__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Position */ "./src/components/Position/index.ts");



const PositionAnimated = ({ width: _width, visible, children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_AnimatedVisibility__WEBPACK_IMPORTED_MODULE_1__["default"], { visibility: visible, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Position__WEBPACK_IMPORTED_MODULE_2__["default"], { ...props, children: children }) }));
/* harmony default export */ __webpack_exports__["default"] = (PositionAnimated);


/***/ }),

/***/ "./src/components/PositionAnimated/index.ts":
/*!**************************************************!*\
  !*** ./src/components/PositionAnimated/index.ts ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* reexport safe */ _PositionAnimated__WEBPACK_IMPORTED_MODULE_0__["default"]; }
/* harmony export */ });
/* harmony import */ var _PositionAnimated__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PositionAnimated */ "./src/components/PositionAnimated/PositionAnimated.tsx");



/***/ }),

/***/ "./src/components/ProgressBar/ProgressBar.tsx":
/*!****************************************************!*\
  !*** ./src/components/ProgressBar/ProgressBar.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ProgressBar: function() { return /* binding */ ProgressBar; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const getWidth = (percentage) => `${Math.min(Math.max(0, percentage), 100).toFixed(1)}%`;
const colors = {
    info: 'status-font-on-info',
    success: 'status-font-on-success',
    warning: 'status-font-on-warning',
    danger: 'status-font-on-danger',
};
const lightColors = {
    info: 'status-background-info',
    success: 'status-background-success',
    warning: 'status-background-warning',
    danger: 'status-background-danger',
};
const getColor = (isLight, variant, error) => {
    if (error) {
        return isLight ? lightColors.danger : colors.danger;
    }
    return isLight ? lightColors[variant] : colors[variant];
};
/**
 * The `ProgressBar` is used to inform the user the progress of an operation.
 */
const ProgressBar = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function ProgressBar({ percentage, variant = 'info', error, animated, light = false, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { ref: ref, "rcx-progress-bar": true, title: error || undefined, overflow: 'hidden', ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { bg: getColor(light, variant, error), "rcx-progress-bar__fill--animated": animated, "rcx-progress-bar__fill": true, width: getWidth(percentage) }) }));
});


/***/ }),

/***/ "./src/components/ProgressBar/index.tsx":
/*!**********************************************!*\
  !*** ./src/components/ProgressBar/index.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ProgressBar: function() { return /* reexport safe */ _ProgressBar__WEBPACK_IMPORTED_MODULE_0__.ProgressBar; }
/* harmony export */ });
/* harmony import */ var _ProgressBar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProgressBar */ "./src/components/ProgressBar/ProgressBar.tsx");



/***/ }),

/***/ "./src/components/RadioButton/RadioButton.tsx":
/*!****************************************************!*\
  !*** ./src/components/RadioButton/RadioButton.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RadioButton: function() { return /* binding */ RadioButton; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const RadioButton = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function RadioButton({ className, labelChildren, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'label', className: className, "rcx-radio-button": true, children: [labelChildren, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'input', "rcx-radio-button__input": true, type: 'radio', ref: ref, ...props }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'i', "rcx-radio-button__fake": true, "aria-hidden": 'true' })] }));
});


/***/ }),

/***/ "./src/components/RadioButton/index.ts":
/*!*********************************************!*\
  !*** ./src/components/RadioButton/index.ts ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RadioButton: function() { return /* reexport safe */ _RadioButton__WEBPACK_IMPORTED_MODULE_0__.RadioButton; }
/* harmony export */ });
/* harmony import */ var _RadioButton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./RadioButton */ "./src/components/RadioButton/RadioButton.tsx");



/***/ }),

/***/ "./src/components/Scrollable/Scrollable.tsx":
/*!**************************************************!*\
  !*** ./src/components/Scrollable/Scrollable.tsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Scrollable: function() { return /* binding */ Scrollable; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/css-in-js */ "@rocket.chat/css-in-js");
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _helpers_appendClassName__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../helpers/appendClassName */ "./src/helpers/appendClassName.ts");
/* harmony import */ var _hooks_useStyle__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../hooks/useStyle */ "./src/hooks/useStyle.ts");
/* harmony import */ var _Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Box/BoxTransforms */ "./src/components/Box/BoxTransforms.ts");







const getTouchingEdges = (element) => ({
    top: !element.scrollTop,
    bottom: !(element.scrollTop + element.clientHeight - element.scrollHeight),
    left: !element.scrollLeft,
    right: !(element.scrollLeft + element.clientWidth - element.scrollWidth),
});
const pollTouchingEdges = (element, touchingEdgesRef, onScrollContent) => {
    const touchingEdges = touchingEdgesRef.current;
    const newTouchingEdges = getTouchingEdges(element);
    const dirty = touchingEdges &&
        (touchingEdges.top !== newTouchingEdges.top ||
            touchingEdges.bottom !== newTouchingEdges.bottom ||
            touchingEdges.left !== newTouchingEdges.left ||
            touchingEdges.right !== newTouchingEdges.right);
    if (dirty) {
        touchingEdgesRef.current = newTouchingEdges;
        onScrollContent?.(newTouchingEdges);
    }
};
/**
 * Add scroll capability to the wrapped component.
 */
const Scrollable = ({ children, horizontal, vertical, smooth, onScrollContent, }) => {
    const scrollTimeoutRef = (0,react__WEBPACK_IMPORTED_MODULE_3__.useRef)();
    const touchingEdgesRef = (0,react__WEBPACK_IMPORTED_MODULE_3__.useRef)({});
    const handleScroll = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_2__.useEffectEvent)((event) => {
        const element = event.currentTarget;
        if (!scrollTimeoutRef.current) {
            pollTouchingEdges(element, touchingEdgesRef, onScrollContent);
        }
        if (scrollTimeoutRef.current)
            clearTimeout(scrollTimeoutRef.current);
        scrollTimeoutRef.current = setTimeout(() => {
            scrollTimeoutRef.current = undefined;
            pollTouchingEdges(element, touchingEdgesRef, onScrollContent);
        }, 200);
    });
    const className = (0,_hooks_useStyle__WEBPACK_IMPORTED_MODULE_5__.useStyle)((0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
      position: relative;

      &::-webkit-scrollbar {
        width: ${4 / 16}rem;
        height: ${4 / 16}rem;
      }

      &::-webkit-scrollbar-track {
        background-color: transparent;
      }

      &::-webkit-scrollbar-thumb {
        background-color: rgba(0, 0, 0, 0.05);
        background-color: var(
          --rcx-theme-scrollbar-thumb-color,
          rgba(0, 0, 0, 0.05)
        );
      }

      &:hover::-webkit-scrollbar-thumb {
        background-color: rgba(0, 0, 0, 0.15);
        background-color: var(
          --rcx-theme-scrollbar-thumb-hover-color,
          rgba(0, 0, 0, 0.15)
        );
      }

      ${(horizontal &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
          overflow-x: auto !important;
        `) ||
        (vertical &&
            (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
          overflow-y: auto !important;
        `) ||
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
        overflow: auto !important;
      `}
      ${smooth &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
        scroll-behavior: smooth !important;
      `}
    `, null);
    const transformFn = (0,react__WEBPACK_IMPORTED_MODULE_3__.useCallback)((props) => {
        props.className =
            className && (0,_helpers_appendClassName__WEBPACK_IMPORTED_MODULE_4__.appendClassName)(props.className, className);
        if (onScrollContent !== undefined && props.onScroll === undefined) {
            props.onScroll = handleScroll;
        }
        return props;
    }, [className, handleScroll, onScrollContent]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_6__.BoxTransforms.Provider, { children: children, value: (0,_Box_BoxTransforms__WEBPACK_IMPORTED_MODULE_6__.useComposedBoxTransform)(transformFn) }));
};


/***/ }),

/***/ "./src/components/Scrollable/index.ts":
/*!********************************************!*\
  !*** ./src/components/Scrollable/index.ts ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Scrollable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Scrollable */ "./src/components/Scrollable/Scrollable.tsx");

/* harmony default export */ __webpack_exports__["default"] = (_Scrollable__WEBPACK_IMPORTED_MODULE_0__.Scrollable);


/***/ }),

/***/ "./src/components/SearchInput/SearchInput.tsx":
/*!****************************************************!*\
  !*** ./src/components/SearchInput/SearchInput.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SearchInput: function() { return /* binding */ SearchInput; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../InputBox */ "./src/components/InputBox/index.ts");



/**
 * An input for search queries.
 */
const SearchInput = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function SearchInput(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBox__WEBPACK_IMPORTED_MODULE_2__.InputBox, { type: 'search', ref: ref, ...props });
});


/***/ }),

/***/ "./src/components/SearchInput/index.tsx":
/*!**********************************************!*\
  !*** ./src/components/SearchInput/index.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SearchInput: function() { return /* reexport safe */ _SearchInput__WEBPACK_IMPORTED_MODULE_0__.SearchInput; }
/* harmony export */ });
/* harmony import */ var _SearchInput__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SearchInput */ "./src/components/SearchInput/SearchInput.tsx");



/***/ }),

/***/ "./src/components/Select/Listbox.tsx":
/*!*******************************************!*\
  !*** ./src/components/Select/Listbox.tsx ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ListBox: function() { return /* binding */ ListBox; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-aria */ "react-aria");
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_aria__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Option__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Option */ "./src/components/Option/index.ts");




function ListBox(props) {
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    const { listBoxRef = ref, state } = props;
    const { listBoxProps } = (0,react_aria__WEBPACK_IMPORTED_MODULE_2__.useListBox)(props, state, listBoxRef);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ...listBoxProps, ref: listBoxRef, children: [...state.collection].map((item) => item.type === 'section' ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ListBoxSection, { section: item, state: state }, item.key)) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(OptionAria, { item: item, state: state }, item.key))) }));
}
function ListBoxSection({ section, state }) {
    const { itemProps, headingProps, groupProps } = (0,react_aria__WEBPACK_IMPORTED_MODULE_2__.useListBoxSection)({
        'heading': section.rendered,
        'aria-label': section['aria-label'],
    });
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("li", { ...itemProps, className: 'pt-2', children: [section.rendered && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { ...headingProps, className: 'text-xs font-bold uppercase text-gray-500 mx-3', children: section.rendered })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", { ...groupProps, children: [...section.childNodes].map((node) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(OptionAria, { item: node, state: state }, node.key))) })] }) }));
}
function OptionAria({ item, state }) {
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)(null);
    const { optionProps, isDisabled, isSelected, isFocused } = (0,react_aria__WEBPACK_IMPORTED_MODULE_2__.useOption)({
        key: item.key,
    }, state, ref);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Option__WEBPACK_IMPORTED_MODULE_3__.Option, { ref: ref, disabled: isDisabled, selected: isSelected, focus: isFocused, label: item.rendered, ...optionProps, children: item.rendered }, item.key));
}


/***/ }),

/***/ "./src/components/Select/Select.tsx":
/*!******************************************!*\
  !*** ./src/components/Select/Select.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Select: function() { return /* binding */ Select; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_stately__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-stately */ "react-stately");
/* harmony import */ var react_stately__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_stately__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _SelectAria__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SelectAria */ "./src/components/Select/SelectAria.tsx");




/**
 * An input for selection of options.
 */
const Select = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Select({ options, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SelectAria__WEBPACK_IMPORTED_MODULE_3__.SelectAria, { ref: ref, ...props, children: options.map((option) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_stately__WEBPACK_IMPORTED_MODULE_2__.Item, { title: option[1] ?? option[0], textValue: option[0], children: option[1] ?? option[0] }, option[0]))) }));
});


/***/ }),

/***/ "./src/components/Select/SelectAddon.tsx":
/*!***********************************************!*\
  !*** ./src/components/Select/SelectAddon.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const SelectAddon = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function SelectAddon(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'div', "rcx-select__addon": true, ref: ref, ...props });
});
/* harmony default export */ __webpack_exports__["default"] = (SelectAddon);


/***/ }),

/***/ "./src/components/Select/SelectAria.tsx":
/*!**********************************************!*\
  !*** ./src/components/Select/SelectAria.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Item: function() { return /* reexport safe */ react_stately__WEBPACK_IMPORTED_MODULE_4__.Item; },
/* harmony export */   SelectAria: function() { return /* binding */ SelectAria; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-aria */ "react-aria");
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_aria__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_stately__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-stately */ "react-stately");
/* harmony import */ var react_stately__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_stately__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _Box_Box__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box/Box */ "./src/components/Box/Box.tsx");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");
/* harmony import */ var _Options__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Options */ "./src/components/Options/index.ts");
/* harmony import */ var _Popover__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Popover */ "./src/components/Popover/index.ts");
/* harmony import */ var _Listbox__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Listbox */ "./src/components/Select/Listbox.tsx");
/* harmony import */ var _SelectTrigger__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./SelectTrigger */ "./src/components/Select/SelectTrigger.tsx");












const SelectAria = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(function SelectAria({ error, placeholder, value, onChange, small, isDisabled: isDisabledProps, disabled, id, ...props }, outerRef) {
    const isDisabled = isDisabledProps || disabled;
    const state = (0,react_stately__WEBPACK_IMPORTED_MODULE_4__.useSelectState)({
        isDisabled,
        selectedKey: typeof value !== 'bigint' ? value : null,
        onSelectionChange: onChange,
        ...props,
    });
    const { ref, borderBoxSize } = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useResizeObserver)();
    const mergedRef = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useMergedRefs)(outerRef, ref);
    const { triggerProps, valueProps, menuProps } = (0,react_aria__WEBPACK_IMPORTED_MODULE_3__.useSelect)({ isDisabled, ...props }, state, ref);
    const { focusProps, isFocusVisible } = (0,react_aria__WEBPACK_IMPORTED_MODULE_3__.useFocusRing)();
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_SelectTrigger__WEBPACK_IMPORTED_MODULE_10__.SelectTrigger, { ...(0,react_aria__WEBPACK_IMPORTED_MODULE_3__.mergeProps)(focusProps, triggerProps), ref: mergedRef, small: small, focus: isFocusVisible || state.isOpen, error: error, id: id, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_aria__WEBPACK_IMPORTED_MODULE_3__.HiddenSelect, { state: state, triggerRef: ref, label: props.label, name: props.name, isDisabled: isDisabled }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box_Box__WEBPACK_IMPORTED_MODULE_5__["default"], { is: 'span', color: state.selectedItem ? 'default' : 'hint', ...valueProps, ...(small && { fontScale: 'c1' }), children: state.selectedItem ? state.selectedItem.rendered : placeholder }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_6__.Icon, { color: 'default', name: state.isOpen ? 'chevron-up' : 'chevron-down', size: 'x20' })] }), state.isOpen && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Popover__WEBPACK_IMPORTED_MODULE_8__.Popover, { state: state, triggerRef: ref, placement: 'bottom', offset: 4, containerPadding: 8, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Options__WEBPACK_IMPORTED_MODULE_7__.OptionContainer, { style: {
                        width: borderBoxSize?.inlineSize,
                    }, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Listbox__WEBPACK_IMPORTED_MODULE_9__.ListBox, { ...menuProps, state: state }) }) }))] }));
});


/***/ }),

/***/ "./src/components/Select/SelectFiltered.tsx":
/*!**************************************************!*\
  !*** ./src/components/Select/SelectFiltered.tsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectFiltered: function() { return /* binding */ SelectFiltered; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! . */ "./src/components/Select/index.ts");
/* harmony import */ var _SelectFilteredAnchor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SelectFilteredAnchor */ "./src/components/Select/SelectFilteredAnchor.tsx");




const SelectFiltered = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function SelectFiltered({ options, placeholder, filter: propFilter, setFilter: propSetFilter, ...props }, ref) {
    const [filter, setFilter] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)('');
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_2__.SelectLegacy, { ref: ref, placeholder: placeholder, filter: propFilter || filter, options: options, ...props, anchor: (params) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SelectFilteredAnchor__WEBPACK_IMPORTED_MODULE_3__["default"], { placeholder: placeholder, filter: propFilter || filter, onChangeFilter: propSetFilter || setFilter, ...params })) }));
});


/***/ }),

/***/ "./src/components/Select/SelectFilteredAnchor.tsx":
/*!********************************************************!*\
  !*** ./src/components/Select/SelectFilteredAnchor.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../InputBox */ "./src/components/InputBox/index.ts");



const SelectFilteredAnchor = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function SelectFilteredAnchor({ children: _children, filter, onChangeFilter, placeholder, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBox__WEBPACK_IMPORTED_MODULE_2__.Input, { mi: 4, flexGrow: 1, className: 'rcx-select__focus', ref: ref, placeholder: placeholder, value: filter, onInput: (e) => onChangeFilter(e.currentTarget.value), ...props, "rcx-input-box--undecorated": true }));
});
/* harmony default export */ __webpack_exports__["default"] = (SelectFilteredAnchor);


/***/ }),

/***/ "./src/components/Select/SelectFocus.tsx":
/*!***********************************************!*\
  !*** ./src/components/Select/SelectFocus.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const SelectFocus = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function SelectFocus(props, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { ref: ref, fontScale: 'p2m', color: 'hint', "rcx-select__focus": true, is: 'button', type: 'button', ...props }));
});
/* harmony default export */ __webpack_exports__["default"] = (SelectFocus);


/***/ }),

/***/ "./src/components/Select/SelectLegacy.tsx":
/*!************************************************!*\
  !*** ./src/components/Select/SelectLegacy.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectLegacy: function() { return /* binding */ SelectLegacy; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _helpers_isForwardRefType__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers/isForwardRefType */ "./src/helpers/isForwardRefType.ts");
/* harmony import */ var _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../AnimatedVisibility */ "./src/components/AnimatedVisibility/index.ts");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");
/* harmony import */ var _Margins__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Margins */ "./src/components/Margins/index.ts");
/* harmony import */ var _Options__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Options */ "./src/components/Options/index.ts");
/* harmony import */ var _PositionAnimated__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../PositionAnimated */ "./src/components/PositionAnimated/index.ts");
/* harmony import */ var _SelectAddon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./SelectAddon */ "./src/components/Select/SelectAddon.tsx");
/* harmony import */ var _SelectFocus__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./SelectFocus */ "./src/components/Select/SelectFocus.tsx");












const Wrapper = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)((props, ref) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_5__["default"], { is: 'div', "rcx-select__wrapper": true, ref: ref, ...props })));
const useDidUpdate = (func, deps) => {
    const didMount = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(false);
    const fn = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useEffectEvent)(func);
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        if (didMount.current) {
            fn();
        }
        didMount.current = true;
    }, deps || []);
};
const SelectLegacy = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({ value, filter, error, disabled, options = [], anchor: Anchor = _SelectFocus__WEBPACK_IMPORTED_MODULE_11__["default"], onChange = () => { }, getValue = ([value] = ['', '']) => value, getLabel = ([, label] = ['', '']) => label, placeholder = '', renderItem, renderSelected: RenderSelected, renderOptions: _Options = _Options__WEBPACK_IMPORTED_MODULE_8__.Options, addonIcon, customEmpty, ...props }, ref) => {
    const [internalValue, setInternalValue] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(value || '');
    const internalChangedByKeyboard = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useEffectEvent)(([value]) => {
        setInternalValue(value);
        onChange(value); // FIXME
    });
    const option = options.find((option) => getValue(option) === internalValue);
    const index = options.indexOf(option);
    const filteredOptions = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
        const mapOptions = ([value, label]) => {
            if (internalValue === value) {
                return [value, label, true];
            }
            return [value, label];
        };
        const applyFilter = ([, option]) => !filter || ~option.toLowerCase().indexOf(filter.toLowerCase());
        return options.filter(applyFilter).map(mapOptions);
    }, [options, internalValue, filter]);
    const [cursor, handleKeyDown, handleKeyUp, reset, [visible, hide, show]] = (0,_Options__WEBPACK_IMPORTED_MODULE_8__.useCursor)(index, filteredOptions, internalChangedByKeyboard);
    const innerRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const anchorRef = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useMergedRefs)(ref, innerRef);
    const removeFocusClass = () => innerRef.current?.classList.remove('focus-visible');
    const internalChangedByClick = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useEffectEvent)(([value]) => {
        setInternalValue(value);
        onChange(value); // FIXME
        removeFocusClass();
        hide();
    });
    const renderAnchor = (params) => {
        if ((0,_helpers_isForwardRefType__WEBPACK_IMPORTED_MODULE_3__.isForwardRefType)(Anchor)) {
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Anchor, { ...params });
        }
        if (typeof Anchor === 'function') {
            return Anchor(params);
        }
        return null;
    };
    const { ref: containerRef, borderBoxSize } = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useResizeObserver)();
    useDidUpdate(reset, [filter, internalValue]);
    (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useOutsideClick)([containerRef], removeFocusClass);
    const valueLabel = getLabel(option);
    const visibleText = (filter === undefined || visible === _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_4__["default"].HIDDEN) &&
        (valueLabel || placeholder || typeof placeholder === 'string');
    const handleClick = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_1__.useEffectEvent)(() => {
        if (innerRef.current?.classList.contains('focus-visible')) {
            removeFocusClass();
            return hide();
        }
        innerRef.current?.classList.add('focus-visible');
        innerRef.current?.focus();
        return show();
    });
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_5__["default"], { "rcx-select": true, disabled: disabled, ref: containerRef, onClick: handleClick, className: (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => [error && 'invalid', disabled && 'disabled'], [error, disabled]), ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(Wrapper, { display: 'flex', mi: 'neg-x4', "rcx-select__wrapper--hidden": !!visibleText, children: [visibleText &&
                        (RenderSelected ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(RenderSelected, { role: 'option', value: getValue(option), label: valueLabel, onClick: internalChangedByClick }, getValue(option))) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_5__["default"], { flexGrow: 1, is: 'span', mi: 4, "rcx-select__item": true, fontScale: 'p2', color: valueLabel ? 'default' : 'hint', children: visibleText }))), renderAnchor({
                        ref: anchorRef,
                        children: !value ? option || placeholder : null,
                        disabled: disabled ?? false,
                        onClick: show,
                        onBlur: hide,
                        onKeyDown: handleKeyDown,
                        onKeyUp: handleKeyUp,
                    }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Margins__WEBPACK_IMPORTED_MODULE_7__["default"], { inline: 'x4', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SelectAddon__WEBPACK_IMPORTED_MODULE_10__["default"], { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_6__.Icon, { name: visible === _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_4__["default"].VISIBLE
                                    ? 'chevron-up'
                                    : addonIcon || 'chevron-down', size: 'x20' }) }) })] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_PositionAnimated__WEBPACK_IMPORTED_MODULE_9__["default"], { visible: visible, anchor: containerRef, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Options, { width: borderBoxSize.inlineSize, role: 'listbox', filter: filter, options: filteredOptions, onSelect: internalChangedByClick, renderItem: renderItem, cursor: cursor, customEmpty: customEmpty }) })] }));
});


/***/ }),

/***/ "./src/components/Select/SelectTrigger.tsx":
/*!*************************************************!*\
  !*** ./src/components/Select/SelectTrigger.tsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectTrigger: function() { return /* binding */ SelectTrigger; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-aria */ "react-aria");
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_aria__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");




const SelectTrigger = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(({ small, error, isDisabled, focus, id, ...props }, ref) => {
    const { buttonProps } = (0,react_aria__WEBPACK_IMPORTED_MODULE_2__.useButton)(props, ref);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_3__["default"], { ...buttonProps, id: id, "rcx-select": true, ref: ref, is: 'button', display: 'flex', flexDirection: 'row', fontScale: 'p2', justifyContent: 'space-between', "rcx-input-box--small": small, className: [
            error && 'invalid',
            isDisabled && 'disabled',
            focus && 'focus',
        ]
            .filter(Boolean)
            .join(' '), children: props.children }));
});


/***/ }),

/***/ "./src/components/Select/index.ts":
/*!****************************************!*\
  !*** ./src/components/Select/index.ts ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Select: function() { return /* reexport safe */ _Select__WEBPACK_IMPORTED_MODULE_1__.Select; },
/* harmony export */   SelectFiltered: function() { return /* reexport safe */ _SelectFiltered__WEBPACK_IMPORTED_MODULE_2__.SelectFiltered; },
/* harmony export */   SelectLegacy: function() { return /* reexport safe */ _SelectLegacy__WEBPACK_IMPORTED_MODULE_0__.SelectLegacy; }
/* harmony export */ });
/* harmony import */ var _SelectLegacy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SelectLegacy */ "./src/components/Select/SelectLegacy.tsx");
/* harmony import */ var _Select__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Select */ "./src/components/Select/Select.tsx");
/* harmony import */ var _SelectFiltered__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SelectFiltered */ "./src/components/Select/SelectFiltered.tsx");





/***/ }),

/***/ "./src/components/SelectInput/SelectInput.tsx":
/*!****************************************************!*\
  !*** ./src/components/SelectInput/SelectInput.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../InputBox */ "./src/components/InputBox/index.ts");
/* harmony import */ var _SelectInputPlaceholder__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SelectInputPlaceholder */ "./src/components/SelectInput/SelectInputPlaceholder.tsx");





/**
 * An input for selection of options.
 */
const SelectInput = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function SelectInput({ children, multiple, placeholder, onChange, ...props }, ref) {
    const [isPlaceholderVisible, setPlaceholderVisible] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(!props.value && !props.defaultValue);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        setPlaceholderVisible(!event.currentTarget.value);
        onChange?.call(event.currentTarget, event);
    }, [onChange]);
    if (multiple) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBox__WEBPACK_IMPORTED_MODULE_3__.InputBox, { children: children, ...props, multiple: true, type: 'select', onChange: handleChange }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_InputBox__WEBPACK_IMPORTED_MODULE_3__.InputBox, { placeholderVisible: isPlaceholderVisible ? !!placeholder : undefined, ref: ref, ...props, addon: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_2__.Icon, { name: 'chevron-down', size: 'x20' }), type: 'select', onChange: handleChange, children: [placeholder && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SelectInputPlaceholder__WEBPACK_IMPORTED_MODULE_4__["default"], { value: '', children: placeholder })), children] }));
});
/* harmony default export */ __webpack_exports__["default"] = (SelectInput);


/***/ }),

/***/ "./src/components/SelectInput/SelectInputOption.tsx":
/*!**********************************************************!*\
  !*** ./src/components/SelectInput/SelectInputOption.tsx ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const SelectInputOption = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function SelectInputOption(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'option', "rcx-input-box__option": true, ref: ref, ...props });
});
/* harmony default export */ __webpack_exports__["default"] = (SelectInputOption);


/***/ }),

/***/ "./src/components/SelectInput/SelectInputPlaceholder.tsx":
/*!***************************************************************!*\
  !*** ./src/components/SelectInput/SelectInputPlaceholder.tsx ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const SelectInputPlaceholder = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Placeholder(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'option', "rcx-input-box__placeholder": true, ref: ref, ...props });
});
/* harmony default export */ __webpack_exports__["default"] = (SelectInputPlaceholder);


/***/ }),

/***/ "./src/components/SelectInput/index.ts":
/*!*********************************************!*\
  !*** ./src/components/SelectInput/index.ts ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectInput: function() { return /* reexport safe */ _SelectInput__WEBPACK_IMPORTED_MODULE_0__["default"]; },
/* harmony export */   SelectInputOption: function() { return /* reexport safe */ _SelectInputOption__WEBPACK_IMPORTED_MODULE_1__["default"]; }
/* harmony export */ });
/* harmony import */ var _SelectInput__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SelectInput */ "./src/components/SelectInput/SelectInput.tsx");
/* harmony import */ var _SelectInputOption__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SelectInputOption */ "./src/components/SelectInput/SelectInputOption.tsx");




/***/ }),

/***/ "./src/components/Sidebar/Item.tsx":
/*!*****************************************!*\
  !*** ./src/components/Sidebar/Item.tsx ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarItem: function() { return /* binding */ SidebarItem; },
/* harmony export */   SidebarItemAction: function() { return /* binding */ SidebarItemAction; },
/* harmony export */   SidebarItemActions: function() { return /* binding */ SidebarItemActions; },
/* harmony export */   SidebarItemAvatar: function() { return /* binding */ SidebarItemAvatar; },
/* harmony export */   SidebarItemBadge: function() { return /* binding */ SidebarItemBadge; },
/* harmony export */   SidebarItemContainer: function() { return /* binding */ SidebarItemContainer; },
/* harmony export */   SidebarItemContent: function() { return /* binding */ SidebarItemContent; },
/* harmony export */   SidebarItemIcon: function() { return /* binding */ SidebarItemIcon; },
/* harmony export */   SidebarItemMenu: function() { return /* binding */ SidebarItemMenu; },
/* harmony export */   SidebarItemSubtitle: function() { return /* binding */ SidebarItemSubtitle; },
/* harmony export */   SidebarItemTime: function() { return /* binding */ SidebarItemTime; },
/* harmony export */   SidebarItemTitle: function() { return /* binding */ SidebarItemTitle; },
/* harmony export */   SidebarItemWrapper: function() { return /* binding */ SidebarItemWrapper; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");
/* harmony import */ var _SidebarActions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SidebarActions */ "./src/components/Sidebar/SidebarActions.tsx");



/**
 * Item component to be used inside Sidebar.
 */
const SidebarItem = ({ selected, highlighted, clickable, featured, is: Tag = 'div', children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Tag, { className: [
        'rc-box rcx-box--full rcx-sidebar-item',
        highlighted && 'rcx-sidebar-item--highlighted',
        (clickable || Tag === 'a') && 'rcx-sidebar-item--clickable',
        selected && 'rcx-sidebar-item--selected',
        featured && 'rcx-sidebar-item--featured',
    ]
        .filter(Boolean)
        .join(' '), ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-sidebar-item__wrapper', children: children }) }));
const SidebarItemContainer = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rc-box rcx-box--full rcx-sidebar-item__container', ...props }));
const SidebarItemMenu = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rc-box rcx-box--full rcx-box--animated rcx-sidebar-item__menu-wrapper', ...props }));
const SidebarItemContent = ({ className = '', ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: `rc-box rcx-box--full rcx-sidebar-item__container rcx-sidebar-item__content ${className}`, ...props }));
const SidebarItemTitle = ({ className = '', ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: `rc-box rcx-box--full rcx-sidebar-item__title ${className}`, ...props }));
const SidebarItemTime = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: `rc-box rcx-box--full rcx-sidebar-item__time ${className}`, ...props }));
const SidebarItemBadge = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: `rc-box rcx-box--full rcx-sidebar-item__badge ${className}`, ...props }));
const SidebarItemSubtitle = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: `rc-box rcx-box--full rcx-sidebar-item__subtitle ${className}`, ...props }));
const SidebarItemWrapper = ({ className = '', ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: `rc-box rcx-box--full rcx-sidebar-item__wrapper ${className}`, ...props }));
const SidebarItemIcon = ({ highlighted, children, icon, className: _className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: [
        'rc-box rcx-box--full rcx-sidebar-item__icon',
        highlighted && 'rcx-sidebar-item__icon--highlighted',
    ]
        .filter(Boolean)
        .join(' '), ...props, children: children || (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__.Icon, { size: 'x16', name: icon, ...props }) }));
const SidebarItemAvatar = ({ ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SidebarItemContainer, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rc-box rcx-box--full rcx-sidebar-item__avatar', ...props }) }));
const SidebarItemActions = _SidebarActions__WEBPACK_IMPORTED_MODULE_2__.SidebarActions;
const SidebarItemAction = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SidebarActions__WEBPACK_IMPORTED_MODULE_2__.SidebarAction, { ...props }));
/* harmony default export */ __webpack_exports__["default"] = (Object.assign(SidebarItem, {
    Menu: SidebarItemMenu,
    Container: SidebarItemContainer,
    Content: SidebarItemContent,
    Title: SidebarItemTitle,
    Subtitle: SidebarItemSubtitle,
    Time: SidebarItemTime,
    Wrapper: SidebarItemWrapper,
    Icon: SidebarItemIcon,
    Avatar: SidebarItemAvatar,
    Actions: SidebarItemActions,
    Action: SidebarItemAction,
    Badge: SidebarItemBadge,
}));


/***/ }),

/***/ "./src/components/Sidebar/Section.tsx":
/*!********************************************!*\
  !*** ./src/components/Sidebar/Section.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarSection: function() { return /* binding */ SidebarSection; },
/* harmony export */   SidebarSectionTitle: function() { return /* binding */ SidebarSectionTitle; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidebarSectionTitle = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-sidebar-title', ...props }));
const SidebarSection = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-sidebar-section', ...props }));
/* harmony default export */ __webpack_exports__["default"] = (Object.assign(SidebarSection, {
    Title: SidebarSectionTitle,
}));


/***/ }),

/***/ "./src/components/Sidebar/SidebarActions.tsx":
/*!***************************************************!*\
  !*** ./src/components/Sidebar/SidebarActions.tsx ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarAction: function() { return /* binding */ SidebarAction; },
/* harmony export */   SidebarActions: function() { return /* binding */ SidebarActions; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Button */ "./src/components/Button/index.ts");
/* harmony import */ var _ButtonGroup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../ButtonGroup */ "./src/components/ButtonGroup/index.ts");




const SidebarActions = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function SidebarActions(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ButtonGroup__WEBPACK_IMPORTED_MODULE_3__.ButtonGroup, { ref: ref, ...props });
});
const SidebarAction = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function SidebarAction(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_2__.IconButton, { small: true, ref: ref, ...props });
});


/***/ }),

/***/ "./src/components/Sidebar/SidebarBanner.tsx":
/*!**************************************************!*\
  !*** ./src/components/Sidebar/SidebarBanner.tsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarBanner: function() { return /* binding */ SidebarBanner; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./src/components/Button/index.ts");


const SidebarBanner = ({ text, description, onClick, variant = 'default', addon, onClose, children, }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: `rcx-box rcx-box--full rcx-sidebar-banner rcx-sidebar-banner--${variant}`, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [text && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-sidebar-banner--text', children: text }), description && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { role: onClick ? 'link' : undefined, tabIndex: 0, className: [
                        'rcx-sidebar-banner--description',
                        onClick && 'rcx-sidebar-banner--description--clickable',
                    ]
                        .filter(Boolean)
                        .join(' '), onClick: onClick, onKeyDown: (e) => e.key === 'Enter' && onClick?.(), children: description })), children] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'rcx-sidebar-banner__actions', children: [addon, onClose && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__.IconButton, { onClick: onClose, tiny: true, icon: 'cross' })] })] }));


/***/ }),

/***/ "./src/components/Sidebar/SidebarDivider.tsx":
/*!***************************************************!*\
  !*** ./src/components/Sidebar/SidebarDivider.tsx ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarDivider: function() { return /* binding */ SidebarDivider; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Divider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Divider */ "./src/components/Divider/index.tsx");


const SidebarDivider = () => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Divider__WEBPACK_IMPORTED_MODULE_1__.Divider, { "rcx-sidebar--divider": true, mbs: -2, mbe: 0 }));


/***/ }),

/***/ "./src/components/Sidebar/SidebarFooter.tsx":
/*!**************************************************!*\
  !*** ./src/components/Sidebar/SidebarFooter.tsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarFooter: function() { return /* binding */ SidebarFooter; },
/* harmony export */   SidebarFooterHighlight: function() { return /* binding */ SidebarFooterHighlight; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidebarFooter = ({ elevated, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: [
        'rcx-box rcx-box--full rcx-sidebar-footer',
        elevated && 'rcx-sidebar-footer--elevated',
    ]
        .filter(Boolean)
        .join(' '), ...props }));
const SidebarFooterHighlight = ({ ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-sidebar-footer__highlights', ...props }));


/***/ }),

/***/ "./src/components/Sidebar/TopBar/TopBar.tsx":
/*!**************************************************!*\
  !*** ./src/components/Sidebar/TopBar/TopBar.tsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TopBar: function() { return /* binding */ TopBar; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

/**
 * Sidebar TopBar and ToolBox.
 */
const TopBar = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: ['rc-box rc-box--full rcx-sidebar-topbar', className]
        .filter(Boolean)
        .join(' '), ...props }));


/***/ }),

/***/ "./src/components/Sidebar/TopBar/TopBarAction.tsx":
/*!********************************************************!*\
  !*** ./src/components/Sidebar/TopBar/TopBarAction.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TopBarAction: function() { return /* binding */ TopBarAction; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _SidebarActions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../SidebarActions */ "./src/components/Sidebar/SidebarActions.tsx");



const TopBarAction = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function TopBarAction(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SidebarActions__WEBPACK_IMPORTED_MODULE_2__.SidebarAction, { ref: ref, ...props });
});


/***/ }),

/***/ "./src/components/Sidebar/TopBar/TopBarActions.tsx":
/*!*********************************************************!*\
  !*** ./src/components/Sidebar/TopBar/TopBarActions.tsx ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TopBarActions: function() { return /* binding */ TopBarActions; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _SidebarActions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../SidebarActions */ "./src/components/Sidebar/SidebarActions.tsx");



const TopBarActions = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function TopBarActions(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SidebarActions__WEBPACK_IMPORTED_MODULE_2__.SidebarActions, { ref: ref, ...props });
});


/***/ }),

/***/ "./src/components/Sidebar/TopBar/TopBarSection.tsx":
/*!*********************************************************!*\
  !*** ./src/components/Sidebar/TopBar/TopBarSection.tsx ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TopBarSection: function() { return /* binding */ TopBarSection; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SidebarDivider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../SidebarDivider */ "./src/components/Sidebar/SidebarDivider.tsx");
/* harmony import */ var _TopBar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TopBar */ "./src/components/Sidebar/TopBar/TopBar.tsx");
/* harmony import */ var _TopBarWrapper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TopBarWrapper */ "./src/components/Sidebar/TopBar/TopBarWrapper.tsx");




const TopBarSection = ({ className, children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_TopBar__WEBPACK_IMPORTED_MODULE_2__.TopBar, { className: ['rcx-sidebar-topbar--section', className]
        .filter(Boolean)
        .join(' '), ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_TopBarWrapper__WEBPACK_IMPORTED_MODULE_3__.TopBarWrapper, { children: children }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SidebarDivider__WEBPACK_IMPORTED_MODULE_1__.SidebarDivider, {})] }));


/***/ }),

/***/ "./src/components/Sidebar/TopBar/TopBarTitle.tsx":
/*!*******************************************************!*\
  !*** ./src/components/Sidebar/TopBar/TopBarTitle.tsx ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TopBarTitle: function() { return /* binding */ TopBarTitle; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Box */ "./src/components/Box/index.ts");


const TopBarTitle = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { className: 'rcx-sidebar-topbar__title', withTruncatedText: true, ...props }));


/***/ }),

/***/ "./src/components/Sidebar/TopBar/TopBarToolBox.tsx":
/*!*********************************************************!*\
  !*** ./src/components/Sidebar/TopBar/TopBarToolBox.tsx ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TopBarToolBox: function() { return /* binding */ TopBarToolBox; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SidebarDivider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../SidebarDivider */ "./src/components/Sidebar/SidebarDivider.tsx");
/* harmony import */ var _TopBar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TopBar */ "./src/components/Sidebar/TopBar/TopBar.tsx");
/* harmony import */ var _TopBarWrapper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TopBarWrapper */ "./src/components/Sidebar/TopBar/TopBarWrapper.tsx");




const TopBarToolBox = ({ children, className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_TopBar__WEBPACK_IMPORTED_MODULE_2__.TopBar, { className: ['rcx-sidebar-topbar--toolbox', className]
        .filter(Boolean)
        .join(' '), ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_TopBarWrapper__WEBPACK_IMPORTED_MODULE_3__.TopBarWrapper, { children: children }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SidebarDivider__WEBPACK_IMPORTED_MODULE_1__.SidebarDivider, {})] }));


/***/ }),

/***/ "./src/components/Sidebar/TopBar/TopBarV2.tsx":
/*!****************************************************!*\
  !*** ./src/components/Sidebar/TopBar/TopBarV2.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TopBarV2: function() { return /* binding */ TopBarV2; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const TopBarV2 = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: [
        'rc-box rc-box--full rcx-sidebar-topbar-v2 rcx-sidebar-topbar-v2',
        className,
    ]
        .filter(Boolean)
        .join(' '), ...props }));


/***/ }),

/***/ "./src/components/Sidebar/TopBar/TopBarWrapper.tsx":
/*!*********************************************************!*\
  !*** ./src/components/Sidebar/TopBar/TopBarWrapper.tsx ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TopBarWrapper: function() { return /* binding */ TopBarWrapper; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const TopBarWrapper = ({ children }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rc-box rc-box--full rcx-sidebar-topbar__wrapper', children: children }));


/***/ }),

/***/ "./src/components/Sidebar/TopBar/index.ts":
/*!************************************************!*\
  !*** ./src/components/Sidebar/TopBar/index.ts ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TopBar: function() { return /* reexport safe */ _TopBar__WEBPACK_IMPORTED_MODULE_1__.TopBar; },
/* harmony export */   TopBarAction: function() { return /* reexport safe */ _TopBarAction__WEBPACK_IMPORTED_MODULE_2__.TopBarAction; },
/* harmony export */   TopBarActions: function() { return /* reexport safe */ _TopBarActions__WEBPACK_IMPORTED_MODULE_3__.TopBarActions; },
/* harmony export */   TopBarAvatar: function() { return /* binding */ TopBarAvatar; },
/* harmony export */   TopBarSection: function() { return /* reexport safe */ _TopBarSection__WEBPACK_IMPORTED_MODULE_4__.TopBarSection; },
/* harmony export */   TopBarTitle: function() { return /* reexport safe */ _TopBarTitle__WEBPACK_IMPORTED_MODULE_5__.TopBarTitle; },
/* harmony export */   TopBarToolBox: function() { return /* reexport safe */ _TopBarToolBox__WEBPACK_IMPORTED_MODULE_6__.TopBarToolBox; },
/* harmony export */   TopBarV2: function() { return /* reexport safe */ _TopBarV2__WEBPACK_IMPORTED_MODULE_8__.TopBarV2; },
/* harmony export */   TopBarWrapper: function() { return /* reexport safe */ _TopBarWrapper__WEBPACK_IMPORTED_MODULE_7__.TopBarWrapper; }
/* harmony export */ });
/* harmony import */ var _SidebarDivider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../SidebarDivider */ "./src/components/Sidebar/SidebarDivider.tsx");
/* harmony import */ var _TopBar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./TopBar */ "./src/components/Sidebar/TopBar/TopBar.tsx");
/* harmony import */ var _TopBarAction__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TopBarAction */ "./src/components/Sidebar/TopBar/TopBarAction.tsx");
/* harmony import */ var _TopBarActions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TopBarActions */ "./src/components/Sidebar/TopBar/TopBarActions.tsx");
/* harmony import */ var _TopBarSection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./TopBarSection */ "./src/components/Sidebar/TopBar/TopBarSection.tsx");
/* harmony import */ var _TopBarTitle__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./TopBarTitle */ "./src/components/Sidebar/TopBar/TopBarTitle.tsx");
/* harmony import */ var _TopBarToolBox__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./TopBarToolBox */ "./src/components/Sidebar/TopBar/TopBarToolBox.tsx");
/* harmony import */ var _TopBarWrapper__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./TopBarWrapper */ "./src/components/Sidebar/TopBar/TopBarWrapper.tsx");
/* harmony import */ var _TopBarV2__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./TopBarV2 */ "./src/components/Sidebar/TopBar/TopBarV2.tsx");








const Avatar = { size: 'x24' };
const TopBarAvatar = Avatar;
/* harmony default export */ __webpack_exports__["default"] = (Object.assign(_TopBar__WEBPACK_IMPORTED_MODULE_1__.TopBar, {
    /** @deprecated use named import instead */
    Section: _TopBarSection__WEBPACK_IMPORTED_MODULE_4__.TopBarSection,
    /** @deprecated use named import instead */
    ToolBox: _TopBarToolBox__WEBPACK_IMPORTED_MODULE_6__.TopBarToolBox,
    /** @deprecated use named import instead */
    Wrapper: _TopBarWrapper__WEBPACK_IMPORTED_MODULE_7__.TopBarWrapper,
    /** @deprecated use named import instead */
    Avatar: TopBarAvatar,
    /** @deprecated use named import instead */
    Actions: _TopBarActions__WEBPACK_IMPORTED_MODULE_3__.TopBarActions,
    /** @deprecated use named import instead */
    Action: _TopBarAction__WEBPACK_IMPORTED_MODULE_2__.TopBarAction,
    /** @deprecated use named import instead */
    Divider: _SidebarDivider__WEBPACK_IMPORTED_MODULE_0__.SidebarDivider,
    /** @deprecated use named import instead */
    Title: _TopBarTitle__WEBPACK_IMPORTED_MODULE_5__.TopBarTitle,
}));










/***/ }),

/***/ "./src/components/Sidebar/index.tsx":
/*!******************************************!*\
  !*** ./src/components/Sidebar/index.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Sidebar: function() { return /* binding */ Sidebar; },
/* harmony export */   SidebarBanner: function() { return /* reexport safe */ _SidebarBanner__WEBPACK_IMPORTED_MODULE_4__.SidebarBanner; },
/* harmony export */   SidebarDivider: function() { return /* reexport safe */ _SidebarDivider__WEBPACK_IMPORTED_MODULE_5__.SidebarDivider; },
/* harmony export */   SidebarFooter: function() { return /* reexport safe */ _SidebarFooter__WEBPACK_IMPORTED_MODULE_7__.SidebarFooter; },
/* harmony export */   SidebarFooterHighlight: function() { return /* reexport safe */ _SidebarFooter__WEBPACK_IMPORTED_MODULE_7__.SidebarFooterHighlight; },
/* harmony export */   SidebarItem: function() { return /* reexport safe */ _Item__WEBPACK_IMPORTED_MODULE_2__["default"]; },
/* harmony export */   SidebarItemAction: function() { return /* reexport safe */ _Item__WEBPACK_IMPORTED_MODULE_2__.SidebarItemAction; },
/* harmony export */   SidebarItemActions: function() { return /* reexport safe */ _Item__WEBPACK_IMPORTED_MODULE_2__.SidebarItemActions; },
/* harmony export */   SidebarItemAvatar: function() { return /* reexport safe */ _Item__WEBPACK_IMPORTED_MODULE_2__.SidebarItemAvatar; },
/* harmony export */   SidebarItemBadge: function() { return /* reexport safe */ _Item__WEBPACK_IMPORTED_MODULE_2__.SidebarItemBadge; },
/* harmony export */   SidebarItemContainer: function() { return /* reexport safe */ _Item__WEBPACK_IMPORTED_MODULE_2__.SidebarItemContainer; },
/* harmony export */   SidebarItemContent: function() { return /* reexport safe */ _Item__WEBPACK_IMPORTED_MODULE_2__.SidebarItemContent; },
/* harmony export */   SidebarItemIcon: function() { return /* reexport safe */ _Item__WEBPACK_IMPORTED_MODULE_2__.SidebarItemIcon; },
/* harmony export */   SidebarItemMenu: function() { return /* reexport safe */ _Item__WEBPACK_IMPORTED_MODULE_2__.SidebarItemMenu; },
/* harmony export */   SidebarItemSubtitle: function() { return /* reexport safe */ _Item__WEBPACK_IMPORTED_MODULE_2__.SidebarItemSubtitle; },
/* harmony export */   SidebarItemTime: function() { return /* reexport safe */ _Item__WEBPACK_IMPORTED_MODULE_2__.SidebarItemTime; },
/* harmony export */   SidebarItemTitle: function() { return /* reexport safe */ _Item__WEBPACK_IMPORTED_MODULE_2__.SidebarItemTitle; },
/* harmony export */   SidebarItemWrapper: function() { return /* reexport safe */ _Item__WEBPACK_IMPORTED_MODULE_2__.SidebarItemWrapper; },
/* harmony export */   SidebarSection: function() { return /* reexport safe */ _Section__WEBPACK_IMPORTED_MODULE_3__["default"]; },
/* harmony export */   SidebarSectionTitle: function() { return /* reexport safe */ _Section__WEBPACK_IMPORTED_MODULE_3__.SidebarSectionTitle; },
/* harmony export */   SidebarTopBar: function() { return /* reexport safe */ _TopBar__WEBPACK_IMPORTED_MODULE_6__["default"]; },
/* harmony export */   TopBar: function() { return /* reexport safe */ _TopBar__WEBPACK_IMPORTED_MODULE_6__.TopBar; },
/* harmony export */   TopBarAction: function() { return /* reexport safe */ _TopBar__WEBPACK_IMPORTED_MODULE_6__.TopBarAction; },
/* harmony export */   TopBarActions: function() { return /* reexport safe */ _TopBar__WEBPACK_IMPORTED_MODULE_6__.TopBarActions; },
/* harmony export */   TopBarAvatar: function() { return /* reexport safe */ _TopBar__WEBPACK_IMPORTED_MODULE_6__.TopBarAvatar; },
/* harmony export */   TopBarSection: function() { return /* reexport safe */ _TopBar__WEBPACK_IMPORTED_MODULE_6__.TopBarSection; },
/* harmony export */   TopBarTitle: function() { return /* reexport safe */ _TopBar__WEBPACK_IMPORTED_MODULE_6__.TopBarTitle; },
/* harmony export */   TopBarToolBox: function() { return /* reexport safe */ _TopBar__WEBPACK_IMPORTED_MODULE_6__.TopBarToolBox; },
/* harmony export */   TopBarV2: function() { return /* reexport safe */ _TopBar__WEBPACK_IMPORTED_MODULE_6__.TopBarV2; },
/* harmony export */   TopBarWrapper: function() { return /* reexport safe */ _TopBar__WEBPACK_IMPORTED_MODULE_6__.TopBarWrapper; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Item__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Item */ "./src/components/Sidebar/Item.tsx");
/* harmony import */ var _Section__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Section */ "./src/components/Sidebar/Section.tsx");
/* harmony import */ var _SidebarBanner__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SidebarBanner */ "./src/components/Sidebar/SidebarBanner.tsx");
/* harmony import */ var _SidebarDivider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SidebarDivider */ "./src/components/Sidebar/SidebarDivider.tsx");
/* harmony import */ var _TopBar__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./TopBar */ "./src/components/Sidebar/TopBar/index.ts");
/* harmony import */ var _SidebarFooter__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SidebarFooter */ "./src/components/Sidebar/SidebarFooter.tsx");







const Sidebar = (props) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-sidebar": true, ...props });
/* harmony default export */ __webpack_exports__["default"] = (Object.assign(Sidebar, {
    TopBar: _TopBar__WEBPACK_IMPORTED_MODULE_6__["default"],
    Item: _Item__WEBPACK_IMPORTED_MODULE_2__["default"],
    Section: _Section__WEBPACK_IMPORTED_MODULE_3__["default"],
    Divider: _SidebarDivider__WEBPACK_IMPORTED_MODULE_5__.SidebarDivider,
    Banner: _SidebarBanner__WEBPACK_IMPORTED_MODULE_4__.SidebarBanner,
}));











/***/ }),

/***/ "./src/components/SidebarV2/Sidebar.tsx":
/*!**********************************************!*\
  !*** ./src/components/SidebarV2/Sidebar.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Sidebar: function() { return /* binding */ Sidebar; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const Sidebar = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(({ collapsed, className, ...props }, ref) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("nav", { ref: ref, className: [
        'rcx-box rcx-box--full rcx-sidebar-v2',
        'rcx-box--animated',
        collapsed && 'rcx-sidebar-v2--collapsed',
        className,
    ]
        .filter(Boolean)
        .join(' '), ...props })));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarAccordion.tsx":
/*!*******************************************************!*\
  !*** ./src/components/SidebarV2/SidebarAccordion.tsx ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarAccordion: function() { return /* binding */ SidebarAccordion; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidebarAccordion = ({ className, children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: [
        'rcx-box rcx-box--full rcx-sidebar-v2-accordion rcx-box--animated',
        className,
    ]
        .filter(Boolean)
        .join(' '), ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-sidebar-v2-accordion__wrapper', children: children }) }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarAccordionItem.tsx":
/*!***********************************************************!*\
  !*** ./src/components/SidebarV2/SidebarAccordionItem.tsx ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarAccordionItem: function() { return /* binding */ SidebarAccordionItem; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Chevron__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Chevron */ "./src/components/Chevron/index.tsx");
/* harmony import */ var _hooks_useCollapse__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./hooks/useCollapse */ "./src/components/SidebarV2/hooks/useCollapse.tsx");



const SidebarAccordionItem = ({ children, title, badge, noncollapsible, disabled, expanded: propExpanded, defaultExpanded, tabIndex, ...props }) => {
    const { barProps, expanded, panelExpanded, panelId, titleId } = (0,_hooks_useCollapse__WEBPACK_IMPORTED_MODULE_2__.useCollapse)({
        expanded: propExpanded,
        defaultExpanded,
        tabIndex,
        disabled,
        noncollapsible,
    });
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("section", { className: 'rcx-box rcx-box--full rcx-sidebar-v2-accordion-item', ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { role: 'button', className: [
                    'rcx-box rcx-box--full rcx-sidebar-v2-accordion-item__bar rcx-box--animated',
                    disabled && 'rcx-sidebar-v2-accordion-item__bar--disabled',
                ]
                    .filter(Boolean)
                    .join(' '), ...barProps, children: [!noncollapsible && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Chevron__WEBPACK_IMPORTED_MODULE_1__.Chevron, { className: 'rcx-sidebar-v2-accordion-item__chevron', size: 'x16', right: !expanded })), title && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h5", { className: 'rcx-sidebar-v2-accordion-item__title', id: titleId, children: title })), !expanded && badge && badge] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: [
                    'rcx-sidebar-v2-accordion-item__panel',
                    'rcx-box--animated',
                    panelExpanded && 'rcx-sidebar-v2-accordion-item__panel--expanded',
                ]
                    .filter(Boolean)
                    .join(' '), id: panelId, children: children })] }));
};


/***/ }),

/***/ "./src/components/SidebarV2/SidebarAction.tsx":
/*!****************************************************!*\
  !*** ./src/components/SidebarV2/SidebarAction.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarAction: function() { return /* binding */ SidebarAction; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Button */ "./src/components/Button/index.ts");



const SidebarAction = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function SidebarAction(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_2__.IconButton, { small: true, ref: ref, ...props });
});


/***/ }),

/***/ "./src/components/SidebarV2/SidebarActions.tsx":
/*!*****************************************************!*\
  !*** ./src/components/SidebarV2/SidebarActions.tsx ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarActions: function() { return /* binding */ SidebarActions; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ButtonGroup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../ButtonGroup */ "./src/components/ButtonGroup/index.ts");



const SidebarActions = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function SidebarActions(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ButtonGroup__WEBPACK_IMPORTED_MODULE_2__.ButtonGroup, { ref: ref, ...props });
});


/***/ }),

/***/ "./src/components/SidebarV2/SidebarBanner.tsx":
/*!****************************************************!*\
  !*** ./src/components/SidebarV2/SidebarBanner.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarBanner: function() { return /* binding */ SidebarBanner; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Button */ "./src/components/Button/index.ts");


const SidebarBanner = ({ title, linkText, linkProps, variant = 'default', addon, onClose, children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: `rcx-box rcx-box--full rcx-sidebar-v2-banner rcx-sidebar-v2-banner--${variant}`, ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'rcx-box rcx-box--full rcx-sidebar-v2-banner__content', children: [title && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h5", { className: 'rcx-box rcx-box--full rcx-sidebar-v2-banner__title', children: title })), linkText && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { className: 'rcx-box rcx-box--full rcx-sidebar-v2-banner__link', ...linkProps, children: linkText })), children] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'rcx-box rcx-box--full rcx-sidebar-v2-banner__addon', children: [addon, onClose && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__.IconButton, { onClick: onClose, tiny: true, icon: 'cross' })] })] }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarButtonGroup.tsx":
/*!*********************************************************!*\
  !*** ./src/components/SidebarV2/SidebarButtonGroup.tsx ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarButtonGroup: function() { return /* binding */ SidebarButtonGroup; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ButtonGroup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ButtonGroup */ "./src/components/ButtonGroup/index.ts");


const SidebarButtonGroup = ({ align = 'end', small = true, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ButtonGroup__WEBPACK_IMPORTED_MODULE_1__.ButtonGroup, { align: align, small: small, ...props }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarCollapseGroup.tsx":
/*!***********************************************************!*\
  !*** ./src/components/SidebarV2/SidebarCollapseGroup.tsx ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarCollapseGroup: function() { return /* binding */ SidebarCollapseGroup; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _SidebarGroupTitle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SidebarGroupTitle */ "./src/components/SidebarV2/SidebarGroupTitle.tsx");
/* harmony import */ var _hooks_useCollapse__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./hooks/useCollapse */ "./src/components/SidebarV2/hooks/useCollapse.tsx");




const SidebarCollapseGroup = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(({ expanded: propExpanded, defaultExpanded, tabIndex, children, badge, title, ...props }, ref) => {
    const { barProps, expanded, panelExpanded, panelId, titleId } = (0,_hooks_useCollapse__WEBPACK_IMPORTED_MODULE_3__.useCollapse)({
        expanded: propExpanded,
        defaultExpanded,
        tabIndex,
    });
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("section", { className: 'rcx-box rcx-box--full rcx-sidebar-v2-collapse-group', ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SidebarGroupTitle__WEBPACK_IMPORTED_MODULE_2__.SidebarGroupTitle, { expanded: expanded, title: title, titleId: titleId, badge: badge, barProps: barProps, role: 'button' }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { role: 'list', ref: ref, className: [
                    'rcx-box rcx-box--full rcx-sidebar-v2-collapse-group__panel rcx-box--animated',
                    panelExpanded && 'rcx-sidebar-v2-collapse-group__panel--expanded',
                ]
                    .filter(Boolean)
                    .join(' '), id: panelId, children: children })] }));
});


/***/ }),

/***/ "./src/components/SidebarV2/SidebarDivider.tsx":
/*!*****************************************************!*\
  !*** ./src/components/SidebarV2/SidebarDivider.tsx ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarDivider: function() { return /* binding */ SidebarDivider; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Divider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Divider */ "./src/components/Divider/index.tsx");


const SidebarDivider = () => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Divider__WEBPACK_IMPORTED_MODULE_1__.Divider, { "rcx-sidebar-v2--divider": true, mbs: -2, mbe: 0 }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarFooter/SidebarFooter.tsx":
/*!******************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarFooter/SidebarFooter.tsx ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarFooter: function() { return /* binding */ SidebarFooter; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidebarFooter = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("footer", { className: 'rcx-sidebar-v2-footer', ...props, children: children }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarFooter/SidebarFooterContent.tsx":
/*!*************************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarFooter/SidebarFooterContent.tsx ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarFooterContent: function() { return /* binding */ SidebarFooterContent; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Box */ "./src/components/Box/index.ts");


const SidebarFooterContent = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { className: 'rcx-sidebar-v2-footer__content', ...props, children: children }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarFooter/index.ts":
/*!*********************************************************!*\
  !*** ./src/components/SidebarV2/SidebarFooter/index.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarV2Footer: function() { return /* reexport safe */ _SidebarFooter__WEBPACK_IMPORTED_MODULE_0__.SidebarFooter; },
/* harmony export */   SidebarV2FooterContent: function() { return /* reexport safe */ _SidebarFooterContent__WEBPACK_IMPORTED_MODULE_1__.SidebarFooterContent; }
/* harmony export */ });
/* harmony import */ var _SidebarFooter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SidebarFooter */ "./src/components/SidebarV2/SidebarFooter/SidebarFooter.tsx");
/* harmony import */ var _SidebarFooterContent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SidebarFooterContent */ "./src/components/SidebarV2/SidebarFooter/SidebarFooterContent.tsx");




/***/ }),

/***/ "./src/components/SidebarV2/SidebarGroupTitle.tsx":
/*!********************************************************!*\
  !*** ./src/components/SidebarV2/SidebarGroupTitle.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarGroupTitle: function() { return /* binding */ SidebarGroupTitle; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Chevron__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Chevron */ "./src/components/Chevron/index.tsx");



const SidebarGroupTitle = ({ title, titleId, badge, barProps, expanded, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: [
        'rcx-box rcx-box--full',
        'rcx-sidebar-v2-collapse-group__bar rcx-box--animated',
    ]
        .filter(Boolean)
        .join(' '), ...barProps, ...props, children: [expanded !== undefined && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Chevron__WEBPACK_IMPORTED_MODULE_2__.Chevron, { size: 'x20', right: !expanded }), title && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h4", { className: 'rcx-box rcx-box--full rcx-sidebar-v2-collapse-group__title', id: titleId, children: title })), !expanded && badge && badge] }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarItem/SidebarItem.tsx":
/*!**************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarItem/SidebarItem.tsx ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarItem: function() { return /* binding */ SidebarItem; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidebarItem = ({ selected, level = 1, className, children, is: Tag = 'a', ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Tag, { className: [
        'rcx-box rcx-box--full rcx-sidebar-v2-item',
        selected && 'rcx-sidebar-v2-item--selected',
        level && `rcx-sidebar-v2-item--level-${level}`,
        className,
    ]
        .filter(Boolean)
        .join(' '), ...props, children: children }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarItem/SidebarItemAction.tsx":
/*!********************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarItem/SidebarItemAction.tsx ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarItemAction: function() { return /* binding */ SidebarItemAction; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Icon */ "./src/components/Icon/index.ts");


const SidebarItemAction = ({ children, className, icon = 'plus-small', ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { role: 'button', tabIndex: 0, className: [
        'rcx-box rcx-box--full rcx-sidebar-v2-item rcx-sidebar-v2-item__action',
        className,
    ]
        .filter(Boolean)
        .join(' '), ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__.Icon, { name: icon, size: 'x20' }), children] }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarItem/SidebarItemAvatarWrapper.tsx":
/*!***************************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarItem/SidebarItemAvatarWrapper.tsx ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarItemAvatarWrapper: function() { return /* binding */ SidebarItemAvatarWrapper; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidebarItemAvatarWrapper = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: ['rcx-box rcx-box--full rcx-sidebar-v2-item__avatar', className]
        .filter(Boolean)
        .join(' '), ...props }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarItem/SidebarItemBadge.tsx":
/*!*******************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarItem/SidebarItemBadge.tsx ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarItemBadge: function() { return /* binding */ SidebarItemBadge; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Badge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Badge */ "./src/components/Badge/index.tsx");


const SidebarItemBadge = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Badge__WEBPACK_IMPORTED_MODULE_1__.Badge, { className: ['rcx-box rcx-box--full rcx-sidebar-v2-item__badge', className]
        .filter(Boolean)
        .join(' '), ...props }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarItem/SidebarItemCol.tsx":
/*!*****************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarItem/SidebarItemCol.tsx ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarItemCol: function() { return /* binding */ SidebarItemCol; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidebarItemCol = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: ['rcx-box rcx-box--full rcx-sidebar-v2-item__col', className]
        .filter(Boolean)
        .join(' '), ...props }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarItem/SidebarItemContent.tsx":
/*!*********************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarItem/SidebarItemContent.tsx ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarItemContent: function() { return /* binding */ SidebarItemContent; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidebarItemContent = ({ className, unread, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: [
        'rcx-box rcx-box--full rcx-sidebar-v2-item__subtitle',
        unread && 'rcx-sidebar-v2-item__subtitle--highlighted',
        className,
    ]
        .filter(Boolean)
        .join(' '), ...props }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarItem/SidebarItemIcon.tsx":
/*!******************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarItem/SidebarItemIcon.tsx ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarItemIcon: function() { return /* binding */ SidebarItemIcon; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Icon */ "./src/components/Icon/index.ts");



const SidebarItemIcon = ({ icon, className, highlighted, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: [
        'rcx-box rcx-box--full rcx-sidebar-v2-item__icon',
        highlighted && 'rcx-sidebar-v2-item__icon--highlighted',
        className,
    ]
        .filter(Boolean)
        .join(' '), children: (0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(icon) ? (icon) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_2__.Icon, { name: icon, size: 'x20', ...props })) }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarItem/SidebarItemMenu.tsx":
/*!******************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarItem/SidebarItemMenu.tsx ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarItemMenu: function() { return /* binding */ SidebarItemMenu; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_appendClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../helpers/appendClassName */ "./src/helpers/appendClassName.ts");
/* harmony import */ var _helpers_patchChildren__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../helpers/patchChildren */ "./src/helpers/patchChildren.ts");



const SidebarItemMenu = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-sidebar-v2-item__menu-wrapper rcx-box--animated', ...props, children: (0,_helpers_patchChildren__WEBPACK_IMPORTED_MODULE_2__.patchChildren)((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'rcx-box rcx-box--full rcx-sidebar-v2-item__menu', children: children }), (childProps) => ({
        className: (0,_helpers_appendClassName__WEBPACK_IMPORTED_MODULE_1__.appendClassName)(childProps.className, 'rcx-sidebar-v2-item__menu'),
    })) }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarItem/SidebarItemRow.tsx":
/*!*****************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarItem/SidebarItemRow.tsx ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarItemRow: function() { return /* binding */ SidebarItemRow; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidebarItemRow = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: ['rcx-box rcx-box--full rcx-sidebar-v2-item__row', className]
        .filter(Boolean)
        .join(' '), ...props }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarItem/SidebarItemStatusBullet.tsx":
/*!**************************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarItem/SidebarItemStatusBullet.tsx ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarItemStatusBullet: function() { return /* binding */ SidebarItemStatusBullet; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _StatusBullet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../StatusBullet */ "./src/components/StatusBullet/index.tsx");


const SidebarItemStatusBullet = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-sidebar-v2-item__status-bullet', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_StatusBullet__WEBPACK_IMPORTED_MODULE_1__.StatusBullet, { ...props }) }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarItem/SidebarItemTimestamp.tsx":
/*!***********************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarItem/SidebarItemTimestamp.tsx ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarItemTimestamp: function() { return /* binding */ SidebarItemTimestamp; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidebarItemTimestamp = ({ className, unread, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: [
        'rcx-box rcx-box--full rcx-sidebar-v2-item__timestamp',
        unread && 'rcx-sidebar-v2-item__timestamp--highlighted',
        className,
    ]
        .filter(Boolean)
        .join(' '), ...props }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarItem/SidebarItemTitle.tsx":
/*!*******************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarItem/SidebarItemTitle.tsx ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarItemTitle: function() { return /* binding */ SidebarItemTitle; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidebarItemTitle = ({ className, unread, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: [
        'rcx-box rcx-box--full rcx-sidebar-v2-item__title',
        unread && 'rcx-sidebar-v2-item__title--highlighted',
        className,
    ]
        .filter(Boolean)
        .join(' '), ...props }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarItem/SidebarListItem.tsx":
/*!******************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarItem/SidebarListItem.tsx ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarListItem: function() { return /* binding */ SidebarListItem; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const SidebarListItem = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(({ className, children, ...props }, ref) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ref: ref, role: 'listitem', className: [
        'rcx-box rcx-box--full rcx-sidebar-item__list-item',
        className,
    ]
        .filter(Boolean)
        .join(' '), ...props, children: children })));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarItem/index.ts":
/*!*******************************************************!*\
  !*** ./src/components/SidebarV2/SidebarItem/index.ts ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarV2Item: function() { return /* reexport safe */ _SidebarItem__WEBPACK_IMPORTED_MODULE_0__.SidebarItem; },
/* harmony export */   SidebarV2ItemAction: function() { return /* reexport safe */ _SidebarItemAction__WEBPACK_IMPORTED_MODULE_1__.SidebarItemAction; },
/* harmony export */   SidebarV2ItemAvatarWrapper: function() { return /* reexport safe */ _SidebarItemAvatarWrapper__WEBPACK_IMPORTED_MODULE_2__.SidebarItemAvatarWrapper; },
/* harmony export */   SidebarV2ItemBadge: function() { return /* reexport safe */ _SidebarItemBadge__WEBPACK_IMPORTED_MODULE_3__.SidebarItemBadge; },
/* harmony export */   SidebarV2ItemCol: function() { return /* reexport safe */ _SidebarItemCol__WEBPACK_IMPORTED_MODULE_8__.SidebarItemCol; },
/* harmony export */   SidebarV2ItemContent: function() { return /* reexport safe */ _SidebarItemContent__WEBPACK_IMPORTED_MODULE_11__.SidebarItemContent; },
/* harmony export */   SidebarV2ItemIcon: function() { return /* reexport safe */ _SidebarItemIcon__WEBPACK_IMPORTED_MODULE_4__.SidebarItemIcon; },
/* harmony export */   SidebarV2ItemMenu: function() { return /* reexport safe */ _SidebarItemMenu__WEBPACK_IMPORTED_MODULE_5__.SidebarItemMenu; },
/* harmony export */   SidebarV2ItemRow: function() { return /* reexport safe */ _SidebarItemRow__WEBPACK_IMPORTED_MODULE_7__.SidebarItemRow; },
/* harmony export */   SidebarV2ItemStatusBullet: function() { return /* reexport safe */ _SidebarItemStatusBullet__WEBPACK_IMPORTED_MODULE_12__.SidebarItemStatusBullet; },
/* harmony export */   SidebarV2ItemTimestamp: function() { return /* reexport safe */ _SidebarItemTimestamp__WEBPACK_IMPORTED_MODULE_9__.SidebarItemTimestamp; },
/* harmony export */   SidebarV2ItemTitle: function() { return /* reexport safe */ _SidebarItemTitle__WEBPACK_IMPORTED_MODULE_6__.SidebarItemTitle; },
/* harmony export */   SidebarV2ListItem: function() { return /* reexport safe */ _SidebarListItem__WEBPACK_IMPORTED_MODULE_10__.SidebarListItem; }
/* harmony export */ });
/* harmony import */ var _SidebarItem__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SidebarItem */ "./src/components/SidebarV2/SidebarItem/SidebarItem.tsx");
/* harmony import */ var _SidebarItemAction__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SidebarItemAction */ "./src/components/SidebarV2/SidebarItem/SidebarItemAction.tsx");
/* harmony import */ var _SidebarItemAvatarWrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SidebarItemAvatarWrapper */ "./src/components/SidebarV2/SidebarItem/SidebarItemAvatarWrapper.tsx");
/* harmony import */ var _SidebarItemBadge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SidebarItemBadge */ "./src/components/SidebarV2/SidebarItem/SidebarItemBadge.tsx");
/* harmony import */ var _SidebarItemIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SidebarItemIcon */ "./src/components/SidebarV2/SidebarItem/SidebarItemIcon.tsx");
/* harmony import */ var _SidebarItemMenu__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SidebarItemMenu */ "./src/components/SidebarV2/SidebarItem/SidebarItemMenu.tsx");
/* harmony import */ var _SidebarItemTitle__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./SidebarItemTitle */ "./src/components/SidebarV2/SidebarItem/SidebarItemTitle.tsx");
/* harmony import */ var _SidebarItemRow__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SidebarItemRow */ "./src/components/SidebarV2/SidebarItem/SidebarItemRow.tsx");
/* harmony import */ var _SidebarItemCol__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./SidebarItemCol */ "./src/components/SidebarV2/SidebarItem/SidebarItemCol.tsx");
/* harmony import */ var _SidebarItemTimestamp__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./SidebarItemTimestamp */ "./src/components/SidebarV2/SidebarItem/SidebarItemTimestamp.tsx");
/* harmony import */ var _SidebarListItem__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./SidebarListItem */ "./src/components/SidebarV2/SidebarItem/SidebarListItem.tsx");
/* harmony import */ var _SidebarItemContent__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./SidebarItemContent */ "./src/components/SidebarV2/SidebarItem/SidebarItemContent.tsx");
/* harmony import */ var _SidebarItemStatusBullet__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./SidebarItemStatusBullet */ "./src/components/SidebarV2/SidebarItem/SidebarItemStatusBullet.tsx");















/***/ }),

/***/ "./src/components/SidebarV2/SidebarLink.tsx":
/*!**************************************************!*\
  !*** ./src/components/SidebarV2/SidebarLink.tsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarLink: function() { return /* binding */ SidebarLink; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_appendClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/appendClassName */ "./src/helpers/appendClassName.ts");
/* harmony import */ var _helpers_patchChildren__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/patchChildren */ "./src/helpers/patchChildren.ts");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");




const SidebarLink = ({ selected, icon, badge, menu, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("a", { role: 'link', tabIndex: 0, className: [
        'rcx-box rcx-box--full',
        'rcx-sidebar-v2-link',
        'rcx-sidebar-v2-item',
        selected && 'rcx-sidebar-v2-item--selected',
    ]
        .filter(Boolean)
        .join(' '), onClick: (e) => e.stopPropagation(), onKeyDown: (e) => e.code === 'Enter' && e.stopPropagation(), ...props, children: [icon && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_3__.Icon, { name: icon, size: 'x20', className: 'rcx-sidebar-v2-item__icon' })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'rcx-box rcx-box--full rcx-sidebar-v2-item__title', children: props.children }), badge, menu &&
            (0,_helpers_patchChildren__WEBPACK_IMPORTED_MODULE_2__.patchChildren)((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'rcx-box rcx-box--full rcx-sidebar-v2-item__menu-wrapper', children: menu }), (childProps) => ({
                className: (0,_helpers_appendClassName__WEBPACK_IMPORTED_MODULE_1__.appendClassName)(childProps.className, 'rcx-box rcx-box--full rcx-sidebar-v2-item__menu rcx-box--animated'),
            }))] }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarMedia/SidebarMedia.tsx":
/*!****************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarMedia/SidebarMedia.tsx ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarMedia: function() { return /* binding */ SidebarMedia; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidebarMedia = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: ['rcx-sidebar-v2-media', className].filter(Boolean).join(' '), ...props }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarMedia/SidebarMediaController.tsx":
/*!**************************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarMedia/SidebarMediaController.tsx ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarMediaController: function() { return /* binding */ SidebarMediaController; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SidebarButtonGroup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../SidebarButtonGroup */ "./src/components/SidebarV2/SidebarButtonGroup.tsx");


const SidebarMediaController = ({ className, label, children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: ['rcx-sidebar-v2-media__controller', className]
        .filter(Boolean)
        .join(' '), children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-sidebar-v2-media__controller__label', children: label }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SidebarButtonGroup__WEBPACK_IMPORTED_MODULE_1__.SidebarButtonGroup, { small: true, align: 'end', ...props, children: children })] }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarMedia/SidebarMediaTitle.tsx":
/*!*********************************************************************!*\
  !*** ./src/components/SidebarV2/SidebarMedia/SidebarMediaTitle.tsx ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarMediaTitle: function() { return /* binding */ SidebarMediaTitle; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidebarMediaTitle = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: ['rcx-sidebar-v2-media__title', className]
        .filter(Boolean)
        .join(' '), ...props }));


/***/ }),

/***/ "./src/components/SidebarV2/SidebarMedia/index.ts":
/*!********************************************************!*\
  !*** ./src/components/SidebarV2/SidebarMedia/index.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarV2Media: function() { return /* reexport safe */ _SidebarMedia__WEBPACK_IMPORTED_MODULE_0__.SidebarMedia; },
/* harmony export */   SidebarV2MediaController: function() { return /* reexport safe */ _SidebarMediaController__WEBPACK_IMPORTED_MODULE_1__.SidebarMediaController; },
/* harmony export */   SidebarV2MediaTitle: function() { return /* reexport safe */ _SidebarMediaTitle__WEBPACK_IMPORTED_MODULE_2__.SidebarMediaTitle; }
/* harmony export */ });
/* harmony import */ var _SidebarMedia__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SidebarMedia */ "./src/components/SidebarV2/SidebarMedia/SidebarMedia.tsx");
/* harmony import */ var _SidebarMediaController__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SidebarMediaController */ "./src/components/SidebarV2/SidebarMedia/SidebarMediaController.tsx");
/* harmony import */ var _SidebarMediaTitle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SidebarMediaTitle */ "./src/components/SidebarV2/SidebarMedia/SidebarMediaTitle.tsx");





/***/ }),

/***/ "./src/components/SidebarV2/SidebarSection.tsx":
/*!*****************************************************!*\
  !*** ./src/components/SidebarV2/SidebarSection.tsx ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarSection: function() { return /* binding */ SidebarSection; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SidebarDivider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SidebarDivider */ "./src/components/SidebarV2/SidebarDivider.tsx");


const SidebarSection = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-box rcx-box--full rcx-sidebar-v2-section', ...props }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SidebarDivider__WEBPACK_IMPORTED_MODULE_1__.SidebarDivider, {})] }));


/***/ }),

/***/ "./src/components/SidebarV2/hooks/useCollapse.tsx":
/*!********************************************************!*\
  !*** ./src/components/SidebarV2/hooks/useCollapse.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useCollapse: function() { return /* binding */ useCollapse; }
/* harmony export */ });
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rocket.chat/fuselage-hooks */ "@rocket.chat/fuselage-hooks");
/* harmony import */ var _rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const hasPropExpanded = (expanded) => expanded !== undefined;
const useCollapse = ({ expanded: propExpanded, defaultExpanded, disabled, noncollapsible, tabIndex = 0, }) => {
    const [stateExpanded, toggleStateExpanded] = (0,_rocket_chat_fuselage_hooks__WEBPACK_IMPORTED_MODULE_0__.useToggle)(defaultExpanded);
    const expanded = hasPropExpanded(propExpanded) ? propExpanded : stateExpanded;
    const panelExpanded = noncollapsible || expanded;
    const titleId = (0,react__WEBPACK_IMPORTED_MODULE_1__.useId)();
    const panelId = (0,react__WEBPACK_IMPORTED_MODULE_1__.useId)();
    const handleClick = (e) => {
        if (disabled) {
            return;
        }
        e.currentTarget?.blur();
        toggleStateExpanded();
    };
    const handleKeyDown = (event) => {
        if (disabled || event.currentTarget !== event.target) {
            return;
        }
        if (['Enter', 'Space'].includes(event.code)) {
            event.preventDefault();
            if (event.repeat) {
                return;
            }
            toggleStateExpanded();
        }
    };
    const collapsibleProps = {
        'aria-controls': panelId,
        'aria-expanded': expanded ? 'true' : 'false',
        'tabIndex': !disabled ? tabIndex : undefined,
        'onClick': handleClick,
        'onKeyDown': handleKeyDown,
    };
    const nonCollapsibleProps = {
        'aria-disabled': 'true',
        'aria-expanded': 'true',
        'aria-labelledby': titleId,
    };
    const barProps = noncollapsible ? nonCollapsibleProps : collapsibleProps;
    return { barProps, titleId, panelId, panelExpanded, expanded };
};


/***/ }),

/***/ "./src/components/SidebarV2/index.tsx":
/*!********************************************!*\
  !*** ./src/components/SidebarV2/index.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarV2: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_0__.Sidebar; },
/* harmony export */   SidebarV2Accordion: function() { return /* reexport safe */ _SidebarAccordion__WEBPACK_IMPORTED_MODULE_1__.SidebarAccordion; },
/* harmony export */   SidebarV2AccordionItem: function() { return /* reexport safe */ _SidebarAccordionItem__WEBPACK_IMPORTED_MODULE_2__.SidebarAccordionItem; },
/* harmony export */   SidebarV2Action: function() { return /* reexport safe */ _SidebarAction__WEBPACK_IMPORTED_MODULE_3__.SidebarAction; },
/* harmony export */   SidebarV2Actions: function() { return /* reexport safe */ _SidebarActions__WEBPACK_IMPORTED_MODULE_4__.SidebarActions; },
/* harmony export */   SidebarV2Banner: function() { return /* reexport safe */ _SidebarBanner__WEBPACK_IMPORTED_MODULE_8__.SidebarBanner; },
/* harmony export */   SidebarV2ButtonGroup: function() { return /* reexport safe */ _SidebarButtonGroup__WEBPACK_IMPORTED_MODULE_11__.SidebarButtonGroup; },
/* harmony export */   SidebarV2CollapseGroup: function() { return /* reexport safe */ _SidebarCollapseGroup__WEBPACK_IMPORTED_MODULE_7__.SidebarCollapseGroup; },
/* harmony export */   SidebarV2Divider: function() { return /* reexport safe */ _SidebarDivider__WEBPACK_IMPORTED_MODULE_13__.SidebarDivider; },
/* harmony export */   SidebarV2Footer: function() { return /* reexport safe */ _SidebarFooter__WEBPACK_IMPORTED_MODULE_9__.SidebarV2Footer; },
/* harmony export */   SidebarV2FooterContent: function() { return /* reexport safe */ _SidebarFooter__WEBPACK_IMPORTED_MODULE_9__.SidebarV2FooterContent; },
/* harmony export */   SidebarV2GroupTitle: function() { return /* reexport safe */ _SidebarGroupTitle__WEBPACK_IMPORTED_MODULE_14__.SidebarGroupTitle; },
/* harmony export */   SidebarV2Item: function() { return /* reexport safe */ _SidebarItem__WEBPACK_IMPORTED_MODULE_6__.SidebarV2Item; },
/* harmony export */   SidebarV2ItemAction: function() { return /* reexport safe */ _SidebarItem__WEBPACK_IMPORTED_MODULE_6__.SidebarV2ItemAction; },
/* harmony export */   SidebarV2ItemAvatarWrapper: function() { return /* reexport safe */ _SidebarItem__WEBPACK_IMPORTED_MODULE_6__.SidebarV2ItemAvatarWrapper; },
/* harmony export */   SidebarV2ItemBadge: function() { return /* reexport safe */ _SidebarItem__WEBPACK_IMPORTED_MODULE_6__.SidebarV2ItemBadge; },
/* harmony export */   SidebarV2ItemCol: function() { return /* reexport safe */ _SidebarItem__WEBPACK_IMPORTED_MODULE_6__.SidebarV2ItemCol; },
/* harmony export */   SidebarV2ItemContent: function() { return /* reexport safe */ _SidebarItem__WEBPACK_IMPORTED_MODULE_6__.SidebarV2ItemContent; },
/* harmony export */   SidebarV2ItemIcon: function() { return /* reexport safe */ _SidebarItem__WEBPACK_IMPORTED_MODULE_6__.SidebarV2ItemIcon; },
/* harmony export */   SidebarV2ItemMenu: function() { return /* reexport safe */ _SidebarItem__WEBPACK_IMPORTED_MODULE_6__.SidebarV2ItemMenu; },
/* harmony export */   SidebarV2ItemRow: function() { return /* reexport safe */ _SidebarItem__WEBPACK_IMPORTED_MODULE_6__.SidebarV2ItemRow; },
/* harmony export */   SidebarV2ItemStatusBullet: function() { return /* reexport safe */ _SidebarItem__WEBPACK_IMPORTED_MODULE_6__.SidebarV2ItemStatusBullet; },
/* harmony export */   SidebarV2ItemTimestamp: function() { return /* reexport safe */ _SidebarItem__WEBPACK_IMPORTED_MODULE_6__.SidebarV2ItemTimestamp; },
/* harmony export */   SidebarV2ItemTitle: function() { return /* reexport safe */ _SidebarItem__WEBPACK_IMPORTED_MODULE_6__.SidebarV2ItemTitle; },
/* harmony export */   SidebarV2Link: function() { return /* reexport safe */ _SidebarLink__WEBPACK_IMPORTED_MODULE_5__.SidebarLink; },
/* harmony export */   SidebarV2ListItem: function() { return /* reexport safe */ _SidebarItem__WEBPACK_IMPORTED_MODULE_6__.SidebarV2ListItem; },
/* harmony export */   SidebarV2Media: function() { return /* reexport safe */ _SidebarMedia__WEBPACK_IMPORTED_MODULE_10__.SidebarV2Media; },
/* harmony export */   SidebarV2MediaController: function() { return /* reexport safe */ _SidebarMedia__WEBPACK_IMPORTED_MODULE_10__.SidebarV2MediaController; },
/* harmony export */   SidebarV2MediaTitle: function() { return /* reexport safe */ _SidebarMedia__WEBPACK_IMPORTED_MODULE_10__.SidebarV2MediaTitle; },
/* harmony export */   SidebarV2Section: function() { return /* reexport safe */ _SidebarSection__WEBPACK_IMPORTED_MODULE_12__.SidebarSection; }
/* harmony export */ });
/* harmony import */ var _Sidebar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Sidebar */ "./src/components/SidebarV2/Sidebar.tsx");
/* harmony import */ var _SidebarAccordion__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SidebarAccordion */ "./src/components/SidebarV2/SidebarAccordion.tsx");
/* harmony import */ var _SidebarAccordionItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SidebarAccordionItem */ "./src/components/SidebarV2/SidebarAccordionItem.tsx");
/* harmony import */ var _SidebarAction__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SidebarAction */ "./src/components/SidebarV2/SidebarAction.tsx");
/* harmony import */ var _SidebarActions__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SidebarActions */ "./src/components/SidebarV2/SidebarActions.tsx");
/* harmony import */ var _SidebarLink__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SidebarLink */ "./src/components/SidebarV2/SidebarLink.tsx");
/* harmony import */ var _SidebarItem__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./SidebarItem */ "./src/components/SidebarV2/SidebarItem/index.ts");
/* harmony import */ var _SidebarCollapseGroup__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SidebarCollapseGroup */ "./src/components/SidebarV2/SidebarCollapseGroup.tsx");
/* harmony import */ var _SidebarBanner__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./SidebarBanner */ "./src/components/SidebarV2/SidebarBanner.tsx");
/* harmony import */ var _SidebarFooter__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./SidebarFooter */ "./src/components/SidebarV2/SidebarFooter/index.ts");
/* harmony import */ var _SidebarMedia__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./SidebarMedia */ "./src/components/SidebarV2/SidebarMedia/index.ts");
/* harmony import */ var _SidebarButtonGroup__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./SidebarButtonGroup */ "./src/components/SidebarV2/SidebarButtonGroup.tsx");
/* harmony import */ var _SidebarSection__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./SidebarSection */ "./src/components/SidebarV2/SidebarSection.tsx");
/* harmony import */ var _SidebarDivider__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./SidebarDivider */ "./src/components/SidebarV2/SidebarDivider.tsx");
/* harmony import */ var _SidebarGroupTitle__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./SidebarGroupTitle */ "./src/components/SidebarV2/SidebarGroupTitle.tsx");

















/***/ }),

/***/ "./src/components/Sidepanel/Sidepanel.tsx":
/*!************************************************!*\
  !*** ./src/components/Sidepanel/Sidepanel.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Sidepanel: function() { return /* binding */ Sidepanel; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const Sidepanel = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: ['rcx-sidepanel', className].filter(Boolean).join(' '), ...props }));


/***/ }),

/***/ "./src/components/Sidepanel/SidepanelDivider.tsx":
/*!*******************************************************!*\
  !*** ./src/components/Sidepanel/SidepanelDivider.tsx ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidepanelDivider: function() { return /* binding */ SidepanelDivider; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Divider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Divider */ "./src/components/Divider/index.tsx");


const SidepanelDivider = () => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Divider__WEBPACK_IMPORTED_MODULE_1__.Divider, { "rcx-sidepanel--divider": true, mbs: -2, mbe: 0 }));


/***/ }),

/***/ "./src/components/Sidepanel/SidepanelHeader.tsx":
/*!******************************************************!*\
  !*** ./src/components/Sidepanel/SidepanelHeader.tsx ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidepanelHeader: function() { return /* binding */ SidepanelHeader; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SidepanelDivider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SidepanelDivider */ "./src/components/Sidepanel/SidepanelDivider.tsx");


const SidepanelHeader = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'rcx-sidepanel-header-wrapper', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: ['rcx-sidepanel-header', className].filter(Boolean).join(' '), ...props }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SidepanelDivider__WEBPACK_IMPORTED_MODULE_1__.SidepanelDivider, {})] }));


/***/ }),

/***/ "./src/components/Sidepanel/SidepanelHeaderTitle.tsx":
/*!***********************************************************!*\
  !*** ./src/components/Sidepanel/SidepanelHeaderTitle.tsx ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidepanelHeaderTitle: function() { return /* binding */ SidepanelHeaderTitle; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidepanelHeaderTitle = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: ['rcx-sidepanel-header__title', className]
        .filter(Boolean)
        .join(' '), ...props }));


/***/ }),

/***/ "./src/components/Sidepanel/SidepanelList.tsx":
/*!****************************************************!*\
  !*** ./src/components/Sidepanel/SidepanelList.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidepanelList: function() { return /* binding */ SidepanelList; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const SidepanelList = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function SidepanelList({ className, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { role: 'list', ref: ref, className: ['rcx-sidepanel-list', className].filter(Boolean).join(' '), ...props }));
});


/***/ }),

/***/ "./src/components/Sidepanel/SidepanelListItem.tsx":
/*!********************************************************!*\
  !*** ./src/components/Sidepanel/SidepanelListItem.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidepanelListItem: function() { return /* binding */ SidepanelListItem; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const SidepanelListItem = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function SidepanelListItem({ className, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { role: 'listitem', ref: ref, className: ['rcx-sidepanel-list__item', className]
            .filter(Boolean)
            .join(' '), ...props }));
});


/***/ }),

/***/ "./src/components/Sidepanel/SidepanelSection.tsx":
/*!*******************************************************!*\
  !*** ./src/components/Sidepanel/SidepanelSection.tsx ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidepanelSection: function() { return /* binding */ SidepanelSection; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidepanelSection = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: ['rcx-sidepanel-section', className].filter(Boolean).join(' '), ...props }));


/***/ }),

/***/ "./src/components/Sidepanel/SidepanelSectionAction.tsx":
/*!*************************************************************!*\
  !*** ./src/components/Sidepanel/SidepanelSectionAction.tsx ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidepanelSectionAction: function() { return /* binding */ SidepanelSectionAction; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const SidepanelSectionAction = ({ className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: ['rcx-sidepanel-section__action', className]
        .filter(Boolean)
        .join(' '), ...props }));


/***/ }),

/***/ "./src/components/Sidepanel/index.ts":
/*!*******************************************!*\
  !*** ./src/components/Sidepanel/index.ts ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Sidepanel: function() { return /* reexport safe */ _Sidepanel__WEBPACK_IMPORTED_MODULE_0__.Sidepanel; },
/* harmony export */   SidepanelDivider: function() { return /* reexport safe */ _SidepanelDivider__WEBPACK_IMPORTED_MODULE_7__.SidepanelDivider; },
/* harmony export */   SidepanelHeader: function() { return /* reexport safe */ _SidepanelHeader__WEBPACK_IMPORTED_MODULE_4__.SidepanelHeader; },
/* harmony export */   SidepanelHeaderTitle: function() { return /* reexport safe */ _SidepanelHeaderTitle__WEBPACK_IMPORTED_MODULE_3__.SidepanelHeaderTitle; },
/* harmony export */   SidepanelList: function() { return /* reexport safe */ _SidepanelList__WEBPACK_IMPORTED_MODULE_5__.SidepanelList; },
/* harmony export */   SidepanelListItem: function() { return /* reexport safe */ _SidepanelListItem__WEBPACK_IMPORTED_MODULE_6__.SidepanelListItem; },
/* harmony export */   SidepanelSection: function() { return /* reexport safe */ _SidepanelSection__WEBPACK_IMPORTED_MODULE_1__.SidepanelSection; },
/* harmony export */   SidepanelSectionAction: function() { return /* reexport safe */ _SidepanelSectionAction__WEBPACK_IMPORTED_MODULE_2__.SidepanelSectionAction; }
/* harmony export */ });
/* harmony import */ var _Sidepanel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Sidepanel */ "./src/components/Sidepanel/Sidepanel.tsx");
/* harmony import */ var _SidepanelSection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SidepanelSection */ "./src/components/Sidepanel/SidepanelSection.tsx");
/* harmony import */ var _SidepanelSectionAction__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SidepanelSectionAction */ "./src/components/Sidepanel/SidepanelSectionAction.tsx");
/* harmony import */ var _SidepanelHeaderTitle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SidepanelHeaderTitle */ "./src/components/Sidepanel/SidepanelHeaderTitle.tsx");
/* harmony import */ var _SidepanelHeader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SidepanelHeader */ "./src/components/Sidepanel/SidepanelHeader.tsx");
/* harmony import */ var _SidepanelList__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SidepanelList */ "./src/components/Sidepanel/SidepanelList.tsx");
/* harmony import */ var _SidepanelListItem__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./SidepanelListItem */ "./src/components/Sidepanel/SidepanelListItem.tsx");
/* harmony import */ var _SidepanelDivider__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SidepanelDivider */ "./src/components/Sidepanel/SidepanelDivider.tsx");










/***/ }),

/***/ "./src/components/Skeleton/Skeleton.tsx":
/*!**********************************************!*\
  !*** ./src/components/Skeleton/Skeleton.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Skeleton: function() { return /* binding */ Skeleton; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/composeClassNames */ "./src/helpers/composeClassNames.ts");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const Skeleton = ({ variant = 'text', ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__.StylingBox, { ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: (0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_1__.cx)((0,_helpers_composeClassNames__WEBPACK_IMPORTED_MODULE_1__.cxx)('rcx-skeleton')({
            text: variant === 'text',
            rect: variant === 'rect',
            circle: variant === 'circle',
        })) }) }));



/***/ }),

/***/ "./src/components/Skeleton/index.tsx":
/*!*******************************************!*\
  !*** ./src/components/Skeleton/index.tsx ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Skeleton: function() { return /* reexport safe */ _Skeleton__WEBPACK_IMPORTED_MODULE_0__.Skeleton; }
/* harmony export */ });
/* harmony import */ var _Skeleton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Skeleton */ "./src/components/Skeleton/Skeleton.tsx");



/***/ }),

/***/ "./src/components/Slider/Slider.tsx":
/*!******************************************!*\
  !*** ./src/components/Slider/Slider.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Slider: function() { return /* binding */ Slider; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/css-in-js */ "@rocket.chat/css-in-js");
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-aria */ "react-aria");
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_aria__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_stately__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-stately */ "react-stately");
/* harmony import */ var react_stately__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_stately__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _hooks_useStyle__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../hooks/useStyle */ "./src/hooks/useStyle.ts");
/* harmony import */ var _SliderHead__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./SliderHead */ "./src/components/Slider/SliderHead.tsx");
/* harmony import */ var _SliderThumb__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SliderThumb */ "./src/components/Slider/SliderThumb.tsx");
/* harmony import */ var _SliderTrack__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./SliderTrack */ "./src/components/Slider/SliderTrack.tsx");









function Slider(props) {
    const { label, formatOptions, showOutput = true, multiThumb, maxValue, minValue, } = props;
    // Get a defaultValue in the range for multiThumb
    const getMultiThumbDefaultValue = () => {
        if (multiThumb && !props.defaultValue) {
            if (minValue && maxValue) {
                return [minValue, maxValue];
            }
            if (minValue) {
                return [minValue, 100];
            }
            if (maxValue) {
                return [0, maxValue];
            }
            return [0, 100];
        }
        return undefined;
    };
    const { defaultValue = getMultiThumbDefaultValue() } = props;
    const sliderProps = {
        ...props,
        isDisabled: props.disabled,
    };
    const trackRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const numberFormatter = (0,react_aria__WEBPACK_IMPORTED_MODULE_3__.useNumberFormatter)(formatOptions);
    const sliderState = (0,react_stately__WEBPACK_IMPORTED_MODULE_4__.useSliderState)({
        defaultValue,
        ...sliderProps,
        numberFormatter,
    });
    const { groupProps, trackProps, labelProps, outputProps } = (0,react_aria__WEBPACK_IMPORTED_MODULE_3__.useSlider)(sliderProps, sliderState, trackRef);
    const isHorizontal = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => sliderState.orientation === 'horizontal', [sliderState.orientation]);
    const isVertical = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => sliderState.orientation === 'vertical', [sliderState.orientation]);
    const slider = (0,_hooks_useStyle__WEBPACK_IMPORTED_MODULE_5__.useStyle)((0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
      display: flex;
      ${isHorizontal &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
        flex-direction: column;
        width: 100%;
      `};
      ${isVertical &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
        flex-direction: row-reverse;
        height: 100%;
      `}
    `, sliderState);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { ...groupProps, className: slider, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SliderHead__WEBPACK_IMPORTED_MODULE_6__.SliderHead, { labelProps: labelProps, outputProps: outputProps, state: sliderState, showOutput: showOutput, label: label, multiThumb: multiThumb }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_SliderTrack__WEBPACK_IMPORTED_MODULE_8__.SliderTrack, { state: sliderState, trackProps: trackProps, trackRef: trackRef, multiThumb: multiThumb, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SliderThumb__WEBPACK_IMPORTED_MODULE_7__.SliderThumb, { index: 0, state: sliderState, trackRef: trackRef }), multiThumb && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SliderThumb__WEBPACK_IMPORTED_MODULE_7__.SliderThumb, { index: 1, state: sliderState, trackRef: trackRef }))] })] }));
}


/***/ }),

/***/ "./src/components/Slider/SliderHead.tsx":
/*!**********************************************!*\
  !*** ./src/components/Slider/SliderHead.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SliderHead: function() { return /* binding */ SliderHead; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/css-in-js */ "@rocket.chat/css-in-js");
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _hooks_useStyle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../hooks/useStyle */ "./src/hooks/useStyle.ts");
/* harmony import */ var _Label__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Label */ "./src/components/Label/index.tsx");




const SliderHead = ({ state, labelProps, outputProps, label, showOutput = true, multiThumb, }) => {
    const labelContainer = (0,_hooks_useStyle__WEBPACK_IMPORTED_MODULE_2__.useStyle)((0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
      display: flex;
      justify-content: space-between;
      ${state.orientation === 'vertical' &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
        flex-direction: column;
      `}
    `, null);
    const output = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Label__WEBPACK_IMPORTED_MODULE_3__.Label, { ...outputProps, children: multiThumb ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Label__WEBPACK_IMPORTED_MODULE_3__.Label, { ...outputProps, "data-testid": 'slider-output', children: `${state.getThumbValueLabel(0)} - ${state.getThumbValueLabel(1)}` })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Label__WEBPACK_IMPORTED_MODULE_3__.Label, { ...outputProps, "data-testid": 'slider-output', children: state.getThumbValueLabel(0) })) }));
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: label ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: labelContainer, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Label__WEBPACK_IMPORTED_MODULE_3__.Label, { ...labelProps, children: label }), showOutput && output] })) : (showOutput && output) }));
};


/***/ }),

/***/ "./src/components/Slider/SliderThumb.tsx":
/*!***********************************************!*\
  !*** ./src/components/Slider/SliderThumb.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SliderThumb: function() { return /* binding */ SliderThumb; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/css-in-js */ "@rocket.chat/css-in-js");
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-aria */ "react-aria");
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_aria__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _Theme__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Theme */ "./src/Theme.ts");
/* harmony import */ var _hooks_useStyle__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../hooks/useStyle */ "./src/hooks/useStyle.ts");






const SliderThumb = (props) => {
    const { state, trackRef, index } = props;
    const inputRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(null);
    const { thumbProps, inputProps, isDragging } = (0,react_aria__WEBPACK_IMPORTED_MODULE_3__.useSliderThumb)({
        index,
        trackRef,
        inputRef,
    }, state);
    const { focusProps, isFocusVisible } = (0,react_aria__WEBPACK_IMPORTED_MODULE_3__.useFocusRing)();
    const thumb = (0,_hooks_useStyle__WEBPACK_IMPORTED_MODULE_5__.useStyle)((0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
      width: 12px;
      height: 12px;

      cursor: ${state.isDisabled ? 'not-allowed' : 'pointer'};
      border-radius: 50%;
      background: ${isFocusVisible || isDragging
        ? _Theme__WEBPACK_IMPORTED_MODULE_4__.Palette.text['font-info']
        : _Theme__WEBPACK_IMPORTED_MODULE_4__.Palette.stroke['stroke-highlight']};
      ${state.orientation === 'horizontal'
        ? (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
            top: 50%;
          `
        : (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
            left: 50%;
          `}
    `, { isFocusVisible, isDragging });
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ...thumbProps, className: thumb, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_aria__WEBPACK_IMPORTED_MODULE_3__.VisuallyHidden, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { ref: inputRef, ...(0,react_aria__WEBPACK_IMPORTED_MODULE_3__.mergeProps)(inputProps, focusProps) }) }) }));
};


/***/ }),

/***/ "./src/components/Slider/SliderTrack.tsx":
/*!***********************************************!*\
  !*** ./src/components/Slider/SliderTrack.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SliderTrack: function() { return /* binding */ SliderTrack; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/css-in-js */ "@rocket.chat/css-in-js");
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Theme__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Theme */ "./src/Theme.ts");
/* harmony import */ var _hooks_useStyle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../hooks/useStyle */ "./src/hooks/useStyle.ts");





const highlight = _Theme__WEBPACK_IMPORTED_MODULE_3__.Palette.stroke['stroke-highlight'];
const light = _Theme__WEBPACK_IMPORTED_MODULE_3__.Palette.stroke['stroke-light'];
const SliderTrack = ({ trackProps, trackRef, state, multiThumb, children, }) => {
    const isHorizontal = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => state.orientation === 'horizontal', [state.orientation]);
    const isVertical = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => state.orientation === 'vertical', [state.orientation]);
    const getThumbPosition = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => (value) => {
        const maxValue = state.getThumbMaxValue(1) || state.getThumbMaxValue(0);
        const minValue = state.getThumbMinValue(0);
        return (value / (maxValue - minValue)) * 100;
    }, [state]);
    const getTrackGradient = () => {
        if (isHorizontal) {
            return multiThumb
                ? `to right, ${light} ${getThumbPosition(state.values[0])}%, ${highlight} 0, ${highlight} ${getThumbPosition(state.values[1])}%, ${light} 0`
                : `to right, ${highlight}  ${getThumbPosition(state.values[0])}%, ${light} 0%`;
        }
        if (isVertical) {
            return multiThumb
                ? `to top, ${light} ${getThumbPosition(state.values[0])}%, ${highlight} 0, ${highlight} ${getThumbPosition(state.values[1])}%, ${light} 0`
                : `to top, ${highlight}  ${getThumbPosition(state.values[0])}%, ${light} 0%`;
        }
        return undefined;
    };
    const track = (0,_hooks_useStyle__WEBPACK_IMPORTED_MODULE_4__.useStyle)((0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
      &::before {
        position: absolute;
        display: block;
        content: '';

        background: linear-gradient(${getTrackGradient()});
        transform: translateX(-50%);
        border-radius: 1rem;
      }
      ${isHorizontal &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
        width: 100%;
        height: 30px;
        &::before {
          top: 50%;
          width: 100%;
          height: 4px;
          transform: translateY(-50%);
        }
      `};
      ${isVertical &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
        width: 30px;
        height: 100%;
        &::before {
          left: 50%;
          width: 4px;
          height: 100%;
        }
      `};
      ${state.isDisabled &&
        (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
        cursor: not-allowed;
        opacity: 0.4;
      `};
    `, state);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ...trackProps, ref: trackRef, className: track, children: children }));
};


/***/ }),

/***/ "./src/components/Slider/index.tsx":
/*!*****************************************!*\
  !*** ./src/components/Slider/index.tsx ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Slider: function() { return /* reexport safe */ _Slider__WEBPACK_IMPORTED_MODULE_0__.Slider; }
/* harmony export */ });
/* harmony import */ var _Slider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Slider */ "./src/components/Slider/Slider.tsx");



/***/ }),

/***/ "./src/components/States/States.tsx":
/*!******************************************!*\
  !*** ./src/components/States/States.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const States = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ...props, className: 'rcx-states', children: children }));
/* harmony default export */ __webpack_exports__["default"] = (States);


/***/ }),

/***/ "./src/components/States/StatesAction.tsx":
/*!************************************************!*\
  !*** ./src/components/States/StatesAction.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/components/index.ts");


const StatesAction = ({ primary = true, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(___WEBPACK_IMPORTED_MODULE_1__.Button, { ...props, primary: primary }));
/* harmony default export */ __webpack_exports__["default"] = (StatesAction);


/***/ }),

/***/ "./src/components/States/StatesActions.tsx":
/*!*************************************************!*\
  !*** ./src/components/States/StatesActions.tsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ButtonGroup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ButtonGroup */ "./src/components/ButtonGroup/index.ts");


const StatesActions = (props) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ButtonGroup__WEBPACK_IMPORTED_MODULE_1__.ButtonGroup, { ...props });
/* harmony default export */ __webpack_exports__["default"] = (StatesActions);


/***/ }),

/***/ "./src/components/States/StatesIcon.tsx":
/*!**********************************************!*\
  !*** ./src/components/States/StatesIcon.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");


const StatesIcon = ({ variation, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__.Icon, { ...props, "rcx-states__icon": true, className: variation && `rcx-states__icon--${variation}`, size: 'x32' }));
/* harmony default export */ __webpack_exports__["default"] = (StatesIcon);


/***/ }),

/***/ "./src/components/States/StatesLink.tsx":
/*!**********************************************!*\
  !*** ./src/components/States/StatesLink.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box/Box */ "./src/components/Box/Box.tsx");


const StatesLink = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { is: 'a', "rcx-states__link": true, ...props }));
/* harmony default export */ __webpack_exports__["default"] = (StatesLink);


/***/ }),

/***/ "./src/components/States/StatesSubtitle.tsx":
/*!**************************************************!*\
  !*** ./src/components/States/StatesSubtitle.tsx ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const StatesSubtitle = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ...props, className: 'rcx-states__subtitle', children: children }));
/* harmony default export */ __webpack_exports__["default"] = (StatesSubtitle);


/***/ }),

/***/ "./src/components/States/StatesSuggestion.tsx":
/*!****************************************************!*\
  !*** ./src/components/States/StatesSuggestion.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const StatesSuggestion = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ...props, className: 'rcx-states__suggestion', children: children }));
/* harmony default export */ __webpack_exports__["default"] = (StatesSuggestion);


/***/ }),

/***/ "./src/components/States/StatesSuggestionList.tsx":
/*!********************************************************!*\
  !*** ./src/components/States/StatesSuggestionList.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const StatesSuggestionList = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", { ...props, className: 'rcx-states__list', children: children }));
/* harmony default export */ __webpack_exports__["default"] = (StatesSuggestionList);


/***/ }),

/***/ "./src/components/States/StatesSuggestionListItem.tsx":
/*!************************************************************!*\
  !*** ./src/components/States/StatesSuggestionListItem.tsx ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const StatesSuggestionListItem = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { ...props, className: 'rcx-states__list-item', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'rcx-states__list-item-wrapper', children: children }) }));
/* harmony default export */ __webpack_exports__["default"] = (StatesSuggestionListItem);


/***/ }),

/***/ "./src/components/States/StatesSuggestionText.tsx":
/*!********************************************************!*\
  !*** ./src/components/States/StatesSuggestionText.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const StatesSuggestionText = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ...props, className: 'rcx-states__suggestion-text', children: children }));
/* harmony default export */ __webpack_exports__["default"] = (StatesSuggestionText);


/***/ }),

/***/ "./src/components/States/StatesTitle.tsx":
/*!***********************************************!*\
  !*** ./src/components/States/StatesTitle.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const StatesTitle = ({ children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h3", { ...props, className: 'rcx-states__title', children: children }));
/* harmony default export */ __webpack_exports__["default"] = (StatesTitle);


/***/ }),

/***/ "./src/components/States/index.tsx":
/*!*****************************************!*\
  !*** ./src/components/States/index.tsx ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   States: function() { return /* reexport safe */ _States__WEBPACK_IMPORTED_MODULE_0__["default"]; },
/* harmony export */   StatesAction: function() { return /* reexport safe */ _StatesAction__WEBPACK_IMPORTED_MODULE_1__["default"]; },
/* harmony export */   StatesActions: function() { return /* reexport safe */ _StatesActions__WEBPACK_IMPORTED_MODULE_2__["default"]; },
/* harmony export */   StatesIcon: function() { return /* reexport safe */ _StatesIcon__WEBPACK_IMPORTED_MODULE_3__["default"]; },
/* harmony export */   StatesLink: function() { return /* reexport safe */ _StatesLink__WEBPACK_IMPORTED_MODULE_4__["default"]; },
/* harmony export */   StatesSubtitle: function() { return /* reexport safe */ _StatesSubtitle__WEBPACK_IMPORTED_MODULE_5__["default"]; },
/* harmony export */   StatesSuggestion: function() { return /* reexport safe */ _StatesSuggestion__WEBPACK_IMPORTED_MODULE_6__["default"]; },
/* harmony export */   StatesSuggestionList: function() { return /* reexport safe */ _StatesSuggestionList__WEBPACK_IMPORTED_MODULE_7__["default"]; },
/* harmony export */   StatesSuggestionListItem: function() { return /* reexport safe */ _StatesSuggestionListItem__WEBPACK_IMPORTED_MODULE_8__["default"]; },
/* harmony export */   StatesSuggestionText: function() { return /* reexport safe */ _StatesSuggestionText__WEBPACK_IMPORTED_MODULE_9__["default"]; },
/* harmony export */   StatesTitle: function() { return /* reexport safe */ _StatesTitle__WEBPACK_IMPORTED_MODULE_10__["default"]; }
/* harmony export */ });
/* harmony import */ var _States__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./States */ "./src/components/States/States.tsx");
/* harmony import */ var _StatesAction__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./StatesAction */ "./src/components/States/StatesAction.tsx");
/* harmony import */ var _StatesActions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./StatesActions */ "./src/components/States/StatesActions.tsx");
/* harmony import */ var _StatesIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./StatesIcon */ "./src/components/States/StatesIcon.tsx");
/* harmony import */ var _StatesLink__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./StatesLink */ "./src/components/States/StatesLink.tsx");
/* harmony import */ var _StatesSubtitle__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./StatesSubtitle */ "./src/components/States/StatesSubtitle.tsx");
/* harmony import */ var _StatesSuggestion__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./StatesSuggestion */ "./src/components/States/StatesSuggestion.tsx");
/* harmony import */ var _StatesSuggestionList__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./StatesSuggestionList */ "./src/components/States/StatesSuggestionList.tsx");
/* harmony import */ var _StatesSuggestionListItem__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./StatesSuggestionListItem */ "./src/components/States/StatesSuggestionListItem.tsx");
/* harmony import */ var _StatesSuggestionText__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./StatesSuggestionText */ "./src/components/States/StatesSuggestionText.tsx");
/* harmony import */ var _StatesTitle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./StatesTitle */ "./src/components/States/StatesTitle.tsx");














/***/ }),

/***/ "./src/components/StatusBullet/StatusBullet.tsx":
/*!******************************************************!*\
  !*** ./src/components/StatusBullet/StatusBullet.tsx ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StatusBullet: function() { return /* binding */ StatusBullet; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _icons_Away__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./icons/Away */ "./src/components/StatusBullet/icons/Away.tsx");
/* harmony import */ var _icons_Busy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./icons/Busy */ "./src/components/StatusBullet/icons/Busy.tsx");
/* harmony import */ var _icons_Disabled__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./icons/Disabled */ "./src/components/StatusBullet/icons/Disabled.tsx");
/* harmony import */ var _icons_Loading__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./icons/Loading */ "./src/components/StatusBullet/icons/Loading.tsx");
/* harmony import */ var _icons_Offline__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./icons/Offline */ "./src/components/StatusBullet/icons/Offline.tsx");
/* harmony import */ var _icons_Online__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./icons/Online */ "./src/components/StatusBullet/icons/Online.tsx");







/**
 * The `StatusBullet` is used to inform the user status.
 */
const StatusBullet = ({ status = 'loading', ...props }) => {
    switch (status) {
        case 'online':
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_icons_Online__WEBPACK_IMPORTED_MODULE_6__["default"], { ...props });
        case 'away':
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_icons_Away__WEBPACK_IMPORTED_MODULE_1__["default"], { ...props });
        case 'busy':
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_icons_Busy__WEBPACK_IMPORTED_MODULE_2__["default"], { ...props });
        case 'disabled':
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_icons_Disabled__WEBPACK_IMPORTED_MODULE_3__["default"], { ...props });
        case 'offline':
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_icons_Offline__WEBPACK_IMPORTED_MODULE_5__["default"], { ...props });
        default:
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_icons_Loading__WEBPACK_IMPORTED_MODULE_4__["default"], { ...props });
    }
};



/***/ }),

/***/ "./src/components/StatusBullet/icons/Away.tsx":
/*!****************************************************!*\
  !*** ./src/components/StatusBullet/icons/Away.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const Away = ({ size, className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", { ...props, width: '10', height: '10', viewBox: '0 0 10 10', className: `rcx-status-bullet rcx-status-bullet--away ${className} ${size === 'small' ? 'rcx-status-bullet--small' : ''}`, xmlns: 'http://www.w3.org/2000/svg', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", { fillRule: 'evenodd', clipRule: 'evenodd', d: 'M5.13337 9.93325C7.78434 9.93325 9.93338 7.78422 9.93338 5.13325C9.93338 2.48229 7.78434 0.333252 5.13337 0.333252C2.48241 0.333252 0.333374 2.48229 0.333374 5.13325C0.333374 7.78422 2.48241 9.93325 5.13337 9.93325ZM5.80004 2.33325C5.80004 1.96506 5.50156 1.66659 5.13337 1.66659C4.76518 1.66659 4.46671 1.96506 4.46671 2.33325V5.13325V5.45367L4.71691 5.65383L6.71691 7.25383C7.00442 7.48384 7.42395 7.43722 7.65395 7.14972C7.88396 6.86221 7.83735 6.44268 7.54984 6.21267L5.80004 4.81284V2.33325Z' }) }));
/* harmony default export */ __webpack_exports__["default"] = (Away);


/***/ }),

/***/ "./src/components/StatusBullet/icons/Busy.tsx":
/*!****************************************************!*\
  !*** ./src/components/StatusBullet/icons/Busy.tsx ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const Busy = ({ size, className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", { ...props, width: '10', height: '10', viewBox: '0 0 10 10', className: `rcx-status-bullet rcx-status-bullet--busy ${className} ${size === 'small' ? 'rcx-status-bullet--small' : ''}`, xmlns: 'http://www.w3.org/2000/svg', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", { fillRule: 'evenodd', clipRule: 'evenodd', d: 'M5.13337 9.93325C7.78434 9.93325 9.93338 7.78422 9.93338 5.13325C9.93338 2.48229 7.78434 0.333252 5.13337 0.333252C2.48241 0.333252 0.333374 2.48229 0.333374 5.13325C0.333374 7.78422 2.48241 9.93325 5.13337 9.93325ZM3.53338 4.46655C3.16519 4.46655 2.86671 4.76503 2.86671 5.13322C2.86671 5.50141 3.16519 5.79989 3.53338 5.79989H6.73338C7.10157 5.79989 7.40004 5.50141 7.40004 5.13322C7.40004 4.76503 7.10157 4.46655 6.73338 4.46655H3.53338Z' }) }));
/* harmony default export */ __webpack_exports__["default"] = (Busy);


/***/ }),

/***/ "./src/components/StatusBullet/icons/Disabled.tsx":
/*!********************************************************!*\
  !*** ./src/components/StatusBullet/icons/Disabled.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const Disabled = ({ size, className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", { ...props, width: '24', height: '24', viewBox: '0 0 24 24', className: `rcx-status-bullet rcx-status-bullet--disabled ${className} ${size === 'small' ? 'rcx-status-bullet--small' : ''}`, xmlns: 'http://www.w3.org/2000/svg', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", { fillRule: 'evenodd', clipRule: 'evenodd', d: 'M12 24C18.6274 24 24 18.6274 24 12C24 5.37258 18.6274 0 12 0C5.37258 0 0 5.37258 0 12C0 18.6274 5.37258 24 12 24ZM13.3367 5.33333C13.3367 4.59695 12.7398 4 12.0034 4C11.267 4 10.67 4.59695 10.67 5.33333V14.6667C10.67 15.403 11.267 16 12.0034 16C12.7398 16 13.3367 15.403 13.3367 14.6667V5.33333ZM13.3367 18.6667C13.3367 17.9303 12.7398 17.3333 12.0034 17.3333C11.267 17.3333 10.67 17.9303 10.67 18.6667C10.67 19.403 11.267 20 12.0034 20C12.7398 20 13.3367 19.403 13.3367 18.6667Z' }) }));
/* harmony default export */ __webpack_exports__["default"] = (Disabled);


/***/ }),

/***/ "./src/components/StatusBullet/icons/Loading.tsx":
/*!*******************************************************!*\
  !*** ./src/components/StatusBullet/icons/Loading.tsx ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const Loading = ({ size, className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", { ...props, width: '12', height: '12', viewBox: '0 0 12 12', fill: 'none', xmlns: 'http://www.w3.org/2000/svg', className: `rcx-status-bullet rcx-status-bullet--loading ${className} ${size === 'small' ? 'rcx-status-bullet--small' : ''}`, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("circle", { cx: '6', cy: '6', r: '5', className: 'rcx-status-bullet rcx-status-bullet--loading', strokeWidth: '2', strokeDasharray: '2 2' }) }));
/* harmony default export */ __webpack_exports__["default"] = (Loading);


/***/ }),

/***/ "./src/components/StatusBullet/icons/Offline.tsx":
/*!*******************************************************!*\
  !*** ./src/components/StatusBullet/icons/Offline.tsx ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const Offline = ({ size, className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", { ...props, width: '12', height: '12', viewBox: '0 0 12 12', fill: 'none', xmlns: 'http://www.w3.org/2000/svg', className: `rcx-status-bullet rcx-status-bullet--offline ${className} ${size === 'small' ? 'rcx-status-bullet--small' : ''}`, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("circle", { cx: '6', cy: '6', r: '5', className: `rcx-status-bullet rcx-status-bullet--offline`, strokeWidth: '2' }) }));
/* harmony default export */ __webpack_exports__["default"] = (Offline);


/***/ }),

/***/ "./src/components/StatusBullet/icons/Online.tsx":
/*!******************************************************!*\
  !*** ./src/components/StatusBullet/icons/Online.tsx ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const Online = ({ size, className, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", { ...props, width: '24', height: '24', viewBox: '0 0 24 24', className: `rcx-status-bullet rcx-status-bullet--online ${className} ${size === 'small' ? 'rcx-status-bullet--small' : ''}`, xmlns: 'http://www.w3.org/2000/svg', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", { d: 'M24 12.0001C24 18.6275 18.6274 24.0001 12 24.0001C5.37255 24.0001 -3.05176e-05 18.6275 -3.05176e-05 12.0001C-3.05176e-05 5.37271 5.37255 0.00012207 12 0.00012207C18.6274 0.00012207 24 5.37271 24 12.0001Z' }) }));
/* harmony default export */ __webpack_exports__["default"] = (Online);


/***/ }),

/***/ "./src/components/StatusBullet/index.tsx":
/*!***********************************************!*\
  !*** ./src/components/StatusBullet/index.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StatusBullet: function() { return /* reexport safe */ _StatusBullet__WEBPACK_IMPORTED_MODULE_0__.StatusBullet; }
/* harmony export */ });
/* harmony import */ var _StatusBullet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./StatusBullet */ "./src/components/StatusBullet/StatusBullet.tsx");



/***/ }),

/***/ "./src/components/Table/Table.tsx":
/*!****************************************!*\
  !*** ./src/components/Table/Table.tsx ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Table: function() { return /* binding */ Table; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");


const Table = ({ striped, sticky, fixed = false, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-table__wrapper": true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { is: 'table', "rcx-table": true, "rcx-table--fixed": fixed, "rcx-table--sticky": sticky, "rcx-table--striped": striped, ...props }) }));


/***/ }),

/***/ "./src/components/Table/TableBody.tsx":
/*!********************************************!*\
  !*** ./src/components/Table/TableBody.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableBody: function() { return /* binding */ TableBody; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");


const TableBody = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { is: 'tbody', "rcx-table__body": true, ...props }));


/***/ }),

/***/ "./src/components/Table/TableCell.tsx":
/*!********************************************!*\
  !*** ./src/components/Table/TableCell.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableCell: function() { return /* binding */ TableCell; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _TableHead__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TableHead */ "./src/components/Table/TableHead.tsx");




const TableCell = ({ align, clickable, children, ...props }) => {
    const isInsideHead = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(_TableHead__WEBPACK_IMPORTED_MODULE_3__.TableHeadContext);
    const innerElement = children ??
        (!isInsideHead ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { display: 'inline-block', is: 'hr', width: 'x14', borderWidth: 1 })) : undefined);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: isInsideHead ? 'th' : 'td', "rcx-table__cell": true, "rcx-table__cell--align": align, "rcx-table__cell--header": isInsideHead, "rcx-table__cell--clickable": clickable, children: innerElement, ...props }));
};


/***/ }),

/***/ "./src/components/Table/TableFoot.tsx":
/*!********************************************!*\
  !*** ./src/components/Table/TableFoot.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableFoot: function() { return /* binding */ TableFoot; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");


const TableFoot = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { is: 'tfoot', "rcx-table__foot": true, ...props }));


/***/ }),

/***/ "./src/components/Table/TableHead.tsx":
/*!********************************************!*\
  !*** ./src/components/Table/TableHead.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableHead: function() { return /* binding */ TableHead; },
/* harmony export */   TableHeadContext: function() { return /* binding */ TableHeadContext; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const TableHeadContext = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)(false);
const TableHead = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TableHeadContext.Provider, { value: true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'thead', "rcx-table__head": true, ...props }) }));


/***/ }),

/***/ "./src/components/Table/TableRow.tsx":
/*!*******************************************!*\
  !*** ./src/components/Table/TableRow.tsx ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableRow: function() { return /* binding */ TableRow; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");


const TableRow = ({ action, selected, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { is: 'tr', "rcx-table__row": true, "rcx-table__row--selected": selected, "rcx-table__row--action": action, ...props }));


/***/ }),

/***/ "./src/components/Table/TableSelection/TableSelection.tsx":
/*!****************************************************************!*\
  !*** ./src/components/Table/TableSelection/TableSelection.tsx ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableSelection: function() { return /* binding */ TableSelection; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Margins__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Margins */ "./src/components/Margins/index.ts");



const TableSelection = ({ children, text, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { "rcx-table__selection": true, display: 'flex', alignItems: 'center', justifyContent: 'space-between', pi: 24, elevation: '2', ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { fontScale: 'p2b', mb: 16, flexShrink: 1, withTruncatedText: true, children: text }), children && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { mi: 'neg-x8', fontScale: 'p2m', flexShrink: 0, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Margins__WEBPACK_IMPORTED_MODULE_2__["default"], { inline: 'x4', children: children }) }))] }));


/***/ }),

/***/ "./src/components/Table/TableSelection/TableSelectionButton.tsx":
/*!**********************************************************************!*\
  !*** ./src/components/Table/TableSelection/TableSelectionButton.tsx ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableSelectionButton: function() { return /* binding */ TableSelectionButton; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Button */ "./src/components/Button/index.ts");


const TableSelectionButton = (props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__.Button, { small: true, flexShrink: 0, ...props }));


/***/ }),

/***/ "./src/components/Table/TableSelection/TableSelectionButtonGroup.tsx":
/*!***************************************************************************!*\
  !*** ./src/components/Table/TableSelection/TableSelectionButtonGroup.tsx ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableSelectionButtonGroup: function() { return /* binding */ TableSelectionButtonGroup; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ButtonGroup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../ButtonGroup */ "./src/components/ButtonGroup/index.ts");


const TableSelectionButtonGroup = (props) => (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ButtonGroup__WEBPACK_IMPORTED_MODULE_1__.ButtonGroup, { ...props });


/***/ }),

/***/ "./src/components/Table/TableSelection/index.ts":
/*!******************************************************!*\
  !*** ./src/components/Table/TableSelection/index.ts ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableSelection: function() { return /* reexport safe */ _TableSelection__WEBPACK_IMPORTED_MODULE_0__.TableSelection; },
/* harmony export */   TableSelectionButton: function() { return /* reexport safe */ _TableSelectionButton__WEBPACK_IMPORTED_MODULE_1__.TableSelectionButton; },
/* harmony export */   TableSelectionButtonGroup: function() { return /* reexport safe */ _TableSelectionButtonGroup__WEBPACK_IMPORTED_MODULE_2__.TableSelectionButtonGroup; }
/* harmony export */ });
/* harmony import */ var _TableSelection__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TableSelection */ "./src/components/Table/TableSelection/TableSelection.tsx");
/* harmony import */ var _TableSelectionButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./TableSelectionButton */ "./src/components/Table/TableSelection/TableSelectionButton.tsx");
/* harmony import */ var _TableSelectionButtonGroup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TableSelectionButtonGroup */ "./src/components/Table/TableSelection/TableSelectionButtonGroup.tsx");





/***/ }),

/***/ "./src/components/Table/index.ts":
/*!***************************************!*\
  !*** ./src/components/Table/index.ts ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Table: function() { return /* reexport safe */ _Table__WEBPACK_IMPORTED_MODULE_0__.Table; },
/* harmony export */   TableBody: function() { return /* reexport safe */ _TableBody__WEBPACK_IMPORTED_MODULE_1__.TableBody; },
/* harmony export */   TableCell: function() { return /* reexport safe */ _TableCell__WEBPACK_IMPORTED_MODULE_2__.TableCell; },
/* harmony export */   TableFoot: function() { return /* reexport safe */ _TableFoot__WEBPACK_IMPORTED_MODULE_3__.TableFoot; },
/* harmony export */   TableHead: function() { return /* reexport safe */ _TableHead__WEBPACK_IMPORTED_MODULE_4__.TableHead; },
/* harmony export */   TableHeadContext: function() { return /* reexport safe */ _TableHead__WEBPACK_IMPORTED_MODULE_4__.TableHeadContext; },
/* harmony export */   TableRow: function() { return /* reexport safe */ _TableRow__WEBPACK_IMPORTED_MODULE_5__.TableRow; },
/* harmony export */   TableSelection: function() { return /* reexport safe */ _TableSelection__WEBPACK_IMPORTED_MODULE_6__.TableSelection; },
/* harmony export */   TableSelectionButton: function() { return /* reexport safe */ _TableSelection__WEBPACK_IMPORTED_MODULE_6__.TableSelectionButton; },
/* harmony export */   TableSelectionButtonGroup: function() { return /* reexport safe */ _TableSelection__WEBPACK_IMPORTED_MODULE_6__.TableSelectionButtonGroup; }
/* harmony export */ });
/* harmony import */ var _Table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Table */ "./src/components/Table/Table.tsx");
/* harmony import */ var _TableBody__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./TableBody */ "./src/components/Table/TableBody.tsx");
/* harmony import */ var _TableCell__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TableCell */ "./src/components/Table/TableCell.tsx");
/* harmony import */ var _TableFoot__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TableFoot */ "./src/components/Table/TableFoot.tsx");
/* harmony import */ var _TableHead__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./TableHead */ "./src/components/Table/TableHead.tsx");
/* harmony import */ var _TableRow__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./TableRow */ "./src/components/Table/TableRow.tsx");
/* harmony import */ var _TableSelection__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./TableSelection */ "./src/components/Table/TableSelection/index.ts");









/***/ }),

/***/ "./src/components/Tabs/Tabs.tsx":
/*!**************************************!*\
  !*** ./src/components/Tabs/Tabs.tsx ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Tabs: function() { return /* binding */ Tabs; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _TabsItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TabsItem */ "./src/components/Tabs/TabsItem.tsx");



/**
 * Tabs is a component to navigate around the UI using buttons arranged together with the selected tab highlighted.
 */
function Tabs({ children, divider = true, ...props }) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { is: 'div', "rcx-tabs": true, "rcx-tabs--with-divider": divider, ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { is: 'div', "rcx-tabs__scroll-box": true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_1__["default"], { is: 'div', "rcx-tabs__wrapper": true, children: children, role: 'tablist' }) }) }));
}
/** @deprecated use named export TabsItem instead */
Tabs.Item = _TabsItem__WEBPACK_IMPORTED_MODULE_2__.TabsItem;


/***/ }),

/***/ "./src/components/Tabs/TabsItem.tsx":
/*!******************************************!*\
  !*** ./src/components/Tabs/TabsItem.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TabsItem: function() { return /* binding */ TabsItem; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const TabsItem = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function TabsItem({ selected, disabled, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'button', "rcx-tabs__item": true, "rcx-tabs__item--selected": selected, "rcx-tabs__item--disabled": disabled, "rcx-tabs__item--selected--disabled": selected && disabled, "aria-selected": selected ? 'true' : 'false', ref: ref, role: 'tab', ...props }));
});


/***/ }),

/***/ "./src/components/Tabs/index.tsx":
/*!***************************************!*\
  !*** ./src/components/Tabs/index.tsx ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Tabs: function() { return /* reexport safe */ _Tabs__WEBPACK_IMPORTED_MODULE_0__.Tabs; },
/* harmony export */   TabsItem: function() { return /* reexport safe */ _TabsItem__WEBPACK_IMPORTED_MODULE_1__.TabsItem; }
/* harmony export */ });
/* harmony import */ var _Tabs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Tabs */ "./src/components/Tabs/Tabs.tsx");
/* harmony import */ var _TabsItem__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./TabsItem */ "./src/components/Tabs/TabsItem.tsx");




/***/ }),

/***/ "./src/components/Tag/Tag.tsx":
/*!************************************!*\
  !*** ./src/components/Tag/Tag.tsx ***!
  \************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Tag: function() { return /* binding */ Tag; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/prependClassName */ "./src/helpers/prependClassName.ts");
/* harmony import */ var _Box_Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box/Box */ "./src/components/Box/Box.tsx");



/**
 * Used for mentions
 */
const Tag = ({ large, medium, className, disabled, onClick, variant, children, icon, href, ...props }) => {
    const modifiers = [
        variant,
        medium && 'medium',
        large && 'large',
        disabled && 'disabled',
        onClick && 'clickable',
        href && 'clickable',
    ]
        .filter(Boolean)
        .map((modifier) => `rcx-tag--${modifier}`)
        .join(' ');
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: href ? 'a' : 'span', className: (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_1__.prependClassName)(className, `rcx-tag ${modifiers}`), onClick: onClick, href: href, ...props, children: [icon, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'rcx-tag__inner', children: children })] }));
};


/***/ }),

/***/ "./src/components/Tag/index.tsx":
/*!**************************************!*\
  !*** ./src/components/Tag/index.tsx ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Tag: function() { return /* reexport safe */ _Tag__WEBPACK_IMPORTED_MODULE_0__.Tag; }
/* harmony export */ });
/* harmony import */ var _Tag__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Tag */ "./src/components/Tag/Tag.tsx");



/***/ }),

/***/ "./src/components/TelephoneInput/TelephoneInput.tsx":
/*!**********************************************************!*\
  !*** ./src/components/TelephoneInput/TelephoneInput.tsx ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TelephoneInput: function() { return /* binding */ TelephoneInput; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../InputBox */ "./src/components/InputBox/index.ts");



/**
 * An input for telephone numbers.
 */
const TelephoneInput = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function TelephoneInput(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBox__WEBPACK_IMPORTED_MODULE_2__.InputBox, { type: 'tel', ref: ref, ...props });
});


/***/ }),

/***/ "./src/components/TelephoneInput/index.tsx":
/*!*************************************************!*\
  !*** ./src/components/TelephoneInput/index.tsx ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TelephoneInput: function() { return /* reexport safe */ _TelephoneInput__WEBPACK_IMPORTED_MODULE_0__.TelephoneInput; }
/* harmony export */ });
/* harmony import */ var _TelephoneInput__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TelephoneInput */ "./src/components/TelephoneInput/TelephoneInput.tsx");



/***/ }),

/***/ "./src/components/TextAreaInput/TextAreaInput.tsx":
/*!********************************************************!*\
  !*** ./src/components/TextAreaInput/TextAreaInput.tsx ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TextAreaInput: function() { return /* binding */ TextAreaInput; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../InputBox */ "./src/components/InputBox/index.ts");



/**
 * An input for multi-line plain-text editing.
 */
const TextAreaInput = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function TextAreaInput(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBox__WEBPACK_IMPORTED_MODULE_2__.InputBox, { type: 'textarea', ref: ref, ...props });
});


/***/ }),

/***/ "./src/components/TextAreaInput/index.ts":
/*!***********************************************!*\
  !*** ./src/components/TextAreaInput/index.ts ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TextAreaInput: function() { return /* reexport safe */ _TextAreaInput__WEBPACK_IMPORTED_MODULE_0__.TextAreaInput; }
/* harmony export */ });
/* harmony import */ var _TextAreaInput__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TextAreaInput */ "./src/components/TextAreaInput/TextAreaInput.tsx");



/***/ }),

/***/ "./src/components/TextInput/TextInput.tsx":
/*!************************************************!*\
  !*** ./src/components/TextInput/TextInput.tsx ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TextInput: function() { return /* binding */ TextInput; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../InputBox */ "./src/components/InputBox/index.ts");



/**
 * An input for any kind of single-line text.
 */
const TextInput = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function TextInput(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBox__WEBPACK_IMPORTED_MODULE_2__.InputBox, { type: 'text', ref: ref, ...props });
});


/***/ }),

/***/ "./src/components/TextInput/index.tsx":
/*!********************************************!*\
  !*** ./src/components/TextInput/index.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TextInput: function() { return /* reexport safe */ _TextInput__WEBPACK_IMPORTED_MODULE_0__.TextInput; }
/* harmony export */ });
/* harmony import */ var _TextInput__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TextInput */ "./src/components/TextInput/TextInput.tsx");



/***/ }),

/***/ "./src/components/Throbber/Throbber.tsx":
/*!**********************************************!*\
  !*** ./src/components/Throbber/Throbber.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Throbber: function() { return /* binding */ Throbber; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/css-in-js */ "@rocket.chat/css-in-js");
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");




function Circle({ disabled, circleCount, iteration, inheritColor, ...props }) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_3__["default"], { is: 'span', className: (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
        animation-duration: ${circleCount * 0.466}s;
        animation-delay: ${iteration * 0.16}s;
      `, "rcx-throbber__circle": true, "rcx-throbber__circle--disabled": disabled, "rcx-throbber__circle--inherit-color": inheritColor, ...props }));
}
/**
 * Indicates content that has not loaded yet.
 */
const Throbber = (0,react__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(function Throbber({ disabled, size = 'x16', circleCount = 3, inheritColor, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_3__["default"], { "rcx-throbber": true, ref: ref, ...props, children: Array.from({ length: circleCount || 3 }, (_, iteration) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Circle, { circleCount: circleCount, iteration: iteration, disabled: !!disabled, size: size, inheritColor: !!inheritColor }, iteration))) }));
});


/***/ }),

/***/ "./src/components/Throbber/index.tsx":
/*!*******************************************!*\
  !*** ./src/components/Throbber/index.tsx ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Throbber: function() { return /* reexport safe */ _Throbber__WEBPACK_IMPORTED_MODULE_0__.Throbber; }
/* harmony export */ });
/* harmony import */ var _Throbber__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Throbber */ "./src/components/Throbber/Throbber.tsx");



/***/ }),

/***/ "./src/components/Tile/Tile.tsx":
/*!**************************************!*\
  !*** ./src/components/Tile/Tile.tsx ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const Tile = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Tile({ elevation = '1', padding = 16, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { ref: ref, "rcx-tile": true, "rcx-tile--elevation": elevation, padding: padding, ...props }));
});
/* harmony default export */ __webpack_exports__["default"] = (Tile);


/***/ }),

/***/ "./src/components/Tile/index.ts":
/*!**************************************!*\
  !*** ./src/components/Tile/index.ts ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* reexport safe */ _Tile__WEBPACK_IMPORTED_MODULE_0__["default"]; }
/* harmony export */ });
/* harmony import */ var _Tile__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Tile */ "./src/components/Tile/Tile.tsx");



/***/ }),

/***/ "./src/components/ToastBar/ToastBar.tsx":
/*!**********************************************!*\
  !*** ./src/components/ToastBar/ToastBar.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ToastBar: function() { return /* binding */ ToastBar; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/css-in-js */ "@rocket.chat/css-in-js");
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Button */ "./src/components/Button/index.ts");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.ts");






/**
 * Shows alerts in a toast component.
 */
function ToastBar({ children, className = '', variant = 'info', time = 5, isPaused, id, onClose, buttonLabel = 'Dismiss alert', ...props }) {
    const iconName = (variant === 'success' && 'circle-check') ||
        (variant === 'error' && 'ban') ||
        'info';
    const sideOpen = (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.keyframes) `
    from {
      opacity: 0;
    }
    to {
      opacity: 1;
    }
  `;
    const progressBar = (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.keyframes) `
    from {
      width: 0%;
    }

    to {
      width: 100%;
    }
  `;
    const toastBarAnimation = (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
    animation: ${sideOpen} 0.5s;
  `;
    const progressBarAnimation = (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_1__.css) `
    &::after {
      width: 0%;
      animation: ${progressBar} ${time}s;
      animation-fill-mode: forwards;
      animation-play-state: ${isPaused ? 'paused' : 'running'};
    }
  `;
    const uniqueId = (0,react__WEBPACK_IMPORTED_MODULE_2__.useId)();
    const toastId = id || uniqueId;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_3__["default"], { className: [
            `rcx-toastbar rcx-toastbar--${variant} ${className}`,
            toastBarAnimation,
        ], elevation: '2nb', borderRadius: 'x4', ...props, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'rcx-toastbar_inner', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_5__.Icon, { className: `rcx-toastbar_icon--${variant}`, size: 'x20', name: iconName }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { role: 'alert', className: 'rcx-toastbar_content', children: children }), onClose && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'rcx-toastbar-close', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_4__.IconButton, { tiny: true, "aria-label": buttonLabel, onClick: () => onClose(toastId), icon: 'cross' }) }))] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_3__["default"], { className: [progressBarAnimation, 'rcx-toastbar_progressbar'] })] }));
}


/***/ }),

/***/ "./src/components/ToastBar/index.ts":
/*!******************************************!*\
  !*** ./src/components/ToastBar/index.ts ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ToastBar: function() { return /* reexport safe */ _ToastBar__WEBPACK_IMPORTED_MODULE_0__.ToastBar; }
/* harmony export */ });
/* harmony import */ var _ToastBar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ToastBar */ "./src/components/ToastBar/ToastBar.tsx");



/***/ }),

/***/ "./src/components/ToggleSwitch/ToggleSwitch.tsx":
/*!******************************************************!*\
  !*** ./src/components/ToggleSwitch/ToggleSwitch.tsx ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ToggleSwitch: function() { return /* binding */ ToggleSwitch; }
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const ToggleSwitch = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function ToggleSwitch({ className, labelChildren, ...props }, ref) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'label', className: className, "rcx-toggle-switch": true, children: [labelChildren, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'input', ref: ref, "rcx-toggle-switch__input": true, type: 'checkbox', ...props }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'i', "rcx-toggle-switch__fake": true, "aria-hidden": 'true' })] }));
});


/***/ }),

/***/ "./src/components/ToggleSwitch/index.tsx":
/*!***********************************************!*\
  !*** ./src/components/ToggleSwitch/index.tsx ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ToggleSwitch: function() { return /* reexport safe */ _ToggleSwitch__WEBPACK_IMPORTED_MODULE_0__.ToggleSwitch; }
/* harmony export */ });
/* harmony import */ var _ToggleSwitch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ToggleSwitch */ "./src/components/ToggleSwitch/ToggleSwitch.tsx");



/***/ }),

/***/ "./src/components/Tooltip/Tooltip.tsx":
/*!********************************************!*\
  !*** ./src/components/Tooltip/Tooltip.tsx ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box */ "./src/components/Box/index.ts");



const parsePlacement = (placement) => {
    const [direction, position] = placement
        ? placement.split('-')
        : [false, false];
    if (direction === 'right' || direction === 'left') {
        return [direction, false];
    }
    return [direction, position];
};
const Tooltip = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Tooltip({ variation = 'dark', placement, ...props }, ref) {
    const [direction, position] = parsePlacement(placement);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Box__WEBPACK_IMPORTED_MODULE_2__["default"], { is: 'div', ref: ref, "rcx-tooltip": true, "rcx-tooltip--dir": direction, "rcx-tooltip--pos": position, "rcx-tooltip--light": variation === 'light', "rcx-tooltip--dark": variation === 'dark', ...props }));
});
/* harmony default export */ __webpack_exports__["default"] = (Tooltip);


/***/ }),

/***/ "./src/components/Tooltip/index.ts":
/*!*****************************************!*\
  !*** ./src/components/Tooltip/index.ts ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* reexport safe */ _Tooltip__WEBPACK_IMPORTED_MODULE_0__["default"]; }
/* harmony export */ });
/* harmony import */ var _Tooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Tooltip */ "./src/components/Tooltip/Tooltip.tsx");



/***/ }),

/***/ "./src/components/UrlInput/UrlInput.tsx":
/*!**********************************************!*\
  !*** ./src/components/UrlInput/UrlInput.tsx ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../InputBox */ "./src/components/InputBox/index.ts");



const UrlInput = (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function UrlInput(props, ref) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_InputBox__WEBPACK_IMPORTED_MODULE_2__.InputBox, { type: 'url', ref: ref, ...props });
});
/* harmony default export */ __webpack_exports__["default"] = (UrlInput);


/***/ }),

/***/ "./src/components/UrlInput/index.ts":
/*!******************************************!*\
  !*** ./src/components/UrlInput/index.ts ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* reexport safe */ _UrlInput__WEBPACK_IMPORTED_MODULE_0__["default"]; }
/* harmony export */ });
/* harmony import */ var _UrlInput__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./UrlInput */ "./src/components/UrlInput/UrlInput.tsx");



/***/ }),

/***/ "./src/components/index.ts":
/*!*********************************!*\
  !*** ./src/components/index.ts ***!
  \*********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Accordion: function() { return /* reexport safe */ _Accordion__WEBPACK_IMPORTED_MODULE_0__.Accordion; },
/* harmony export */   AccordionItem: function() { return /* reexport safe */ _Accordion__WEBPACK_IMPORTED_MODULE_0__.AccordionItem; },
/* harmony export */   ActionButton: function() { return /* reexport safe */ _Button__WEBPACK_IMPORTED_MODULE_9__.ActionButton; },
/* harmony export */   AnimatedVisibility: function() { return /* reexport safe */ _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_1__["default"]; },
/* harmony export */   AudioPlayer: function() { return /* reexport safe */ _AudioPlayer__WEBPACK_IMPORTED_MODULE_2__.AudioPlayer; },
/* harmony export */   AutoComplete: function() { return /* reexport safe */ _AutoComplete__WEBPACK_IMPORTED_MODULE_3__.AutoComplete; },
/* harmony export */   Avatar: function() { return /* reexport safe */ _Avatar__WEBPACK_IMPORTED_MODULE_4__.Avatar; },
/* harmony export */   AvatarContainer: function() { return /* reexport safe */ _Avatar__WEBPACK_IMPORTED_MODULE_4__.AvatarContainer; },
/* harmony export */   AvatarStack: function() { return /* reexport safe */ _Avatar__WEBPACK_IMPORTED_MODULE_4__.AvatarStack; },
/* harmony export */   Badge: function() { return /* reexport safe */ _Badge__WEBPACK_IMPORTED_MODULE_5__.Badge; },
/* harmony export */   Banner: function() { return /* reexport safe */ _Banner__WEBPACK_IMPORTED_MODULE_6__["default"]; },
/* harmony export */   Box: function() { return /* reexport safe */ _Box__WEBPACK_IMPORTED_MODULE_7__["default"]; },
/* harmony export */   Bubble: function() { return /* reexport safe */ _Bubble__WEBPACK_IMPORTED_MODULE_10__.Bubble; },
/* harmony export */   Button: function() { return /* reexport safe */ _Button__WEBPACK_IMPORTED_MODULE_9__["default"]; },
/* harmony export */   ButtonGroup: function() { return /* reexport safe */ _ButtonGroup__WEBPACK_IMPORTED_MODULE_11__.ButtonGroup; },
/* harmony export */   Callout: function() { return /* reexport safe */ _Callout__WEBPACK_IMPORTED_MODULE_12__.Callout; },
/* harmony export */   Card: function() { return /* reexport safe */ _Card__WEBPACK_IMPORTED_MODULE_13__.Card; },
/* harmony export */   CardBody: function() { return /* reexport safe */ _Card__WEBPACK_IMPORTED_MODULE_13__.CardBody; },
/* harmony export */   CardCol: function() { return /* reexport safe */ _Card__WEBPACK_IMPORTED_MODULE_13__.CardCol; },
/* harmony export */   CardContent: function() { return /* reexport safe */ _Card__WEBPACK_IMPORTED_MODULE_13__.CardContent; },
/* harmony export */   CardControls: function() { return /* reexport safe */ _Card__WEBPACK_IMPORTED_MODULE_13__.CardControls; },
/* harmony export */   CardGrid: function() { return /* reexport safe */ _CardGrid__WEBPACK_IMPORTED_MODULE_15__.CardGrid; },
/* harmony export */   CardGroup: function() { return /* reexport safe */ _CardGroup__WEBPACK_IMPORTED_MODULE_14__.CardGroup; },
/* harmony export */   CardHeader: function() { return /* reexport safe */ _Card__WEBPACK_IMPORTED_MODULE_13__.CardHeader; },
/* harmony export */   CardRow: function() { return /* reexport safe */ _Card__WEBPACK_IMPORTED_MODULE_13__.CardRow; },
/* harmony export */   CardTitle: function() { return /* reexport safe */ _Card__WEBPACK_IMPORTED_MODULE_13__.CardTitle; },
/* harmony export */   CheckBox: function() { return /* reexport safe */ _CheckBox__WEBPACK_IMPORTED_MODULE_16__.CheckBox; },
/* harmony export */   CheckOption: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_41__.CheckOption; },
/* harmony export */   Chevron: function() { return /* reexport safe */ _Chevron__WEBPACK_IMPORTED_MODULE_17__.Chevron; },
/* harmony export */   Chip: function() { return /* reexport safe */ _Chip__WEBPACK_IMPORTED_MODULE_21__["default"]; },
/* harmony export */   CodeSnippet: function() { return /* reexport safe */ _CodeSnippet__WEBPACK_IMPORTED_MODULE_18__["default"]; },
/* harmony export */   Contextualbar: function() { return /* reexport safe */ _Contextualbar__WEBPACK_IMPORTED_MODULE_19__.Contextualbar; },
/* harmony export */   ContextualbarAction: function() { return /* reexport safe */ _Contextualbar__WEBPACK_IMPORTED_MODULE_19__.ContextualbarAction; },
/* harmony export */   ContextualbarActions: function() { return /* reexport safe */ _Contextualbar__WEBPACK_IMPORTED_MODULE_19__.ContextualbarActions; },
/* harmony export */   ContextualbarButton: function() { return /* reexport safe */ _Contextualbar__WEBPACK_IMPORTED_MODULE_19__.ContextualbarButton; },
/* harmony export */   ContextualbarContent: function() { return /* reexport safe */ _Contextualbar__WEBPACK_IMPORTED_MODULE_19__.ContextualbarContent; },
/* harmony export */   ContextualbarEmptyContent: function() { return /* reexport safe */ _Contextualbar__WEBPACK_IMPORTED_MODULE_19__.ContextualbarEmptyContent; },
/* harmony export */   ContextualbarFooter: function() { return /* reexport safe */ _Contextualbar__WEBPACK_IMPORTED_MODULE_19__.ContextualbarFooter; },
/* harmony export */   ContextualbarHeader: function() { return /* reexport safe */ _Contextualbar__WEBPACK_IMPORTED_MODULE_19__.ContextualbarHeader; },
/* harmony export */   ContextualbarIcon: function() { return /* reexport safe */ _Contextualbar__WEBPACK_IMPORTED_MODULE_19__.ContextualbarIcon; },
/* harmony export */   ContextualbarSection: function() { return /* reexport safe */ _Contextualbar__WEBPACK_IMPORTED_MODULE_19__.ContextualbarSection; },
/* harmony export */   ContextualbarSkeleton: function() { return /* reexport safe */ _Contextualbar__WEBPACK_IMPORTED_MODULE_19__.ContextualbarSkeleton; },
/* harmony export */   ContextualbarTitle: function() { return /* reexport safe */ _Contextualbar__WEBPACK_IMPORTED_MODULE_19__.ContextualbarTitle; },
/* harmony export */   ContextualbarV2: function() { return /* reexport safe */ _ContextualbarV2__WEBPACK_IMPORTED_MODULE_20__.ContextualbarV2; },
/* harmony export */   ContextualbarV2Action: function() { return /* reexport safe */ _ContextualbarV2__WEBPACK_IMPORTED_MODULE_20__.ContextualbarV2Action; },
/* harmony export */   ContextualbarV2Actions: function() { return /* reexport safe */ _ContextualbarV2__WEBPACK_IMPORTED_MODULE_20__.ContextualbarV2Actions; },
/* harmony export */   ContextualbarV2Button: function() { return /* reexport safe */ _ContextualbarV2__WEBPACK_IMPORTED_MODULE_20__.ContextualbarV2Button; },
/* harmony export */   ContextualbarV2Content: function() { return /* reexport safe */ _ContextualbarV2__WEBPACK_IMPORTED_MODULE_20__.ContextualbarV2Content; },
/* harmony export */   ContextualbarV2EmptyContent: function() { return /* reexport safe */ _ContextualbarV2__WEBPACK_IMPORTED_MODULE_20__.ContextualbarV2EmptyContent; },
/* harmony export */   ContextualbarV2Footer: function() { return /* reexport safe */ _ContextualbarV2__WEBPACK_IMPORTED_MODULE_20__.ContextualbarV2Footer; },
/* harmony export */   ContextualbarV2Header: function() { return /* reexport safe */ _ContextualbarV2__WEBPACK_IMPORTED_MODULE_20__.ContextualbarV2Header; },
/* harmony export */   ContextualbarV2Icon: function() { return /* reexport safe */ _ContextualbarV2__WEBPACK_IMPORTED_MODULE_20__.ContextualbarV2Icon; },
/* harmony export */   ContextualbarV2Section: function() { return /* reexport safe */ _ContextualbarV2__WEBPACK_IMPORTED_MODULE_20__.ContextualbarV2Section; },
/* harmony export */   ContextualbarV2Skeleton: function() { return /* reexport safe */ _ContextualbarV2__WEBPACK_IMPORTED_MODULE_20__.ContextualbarV2Skeleton; },
/* harmony export */   ContextualbarV2Title: function() { return /* reexport safe */ _ContextualbarV2__WEBPACK_IMPORTED_MODULE_20__.ContextualbarV2Title; },
/* harmony export */   Divider: function() { return /* reexport safe */ _Divider__WEBPACK_IMPORTED_MODULE_22__.Divider; },
/* harmony export */   Dropdown: function() { return /* reexport safe */ _Dropdown__WEBPACK_IMPORTED_MODULE_23__.Dropdown; },
/* harmony export */   EmailInput: function() { return /* reexport safe */ _EmailInput__WEBPACK_IMPORTED_MODULE_24__.EmailInput; },
/* harmony export */   Field: function() { return /* reexport safe */ _Field__WEBPACK_IMPORTED_MODULE_25__.Field; },
/* harmony export */   FieldDescription: function() { return /* reexport safe */ _Field__WEBPACK_IMPORTED_MODULE_25__.FieldDescription; },
/* harmony export */   FieldError: function() { return /* reexport safe */ _Field__WEBPACK_IMPORTED_MODULE_25__.FieldError; },
/* harmony export */   FieldGroup: function() { return /* reexport safe */ _FieldGroup__WEBPACK_IMPORTED_MODULE_26__.FieldGroup; },
/* harmony export */   FieldHint: function() { return /* reexport safe */ _Field__WEBPACK_IMPORTED_MODULE_25__.FieldHint; },
/* harmony export */   FieldLabel: function() { return /* reexport safe */ _Field__WEBPACK_IMPORTED_MODULE_25__.FieldLabel; },
/* harmony export */   FieldLabelInfo: function() { return /* reexport safe */ _Field__WEBPACK_IMPORTED_MODULE_25__.FieldLabelInfo; },
/* harmony export */   FieldLink: function() { return /* reexport safe */ _Field__WEBPACK_IMPORTED_MODULE_25__.FieldLink; },
/* harmony export */   FieldRow: function() { return /* reexport safe */ _Field__WEBPACK_IMPORTED_MODULE_25__.FieldRow; },
/* harmony export */   Flex: function() { return /* reexport safe */ _Flex__WEBPACK_IMPORTED_MODULE_28__["default"]; },
/* harmony export */   FramedIcon: function() { return /* reexport safe */ _FramedIcon__WEBPACK_IMPORTED_MODULE_27__.FramedIcon; },
/* harmony export */   Grid: function() { return /* reexport safe */ _Grid__WEBPACK_IMPORTED_MODULE_29__.Grid; },
/* harmony export */   GridItem: function() { return /* reexport safe */ _Grid__WEBPACK_IMPORTED_MODULE_29__.GridItem; },
/* harmony export */   Icon: function() { return /* reexport safe */ _Icon__WEBPACK_IMPORTED_MODULE_30__.Icon; },
/* harmony export */   IconButton: function() { return /* reexport safe */ _Button__WEBPACK_IMPORTED_MODULE_9__.IconButton; },
/* harmony export */   Input: function() { return /* reexport safe */ _InputBox__WEBPACK_IMPORTED_MODULE_31__.Input; },
/* harmony export */   InputBox: function() { return /* reexport safe */ _InputBox__WEBPACK_IMPORTED_MODULE_31__.InputBox; },
/* harmony export */   InputBoxSkeleton: function() { return /* reexport safe */ _InputBox__WEBPACK_IMPORTED_MODULE_31__.InputBoxSkeleton; },
/* harmony export */   Label: function() { return /* reexport safe */ _Label__WEBPACK_IMPORTED_MODULE_32__.Label; },
/* harmony export */   Margins: function() { return /* reexport safe */ _Margins__WEBPACK_IMPORTED_MODULE_33__["default"]; },
/* harmony export */   Menu: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_34__.Menu; },
/* harmony export */   MenuItem: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_34__.MenuItem; },
/* harmony export */   MenuItemAvatar: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_34__.MenuItemAvatar; },
/* harmony export */   MenuItemColumn: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_34__.MenuItemColumn; },
/* harmony export */   MenuItemContent: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_34__.MenuItemContent; },
/* harmony export */   MenuItemDescription: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_34__.MenuItemDescription; },
/* harmony export */   MenuItemIcon: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_34__.MenuItemIcon; },
/* harmony export */   MenuItemInput: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_34__.MenuItemInput; },
/* harmony export */   MenuItemSkeleton: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_34__.MenuItemSkeleton; },
/* harmony export */   MenuItemTitle: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_34__.MenuItemTitle; },
/* harmony export */   MenuSection: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_34__.MenuSection; },
/* harmony export */   MenuV2: function() { return /* reexport safe */ _Menu__WEBPACK_IMPORTED_MODULE_34__.MenuV2; },
/* harmony export */   Message: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__["default"]; },
/* harmony export */   MessageBlock: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageBlock; },
/* harmony export */   MessageBody: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageBody; },
/* harmony export */   MessageContainer: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageContainer; },
/* harmony export */   MessageContainerFixed: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageContainerFixed; },
/* harmony export */   MessageDivider: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageDivider; },
/* harmony export */   MessageEmoji: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageEmoji; },
/* harmony export */   MessageGenericPreview: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageGenericPreview; },
/* harmony export */   MessageGenericPreviewContent: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageGenericPreviewContent; },
/* harmony export */   MessageGenericPreviewCoverImage: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageGenericPreviewCoverImage; },
/* harmony export */   MessageGenericPreviewDescription: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageGenericPreviewDescription; },
/* harmony export */   MessageGenericPreviewFooter: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageGenericPreviewFooter; },
/* harmony export */   MessageGenericPreviewIcon: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageGenericPreviewIcon; },
/* harmony export */   MessageGenericPreviewImage: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageGenericPreviewImage; },
/* harmony export */   MessageGenericPreviewThumb: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageGenericPreviewThumb; },
/* harmony export */   MessageGenericPreviewTitle: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageGenericPreviewTitle; },
/* harmony export */   MessageHeader: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageHeader; },
/* harmony export */   MessageHighlight: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageHighlight; },
/* harmony export */   MessageLeftContainer: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageLeftContainer; },
/* harmony export */   MessageMetrics: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageMetrics; },
/* harmony export */   MessageMetricsFollowing: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageMetricsFollowing; },
/* harmony export */   MessageMetricsItem: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageMetricsItem; },
/* harmony export */   MessageMetricsItemAvatarRow: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageMetricsItemAvatarRow; },
/* harmony export */   MessageMetricsItemAvatarRowContent: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageMetricsItemAvatarRowContent; },
/* harmony export */   MessageMetricsItemIcon: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageMetricsItemIcon; },
/* harmony export */   MessageMetricsItemLabel: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageMetricsItemLabel; },
/* harmony export */   MessageMetricsReply: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageMetricsReply; },
/* harmony export */   MessageName: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageName; },
/* harmony export */   MessageNameContainer: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageNameContainer; },
/* harmony export */   MessageReaction: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageReaction; },
/* harmony export */   MessageReactionAction: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageReactionAction; },
/* harmony export */   MessageReactionCounter: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageReactionCounter; },
/* harmony export */   MessageReactionEmoji: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageReactionEmoji; },
/* harmony export */   MessageReactions: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageReactions; },
/* harmony export */   MessageRole: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageRole; },
/* harmony export */   MessageRoles: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageRoles; },
/* harmony export */   MessageStatusIndicator: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageStatusIndicator; },
/* harmony export */   MessageStatusIndicatorItem: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageStatusIndicatorItem; },
/* harmony export */   MessageStatusIndicatorText: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageStatusIndicatorText; },
/* harmony export */   MessageStatusPrivateIndicator: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageStatusPrivateIndicator; },
/* harmony export */   MessageSystem: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageSystem; },
/* harmony export */   MessageSystemBlock: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageSystemBlock; },
/* harmony export */   MessageSystemBody: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageSystemBody; },
/* harmony export */   MessageSystemContainer: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageSystemContainer; },
/* harmony export */   MessageSystemLeftContainer: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageSystemLeftContainer; },
/* harmony export */   MessageSystemName: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageSystemName; },
/* harmony export */   MessageSystemTimestamp: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageSystemTimestamp; },
/* harmony export */   MessageTimestamp: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageTimestamp; },
/* harmony export */   MessageToolbar: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageToolbar; },
/* harmony export */   MessageToolbarItem: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageToolbarItem; },
/* harmony export */   MessageToolbarWrapper: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageToolbarWrapper; },
/* harmony export */   MessageUsername: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.MessageUsername; },
/* harmony export */   Modal: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_36__.Modal; },
/* harmony export */   ModalBackdrop: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_36__.ModalBackdrop; },
/* harmony export */   ModalClose: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_36__.ModalClose; },
/* harmony export */   ModalContent: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_36__.ModalContent; },
/* harmony export */   ModalFooter: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_36__.ModalFooter; },
/* harmony export */   ModalFooterAnnotation: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_36__.ModalFooterAnnotation; },
/* harmony export */   ModalFooterControllers: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_36__.ModalFooterControllers; },
/* harmony export */   ModalHeader: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_36__.ModalHeader; },
/* harmony export */   ModalHeaderText: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_36__.ModalHeaderText; },
/* harmony export */   ModalHeroImage: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_36__.ModalHeroImage; },
/* harmony export */   ModalIcon: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_36__.ModalIcon; },
/* harmony export */   ModalTagline: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_36__.ModalTagline; },
/* harmony export */   ModalThumb: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_36__.ModalThumb; },
/* harmony export */   ModalTitle: function() { return /* reexport safe */ _Modal__WEBPACK_IMPORTED_MODULE_36__.ModalTitle; },
/* harmony export */   MultiSelect: function() { return /* reexport safe */ _MultiSelect__WEBPACK_IMPORTED_MODULE_37__.MultiSelect; },
/* harmony export */   MultiSelectFiltered: function() { return /* reexport safe */ _MultiSelect__WEBPACK_IMPORTED_MODULE_37__.MultiSelectFiltered; },
/* harmony export */   NavBar: function() { return /* reexport safe */ _NavBar__WEBPACK_IMPORTED_MODULE_38__.NavBar; },
/* harmony export */   NavBarDivider: function() { return /* reexport safe */ _NavBar__WEBPACK_IMPORTED_MODULE_38__.NavBarDivider; },
/* harmony export */   NavBarGroup: function() { return /* reexport safe */ _NavBar__WEBPACK_IMPORTED_MODULE_38__.NavBarGroup; },
/* harmony export */   NavBarItem: function() { return /* reexport safe */ _NavBar__WEBPACK_IMPORTED_MODULE_38__.NavBarItem; },
/* harmony export */   NavBarSection: function() { return /* reexport safe */ _NavBar__WEBPACK_IMPORTED_MODULE_38__.NavBarSection; },
/* harmony export */   NumberInput: function() { return /* reexport safe */ _NumberInput__WEBPACK_IMPORTED_MODULE_39__.NumberInput; },
/* harmony export */   Option: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_41__.Option; },
/* harmony export */   OptionAvatar: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_41__.OptionAvatar; },
/* harmony export */   OptionColumn: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_41__.OptionColumn; },
/* harmony export */   OptionContainer: function() { return /* reexport safe */ _Options__WEBPACK_IMPORTED_MODULE_40__.OptionContainer; },
/* harmony export */   OptionContent: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_41__.OptionContent; },
/* harmony export */   OptionDescription: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_41__.OptionDescription; },
/* harmony export */   OptionDescriptionBlock: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_41__.OptionDescriptionBlock; },
/* harmony export */   OptionDivider: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_41__.OptionDivider; },
/* harmony export */   OptionHeader: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_41__.OptionHeader; },
/* harmony export */   OptionIcon: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_41__.OptionIcon; },
/* harmony export */   OptionInput: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_41__.OptionInput; },
/* harmony export */   OptionMenu: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_41__.OptionMenu; },
/* harmony export */   OptionSkeleton: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_41__.OptionSkeleton; },
/* harmony export */   OptionTitle: function() { return /* reexport safe */ _Option__WEBPACK_IMPORTED_MODULE_41__.OptionTitle; },
/* harmony export */   Options: function() { return /* reexport safe */ _Options__WEBPACK_IMPORTED_MODULE_40__.Options; },
/* harmony export */   PaginatedMultiSelectFiltered: function() { return /* reexport safe */ _PaginatedSelect__WEBPACK_IMPORTED_MODULE_54__.PaginatedMultiSelectFiltered; },
/* harmony export */   PaginatedSelectFiltered: function() { return /* reexport safe */ _PaginatedSelect__WEBPACK_IMPORTED_MODULE_54__.PaginatedSelectFiltered; },
/* harmony export */   Pagination: function() { return /* reexport safe */ _Pagination__WEBPACK_IMPORTED_MODULE_42__.Pagination; },
/* harmony export */   PaletteStyleTag: function() { return /* reexport safe */ _PaletteStyleTag__WEBPACK_IMPORTED_MODULE_43__.PaletteStyleTag; },
/* harmony export */   PasswordInput: function() { return /* reexport safe */ _PasswordInput__WEBPACK_IMPORTED_MODULE_44__["default"]; },
/* harmony export */   Popover: function() { return /* reexport safe */ _Popover__WEBPACK_IMPORTED_MODULE_55__.Popover; },
/* harmony export */   Position: function() { return /* reexport safe */ _Position__WEBPACK_IMPORTED_MODULE_46__["default"]; },
/* harmony export */   PositionAnimated: function() { return /* reexport safe */ _PositionAnimated__WEBPACK_IMPORTED_MODULE_47__["default"]; },
/* harmony export */   ProgressBar: function() { return /* reexport safe */ _ProgressBar__WEBPACK_IMPORTED_MODULE_48__.ProgressBar; },
/* harmony export */   RadioButton: function() { return /* reexport safe */ _RadioButton__WEBPACK_IMPORTED_MODULE_49__.RadioButton; },
/* harmony export */   Scrollable: function() { return /* reexport safe */ _Scrollable__WEBPACK_IMPORTED_MODULE_50__["default"]; },
/* harmony export */   SearchInput: function() { return /* reexport safe */ _SearchInput__WEBPACK_IMPORTED_MODULE_51__.SearchInput; },
/* harmony export */   Select: function() { return /* reexport safe */ _Select__WEBPACK_IMPORTED_MODULE_52__.Select; },
/* harmony export */   SelectFiltered: function() { return /* reexport safe */ _Select__WEBPACK_IMPORTED_MODULE_52__.SelectFiltered; },
/* harmony export */   SelectInput: function() { return /* reexport safe */ _SelectInput__WEBPACK_IMPORTED_MODULE_56__.SelectInput; },
/* harmony export */   SelectInputOption: function() { return /* reexport safe */ _SelectInput__WEBPACK_IMPORTED_MODULE_56__.SelectInputOption; },
/* harmony export */   SelectLegacy: function() { return /* reexport safe */ _Select__WEBPACK_IMPORTED_MODULE_52__.SelectLegacy; },
/* harmony export */   Sidebar: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__["default"]; },
/* harmony export */   SidebarBanner: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarBanner; },
/* harmony export */   SidebarDivider: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarDivider; },
/* harmony export */   SidebarFooter: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarFooter; },
/* harmony export */   SidebarFooterHighlight: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarFooterHighlight; },
/* harmony export */   SidebarItem: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarItem; },
/* harmony export */   SidebarItemAction: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarItemAction; },
/* harmony export */   SidebarItemActions: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarItemActions; },
/* harmony export */   SidebarItemAvatar: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarItemAvatar; },
/* harmony export */   SidebarItemBadge: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarItemBadge; },
/* harmony export */   SidebarItemContainer: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarItemContainer; },
/* harmony export */   SidebarItemContent: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarItemContent; },
/* harmony export */   SidebarItemIcon: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarItemIcon; },
/* harmony export */   SidebarItemMenu: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarItemMenu; },
/* harmony export */   SidebarItemSubtitle: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarItemSubtitle; },
/* harmony export */   SidebarItemTime: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarItemTime; },
/* harmony export */   SidebarItemTitle: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarItemTitle; },
/* harmony export */   SidebarItemWrapper: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarItemWrapper; },
/* harmony export */   SidebarSection: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarSection; },
/* harmony export */   SidebarSectionTitle: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarSectionTitle; },
/* harmony export */   SidebarTopBar: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.SidebarTopBar; },
/* harmony export */   SidebarV2: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2; },
/* harmony export */   SidebarV2Accordion: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2Accordion; },
/* harmony export */   SidebarV2AccordionItem: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2AccordionItem; },
/* harmony export */   SidebarV2Action: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2Action; },
/* harmony export */   SidebarV2Actions: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2Actions; },
/* harmony export */   SidebarV2Banner: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2Banner; },
/* harmony export */   SidebarV2ButtonGroup: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2ButtonGroup; },
/* harmony export */   SidebarV2CollapseGroup: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2CollapseGroup; },
/* harmony export */   SidebarV2Divider: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2Divider; },
/* harmony export */   SidebarV2Footer: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2Footer; },
/* harmony export */   SidebarV2FooterContent: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2FooterContent; },
/* harmony export */   SidebarV2GroupTitle: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2GroupTitle; },
/* harmony export */   SidebarV2Item: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2Item; },
/* harmony export */   SidebarV2ItemAction: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2ItemAction; },
/* harmony export */   SidebarV2ItemAvatarWrapper: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2ItemAvatarWrapper; },
/* harmony export */   SidebarV2ItemBadge: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2ItemBadge; },
/* harmony export */   SidebarV2ItemCol: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2ItemCol; },
/* harmony export */   SidebarV2ItemContent: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2ItemContent; },
/* harmony export */   SidebarV2ItemIcon: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2ItemIcon; },
/* harmony export */   SidebarV2ItemMenu: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2ItemMenu; },
/* harmony export */   SidebarV2ItemRow: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2ItemRow; },
/* harmony export */   SidebarV2ItemStatusBullet: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2ItemStatusBullet; },
/* harmony export */   SidebarV2ItemTimestamp: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2ItemTimestamp; },
/* harmony export */   SidebarV2ItemTitle: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2ItemTitle; },
/* harmony export */   SidebarV2Link: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2Link; },
/* harmony export */   SidebarV2ListItem: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2ListItem; },
/* harmony export */   SidebarV2Media: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2Media; },
/* harmony export */   SidebarV2MediaController: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2MediaController; },
/* harmony export */   SidebarV2MediaTitle: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2MediaTitle; },
/* harmony export */   SidebarV2Section: function() { return /* reexport safe */ _SidebarV2__WEBPACK_IMPORTED_MODULE_59__.SidebarV2Section; },
/* harmony export */   Sidepanel: function() { return /* reexport safe */ _Sidepanel__WEBPACK_IMPORTED_MODULE_58__.Sidepanel; },
/* harmony export */   SidepanelDivider: function() { return /* reexport safe */ _Sidepanel__WEBPACK_IMPORTED_MODULE_58__.SidepanelDivider; },
/* harmony export */   SidepanelHeader: function() { return /* reexport safe */ _Sidepanel__WEBPACK_IMPORTED_MODULE_58__.SidepanelHeader; },
/* harmony export */   SidepanelHeaderTitle: function() { return /* reexport safe */ _Sidepanel__WEBPACK_IMPORTED_MODULE_58__.SidepanelHeaderTitle; },
/* harmony export */   SidepanelList: function() { return /* reexport safe */ _Sidepanel__WEBPACK_IMPORTED_MODULE_58__.SidepanelList; },
/* harmony export */   SidepanelListItem: function() { return /* reexport safe */ _Sidepanel__WEBPACK_IMPORTED_MODULE_58__.SidepanelListItem; },
/* harmony export */   SidepanelSection: function() { return /* reexport safe */ _Sidepanel__WEBPACK_IMPORTED_MODULE_58__.SidepanelSection; },
/* harmony export */   SidepanelSectionAction: function() { return /* reexport safe */ _Sidepanel__WEBPACK_IMPORTED_MODULE_58__.SidepanelSectionAction; },
/* harmony export */   Skeleton: function() { return /* reexport safe */ _Skeleton__WEBPACK_IMPORTED_MODULE_60__.Skeleton; },
/* harmony export */   Slider: function() { return /* reexport safe */ _Slider__WEBPACK_IMPORTED_MODULE_53__.Slider; },
/* harmony export */   States: function() { return /* reexport safe */ _States__WEBPACK_IMPORTED_MODULE_61__.States; },
/* harmony export */   StatesAction: function() { return /* reexport safe */ _States__WEBPACK_IMPORTED_MODULE_61__.StatesAction; },
/* harmony export */   StatesActions: function() { return /* reexport safe */ _States__WEBPACK_IMPORTED_MODULE_61__.StatesActions; },
/* harmony export */   StatesIcon: function() { return /* reexport safe */ _States__WEBPACK_IMPORTED_MODULE_61__.StatesIcon; },
/* harmony export */   StatesLink: function() { return /* reexport safe */ _States__WEBPACK_IMPORTED_MODULE_61__.StatesLink; },
/* harmony export */   StatesSubtitle: function() { return /* reexport safe */ _States__WEBPACK_IMPORTED_MODULE_61__.StatesSubtitle; },
/* harmony export */   StatesSuggestion: function() { return /* reexport safe */ _States__WEBPACK_IMPORTED_MODULE_61__.StatesSuggestion; },
/* harmony export */   StatesSuggestionList: function() { return /* reexport safe */ _States__WEBPACK_IMPORTED_MODULE_61__.StatesSuggestionList; },
/* harmony export */   StatesSuggestionListItem: function() { return /* reexport safe */ _States__WEBPACK_IMPORTED_MODULE_61__.StatesSuggestionListItem; },
/* harmony export */   StatesSuggestionText: function() { return /* reexport safe */ _States__WEBPACK_IMPORTED_MODULE_61__.StatesSuggestionText; },
/* harmony export */   StatesTitle: function() { return /* reexport safe */ _States__WEBPACK_IMPORTED_MODULE_61__.StatesTitle; },
/* harmony export */   StatusBullet: function() { return /* reexport safe */ _StatusBullet__WEBPACK_IMPORTED_MODULE_45__.StatusBullet; },
/* harmony export */   Table: function() { return /* reexport safe */ _Table__WEBPACK_IMPORTED_MODULE_62__.Table; },
/* harmony export */   TableBody: function() { return /* reexport safe */ _Table__WEBPACK_IMPORTED_MODULE_62__.TableBody; },
/* harmony export */   TableCell: function() { return /* reexport safe */ _Table__WEBPACK_IMPORTED_MODULE_62__.TableCell; },
/* harmony export */   TableFoot: function() { return /* reexport safe */ _Table__WEBPACK_IMPORTED_MODULE_62__.TableFoot; },
/* harmony export */   TableHead: function() { return /* reexport safe */ _Table__WEBPACK_IMPORTED_MODULE_62__.TableHead; },
/* harmony export */   TableHeadContext: function() { return /* reexport safe */ _Table__WEBPACK_IMPORTED_MODULE_62__.TableHeadContext; },
/* harmony export */   TableRow: function() { return /* reexport safe */ _Table__WEBPACK_IMPORTED_MODULE_62__.TableRow; },
/* harmony export */   TableSelection: function() { return /* reexport safe */ _Table__WEBPACK_IMPORTED_MODULE_62__.TableSelection; },
/* harmony export */   TableSelectionButton: function() { return /* reexport safe */ _Table__WEBPACK_IMPORTED_MODULE_62__.TableSelectionButton; },
/* harmony export */   TableSelectionButtonGroup: function() { return /* reexport safe */ _Table__WEBPACK_IMPORTED_MODULE_62__.TableSelectionButtonGroup; },
/* harmony export */   Tabs: function() { return /* reexport safe */ _Tabs__WEBPACK_IMPORTED_MODULE_63__.Tabs; },
/* harmony export */   TabsItem: function() { return /* reexport safe */ _Tabs__WEBPACK_IMPORTED_MODULE_63__.TabsItem; },
/* harmony export */   Tag: function() { return /* reexport safe */ _Tag__WEBPACK_IMPORTED_MODULE_64__.Tag; },
/* harmony export */   TelephoneInput: function() { return /* reexport safe */ _TelephoneInput__WEBPACK_IMPORTED_MODULE_65__.TelephoneInput; },
/* harmony export */   TextAreaInput: function() { return /* reexport safe */ _TextAreaInput__WEBPACK_IMPORTED_MODULE_66__.TextAreaInput; },
/* harmony export */   TextInput: function() { return /* reexport safe */ _TextInput__WEBPACK_IMPORTED_MODULE_67__.TextInput; },
/* harmony export */   ThreadMessage: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.ThreadMessage; },
/* harmony export */   ThreadMessageBody: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.ThreadMessageBody; },
/* harmony export */   ThreadMessageContainer: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.ThreadMessageContainer; },
/* harmony export */   ThreadMessageEmoji: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.ThreadMessageEmoji; },
/* harmony export */   ThreadMessageFollow: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.ThreadMessageFollow; },
/* harmony export */   ThreadMessageIconThread: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.ThreadMessageIconThread; },
/* harmony export */   ThreadMessageLeftContainer: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.ThreadMessageLeftContainer; },
/* harmony export */   ThreadMessageOrigin: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.ThreadMessageOrigin; },
/* harmony export */   ThreadMessageRow: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.ThreadMessageRow; },
/* harmony export */   ThreadMessageUnfollow: function() { return /* reexport safe */ _Message__WEBPACK_IMPORTED_MODULE_35__.ThreadMessageUnfollow; },
/* harmony export */   Throbber: function() { return /* reexport safe */ _Throbber__WEBPACK_IMPORTED_MODULE_68__.Throbber; },
/* harmony export */   Tile: function() { return /* reexport safe */ _Tile__WEBPACK_IMPORTED_MODULE_69__["default"]; },
/* harmony export */   ToastBar: function() { return /* reexport safe */ _ToastBar__WEBPACK_IMPORTED_MODULE_70__.ToastBar; },
/* harmony export */   ToggleSwitch: function() { return /* reexport safe */ _ToggleSwitch__WEBPACK_IMPORTED_MODULE_71__.ToggleSwitch; },
/* harmony export */   Tooltip: function() { return /* reexport safe */ _Tooltip__WEBPACK_IMPORTED_MODULE_72__["default"]; },
/* harmony export */   TopBar: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.TopBar; },
/* harmony export */   TopBarAction: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.TopBarAction; },
/* harmony export */   TopBarActions: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.TopBarActions; },
/* harmony export */   TopBarAvatar: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.TopBarAvatar; },
/* harmony export */   TopBarSection: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.TopBarSection; },
/* harmony export */   TopBarTitle: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.TopBarTitle; },
/* harmony export */   TopBarToolBox: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.TopBarToolBox; },
/* harmony export */   TopBarV2: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.TopBarV2; },
/* harmony export */   TopBarWrapper: function() { return /* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_57__.TopBarWrapper; },
/* harmony export */   UrlInput: function() { return /* reexport safe */ _UrlInput__WEBPACK_IMPORTED_MODULE_73__["default"]; },
/* harmony export */   useArrayLikeClassNameProp: function() { return /* reexport safe */ _hooks_useArrayLikeClassNameProp__WEBPACK_IMPORTED_MODULE_8__.useArrayLikeClassNameProp; },
/* harmony export */   useCursor: function() { return /* reexport safe */ _Options__WEBPACK_IMPORTED_MODULE_40__.useCursor; }
/* harmony export */ });
/* harmony import */ var _Accordion__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Accordion */ "./src/components/Accordion/index.ts");
/* harmony import */ var _AnimatedVisibility__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AnimatedVisibility */ "./src/components/AnimatedVisibility/index.ts");
/* harmony import */ var _AudioPlayer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AudioPlayer */ "./src/components/AudioPlayer/index.ts");
/* harmony import */ var _AutoComplete__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AutoComplete */ "./src/components/AutoComplete/index.ts");
/* harmony import */ var _Avatar__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Avatar */ "./src/components/Avatar/index.ts");
/* harmony import */ var _Badge__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Badge */ "./src/components/Badge/index.tsx");
/* harmony import */ var _Banner__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Banner */ "./src/components/Banner/index.ts");
/* harmony import */ var _Box__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Box */ "./src/components/Box/index.ts");
/* harmony import */ var _hooks_useArrayLikeClassNameProp__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../hooks/useArrayLikeClassNameProp */ "./src/hooks/useArrayLikeClassNameProp.ts");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Button */ "./src/components/Button/index.ts");
/* harmony import */ var _Bubble__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Bubble */ "./src/components/Bubble/index.ts");
/* harmony import */ var _ButtonGroup__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./ButtonGroup */ "./src/components/ButtonGroup/index.ts");
/* harmony import */ var _Callout__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Callout */ "./src/components/Callout/index.tsx");
/* harmony import */ var _Card__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Card */ "./src/components/Card/index.ts");
/* harmony import */ var _CardGroup__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./CardGroup */ "./src/components/CardGroup/index.ts");
/* harmony import */ var _CardGrid__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./CardGrid */ "./src/components/CardGrid/index.ts");
/* harmony import */ var _CheckBox__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./CheckBox */ "./src/components/CheckBox/index.ts");
/* harmony import */ var _Chevron__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./Chevron */ "./src/components/Chevron/index.tsx");
/* harmony import */ var _CodeSnippet__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./CodeSnippet */ "./src/components/CodeSnippet/index.tsx");
/* harmony import */ var _Contextualbar__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./Contextualbar */ "./src/components/Contextualbar/index.ts");
/* harmony import */ var _ContextualbarV2__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./ContextualbarV2 */ "./src/components/ContextualbarV2/index.ts");
/* harmony import */ var _Chip__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./Chip */ "./src/components/Chip/index.ts");
/* harmony import */ var _Divider__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./Divider */ "./src/components/Divider/index.tsx");
/* harmony import */ var _Dropdown__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./Dropdown */ "./src/components/Dropdown/index.tsx");
/* harmony import */ var _EmailInput__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./EmailInput */ "./src/components/EmailInput/index.tsx");
/* harmony import */ var _Field__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./Field */ "./src/components/Field/index.ts");
/* harmony import */ var _FieldGroup__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./FieldGroup */ "./src/components/FieldGroup/index.ts");
/* harmony import */ var _FramedIcon__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./FramedIcon */ "./src/components/FramedIcon/index.ts");
/* harmony import */ var _Flex__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./Flex */ "./src/components/Flex/index.ts");
/* harmony import */ var _Grid__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./Grid */ "./src/components/Grid/index.ts");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./Icon */ "./src/components/Icon/index.ts");
/* harmony import */ var _InputBox__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./InputBox */ "./src/components/InputBox/index.ts");
/* harmony import */ var _Label__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./Label */ "./src/components/Label/index.tsx");
/* harmony import */ var _Margins__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./Margins */ "./src/components/Margins/index.ts");
/* harmony import */ var _Menu__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./Menu */ "./src/components/Menu/index.ts");
/* harmony import */ var _Message__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./Message */ "./src/components/Message/index.tsx");
/* harmony import */ var _Modal__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./Modal */ "./src/components/Modal/index.ts");
/* harmony import */ var _MultiSelect__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./MultiSelect */ "./src/components/MultiSelect/index.ts");
/* harmony import */ var _NavBar__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./NavBar */ "./src/components/NavBar/index.ts");
/* harmony import */ var _NumberInput__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./NumberInput */ "./src/components/NumberInput/index.tsx");
/* harmony import */ var _Options__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./Options */ "./src/components/Options/index.ts");
/* harmony import */ var _Option__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./Option */ "./src/components/Option/index.ts");
/* harmony import */ var _Pagination__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./Pagination */ "./src/components/Pagination/index.ts");
/* harmony import */ var _PaletteStyleTag__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./PaletteStyleTag */ "./src/components/PaletteStyleTag/index.ts");
/* harmony import */ var _PasswordInput__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./PasswordInput */ "./src/components/PasswordInput/index.ts");
/* harmony import */ var _StatusBullet__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./StatusBullet */ "./src/components/StatusBullet/index.tsx");
/* harmony import */ var _Position__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./Position */ "./src/components/Position/index.ts");
/* harmony import */ var _PositionAnimated__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./PositionAnimated */ "./src/components/PositionAnimated/index.ts");
/* harmony import */ var _ProgressBar__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./ProgressBar */ "./src/components/ProgressBar/index.tsx");
/* harmony import */ var _RadioButton__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./RadioButton */ "./src/components/RadioButton/index.ts");
/* harmony import */ var _Scrollable__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./Scrollable */ "./src/components/Scrollable/index.ts");
/* harmony import */ var _SearchInput__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ./SearchInput */ "./src/components/SearchInput/index.tsx");
/* harmony import */ var _Select__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ./Select */ "./src/components/Select/index.ts");
/* harmony import */ var _Slider__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ./Slider */ "./src/components/Slider/index.tsx");
/* harmony import */ var _PaginatedSelect__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ./PaginatedSelect */ "./src/components/PaginatedSelect/index.ts");
/* harmony import */ var _Popover__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ./Popover */ "./src/components/Popover/index.ts");
/* harmony import */ var _SelectInput__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ./SelectInput */ "./src/components/SelectInput/index.ts");
/* harmony import */ var _Sidebar__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ./Sidebar */ "./src/components/Sidebar/index.tsx");
/* harmony import */ var _Sidepanel__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ./Sidepanel */ "./src/components/Sidepanel/index.ts");
/* harmony import */ var _SidebarV2__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! ./SidebarV2 */ "./src/components/SidebarV2/index.tsx");
/* harmony import */ var _Skeleton__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! ./Skeleton */ "./src/components/Skeleton/index.tsx");
/* harmony import */ var _States__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! ./States */ "./src/components/States/index.tsx");
/* harmony import */ var _Table__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! ./Table */ "./src/components/Table/index.ts");
/* harmony import */ var _Tabs__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! ./Tabs */ "./src/components/Tabs/index.tsx");
/* harmony import */ var _Tag__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! ./Tag */ "./src/components/Tag/index.tsx");
/* harmony import */ var _TelephoneInput__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(/*! ./TelephoneInput */ "./src/components/TelephoneInput/index.tsx");
/* harmony import */ var _TextAreaInput__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(/*! ./TextAreaInput */ "./src/components/TextAreaInput/index.ts");
/* harmony import */ var _TextInput__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(/*! ./TextInput */ "./src/components/TextInput/index.tsx");
/* harmony import */ var _Throbber__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(/*! ./Throbber */ "./src/components/Throbber/index.tsx");
/* harmony import */ var _Tile__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(/*! ./Tile */ "./src/components/Tile/index.ts");
/* harmony import */ var _ToastBar__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(/*! ./ToastBar */ "./src/components/ToastBar/index.ts");
/* harmony import */ var _ToggleSwitch__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(/*! ./ToggleSwitch */ "./src/components/ToggleSwitch/index.tsx");
/* harmony import */ var _Tooltip__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(/*! ./Tooltip */ "./src/components/Tooltip/index.ts");
/* harmony import */ var _UrlInput__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(/*! ./UrlInput */ "./src/components/UrlInput/index.ts");














































































/***/ }),

/***/ "./src/getPaletteColor.ts":
/*!********************************!*\
  !*** ./src/getPaletteColor.ts ***!
  \********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getPaletteColor: function() { return /* binding */ getPaletteColor; }
/* harmony export */ });
/* harmony import */ var _rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rocket.chat/fuselage-tokens/colors.json */ "@rocket.chat/fuselage-tokens/colors.json");
/* harmony import */ var _rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! invariant */ "invariant");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_1__);


const isPaletteColorRef = (ref) => typeof ref === 'string' && ref in (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default());
const mapTypeToPrefix = {
    neutral: 'n',
    blue: 'b',
    green: 'g',
    yellow: 'y',
    red: 'r',
    orange: 'o',
    purple: 'p',
};
const getPaletteColor = (type, grade, alpha) => {
    const ref = `${mapTypeToPrefix[type]}${grade}`;
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(isPaletteColorRef(ref), 'invalid color reference');
    const baseColor = (_rocket_chat_fuselage_tokens_colors_json__WEBPACK_IMPORTED_MODULE_0___default())[ref];
    const matches = /^#([0-9A-Fa-f]{2})([0-9A-Fa-f]{2})([0-9A-Fa-f]{2})$/.exec(baseColor);
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(!!matches, 'invalid color token format');
    if (alpha !== undefined) {
        const [, r, g, b] = matches;
        return [
            `--rcx-color-${type}-${grade}-${(alpha * 100).toFixed(0)}`,
            `rgba(${parseInt(r, 16)}, ${parseInt(g, 16)}, ${parseInt(b, 16)}, ${alpha * 100}%)`,
        ];
    }
    return [`--rcx-color-${type}-${grade}`, baseColor];
};


/***/ }),

/***/ "./src/helpers/WithErrorWrapper.tsx":
/*!******************************************!*\
  !*** ./src/helpers/WithErrorWrapper.tsx ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function WithErrorWrapper({ context, componentName, children, parentComponent, }) {
    const isInsideParent = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(context);
    if (!isInsideParent) {
        throw new Error(`${componentName} should be used as children of ${parentComponent} Component`);
    }
    return children;
}
/* harmony default export */ __webpack_exports__["default"] = (WithErrorWrapper);


/***/ }),

/***/ "./src/helpers/appendClassName.ts":
/*!****************************************!*\
  !*** ./src/helpers/appendClassName.ts ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   appendClassName: function() { return /* binding */ appendClassName; }
/* harmony export */ });
const appendClassName = (currentClassName, newClassName) => {
    if (currentClassName === undefined || currentClassName === '') {
        return newClassName;
    }
    if (Array.isArray(currentClassName)) {
        return [...currentClassName, newClassName];
    }
    return `${currentClassName} ${newClassName}`;
};


/***/ }),

/***/ "./src/helpers/composeClassNames.ts":
/*!******************************************!*\
  !*** ./src/helpers/composeClassNames.ts ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   composeClassNames: function() { return /* binding */ composeClassNames; },
/* harmony export */   cx: function() { return /* binding */ cx; },
/* harmony export */   cxx: function() { return /* binding */ cxx; }
/* harmony export */ });
/* harmony import */ var _exhaustiveCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./exhaustiveCheck */ "./src/helpers/exhaustiveCheck.ts");

const withPrefix = (prefix) => (modifier) => prefix ? `${prefix}--${modifier}` : modifier;
const composeClassNames = (prefix) => (...args) => {
    const addPrefix = withPrefix(prefix);
    const classNames = args
        .map((arg) => {
        if (typeof arg === 'string') {
            return arg;
        }
        if (typeof arg === 'object' && Array.isArray(arg)) {
            return arg.filter(Boolean).map(addPrefix).join(' ');
        }
        if (typeof arg === 'object' && arg !== null) {
            return Object.entries(arg)
                .map(([key, value]) => {
                if (typeof value === 'boolean') {
                    if (value) {
                        return addPrefix(key);
                    }
                    return null;
                }
                if (typeof value === 'string' || typeof value === 'number') {
                    return addPrefix(`${key}-${value}`);
                }
                return null;
            })
                .filter(Boolean)
                .join(' ');
        }
        return null;
    })
        .concat()
        .filter(Boolean)
        .join(' ');
    return [prefix, classNames].filter(Boolean).join(' ');
};
/**
 * Composes class names into a single string based on flags.
 *
 * Any falsy value passed as an argument will be ignored.
 *
 * If a string is passed, it will be used as a class name.
 *
 * If a dictionary object is passed, its keys will be used as class names and its values will be used as modifiers --
 * unless the value is a boolean, in which case the key will be used as a class name if the value is `true`.
 *
 * @example
 * ```ts
 * cx('a', false, 'b', null, { c: true, d: false, e: 'f', f: 1 }); // 'a b c e-f f-1'
 * ```
 *
 * @param args a sequence of falsy values, strings and dictionary objects containing the class names
 * @returns a space-separated string of class names
 */
const cx = (...args) => args
    .flatMap((arg) => {
    if (!arg) {
        return [];
    }
    if (typeof arg === 'string') {
        return arg;
    }
    if (typeof arg === 'object') {
        return Object.entries(arg).flatMap(([className, value]) => {
            if (typeof value === 'boolean') {
                return value ? className : [];
            }
            return `${className}-${value}`;
        });
    }
    return (0,_exhaustiveCheck__WEBPACK_IMPORTED_MODULE_0__.exhaustiveCheck)(arg);
})
    .join(' ');
/**
 * Composes class name modifiers under a class name into a single class names' string based on flags.
 *
 * This function returns a function similar to `cx`, with the difference it handles the arguments as class name
 * modifiers (based on BEM CSS conventions). However, it's recommended to use `cxx` as a curried function.
 *
 * @example
 * ```ts
 * cxx('z')('a', false, 'b', null, { c: true, d: false, e: 'f', f: 1 }); // 'z z--a z--b z--c z--e-f z--f-1'
 * ```
 * @param className the class name
 * @param args a sequence of falsy values, strings and dictionary objects containing the modifiers
 * @returns a space-separated string of class names
 */
const cxx = (className) => (...args) => {
    const classNames = args.flatMap((arg) => {
        if (!arg) {
            return [];
        }
        if (typeof arg === 'string') {
            return `${className}--${arg}`;
        }
        if (typeof arg === 'object') {
            return Object.entries(arg).flatMap(([modifier, value]) => {
                if (typeof value === 'boolean') {
                    return value ? `${className}--${modifier}` : [];
                }
                return `${className}--${modifier}-${value}`;
            });
        }
        return (0,_exhaustiveCheck__WEBPACK_IMPORTED_MODULE_0__.exhaustiveCheck)(arg);
    });
    classNames.unshift(className);
    return classNames.join(' ');
};


/***/ }),

/***/ "./src/helpers/exhaustiveCheck.ts":
/*!****************************************!*\
  !*** ./src/helpers/exhaustiveCheck.ts ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   exhaustiveCheck: function() { return /* binding */ exhaustiveCheck; }
/* harmony export */ });
/**
 * Utility function to check exhaustiveness of a switch statement or if-else statements.
 *
 * In TypeScript, variables going through a sequence of conditionals, like cases in switch statements or if-else
 * statements, the variable type is incrementally narrowed as the conditionals are evaluated until it reaches the
 * `never` type, meaning all possible cases have been covered. This function is used to check, at compilation time, that
 * all possible cases have been covered (i.e. if the conditional checks were exhaustive) and should only be called in
 * unreachable blocks of code.
 *
 * @example
 * ```ts
 * declare const value: 'foo' | 'bar';
 * switch (value) {
 *   case 'foo':
 *     // ...
 *     break;
 *   case 'bar':
 *     // ...
 *     break;
 *   default: // should be unreachable
 *     exhaustiveCheck(value); // `value` type should be `never`, otherwise the compilation fails
 * }
 * ```
 *
 * @param _ the value which type should be `never`
 * @throws {Error} will always throw an error if it's reached
 */
const exhaustiveCheck = (_) => {
    throw new Error('Exhaustive check failed');
};


/***/ }),

/***/ "./src/helpers/flattenChildren.ts":
/*!****************************************!*\
  !*** ./src/helpers/flattenChildren.ts ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   flattenChildren: function() { return /* reexport default from dynamic */ react_keyed_flatten_children__WEBPACK_IMPORTED_MODULE_0___default.a; }
/* harmony export */ });
/* harmony import */ var react_keyed_flatten_children__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-keyed-flatten-children */ "react-keyed-flatten-children");
/* harmony import */ var react_keyed_flatten_children__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_keyed_flatten_children__WEBPACK_IMPORTED_MODULE_0__);



/***/ }),

/***/ "./src/helpers/fromCamelToKebab.ts":
/*!*****************************************!*\
  !*** ./src/helpers/fromCamelToKebab.ts ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fromCamelToKebab: function() { return /* binding */ fromCamelToKebab; }
/* harmony export */ });
const fromCamelToKebab = (string) => string.replace(/([a-z0-9]|(?=[A-Z]))([A-Z])/g, '$1-$2').toLowerCase();


/***/ }),

/***/ "./src/helpers/isForwardRefType.ts":
/*!*****************************************!*\
  !*** ./src/helpers/isForwardRefType.ts ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isForwardRefType: function() { return /* binding */ isForwardRefType; }
/* harmony export */ });
const isForwardRefType = (type) => type.$$typeof === Symbol.for('react.forward_ref');


/***/ }),

/***/ "./src/helpers/patchChildren.ts":
/*!**************************************!*\
  !*** ./src/helpers/patchChildren.ts ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   patchChildren: function() { return /* binding */ patchChildren; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _flattenChildren__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./flattenChildren */ "./src/helpers/flattenChildren.ts");
/* harmony import */ var _shallowEqual__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shallowEqual */ "./src/helpers/shallowEqual.ts");



const patchChildren = (children, patch) => {
    let dirty = false;
    const newChildren = (0,_flattenChildren__WEBPACK_IMPORTED_MODULE_1__.flattenChildren)(children).map((child) => {
        if (!(0,react__WEBPACK_IMPORTED_MODULE_0__.isValidElement)(child)) {
            return child;
        }
        const mergedProps = patch(child.props);
        if ((0,_shallowEqual__WEBPACK_IMPORTED_MODULE_2__.shallowEqual)(child.props, mergedProps)) {
            return child;
        }
        dirty = true;
        return (0,react__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(child, mergedProps);
    });
    if (dirty) {
        return newChildren;
    }
    return children;
};


/***/ }),

/***/ "./src/helpers/prependClassName.ts":
/*!*****************************************!*\
  !*** ./src/helpers/prependClassName.ts ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   prependClassName: function() { return /* binding */ prependClassName; }
/* harmony export */ });
const isStringArray = (value) => Array.isArray(value);
const prependClassName = (currentClassName, newClassName) => {
    if (isStringArray(currentClassName)) {
        return [newClassName, ...currentClassName];
    }
    if (currentClassName) {
        return `${newClassName} ${currentClassName}`;
    }
    return newClassName;
};


/***/ }),

/***/ "./src/helpers/prevent.ts":
/*!********************************!*\
  !*** ./src/helpers/prevent.ts ***!
  \********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   prevent: function() { return /* binding */ prevent; }
/* harmony export */ });
const prevent = (event) => {
    event.preventDefault();
    event.stopPropagation();
    event.nativeEvent.stopImmediatePropagation();
};


/***/ }),

/***/ "./src/helpers/shallowEqual.ts":
/*!*************************************!*\
  !*** ./src/helpers/shallowEqual.ts ***!
  \*************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   shallowEqual: function() { return /* binding */ shallowEqual; }
/* harmony export */ });
const isObject = (value) => typeof value === 'object' && value !== null;
const compareObjects = (a, b) => {
    const keysA = Object.keys(a);
    const keysB = Object.keys(b);
    if (keysA.length !== keysB.length) {
        return false;
    }
    return !keysA.some((key) => !b.hasOwnProperty(key) || a[key] !== b[key]);
};
const shallowEqual = (a, b) => {
    if (a === b) {
        return true;
    }
    if (Number.isNaN(a) && Number.isNaN(b)) {
        return true;
    }
    if (!isObject(a) || !isObject(b)) {
        return false;
    }
    return compareObjects(a, b);
};


/***/ }),

/***/ "./src/helpers/toCSSValue.ts":
/*!***********************************!*\
  !*** ./src/helpers/toCSSValue.ts ***!
  \***********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   toCSSColorValue: function() { return /* binding */ toCSSColorValue; },
/* harmony export */   toCSSFontValue: function() { return /* binding */ toCSSFontValue; },
/* harmony export */   toCSSValue: function() { return /* binding */ toCSSValue; }
/* harmony export */ });
/* harmony import */ var _rocket_chat_css_supports__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rocket.chat/css-supports */ "@rocket.chat/css-supports");
/* harmony import */ var _rocket_chat_css_supports__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_css_supports__WEBPACK_IMPORTED_MODULE_0__);

const cssSupportsVariable = (0,_rocket_chat_css_supports__WEBPACK_IMPORTED_MODULE_0__.cssSupports)('(--foo: bar)');
const toCSSValue = cssSupportsVariable
    ? ((label, value) => `var(${label}, ${value})`)
    : ((_label, value) => value);
const toCSSFontValue = ((label, value) => toCSSValue(`--rcx-font-family-${label}`, value));
const toCSSColorValue = ((label, value) => toCSSValue(`--rcx-color-${label}`, value));


/***/ }),

/***/ "./src/hooks/useArrayLikeClassNameProp.ts":
/*!************************************************!*\
  !*** ./src/hooks/useArrayLikeClassNameProp.ts ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useArrayLikeClassNameProp: function() { return /* binding */ useArrayLikeClassNameProp; }
/* harmony export */ });
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rocket.chat/css-in-js */ "@rocket.chat/css-in-js");
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_appendClassName__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/appendClassName */ "./src/helpers/appendClassName.ts");
/* harmony import */ var _useStyle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./useStyle */ "./src/hooks/useStyle.ts");



const useArrayLikeClassNameProp = (props) => {
    const classNames = props.className
        ? [].concat(props.className)
        : [];
    const cssFns = classNames.filter((value) => typeof value === 'function');
    const stylesClassName = (0,_useStyle__WEBPACK_IMPORTED_MODULE_2__.useStyle)((0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.css) `
      ${cssFns}
    `, props);
    const strings = classNames.filter((value) => typeof value === 'string');
    const className = strings.reduce((className, string) => (0,_helpers_appendClassName__WEBPACK_IMPORTED_MODULE_1__.appendClassName)(className, string), stylesClassName || '');
    return Object.assign(props, { className });
};


/***/ }),

/***/ "./src/hooks/useBoxOnlyProps.ts":
/*!**************************************!*\
  !*** ./src/hooks/useBoxOnlyProps.ts ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useBoxOnlyProps: function() { return /* binding */ useBoxOnlyProps; }
/* harmony export */ });
/* harmony import */ var _helpers_prependClassName__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../helpers/prependClassName */ "./src/helpers/prependClassName.ts");

const useBoxOnlyProps = (props) => {
    Object.entries(props).forEach(([key, value]) => {
        if (key.slice(0, 4) === 'rcx-') {
            try {
                if (!value) {
                    return;
                }
                const newClassName = value === true ? key : `${key}-${value}`;
                props.className = (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_0__.prependClassName)(props.className, newClassName);
            }
            finally {
                delete props[key];
            }
        }
    });
    if (props.animated) {
        props.className = (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_0__.prependClassName)(props.className, 'rcx-box--animated');
        delete props.animated;
    }
    if (props.withRichContent) {
        if (props.withRichContent === 'inlineWithoutBreaks') {
            props.className = (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_0__.prependClassName)(props.className, 'rcx-box--with-inline-elements');
        }
        else {
            props.className = (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_0__.prependClassName)(props.className, 'rcx-box--with-inline-elements');
            props.className = (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_0__.prependClassName)(props.className, 'rcx-box--with-block-elements');
        }
    }
    if (props.htmlSize) {
        props.size = props.htmlSize;
        delete props.htmlSize;
    }
    if (props.focusable) {
        props.className = (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_0__.prependClassName)(props.className, 'rcx-box--focusable');
        delete props.focusable;
    }
    delete props.withRichContent;
    props.className = (0,_helpers_prependClassName__WEBPACK_IMPORTED_MODULE_0__.prependClassName)(props.className, 'rcx-box rcx-box--full');
    return props;
};


/***/ }),

/***/ "./src/hooks/useStyle.ts":
/*!*******************************!*\
  !*** ./src/hooks/useStyle.ts ***!
  \*******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useStyle: function() { return /* binding */ useStyle; }
/* harmony export */ });
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rocket.chat/css-in-js */ "@rocket.chat/css-in-js");
/* harmony import */ var _rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const useStyle = (cssFn, arg) => {
    const content = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => (cssFn ? cssFn(arg) : undefined), [arg, cssFn]);
    const className = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
        if (!content) {
            return;
        }
        return content ? (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.createClassName)(content) : undefined;
    }, [content]);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useDebugValue)(className);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useInsertionEffect)(() => {
        if (!content || !className) {
            return;
        }
        const escapedClassName = (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.escapeName)(className);
        const transpiledContent = (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.transpile)(`.${escapedClassName}`, content);
        const detach = (0,_rocket_chat_css_in_js__WEBPACK_IMPORTED_MODULE_0__.attachRules)(transpiledContent);
        return () => {
            setTimeout(detach, 1000);
        };
    }, [className, content]);
    return className;
};


/***/ }),

/***/ "./src/index.scss":
/*!************************!*\
  !*** ./src/index.scss ***!
  \************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/index.ts":
/*!**********************!*\
  !*** ./src/index.ts ***!
  \**********************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Accordion: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Accordion; },
/* harmony export */   AccordionItem: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.AccordionItem; },
/* harmony export */   ActionButton: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ActionButton; },
/* harmony export */   AnimatedVisibility: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.AnimatedVisibility; },
/* harmony export */   AudioPlayer: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.AudioPlayer; },
/* harmony export */   AutoComplete: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.AutoComplete; },
/* harmony export */   Avatar: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Avatar; },
/* harmony export */   AvatarContainer: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.AvatarContainer; },
/* harmony export */   AvatarStack: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.AvatarStack; },
/* harmony export */   Badge: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Badge; },
/* harmony export */   Banner: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Banner; },
/* harmony export */   Box: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Box; },
/* harmony export */   Bubble: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Bubble; },
/* harmony export */   Button: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Button; },
/* harmony export */   ButtonGroup: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ButtonGroup; },
/* harmony export */   Callout: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Callout; },
/* harmony export */   Card: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Card; },
/* harmony export */   CardBody: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.CardBody; },
/* harmony export */   CardCol: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.CardCol; },
/* harmony export */   CardContent: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.CardContent; },
/* harmony export */   CardControls: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.CardControls; },
/* harmony export */   CardGrid: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.CardGrid; },
/* harmony export */   CardGroup: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.CardGroup; },
/* harmony export */   CardHeader: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.CardHeader; },
/* harmony export */   CardRow: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.CardRow; },
/* harmony export */   CardTitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.CardTitle; },
/* harmony export */   CheckBox: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.CheckBox; },
/* harmony export */   CheckOption: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.CheckOption; },
/* harmony export */   Chevron: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Chevron; },
/* harmony export */   Chip: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Chip; },
/* harmony export */   CodeSnippet: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.CodeSnippet; },
/* harmony export */   Contextualbar: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Contextualbar; },
/* harmony export */   ContextualbarAction: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarAction; },
/* harmony export */   ContextualbarActions: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarActions; },
/* harmony export */   ContextualbarButton: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarButton; },
/* harmony export */   ContextualbarContent: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarContent; },
/* harmony export */   ContextualbarEmptyContent: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarEmptyContent; },
/* harmony export */   ContextualbarFooter: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarFooter; },
/* harmony export */   ContextualbarHeader: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarHeader; },
/* harmony export */   ContextualbarIcon: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarIcon; },
/* harmony export */   ContextualbarSection: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarSection; },
/* harmony export */   ContextualbarSkeleton: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarSkeleton; },
/* harmony export */   ContextualbarTitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarTitle; },
/* harmony export */   ContextualbarV2: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarV2; },
/* harmony export */   ContextualbarV2Action: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarV2Action; },
/* harmony export */   ContextualbarV2Actions: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarV2Actions; },
/* harmony export */   ContextualbarV2Button: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarV2Button; },
/* harmony export */   ContextualbarV2Content: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarV2Content; },
/* harmony export */   ContextualbarV2EmptyContent: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarV2EmptyContent; },
/* harmony export */   ContextualbarV2Footer: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarV2Footer; },
/* harmony export */   ContextualbarV2Header: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarV2Header; },
/* harmony export */   ContextualbarV2Icon: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarV2Icon; },
/* harmony export */   ContextualbarV2Section: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarV2Section; },
/* harmony export */   ContextualbarV2Skeleton: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarV2Skeleton; },
/* harmony export */   ContextualbarV2Title: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ContextualbarV2Title; },
/* harmony export */   Divider: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Divider; },
/* harmony export */   Dropdown: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Dropdown; },
/* harmony export */   EmailInput: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.EmailInput; },
/* harmony export */   Field: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Field; },
/* harmony export */   FieldDescription: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.FieldDescription; },
/* harmony export */   FieldError: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.FieldError; },
/* harmony export */   FieldGroup: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.FieldGroup; },
/* harmony export */   FieldHint: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.FieldHint; },
/* harmony export */   FieldLabel: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.FieldLabel; },
/* harmony export */   FieldLabelInfo: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.FieldLabelInfo; },
/* harmony export */   FieldLink: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.FieldLink; },
/* harmony export */   FieldRow: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.FieldRow; },
/* harmony export */   Flex: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Flex; },
/* harmony export */   FramedIcon: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.FramedIcon; },
/* harmony export */   Grid: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Grid; },
/* harmony export */   GridItem: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.GridItem; },
/* harmony export */   Icon: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Icon; },
/* harmony export */   IconButton: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.IconButton; },
/* harmony export */   Input: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Input; },
/* harmony export */   InputBox: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.InputBox; },
/* harmony export */   InputBoxSkeleton: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.InputBoxSkeleton; },
/* harmony export */   Label: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Label; },
/* harmony export */   Margins: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Margins; },
/* harmony export */   Menu: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Menu; },
/* harmony export */   MenuItem: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MenuItem; },
/* harmony export */   MenuItemAvatar: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MenuItemAvatar; },
/* harmony export */   MenuItemColumn: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MenuItemColumn; },
/* harmony export */   MenuItemContent: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MenuItemContent; },
/* harmony export */   MenuItemDescription: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MenuItemDescription; },
/* harmony export */   MenuItemIcon: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MenuItemIcon; },
/* harmony export */   MenuItemInput: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MenuItemInput; },
/* harmony export */   MenuItemSkeleton: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MenuItemSkeleton; },
/* harmony export */   MenuItemTitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MenuItemTitle; },
/* harmony export */   MenuSection: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MenuSection; },
/* harmony export */   MenuV2: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MenuV2; },
/* harmony export */   Message: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Message; },
/* harmony export */   MessageBlock: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageBlock; },
/* harmony export */   MessageBody: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageBody; },
/* harmony export */   MessageContainer: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageContainer; },
/* harmony export */   MessageContainerFixed: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageContainerFixed; },
/* harmony export */   MessageDivider: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageDivider; },
/* harmony export */   MessageEmoji: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageEmoji; },
/* harmony export */   MessageGenericPreview: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageGenericPreview; },
/* harmony export */   MessageGenericPreviewContent: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageGenericPreviewContent; },
/* harmony export */   MessageGenericPreviewCoverImage: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageGenericPreviewCoverImage; },
/* harmony export */   MessageGenericPreviewDescription: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageGenericPreviewDescription; },
/* harmony export */   MessageGenericPreviewFooter: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageGenericPreviewFooter; },
/* harmony export */   MessageGenericPreviewIcon: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageGenericPreviewIcon; },
/* harmony export */   MessageGenericPreviewImage: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageGenericPreviewImage; },
/* harmony export */   MessageGenericPreviewThumb: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageGenericPreviewThumb; },
/* harmony export */   MessageGenericPreviewTitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageGenericPreviewTitle; },
/* harmony export */   MessageHeader: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageHeader; },
/* harmony export */   MessageHighlight: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageHighlight; },
/* harmony export */   MessageLeftContainer: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageLeftContainer; },
/* harmony export */   MessageMetrics: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageMetrics; },
/* harmony export */   MessageMetricsFollowing: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageMetricsFollowing; },
/* harmony export */   MessageMetricsItem: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageMetricsItem; },
/* harmony export */   MessageMetricsItemAvatarRow: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageMetricsItemAvatarRow; },
/* harmony export */   MessageMetricsItemAvatarRowContent: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageMetricsItemAvatarRowContent; },
/* harmony export */   MessageMetricsItemIcon: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageMetricsItemIcon; },
/* harmony export */   MessageMetricsItemLabel: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageMetricsItemLabel; },
/* harmony export */   MessageMetricsReply: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageMetricsReply; },
/* harmony export */   MessageName: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageName; },
/* harmony export */   MessageNameContainer: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageNameContainer; },
/* harmony export */   MessageReaction: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageReaction; },
/* harmony export */   MessageReactionAction: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageReactionAction; },
/* harmony export */   MessageReactionCounter: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageReactionCounter; },
/* harmony export */   MessageReactionEmoji: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageReactionEmoji; },
/* harmony export */   MessageReactions: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageReactions; },
/* harmony export */   MessageRole: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageRole; },
/* harmony export */   MessageRoles: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageRoles; },
/* harmony export */   MessageStatusIndicator: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageStatusIndicator; },
/* harmony export */   MessageStatusIndicatorItem: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageStatusIndicatorItem; },
/* harmony export */   MessageStatusIndicatorText: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageStatusIndicatorText; },
/* harmony export */   MessageStatusPrivateIndicator: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageStatusPrivateIndicator; },
/* harmony export */   MessageSystem: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageSystem; },
/* harmony export */   MessageSystemBlock: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageSystemBlock; },
/* harmony export */   MessageSystemBody: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageSystemBody; },
/* harmony export */   MessageSystemContainer: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageSystemContainer; },
/* harmony export */   MessageSystemLeftContainer: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageSystemLeftContainer; },
/* harmony export */   MessageSystemName: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageSystemName; },
/* harmony export */   MessageSystemTimestamp: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageSystemTimestamp; },
/* harmony export */   MessageTimestamp: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageTimestamp; },
/* harmony export */   MessageToolbar: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageToolbar; },
/* harmony export */   MessageToolbarItem: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageToolbarItem; },
/* harmony export */   MessageToolbarWrapper: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageToolbarWrapper; },
/* harmony export */   MessageUsername: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MessageUsername; },
/* harmony export */   Modal: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Modal; },
/* harmony export */   ModalBackdrop: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ModalBackdrop; },
/* harmony export */   ModalClose: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ModalClose; },
/* harmony export */   ModalContent: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ModalContent; },
/* harmony export */   ModalFooter: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ModalFooter; },
/* harmony export */   ModalFooterAnnotation: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ModalFooterAnnotation; },
/* harmony export */   ModalFooterControllers: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ModalFooterControllers; },
/* harmony export */   ModalHeader: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ModalHeader; },
/* harmony export */   ModalHeaderText: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ModalHeaderText; },
/* harmony export */   ModalHeroImage: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ModalHeroImage; },
/* harmony export */   ModalIcon: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ModalIcon; },
/* harmony export */   ModalTagline: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ModalTagline; },
/* harmony export */   ModalThumb: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ModalThumb; },
/* harmony export */   ModalTitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ModalTitle; },
/* harmony export */   MultiSelect: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MultiSelect; },
/* harmony export */   MultiSelectFiltered: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.MultiSelectFiltered; },
/* harmony export */   NavBar: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.NavBar; },
/* harmony export */   NavBarDivider: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.NavBarDivider; },
/* harmony export */   NavBarGroup: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.NavBarGroup; },
/* harmony export */   NavBarItem: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.NavBarItem; },
/* harmony export */   NavBarSection: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.NavBarSection; },
/* harmony export */   NumberInput: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.NumberInput; },
/* harmony export */   Option: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Option; },
/* harmony export */   OptionAvatar: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.OptionAvatar; },
/* harmony export */   OptionColumn: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.OptionColumn; },
/* harmony export */   OptionContainer: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.OptionContainer; },
/* harmony export */   OptionContent: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.OptionContent; },
/* harmony export */   OptionDescription: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.OptionDescription; },
/* harmony export */   OptionDescriptionBlock: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.OptionDescriptionBlock; },
/* harmony export */   OptionDivider: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.OptionDivider; },
/* harmony export */   OptionHeader: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.OptionHeader; },
/* harmony export */   OptionIcon: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.OptionIcon; },
/* harmony export */   OptionInput: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.OptionInput; },
/* harmony export */   OptionMenu: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.OptionMenu; },
/* harmony export */   OptionSkeleton: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.OptionSkeleton; },
/* harmony export */   OptionTitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.OptionTitle; },
/* harmony export */   Options: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Options; },
/* harmony export */   PaginatedMultiSelectFiltered: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.PaginatedMultiSelectFiltered; },
/* harmony export */   PaginatedSelectFiltered: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.PaginatedSelectFiltered; },
/* harmony export */   Pagination: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Pagination; },
/* harmony export */   Palette: function() { return /* reexport safe */ _Theme__WEBPACK_IMPORTED_MODULE_3__.Palette; },
/* harmony export */   PaletteStyleTag: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.PaletteStyleTag; },
/* harmony export */   PasswordInput: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.PasswordInput; },
/* harmony export */   Popover: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Popover; },
/* harmony export */   Position: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Position; },
/* harmony export */   PositionAnimated: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.PositionAnimated; },
/* harmony export */   ProgressBar: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ProgressBar; },
/* harmony export */   RadioButton: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.RadioButton; },
/* harmony export */   Scrollable: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Scrollable; },
/* harmony export */   SearchInput: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SearchInput; },
/* harmony export */   Select: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Select; },
/* harmony export */   SelectFiltered: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SelectFiltered; },
/* harmony export */   SelectInput: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SelectInput; },
/* harmony export */   SelectInputOption: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SelectInputOption; },
/* harmony export */   SelectLegacy: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SelectLegacy; },
/* harmony export */   Sidebar: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Sidebar; },
/* harmony export */   SidebarBanner: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarBanner; },
/* harmony export */   SidebarDivider: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarDivider; },
/* harmony export */   SidebarFooter: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarFooter; },
/* harmony export */   SidebarFooterHighlight: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarFooterHighlight; },
/* harmony export */   SidebarItem: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarItem; },
/* harmony export */   SidebarItemAction: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarItemAction; },
/* harmony export */   SidebarItemActions: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarItemActions; },
/* harmony export */   SidebarItemAvatar: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarItemAvatar; },
/* harmony export */   SidebarItemBadge: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarItemBadge; },
/* harmony export */   SidebarItemContainer: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarItemContainer; },
/* harmony export */   SidebarItemContent: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarItemContent; },
/* harmony export */   SidebarItemIcon: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarItemIcon; },
/* harmony export */   SidebarItemMenu: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarItemMenu; },
/* harmony export */   SidebarItemSubtitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarItemSubtitle; },
/* harmony export */   SidebarItemTime: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarItemTime; },
/* harmony export */   SidebarItemTitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarItemTitle; },
/* harmony export */   SidebarItemWrapper: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarItemWrapper; },
/* harmony export */   SidebarSection: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarSection; },
/* harmony export */   SidebarSectionTitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarSectionTitle; },
/* harmony export */   SidebarTopBar: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarTopBar; },
/* harmony export */   SidebarV2: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2; },
/* harmony export */   SidebarV2Accordion: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2Accordion; },
/* harmony export */   SidebarV2AccordionItem: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2AccordionItem; },
/* harmony export */   SidebarV2Action: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2Action; },
/* harmony export */   SidebarV2Actions: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2Actions; },
/* harmony export */   SidebarV2Banner: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2Banner; },
/* harmony export */   SidebarV2ButtonGroup: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2ButtonGroup; },
/* harmony export */   SidebarV2CollapseGroup: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2CollapseGroup; },
/* harmony export */   SidebarV2Divider: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2Divider; },
/* harmony export */   SidebarV2Footer: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2Footer; },
/* harmony export */   SidebarV2FooterContent: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2FooterContent; },
/* harmony export */   SidebarV2GroupTitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2GroupTitle; },
/* harmony export */   SidebarV2Item: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2Item; },
/* harmony export */   SidebarV2ItemAction: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2ItemAction; },
/* harmony export */   SidebarV2ItemAvatarWrapper: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2ItemAvatarWrapper; },
/* harmony export */   SidebarV2ItemBadge: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2ItemBadge; },
/* harmony export */   SidebarV2ItemCol: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2ItemCol; },
/* harmony export */   SidebarV2ItemContent: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2ItemContent; },
/* harmony export */   SidebarV2ItemIcon: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2ItemIcon; },
/* harmony export */   SidebarV2ItemMenu: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2ItemMenu; },
/* harmony export */   SidebarV2ItemRow: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2ItemRow; },
/* harmony export */   SidebarV2ItemStatusBullet: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2ItemStatusBullet; },
/* harmony export */   SidebarV2ItemTimestamp: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2ItemTimestamp; },
/* harmony export */   SidebarV2ItemTitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2ItemTitle; },
/* harmony export */   SidebarV2Link: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2Link; },
/* harmony export */   SidebarV2ListItem: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2ListItem; },
/* harmony export */   SidebarV2Media: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2Media; },
/* harmony export */   SidebarV2MediaController: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2MediaController; },
/* harmony export */   SidebarV2MediaTitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2MediaTitle; },
/* harmony export */   SidebarV2Section: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidebarV2Section; },
/* harmony export */   Sidepanel: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Sidepanel; },
/* harmony export */   SidepanelDivider: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidepanelDivider; },
/* harmony export */   SidepanelHeader: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidepanelHeader; },
/* harmony export */   SidepanelHeaderTitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidepanelHeaderTitle; },
/* harmony export */   SidepanelList: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidepanelList; },
/* harmony export */   SidepanelListItem: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidepanelListItem; },
/* harmony export */   SidepanelSection: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidepanelSection; },
/* harmony export */   SidepanelSectionAction: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.SidepanelSectionAction; },
/* harmony export */   Skeleton: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Skeleton; },
/* harmony export */   Slider: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Slider; },
/* harmony export */   States: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.States; },
/* harmony export */   StatesAction: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.StatesAction; },
/* harmony export */   StatesActions: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.StatesActions; },
/* harmony export */   StatesIcon: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.StatesIcon; },
/* harmony export */   StatesLink: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.StatesLink; },
/* harmony export */   StatesSubtitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.StatesSubtitle; },
/* harmony export */   StatesSuggestion: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.StatesSuggestion; },
/* harmony export */   StatesSuggestionList: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.StatesSuggestionList; },
/* harmony export */   StatesSuggestionListItem: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.StatesSuggestionListItem; },
/* harmony export */   StatesSuggestionText: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.StatesSuggestionText; },
/* harmony export */   StatesTitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.StatesTitle; },
/* harmony export */   StatusBullet: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.StatusBullet; },
/* harmony export */   Table: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Table; },
/* harmony export */   TableBody: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TableBody; },
/* harmony export */   TableCell: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TableCell; },
/* harmony export */   TableFoot: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TableFoot; },
/* harmony export */   TableHead: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TableHead; },
/* harmony export */   TableHeadContext: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TableHeadContext; },
/* harmony export */   TableRow: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TableRow; },
/* harmony export */   TableSelection: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TableSelection; },
/* harmony export */   TableSelectionButton: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TableSelectionButton; },
/* harmony export */   TableSelectionButtonGroup: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TableSelectionButtonGroup; },
/* harmony export */   Tabs: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Tabs; },
/* harmony export */   TabsItem: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TabsItem; },
/* harmony export */   Tag: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Tag; },
/* harmony export */   TelephoneInput: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TelephoneInput; },
/* harmony export */   TextAreaInput: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TextAreaInput; },
/* harmony export */   TextInput: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TextInput; },
/* harmony export */   ThreadMessage: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ThreadMessage; },
/* harmony export */   ThreadMessageBody: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ThreadMessageBody; },
/* harmony export */   ThreadMessageContainer: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ThreadMessageContainer; },
/* harmony export */   ThreadMessageEmoji: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ThreadMessageEmoji; },
/* harmony export */   ThreadMessageFollow: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ThreadMessageFollow; },
/* harmony export */   ThreadMessageIconThread: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ThreadMessageIconThread; },
/* harmony export */   ThreadMessageLeftContainer: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ThreadMessageLeftContainer; },
/* harmony export */   ThreadMessageOrigin: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ThreadMessageOrigin; },
/* harmony export */   ThreadMessageRow: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ThreadMessageRow; },
/* harmony export */   ThreadMessageUnfollow: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ThreadMessageUnfollow; },
/* harmony export */   Throbber: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Throbber; },
/* harmony export */   Tile: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Tile; },
/* harmony export */   ToastBar: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ToastBar; },
/* harmony export */   ToggleSwitch: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.ToggleSwitch; },
/* harmony export */   Tooltip: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.Tooltip; },
/* harmony export */   TopBar: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TopBar; },
/* harmony export */   TopBarAction: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TopBarAction; },
/* harmony export */   TopBarActions: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TopBarActions; },
/* harmony export */   TopBarAvatar: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TopBarAvatar; },
/* harmony export */   TopBarSection: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TopBarSection; },
/* harmony export */   TopBarTitle: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TopBarTitle; },
/* harmony export */   TopBarToolBox: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TopBarToolBox; },
/* harmony export */   TopBarV2: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TopBarV2; },
/* harmony export */   TopBarWrapper: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.TopBarWrapper; },
/* harmony export */   UrlInput: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.UrlInput; },
/* harmony export */   __setThrowErrorOnInvalidToken__: function() { return /* reexport safe */ _Theme__WEBPACK_IMPORTED_MODULE_3__.__setThrowErrorOnInvalidToken__; },
/* harmony export */   backgroundColor: function() { return /* reexport safe */ _styleTokens__WEBPACK_IMPORTED_MODULE_2__.backgroundColor; },
/* harmony export */   borderRadius: function() { return /* reexport safe */ _styleTokens__WEBPACK_IMPORTED_MODULE_2__.borderRadius; },
/* harmony export */   borderWidth: function() { return /* reexport safe */ _styleTokens__WEBPACK_IMPORTED_MODULE_2__.borderWidth; },
/* harmony export */   color: function() { return /* reexport safe */ _styleTokens__WEBPACK_IMPORTED_MODULE_2__.color; },
/* harmony export */   fontColor: function() { return /* reexport safe */ _styleTokens__WEBPACK_IMPORTED_MODULE_2__.fontColor; },
/* harmony export */   fontFamily: function() { return /* reexport safe */ _styleTokens__WEBPACK_IMPORTED_MODULE_2__.fontFamily; },
/* harmony export */   fontScale: function() { return /* reexport safe */ _styleTokens__WEBPACK_IMPORTED_MODULE_2__.fontScale; },
/* harmony export */   inset: function() { return /* reexport safe */ _styleTokens__WEBPACK_IMPORTED_MODULE_2__.inset; },
/* harmony export */   margin: function() { return /* reexport safe */ _styleTokens__WEBPACK_IMPORTED_MODULE_2__.margin; },
/* harmony export */   padding: function() { return /* reexport safe */ _styleTokens__WEBPACK_IMPORTED_MODULE_2__.padding; },
/* harmony export */   size: function() { return /* reexport safe */ _styleTokens__WEBPACK_IMPORTED_MODULE_2__.size; },
/* harmony export */   strokeColor: function() { return /* reexport safe */ _styleTokens__WEBPACK_IMPORTED_MODULE_2__.strokeColor; },
/* harmony export */   useArrayLikeClassNameProp: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.useArrayLikeClassNameProp; },
/* harmony export */   useCursor: function() { return /* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_1__.useCursor; }
/* harmony export */ });
/* harmony import */ var _index_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./index.scss */ "./src/index.scss");
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components */ "./src/components/index.ts");
/* harmony import */ var _styleTokens__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./styleTokens */ "./src/styleTokens.ts");
/* harmony import */ var _Theme__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Theme */ "./src/Theme.ts");






/***/ }),

/***/ "./src/styleTokens.ts":
/*!****************************!*\
  !*** ./src/styleTokens.ts ***!
  \****************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   backgroundColor: function() { return /* binding */ backgroundColor; },
/* harmony export */   borderRadius: function() { return /* binding */ borderRadius; },
/* harmony export */   borderWidth: function() { return /* binding */ borderWidth; },
/* harmony export */   color: function() { return /* binding */ color; },
/* harmony export */   fontColor: function() { return /* binding */ fontColor; },
/* harmony export */   fontFamily: function() { return /* binding */ fontFamily; },
/* harmony export */   fontScale: function() { return /* binding */ fontScale; },
/* harmony export */   inset: function() { return /* binding */ inset; },
/* harmony export */   margin: function() { return /* binding */ margin; },
/* harmony export */   padding: function() { return /* binding */ padding; },
/* harmony export */   size: function() { return /* binding */ size; },
/* harmony export */   strokeColor: function() { return /* binding */ strokeColor; }
/* harmony export */ });
/* harmony import */ var _rocket_chat_fuselage_tokens_typography_json__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rocket.chat/fuselage-tokens/typography.json */ "@rocket.chat/fuselage-tokens/typography.json");
/* harmony import */ var _rocket_chat_fuselage_tokens_typography_json__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_fuselage_tokens_typography_json__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rocket_chat_memo__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rocket.chat/memo */ "@rocket.chat/memo");
/* harmony import */ var _rocket_chat_memo__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_rocket_chat_memo__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! invariant */ "invariant");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Theme__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Theme */ "./src/Theme.ts");
/* harmony import */ var _getPaletteColor__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getPaletteColor */ "./src/getPaletteColor.ts");
/* harmony import */ var _helpers_toCSSValue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./helpers/toCSSValue */ "./src/helpers/toCSSValue.ts");






const measure = (computeSpecialValue) => (0,_rocket_chat_memo__WEBPACK_IMPORTED_MODULE_1__.memoize)((value) => {
    if (typeof value === 'number') {
        return `${value}px`;
    }
    if (typeof value !== 'string') {
        return undefined;
    }
    const xRegExp = /^(neg-|-)?x(\d+)$/;
    const matches = xRegExp.exec(value);
    if (matches) {
        const [, negativeMark, measureInPixelsAsString] = matches;
        const measureInPixels = (negativeMark ? -1 : 1) * parseInt(measureInPixelsAsString, 10);
        return `${measureInPixels / 16}rem`;
    }
    if (computeSpecialValue) {
        return computeSpecialValue(value) || value;
    }
    return value;
});
const borderWidth = measure((value) => {
    if (value === 'none') {
        return '0px';
    }
    if (value === 'default') {
        return borderWidth('x1');
    }
    return undefined;
});
const borderRadius = measure((value) => {
    if (value === 'none') {
        return '0px';
    }
    if (value === 'full') {
        return '9999px';
    }
    return undefined;
});
const mapTypeToPrefix = {
    neutral: 'n',
    blue: 'b',
    green: 'g',
    yellow: 'y',
    red: 'r',
    orange: 'o',
    purple: 'p',
};
const isPaletteColorType = (type) => typeof type === 'string' && type in mapTypeToPrefix;
const isPaletteColorGrade = (grade) => typeof grade === 'number' &&
    grade % 100 === 0 &&
    grade / 100 >= 1 &&
    grade / 100 <= 9;
const isPaletteColorAlpha = (alpha) => alpha === undefined ||
    (typeof alpha === 'number' && alpha >= 0 && alpha <= 1);
const paletteColorRegex = /^(neutral|blue|green|yellow|red|orange|purple)-(\d+)(-(\d+))?$/;
const strokeColor = (0,_rocket_chat_memo__WEBPACK_IMPORTED_MODULE_1__.memoize)((value) => {
    const colorName = `stroke-${value}`;
    if ((0,_Theme__WEBPACK_IMPORTED_MODULE_3__.isStrokeColor)(colorName)) {
        return _Theme__WEBPACK_IMPORTED_MODULE_3__.strokeColors[colorName].toString();
    }
    return color(value);
});
const backgroundColor = (0,_rocket_chat_memo__WEBPACK_IMPORTED_MODULE_1__.memoize)((value) => {
    const colorName = `surface-${value}`;
    if ((0,_Theme__WEBPACK_IMPORTED_MODULE_3__.isSurfaceColor)(value)) {
        return _Theme__WEBPACK_IMPORTED_MODULE_3__.surfaceColors[value].toString();
    }
    if ((0,_Theme__WEBPACK_IMPORTED_MODULE_3__.isSurfaceColor)(colorName)) {
        return _Theme__WEBPACK_IMPORTED_MODULE_3__.surfaceColors[colorName].toString();
    }
    if ((0,_Theme__WEBPACK_IMPORTED_MODULE_3__.isStatusBackgroundColor)(value)) {
        return _Theme__WEBPACK_IMPORTED_MODULE_3__.statusBackgroundColors[value].toString();
    }
    if ((0,_Theme__WEBPACK_IMPORTED_MODULE_3__.isStatusColor)(value)) {
        if (true) {
            console.warn(`${value} shouldn't be used as a backgroundColor.`);
        }
        return _Theme__WEBPACK_IMPORTED_MODULE_3__.statusColors[value].toString();
    }
    if ((0,_Theme__WEBPACK_IMPORTED_MODULE_3__.isBadgeColor)(value)) {
        return _Theme__WEBPACK_IMPORTED_MODULE_3__.badgeBackgroundColors[value].toString();
    }
    return color(value);
});
const fontColor = (0,_rocket_chat_memo__WEBPACK_IMPORTED_MODULE_1__.memoize)((value) => {
    const colorName = `font-${value}`;
    if ((0,_Theme__WEBPACK_IMPORTED_MODULE_3__.isTextIconColor)(colorName)) {
        return _Theme__WEBPACK_IMPORTED_MODULE_3__.textIconColors[colorName].toString();
    }
    if ((0,_Theme__WEBPACK_IMPORTED_MODULE_3__.isStatusColor)(value)) {
        return _Theme__WEBPACK_IMPORTED_MODULE_3__.statusColors[value].toString();
    }
    return color(value);
});
/** @deprecated **/
const color = (0,_rocket_chat_memo__WEBPACK_IMPORTED_MODULE_1__.memoize)((value) => {
    if (typeof value !== 'string') {
        return;
    }
    if (true) {
        console.warn(`invalid color: ${value}`, new Error().stack);
    }
    if (_Theme__WEBPACK_IMPORTED_MODULE_3__.throwErrorOnInvalidToken) {
        throw new Error(`The color token "${value}" is deprecated. Please use the new color tokens instead.`);
    }
    if ((0,_Theme__WEBPACK_IMPORTED_MODULE_3__.isSurfaceColor)(value)) {
        return _Theme__WEBPACK_IMPORTED_MODULE_3__.surfaceColors[value].toString();
    }
    if ((0,_Theme__WEBPACK_IMPORTED_MODULE_3__.isStatusBackgroundColor)(value)) {
        return _Theme__WEBPACK_IMPORTED_MODULE_3__.statusBackgroundColors[value].toString();
    }
    if ((0,_Theme__WEBPACK_IMPORTED_MODULE_3__.isStrokeColor)(value)) {
        return _Theme__WEBPACK_IMPORTED_MODULE_3__.strokeColors[value].toString();
    }
    if ((0,_Theme__WEBPACK_IMPORTED_MODULE_3__.isTextIconColor)(value)) {
        return _Theme__WEBPACK_IMPORTED_MODULE_3__.textIconColors[value].toString();
    }
    if (value === 'surface' || value === 'surface-light') {
        return _Theme__WEBPACK_IMPORTED_MODULE_3__.surfaceColors['surface-light'].toString();
    }
    if (value === 'surface-tint') {
        return (0,_helpers_toCSSValue__WEBPACK_IMPORTED_MODULE_5__.toCSSColorValue)(value, _Theme__WEBPACK_IMPORTED_MODULE_3__.neutral[100]);
    }
    if (value === 'secondary-info') {
        return (0,_helpers_toCSSValue__WEBPACK_IMPORTED_MODULE_5__.toCSSColorValue)(value, _Theme__WEBPACK_IMPORTED_MODULE_3__.neutral[700]);
    }
    if (value === 'surface-neutral') {
        return (0,_helpers_toCSSValue__WEBPACK_IMPORTED_MODULE_5__.toCSSColorValue)(value, _Theme__WEBPACK_IMPORTED_MODULE_3__.neutral[400]);
    }
    const paletteMatches = paletteColorRegex.exec(String(value));
    if (typeof paletteMatches?.length === 'number' &&
        paletteMatches?.length >= 5) {
        const [, type, gradeString, , alphaString] = paletteMatches;
        const grade = parseInt(gradeString, 10);
        const alpha = alphaString !== undefined ? parseInt(alphaString, 10) / 100 : undefined;
        invariant__WEBPACK_IMPORTED_MODULE_2___default()(isPaletteColorType(type), 'invalid color type');
        invariant__WEBPACK_IMPORTED_MODULE_2___default()(isPaletteColorGrade(grade), 'invalid color grade');
        invariant__WEBPACK_IMPORTED_MODULE_2___default()(isPaletteColorAlpha(alpha), 'invalid color alpha');
        const [customProperty, color] = (0,_getPaletteColor__WEBPACK_IMPORTED_MODULE_4__.getPaletteColor)(type, grade, alpha);
        if (customProperty) {
            return (0,_helpers_toCSSValue__WEBPACK_IMPORTED_MODULE_5__.toCSSValue)(customProperty, color);
        }
        return color;
    }
    return value;
});
const size = measure((value) => {
    if (value === 'none') {
        return '0px';
    }
    if (value === 'full') {
        return '100%';
    }
    if (value === 'sw') {
        return '100vw';
    }
    if (value === 'sh') {
        return '100vh';
    }
    return undefined;
});
const inset = measure((value) => {
    if (value === 'none') {
        return '0px';
    }
    return undefined;
});
const margin = measure((value) => {
    if (value === 'none') {
        return '0px';
    }
    return undefined;
});
const padding = measure((value) => {
    if (value === 'none') {
        return '0px';
    }
    return undefined;
});
const isFontFamily = (value) => typeof value === 'string' && value in (_rocket_chat_fuselage_tokens_typography_json__WEBPACK_IMPORTED_MODULE_0___default().fontFamilies);
const fontFamily = (0,_rocket_chat_memo__WEBPACK_IMPORTED_MODULE_1__.memoize)((value) => {
    if (!isFontFamily(value)) {
        return undefined;
    }
    const fontFamily = (_rocket_chat_fuselage_tokens_typography_json__WEBPACK_IMPORTED_MODULE_0___default().fontFamilies)[value]
        .map((fontFace) => (fontFace.includes(' ') ? `'${fontFace}'` : fontFace))
        .join(', ');
    return (0,_helpers_toCSSValue__WEBPACK_IMPORTED_MODULE_5__.toCSSFontValue)(value, fontFamily);
});
const isFontScale = (value) => typeof value === 'string' && value in (_rocket_chat_fuselage_tokens_typography_json__WEBPACK_IMPORTED_MODULE_0___default().fontScales);
const fontScale = (0,_rocket_chat_memo__WEBPACK_IMPORTED_MODULE_1__.memoize)((value) => {
    if (!isFontScale(value)) {
        return undefined;
    }
    const { fontSize, fontWeight, lineHeight, letterSpacing } = (_rocket_chat_fuselage_tokens_typography_json__WEBPACK_IMPORTED_MODULE_0___default().fontScales)[value];
    return {
        fontSize: `${fontSize / 16}rem`,
        fontWeight,
        lineHeight: `${lineHeight / 16}rem`,
        letterSpacing: `${letterSpacing / 16}rem`,
    };
});


/***/ }),

/***/ "@rocket.chat/css-in-js":
/*!*****************************************!*\
  !*** external "@rocket.chat/css-in-js" ***!
  \*****************************************/
/***/ (function(module) {

module.exports = __WEBPACK_EXTERNAL_MODULE__rocket_chat_css_in_js__;

/***/ }),

/***/ "@rocket.chat/css-supports":
/*!********************************************!*\
  !*** external "@rocket.chat/css-supports" ***!
  \********************************************/
/***/ (function(module) {

module.exports = __WEBPACK_EXTERNAL_MODULE__rocket_chat_css_supports__;

/***/ }),

/***/ "@rocket.chat/fuselage-hooks":
/*!**********************************************!*\
  !*** external "@rocket.chat/fuselage-hooks" ***!
  \**********************************************/
/***/ (function(module) {

module.exports = __WEBPACK_EXTERNAL_MODULE__rocket_chat_fuselage_hooks__;

/***/ }),

/***/ "@rocket.chat/fuselage-tokens/colors.json":
/*!***********************************************************!*\
  !*** external "@rocket.chat/fuselage-tokens/colors.json" ***!
  \***********************************************************/
/***/ (function(module) {

module.exports = __WEBPACK_EXTERNAL_MODULE__rocket_chat_fuselage_tokens_colors_json__;

/***/ }),

/***/ "@rocket.chat/fuselage-tokens/dist/badge.json":
/*!***************************************************************!*\
  !*** external "@rocket.chat/fuselage-tokens/dist/badge.json" ***!
  \***************************************************************/
/***/ (function(module) {

module.exports = __WEBPACK_EXTERNAL_MODULE__rocket_chat_fuselage_tokens_dist_badge_json__;

/***/ }),

/***/ "@rocket.chat/fuselage-tokens/dist/button.json":
/*!****************************************************************!*\
  !*** external "@rocket.chat/fuselage-tokens/dist/button.json" ***!
  \****************************************************************/
/***/ (func