import { jsx as _jsx } from "react/jsx-runtime";
import * as UiKit from '@rocket.chat/ui-kit';
import { FuselageSurfaceRenderer, renderTextObject } from './FuselageSurfaceRenderer';
import TabNavigationBlock from '../blocks/TabNavigationBlock';
import { AppIdProvider } from '../contexts/AppIdContext';
export class ContextualBarSurfaceRenderer extends FuselageSurfaceRenderer {
    constructor() {
        super(['actions', 'context', 'divider', 'image', 'input', 'section', 'preview', 'callout', 'tab_navigation']);
        this.plain_text = renderTextObject;
        this.mrkdwn = renderTextObject;
    }
    tab_navigation(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(TabNavigationBlock, { block: block, context: context, index: index, surfaceRenderer: this }) }, index));
        }
        return null;
    }
}
//# sourceMappingURL=ContextualBarSurfaceRenderer.js.map