const getIconButtonPayload = (icon, label) => ({
    appId: 'dummy-app-id',
    blockId: 'dummy-block-id',
    actionId: 'dummy-action-id',
    type: 'icon_button',
    icon: Object.assign({ type: 'icon', icon: 'info', variant: 'default' }, icon),
    label: label !== null && label !== void 0 ? label : 'Call history',
});
export const infoCard = [
    {
        type: 'info_card',
        rows: [
            {
                background: 'default',
                elements: [
                    { type: 'icon', icon: 'phone-issue', variant: 'danger' },
                    { type: 'plain_text', text: 'Voice call failed' },
                ],
                action: getIconButtonPayload({ icon: 'info' }),
            },
        ],
    },
];
export const infoCardMultiple = [
    {
        type: 'info_card',
        rows: [
            {
                background: 'default',
                elements: [
                    { type: 'icon', icon: 'phone-off', variant: 'default' },
                    { type: 'plain_text', text: 'Call ended' },
                ],
                action: getIconButtonPayload({ icon: 'info' }),
            },
            {
                background: 'secondary',
                elements: [{ type: 'plain_text', text: '00:58' }],
            },
        ],
    },
];
//# sourceMappingURL=infoCard.js.map