import { jsx as _jsx } from "react/jsx-runtime";
import { TabsItem } from '@rocket.chat/fuselage';
import * as UiKit from '@rocket.chat/ui-kit';
import { useUiKitState } from '../hooks/useUiKitState';
export const TabElement = ({ block, context, surfaceRenderer, index, select, }) => {
    const [{ loading }, action] = useUiKitState(block, context);
    const { title, selected, disabled } = block;
    return (_jsx(TabsItem, { selected: selected, disabled: loading ? true : disabled, onClick: (e) => {
            !disabled && select(index);
            !disabled && action(e);
        }, children: surfaceRenderer.renderTextObject(title, 0, UiKit.BlockContext.NONE) }));
};
//# sourceMappingURL=TabElement.js.map