import { jsx as _jsx } from "react/jsx-runtime";
import { MultiSelectFiltered } from '@rocket.chat/fuselage';
import { memo, useCallback, useMemo } from 'react';
import { useStringFromTextObject } from '../hooks/useStringFromTextObject';
import { useUiKitState } from '../hooks/useUiKitState';
const MultiStaticSelectElement = ({ block, context }) => {
    const [{ loading, value, error }, action] = useUiKitState(block, context);
    const fromTextObjectToString = useStringFromTextObject();
    const options = useMemo(() => block.options.map(({ value, text }) => { var _a; return [value, (_a = fromTextObjectToString(text)) !== null && _a !== void 0 ? _a : '']; }), [block.options, fromTextObjectToString]);
    const handleChange = useCallback((value) => {
        action({ target: { value } });
    }, [action]);
    return (_jsx(MultiSelectFiltered, { value: value, disabled: loading, error: error, options: options, placeholder: fromTextObjectToString(block.placeholder), onChange: handleChange }));
};
export default memo(MultiStaticSelectElement);
//# sourceMappingURL=MultiStaticSelectElement.js.map