import { jsx as _jsx } from "react/jsx-runtime";
import { Skeleton } from '@rocket.chat/fuselage';
import { Markup } from '@rocket.chat/gazzodown';
import { parse } from '@rocket.chat/message-parser';
import { Suspense } from 'react';
import { useAppTranslation } from '../hooks/useAppTranslation';
const MarkdownTextElement = ({ textObject }) => {
    const { t } = useAppTranslation();
    const text = textObject.i18n ? t(textObject.i18n.key, Object.assign({}, textObject.i18n.args)) : textObject.text;
    if (!text) {
        return null;
    }
    return (_jsx(Suspense, { fallback: _jsx(Skeleton, {}), children: _jsx(Markup, { tokens: parse(text, { emoticons: false }) }) }));
};
export default MarkdownTextElement;
//# sourceMappingURL=MarkdownTextElement.js.map