import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { CheckBox, Box } from '@rocket.chat/fuselage';
import * as UiKit from '@rocket.chat/ui-kit';
import { useUiKitState } from '../hooks/useUiKitState';
const CheckboxElement = ({ block, context, surfaceRenderer }) => {
    const [{ loading, value }, action] = useUiKitState(block, context);
    const { options } = block;
    return (_jsx(Box, { children: options.map((option) => {
            const isChecked = value === null || value === void 0 ? void 0 : value.includes(option.value);
            return (_jsxs(Box, { pb: 4, children: [_jsx(CheckBox, { disabled: loading, value: option.value, checked: isChecked, onChange: action }), _jsx(Box, { is: 'label', pis: 8, children: surfaceRenderer.renderTextObject(option.text, 0, UiKit.BlockContext.NONE) })] }, option.value));
        }) }));
};
export default CheckboxElement;
//# sourceMappingURL=CheckboxElement.js.map