import { jsx as _jsx } from "react/jsx-runtime";
import { Tabs } from '@rocket.chat/fuselage';
import { memo, useState } from 'react';
import { TabElement } from '../elements/TabElement';
const TabNavigationBlock = (blockProps) => {
    const { block: { tabs }, context, surfaceRenderer, } = blockProps;
    const [selected, select] = useState();
    return (_jsx(Tabs, { marginBlock: 24, children: tabs.map((innerBlock, idx) => {
            if (selected !== undefined) {
                innerBlock.selected = idx === selected;
            }
            return (_jsx(TabElement, { index: idx, context: context, surfaceRenderer: surfaceRenderer, block: innerBlock, select: select }, `${innerBlock.blockId}_${idx}`));
        }) }));
};
export default memo(TabNavigationBlock);
//# sourceMappingURL=TabNavigationBlock.js.map