import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Flex, Grid, GridItem } from '@rocket.chat/fuselage';
import { memo, useMemo } from 'react';
import Fields from './SectionBlock.Fields';
const SectionBlock = ({ className, block, surfaceRenderer }) => {
    const { text, fields } = block;
    const accessoryElement = useMemo(() => block.accessory
        ? Object.assign({ appId: block.appId, blockId: block.blockId }, block.accessory) : undefined, [block.appId, block.blockId, block.accessory]);
    return (_jsxs(Grid, { className: className, children: [_jsxs(GridItem, { children: [text && (_jsx(Box, { is: 'span', fontScale: 'p2', color: 'default', children: surfaceRenderer.text(text) })), fields && _jsx(Fields, { fields: fields, surfaceRenderer: surfaceRenderer })] }), block.accessory && (_jsx(Flex.Item, { grow: 0, children: _jsx(GridItem, { children: accessoryElement ? surfaceRenderer.renderSectionAccessoryBlockElement(accessoryElement, 0) : null }) }))] }));
};
export default memo(SectionBlock);
//# sourceMappingURL=SectionBlock.js.map