import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { Box } from '@rocket.chat/fuselage';
import * as UiKit from '@rocket.chat/ui-kit';
import IconButtonElement from '../elements/IconButtonElement';
import IconElement from '../elements/IconElement';
const InfoCard = ({ block, surfaceRenderer, context }) => {
    const { rows, blockId } = block;
    return (_jsx(Box, { display: 'flex', flexDirection: 'column', borderWidth: 1, borderRadius: 'x4', borderColor: 'extra-light', maxWidth: '345px', backgroundColor: 'surface-tint', overflow: 'hidden', color: 'default', children: rows.map((row, index) => {
            const { elements, action, background } = row;
            return (_jsxs(Box, { padding: 16, backgroundColor: background === 'default' ? 'surface-light' : undefined, display: 'flex', alignItems: 'center', justifyContent: 'space-between', flexDirection: 'row', children: [_jsx(Box, { display: 'flex', alignItems: 'center', flexDirection: 'row', mi: -4, children: elements.map((element, index) => {
                            if (element.type === 'icon') {
                                return (_jsx(Box, { mi: 4, children: _jsx(IconElement, { block: element, context: context, surfaceRenderer: surfaceRenderer, index: index }) }, index));
                            }
                            if (element.type === 'plain_text' || element.type === 'mrkdwn') {
                                return (_jsx(Box, { mi: 4, children: _jsx(_Fragment, { children: surfaceRenderer.renderTextObject(element, index, UiKit.BlockContext.NONE) }) }, index));
                            }
                            return null;
                        }) }), _jsx("div", { children: action ? _jsx(IconButtonElement, { block: action, context: context, surfaceRenderer: surfaceRenderer, index: index }) : null })] }, `${blockId !== null && blockId !== void 0 ? blockId : 'info_card'}-${index}`));
        }) }));
};
export default InfoCard;
//# sourceMappingURL=InfoCard.js.map