"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var react_dom_1 = require("react-dom");
var ensureAnchorElement = function (id) {
    var existingAnchor = document.getElementById(id);
    if (existingAnchor)
        return existingAnchor;
    var newAnchor = document.createElement('div');
    newAnchor.id = id;
    document.body.appendChild(newAnchor);
    return newAnchor;
};
var getAnchorRefCount = function (anchorElement) {
    var refCount = anchorElement.dataset.refCount;
    if (refCount)
        return parseInt(refCount, 10);
    return 0;
};
var setAnchorRefCount = function (anchorElement, refCount) {
    anchorElement.dataset.refCount = String(refCount);
};
var refAnchorElement = function (anchorElement) {
    setAnchorRefCount(anchorElement, getAnchorRefCount(anchorElement) + 1);
    if (anchorElement.parentElement !== document.body) {
        document.body.appendChild(anchorElement);
    }
};
var unrefAnchorElement = function (anchorElement) {
    var refCount = getAnchorRefCount(anchorElement) - 1;
    setAnchorRefCount(anchorElement, refCount);
    if (refCount <= 0) {
        document.body.removeChild(anchorElement);
    }
};
var ToastBarPortal = function (_a) {
    var children = _a.children;
    var toastBarRoot = ensureAnchorElement('toastBarRoot');
    (0, react_1.useLayoutEffect)(function () {
        refAnchorElement(toastBarRoot);
        return function () {
            unrefAnchorElement(toastBarRoot);
        };
    }, [toastBarRoot]);
    return (0, react_dom_1.createPortal)(children, toastBarRoot);
};
exports.default = (0, react_1.memo)(ToastBarPortal);
//# sourceMappingURL=ToastBarPortal.js.map