var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx } from "react/jsx-runtime";
import { VisuallyHidden } from 'react-aria';
import { useFieldReferencedByInput, useFieldReferencedByLabel, useFieldWrappedByInputLabel, } from '../Field/FieldContext';
function withLabelId(Component) {
    var _a, _b;
    var WrappedComponent = function (props) {
        var labelProps = useFieldReferencedByInput();
        return _jsx(Component, __assign({}, props, labelProps));
    };
    WrappedComponent.displayName = "withLabelId(".concat((_b = (_a = Component.displayName) !== null && _a !== void 0 ? _a : Component.name) !== null && _b !== void 0 ? _b : 'InputComponent', ")");
    return WrappedComponent;
}
function withAriaLabelledBy(Component) {
    var _a, _b;
    var WrappedComponent = function (props) {
        var labelProps = useFieldReferencedByLabel();
        return _jsx(Component, __assign({}, props, labelProps));
    };
    WrappedComponent.displayName = "withAriaLabelledBy(".concat((_b = (_a = Component.displayName) !== null && _a !== void 0 ? _a : Component.name) !== null && _b !== void 0 ? _b : 'InputComponent', ")");
    return WrappedComponent;
}
function withVisuallyHiddenLabel(Component) {
    var _a, _b;
    var WrappedComponent = function (props) {
        var _a = useFieldWrappedByInputLabel(), label = _a[0], labelProps = _a[1], labelRef = _a[2];
        return (_jsx(Component, __assign({}, props, labelProps, { ref: labelRef, labelChildren: _jsx(VisuallyHidden, { children: label }) })));
    };
    WrappedComponent.displayName = "withVisuallyHiddenLabel(".concat((_b = (_a = Component.displayName) !== null && _a !== void 0 ? _a : Component.name) !== null && _b !== void 0 ? _b : 'InputComponent', ")");
    return WrappedComponent;
}
export { withLabelId, withAriaLabelledBy, withVisuallyHiddenLabel };
//# sourceMappingURL=withLabelHelpers.js.map