import { jsx as _jsx } from "react/jsx-runtime";
import { Emitter } from '@rocket.chat/emitter';
import { useState, useCallback } from 'react';
import { useId } from 'react-aria';
import { FieldContext } from './FieldContext';
function FieldProvider(_a) {
    var children = _a.children;
    var id = useId();
    var _b = useState(null), label = _b[0], setLabel = _b[1];
    var _c = useState(new Set()), descriptors = _c[0], setDescriptors = _c[1];
    var _d = useState('referencedByInput'), fieldType = _d[0], setFieldType = _d[1];
    var emitter = useState(function () { return new Emitter(); })[0];
    var setDescriptor = useCallback(function (type, unregister) {
        setDescriptors(function (labels) {
            var _labelMap = new Set(labels);
            if (unregister) {
                _labelMap.delete(type);
                return _labelMap;
            }
            _labelMap.add(type);
            return _labelMap;
        });
    }, []);
    var emitAction = useCallback(function () {
        emitter.emit('action');
    }, [emitter]);
    var onAction = useCallback(function (cb) {
        return emitter.on('action', cb);
    }, [emitter]);
    return (_jsx(FieldContext.Provider, { value: {
            emitAction: emitAction,
            onAction: onAction,
            setDescriptor: setDescriptor,
            setLabel: setLabel,
            descriptors: descriptors,
            label: label,
            id: id,
            fieldType: fieldType,
            setFieldType: setFieldType,
        }, children: children }));
}
export default FieldProvider;
//# sourceMappingURL=FieldProvider.js.map