var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { useSafeRefCallback } from '@rocket.chat/fuselage-hooks';
import { createContext, useCallback, useContext, useEffect, useMemo, } from 'react';
export var FieldContext = createContext({
    setDescriptor: function () { },
    setLabel: function () { },
    descriptors: new Set(),
    label: null,
    id: '',
    fieldType: 'referencedByLabel',
    setFieldType: function () { },
    emitAction: function () { },
    onAction: function () { },
});
var getTextFromNode = function (node) {
    if (!node.textContent) {
        return null;
    }
    var text = [];
    var treeWalker = node.ownerDocument.createTreeWalker(node, NodeFilter.SHOW_TEXT);
    while (treeWalker.nextNode()) {
        text.push(treeWalker.currentNode.textContent);
    }
    return text.join(' ');
};
export var useFieldLabel = function () {
    var _a = useContext(FieldContext), setLabel = _a.setLabel, id = _a.id, emitAction = _a.emitAction;
    var setLabelRef = useSafeRefCallback(useCallback(function (node) {
        if (!node) {
            return;
        }
        setLabel(getTextFromNode(node));
        var onClick = function () { return emitAction(); };
        node.addEventListener('click', onClick);
        return function () { return node.removeEventListener('click', onClick); };
    }, [setLabel, emitAction]));
    return [setLabelRef, "".concat(id, "-label")];
};
export var useFieldFieldType = function () {
    var fieldType = useContext(FieldContext).fieldType;
    return fieldType;
};
export var useFieldDescriptorId = function (type) {
    var _a = useContext(FieldContext), setDescriptor = _a.setDescriptor, id = _a.id;
    useEffect(function () {
        setDescriptor(type);
        return function () { return setDescriptor(type, true); };
    }, [type, setDescriptor]);
    return "".concat(id, "-").concat(type);
};
var describedByOrder = ['description', 'error', 'hint'];
var getDescribedBy = function (descriptors, id) {
    return describedByOrder
        .map(function (type) {
        return descriptors.has(type) ? "".concat(id, "-").concat(type) : undefined;
    })
        .filter(Boolean)
        .join(' ');
};
var getInputId = function (id, descriptors) {
    return "".concat(id, "-label").concat(descriptors.has('placeholder') ? " ".concat(id, "-placeholder") : '');
};
var getAriaInvalid = function (descriptors) {
    if (descriptors.has('error')) {
        return { 'aria-invalid': 'true' };
    }
    return { 'aria-invalid': 'false' };
};
// Input has id and label is htmlFor
export var useFieldReferencedByInput = function () {
    var _a = useContext(FieldContext), id = _a.id, descriptors = _a.descriptors, setFieldType = _a.setFieldType;
    useEffect(function () {
        setFieldType('referencedByInput');
    }, [setFieldType]);
    return useMemo(function () { return (__assign({ 'id': getInputId(id, descriptors), 'aria-describedby': getDescribedBy(descriptors, id) }, getAriaInvalid(descriptors))); }, [descriptors, id]);
};
// label has id and input is aria-labelledby
export var useFieldReferencedByLabel = function () {
    var _a = useContext(FieldContext), id = _a.id, descriptors = _a.descriptors, setFieldType = _a.setFieldType;
    useEffect(function () {
        setFieldType('referencedByLabel');
    }, [setFieldType]);
    return useMemo(function () { return (__assign({ 'aria-labelledby': getInputId(id, descriptors), 'aria-describedby': getDescribedBy(descriptors, id) }, getAriaInvalid(descriptors))); }, [descriptors, id]);
};
// label is rendered visually hidden inside the inputs wrapper label
export var useFieldWrappedByInputLabel = function () {
    var _a = useContext(FieldContext), id = _a.id, label = _a.label, descriptors = _a.descriptors, setFieldType = _a.setFieldType, onAction = _a.onAction;
    useEffect(function () {
        setFieldType('wrappedByLabel');
    }, [setFieldType]);
    var refCallback = useSafeRefCallback(useCallback(function (node) {
        if (!node) {
            return;
        }
        onAction(function () {
            node.focus();
            node.click();
        });
    }, [onAction]));
    return useMemo(function () { return [
        label,
        __assign({ 'aria-describedby': getDescribedBy(descriptors, id), 'id': getInputId(id, descriptors) }, getAriaInvalid(descriptors)),
        refCallback,
    ]; }, [label, descriptors, id, refCallback]);
};
//# sourceMappingURL=FieldContext.js.map