"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.withLabelId = withLabelId;
exports.withAriaLabelledBy = withAriaLabelledBy;
exports.withVisuallyHiddenLabel = withVisuallyHiddenLabel;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_aria_1 = require("react-aria");
var FieldContext_1 = require("../Field/FieldContext");
function withLabelId(Component) {
    var _a, _b;
    var WrappedComponent = function (props) {
        var labelProps = (0, FieldContext_1.useFieldReferencedByInput)();
        return (0, jsx_runtime_1.jsx)(Component, __assign({}, props, labelProps));
    };
    WrappedComponent.displayName = "withLabelId(".concat((_b = (_a = Component.displayName) !== null && _a !== void 0 ? _a : Component.name) !== null && _b !== void 0 ? _b : 'InputComponent', ")");
    return WrappedComponent;
}
function withAriaLabelledBy(Component) {
    var _a, _b;
    var WrappedComponent = function (props) {
        var labelProps = (0, FieldContext_1.useFieldReferencedByLabel)();
        return (0, jsx_runtime_1.jsx)(Component, __assign({}, props, labelProps));
    };
    WrappedComponent.displayName = "withAriaLabelledBy(".concat((_b = (_a = Component.displayName) !== null && _a !== void 0 ? _a : Component.name) !== null && _b !== void 0 ? _b : 'InputComponent', ")");
    return WrappedComponent;
}
function withVisuallyHiddenLabel(Component) {
    var _a, _b;
    var WrappedComponent = function (props) {
        var _a = (0, FieldContext_1.useFieldWrappedByInputLabel)(), label = _a[0], labelProps = _a[1], labelRef = _a[2];
        return ((0, jsx_runtime_1.jsx)(Component, __assign({}, props, labelProps, { ref: labelRef, labelChildren: (0, jsx_runtime_1.jsx)(react_aria_1.VisuallyHidden, { children: label }) })));
    };
    WrappedComponent.displayName = "withVisuallyHiddenLabel(".concat((_b = (_a = Component.displayName) !== null && _a !== void 0 ? _a : Component.name) !== null && _b !== void 0 ? _b : 'InputComponent', ")");
    return WrappedComponent;
}
//# sourceMappingURL=withLabelHelpers.js.map