"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useFieldWrappedByInputLabel = exports.useFieldReferencedByLabel = exports.useFieldReferencedByInput = exports.useFieldDescriptorId = exports.useFieldFieldType = exports.useFieldLabel = exports.FieldContext = void 0;
var fuselage_hooks_1 = require("@rocket.chat/fuselage-hooks");
var react_1 = require("react");
exports.FieldContext = (0, react_1.createContext)({
    setDescriptor: function () { },
    setLabel: function () { },
    descriptors: new Set(),
    label: null,
    id: '',
    fieldType: 'referencedByLabel',
    setFieldType: function () { },
    emitAction: function () { },
    onAction: function () { },
});
var getTextFromNode = function (node) {
    if (!node.textContent) {
        return null;
    }
    var text = [];
    var treeWalker = node.ownerDocument.createTreeWalker(node, NodeFilter.SHOW_TEXT);
    while (treeWalker.nextNode()) {
        text.push(treeWalker.currentNode.textContent);
    }
    return text.join(' ');
};
var useFieldLabel = function () {
    var _a = (0, react_1.useContext)(exports.FieldContext), setLabel = _a.setLabel, id = _a.id, emitAction = _a.emitAction;
    var setLabelRef = (0, fuselage_hooks_1.useSafeRefCallback)((0, react_1.useCallback)(function (node) {
        if (!node) {
            return;
        }
        setLabel(getTextFromNode(node));
        var onClick = function () { return emitAction(); };
        node.addEventListener('click', onClick);
        return function () { return node.removeEventListener('click', onClick); };
    }, [setLabel, emitAction]));
    return [setLabelRef, "".concat(id, "-label")];
};
exports.useFieldLabel = useFieldLabel;
var useFieldFieldType = function () {
    var fieldType = (0, react_1.useContext)(exports.FieldContext).fieldType;
    return fieldType;
};
exports.useFieldFieldType = useFieldFieldType;
var useFieldDescriptorId = function (type) {
    var _a = (0, react_1.useContext)(exports.FieldContext), setDescriptor = _a.setDescriptor, id = _a.id;
    (0, react_1.useEffect)(function () {
        setDescriptor(type);
        return function () { return setDescriptor(type, true); };
    }, [type, setDescriptor]);
    return "".concat(id, "-").concat(type);
};
exports.useFieldDescriptorId = useFieldDescriptorId;
var describedByOrder = ['description', 'error', 'hint'];
var getDescribedBy = function (descriptors, id) {
    return describedByOrder
        .map(function (type) {
        return descriptors.has(type) ? "".concat(id, "-").concat(type) : undefined;
    })
        .filter(Boolean)
        .join(' ');
};
var getInputId = function (id, descriptors) {
    return "".concat(id, "-label").concat(descriptors.has('placeholder') ? " ".concat(id, "-placeholder") : '');
};
var getAriaInvalid = function (descriptors) {
    if (descriptors.has('error')) {
        return { 'aria-invalid': 'true' };
    }
    return { 'aria-invalid': 'false' };
};
// Input has id and label is htmlFor
var useFieldReferencedByInput = function () {
    var _a = (0, react_1.useContext)(exports.FieldContext), id = _a.id, descriptors = _a.descriptors, setFieldType = _a.setFieldType;
    (0, react_1.useEffect)(function () {
        setFieldType('referencedByInput');
    }, [setFieldType]);
    return (0, react_1.useMemo)(function () { return (__assign({ 'id': getInputId(id, descriptors), 'aria-describedby': getDescribedBy(descriptors, id) }, getAriaInvalid(descriptors))); }, [descriptors, id]);
};
exports.useFieldReferencedByInput = useFieldReferencedByInput;
// label has id and input is aria-labelledby
var useFieldReferencedByLabel = function () {
    var _a = (0, react_1.useContext)(exports.FieldContext), id = _a.id, descriptors = _a.descriptors, setFieldType = _a.setFieldType;
    (0, react_1.useEffect)(function () {
        setFieldType('referencedByLabel');
    }, [setFieldType]);
    return (0, react_1.useMemo)(function () { return (__assign({ 'aria-labelledby': getInputId(id, descriptors), 'aria-describedby': getDescribedBy(descriptors, id) }, getAriaInvalid(descriptors))); }, [descriptors, id]);
};
exports.useFieldReferencedByLabel = useFieldReferencedByLabel;
// label is rendered visually hidden inside the inputs wrapper label
var useFieldWrappedByInputLabel = function () {
    var _a = (0, react_1.useContext)(exports.FieldContext), id = _a.id, label = _a.label, descriptors = _a.descriptors, setFieldType = _a.setFieldType, onAction = _a.onAction;
    (0, react_1.useEffect)(function () {
        setFieldType('wrappedByLabel');
    }, [setFieldType]);
    var refCallback = (0, fuselage_hooks_1.useSafeRefCallback)((0, react_1.useCallback)(function (node) {
        if (!node) {
            return;
        }
        onAction(function () {
            node.focus();
            node.click();
        });
    }, [onAction]));
    return (0, react_1.useMemo)(function () { return [
        label,
        __assign({ 'aria-describedby': getDescribedBy(descriptors, id), 'id': getInputId(id, descriptors) }, getAriaInvalid(descriptors)),
        refCallback,
    ]; }, [label, descriptors, id, refCallback]);
};
exports.useFieldWrappedByInputLabel = useFieldWrappedByInputLabel;
//# sourceMappingURL=FieldContext.js.map