"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseUserList = parseUserList;
function parseUserList(commandResponse) {
    const { _body: text } = commandResponse;
    if (!text || typeof text !== 'string') {
        throw new Error('Invalid response from FreeSwitch server.');
    }
    const lines = text.split('\n');
    const columnsLine = lines.shift();
    if (!columnsLine) {
        throw new Error('Invalid response from FreeSwitch server.');
    }
    const columns = columnsLine.split('|');
    const users = new Map();
    for (const line of lines) {
        const values = line.split('|');
        if (!values.length || !values[0]) {
            continue;
        }
        const user = Object.fromEntries(values.map((value, index) => {
            return [(columns.length > index && columns[index]) || `column${index}`, value];
        }));
        if (!user.userid || user.userid === '+OK') {
            continue;
        }
        const { group, ...newUserData } = user;
        const existingUser = users.get(user.userid);
        const groups = (existingUser?.groups || []);
        if (group && !groups.includes(group)) {
            groups.push(group);
        }
        users.set(user.userid, {
            ...(users.get(user.userid) || newUserData),
            groups,
        });
    }
    return [...users.values()].map((user) => ({
        ...user,
        groups: user.groups.join('|'),
    }));
}
//# sourceMappingURL=parseUserList.js.map