"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseChannelKind = parseChannelKind;
function parseChannelKind(channelName) {
    if (!channelName) {
        return 'unknown';
    }
    if (channelName.startsWith('sofia/internal/')) {
        return 'internal';
    }
    if (channelName.startsWith('sofia/external/')) {
        return 'external';
    }
    if (channelName.startsWith('loopback/voicemail')) {
        return 'voicemail';
    }
    return 'unknown';
}
//# sourceMappingURL=parseChannelKind.js.map