"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filterStringList = filterStringList;
function filterStringList(object, filterFn, mapFn) {
    const filteredEntries = Object.entries(object).filter(([key]) => filterFn(key));
    if (!mapFn) {
        return Object.fromEntries(filteredEntries);
    }
    const mappedEntries = filteredEntries.map(mapFn).filter((entry) => entry);
    return Object.fromEntries(mappedEntries);
}
//# sourceMappingURL=filterStringList.js.map