"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filterOutMissingData = filterOutMissingData;
const tools_1 = require("@rocket.chat/tools");
function filterOutMissingData(data) {
    return (0, tools_1.objectMap)(data, ({ key, value }) => {
        if (typeof value !== 'boolean') {
            if (!value || value === '0') {
                return;
            }
        }
        if (typeof value === 'object' && !(value instanceof Date) && !Array.isArray(value) && !Object.keys(value).length) {
            return;
        }
        return { key, value };
    }, true);
}
//# sourceMappingURL=filterOutMissingData.js.map