"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FreeSwitchApiClient = void 0;
const esl_1 = require("esl");
const logger_1 = require("../logger");
const client_1 = require("./client");
class FreeSwitchApiClient extends client_1.FreeSwitchESLClient {
    getCommandResponse(response, command) {
        if (!response?.body) {
            logger_1.logger.error('No response from FreeSwitch server', command, response);
            throw new Error('No response from FreeSwitch server.');
        }
        return response.body;
    }
    async transitionToReady() {
        try {
            this.response.event_json('BACKGROUND_JOB');
        }
        catch (error) {
            logger_1.logger.error({ msg: 'Failed to request api responses', error });
            throw new Error('failed-to-request-api-responses');
        }
        super.transitionToReady();
    }
    async runCommand(command, timeout) {
        await this.waitUntilUsable();
        const result = await this.response.bgapi(command, timeout ?? esl_1.FreeSwitchResponse.default_command_timeout);
        return this.getCommandResponse(result, command);
    }
    static async runCallback(options, cb) {
        const client = new FreeSwitchApiClient(options);
        try {
            await client.waitUntilUsable();
            // Await result so it runs within the try..finally scope
            const result = await cb(async (command, timeout) => client.runCommand(command, timeout));
            return result;
        }
        finally {
            client.endConnection();
        }
    }
    static async runSingleCommand(options, command, timeout) {
        return this.runCallback(options, async (runCommand) => runCommand(command, timeout));
    }
}
exports.FreeSwitchApiClient = FreeSwitchApiClient;
//# sourceMappingURL=apiClient.js.map